/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.config.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.nl2api.model.PlainField;
import kd.ai.gai.plugin.flow.config.helper.VarParamConverter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import org.apache.commons.lang3.StringUtils;

public class ParamDefinitionUtils {
    public static String getParamFullName(DynamicObjectCollection rows, String nameProp, int rowIndex) {
        DynamicObject rowData = (DynamicObject)rows.get(rowIndex);
        String parentId = rowData.getString("pid");
        String name = rowData.getString(nameProp);
        if (StringUtils.isBlank((CharSequence)parentId) || "0".equals(parentId)) {
            return name;
        }
        Map<String, DynamicObject> rowDataMap = rows.stream().collect(Collectors.toMap(row -> row.getPkValue().toString(), row -> row));
        if (!rowDataMap.containsKey(parentId)) {
            return name;
        }
        DynamicObject parentRowData = rowDataMap.get(parentId);
        return ParamDefinitionUtils.getParamFullName(rows, nameProp, parentRowData.getInt("seq") - 1) + "." + name;
    }

    public static List<ParamDefinition> convertPlainFieldToParamDefinition(List<PlainField> plainFields) {
        if (plainFields == null || plainFields.isEmpty()) {
            return new ArrayList<ParamDefinition>(0);
        }
        ArrayList<ParamDefinition> result = new ArrayList<ParamDefinition>(10);
        ArrayParamDefinition resultNode = null;
        ArrayList<ParamDefinition> paramList = new ArrayList<ParamDefinition>(plainFields.size());
        HashMap<String, ParamDefinition> allParamMap = new HashMap<String, ParamDefinition>(plainFields.size());
        for (PlainField plainField : plainFields) {
            ParamDefinition param;
            if ("must".equals(plainField.getFieldKey())) {
                param = VarParamConverter.createParamDefinitionByType(plainField.getFieldId(), plainField.getFieldType());
                param.setDescription(plainField.getFieldName());
                if ("result".equals(plainField.getFieldId()) && param instanceof ArrayParamDefinition) {
                    resultNode = (ArrayParamDefinition)param;
                }
                result.add(param);
                continue;
            }
            param = ParamDefinitionUtils.buildFieldParamTree(plainField, allParamMap);
            if (param == null) continue;
            paramList.add(param);
        }
        if (resultNode == null) {
            result.addAll(paramList);
        } else {
            ObjectParamDefinition itemDefinition = (ObjectParamDefinition)resultNode.getItemDefinition();
            itemDefinition.setProperties(paramList);
        }
        return result;
    }

    private static ParamDefinition buildFieldParamTree(PlainField plainField, Map<String, ParamDefinition> allParamMap) {
        String paramName = plainField.getFieldId();
        String paramType = plainField.getFieldType();
        String paramDesc = plainField.getFieldName();
        List<String> entities = ParamDefinitionUtils.getEntityListByPath(plainField.getEntityKey());
        if (paramName.lastIndexOf(".") < 0) {
            ParamDefinition paramDefinition = VarParamConverter.createParamDefinitionByType(paramName, paramType);
            paramDefinition.setDescription(paramDesc);
            ParamDefinitionUtils.putMustProperties(paramDefinition, plainField);
            allParamMap.put(paramName, paramDefinition);
            return paramDefinition;
        }
        String[] paramNames = paramName.split("\\.");
        ParamDefinition tempParam = null;
        for (int i = paramNames.length - 1; i >= 0; --i) {
            Object paramDefinition;
            if (i == paramNames.length - 1) {
                paramDefinition = VarParamConverter.createParamDefinitionByType(paramNames[i], paramType);
                paramDefinition.setDescription(paramDesc);
                ParamDefinitionUtils.putMustProperties(paramDefinition, plainField);
                tempParam = paramDefinition;
                allParamMap.put(paramNames[i], (ParamDefinition)paramDefinition);
                continue;
            }
            if (allParamMap.containsKey(paramNames[i])) {
                paramDefinition = allParamMap.get(paramNames[i]);
                ParamDefinitionUtils.setChildParam(paramDefinition, tempParam);
                allParamMap.put(paramNames[i], (ParamDefinition)paramDefinition);
                return null;
            }
            paramDefinition = entities.contains(paramNames[i]) ? ParamDefinitionBuilder.objectArray((String)paramNames[i], (ObjectParamDefinition)new ObjectParamDefinition("item")).build() : ParamDefinitionBuilder.object((String)paramNames[i]).build();
            ParamDefinitionUtils.setChildParam(paramDefinition, tempParam);
            ParamDefinitionUtils.putMustProperties(paramDefinition, plainField);
            allParamMap.put(paramNames[i], (ParamDefinition)paramDefinition);
            if (i == 0) {
                return paramDefinition;
            }
            tempParam = paramDefinition;
        }
        return null;
    }

    private static void putMustProperties(ParamDefinition paramDefinition, PlainField plainField) {
        if (plainField.getMust() != null) {
            HashMap<String, String> mustProperties = new HashMap<String, String>(1);
            mustProperties.put("isMust", String.valueOf(plainField.getMust()));
            paramDefinition.setCustomProperties(mustProperties);
        }
    }

    private static List<String> getEntityListByPath(String entityPath) {
        if (StringUtils.isBlank((CharSequence)entityPath) || entityPath.lastIndexOf(".") < 0) {
            return new ArrayList<String>(0);
        }
        String[] entities = entityPath.split("\\.");
        ArrayList<String> entityList = new ArrayList<String>();
        for (int i = 0; i < entities.length; ++i) {
            if (i == 0) continue;
            entityList.add(entities[i]);
        }
        return entityList;
    }

    private static void setChildParam(ParamDefinition param, ParamDefinition childParam) {
        if (param instanceof ArrayParamDefinition) {
            ObjectParamDefinition itemDefinition = (ObjectParamDefinition)((ArrayParamDefinition)param).getItemDefinition();
            List<ParamDefinition> properties = new ArrayList<ParamDefinition>(itemDefinition.getProperties());
            if (properties.isEmpty()) {
                properties = Collections.singletonList(childParam);
            } else {
                properties.add(childParam);
            }
            itemDefinition.setProperties(properties);
            ((ArrayParamDefinition)param).setItemDefinition((ParamDefinition)itemDefinition);
        } else if (param instanceof ObjectParamDefinition) {
            List<ParamDefinition> properties = new ArrayList<ParamDefinition>(((ObjectParamDefinition)param).getProperties());
            if (properties.isEmpty()) {
                properties = Collections.singletonList(childParam);
            } else {
                properties.add(childParam);
            }
            ((ObjectParamDefinition)param).setProperties(properties);
        }
    }
}

