/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.ActionBaseInfo;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.PromptTemplateContent;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.RepoReplyConfig;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.flow.template.FlowTemplateFactory;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.event.IEventHandler;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitEventHandler
implements IEventHandler {
    private static final Logger log = LoggerFactory.getLogger(InitEventHandler.class);
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_IS_INPUT = "isinput";
    private static final String KEY_INPUT_VALUE = "input_value";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final DateTimeFormatter FORMATTER1 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).optionalEnd().toFormatter();
    private static final DateTimeFormatter FORMATTER2 = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("EEE MMM dd HH:mm:ss z yyyy").toFormatter(Locale.ENGLISH);

    @Override
    public void handleEvent(String eventArgs) {
        CustomControlAction initAction = new CustomControlAction("init");
        Flow flow = FlowEditingContext.get().getService(ModelService.class).getFlow();
        initAction.setValue(JsonUtil.toJson((Object)flow));
        List<ActionBaseInfo> actionBaseInfoList = InitEventHandler.getActionBaseInfoByFlow(flow);
        initAction.setActionBaseInfos(JsonUtil.toJson(actionBaseInfoList));
        FlowEditingContext.get().getService(FlowActionService.class).sendAction(initAction);
        FlowEditingContext.get().getService(ViewService.class).lockFlow();
        this.sendProcessTemplateListAction();
    }

    public static List<ActionBaseInfo> getActionBaseInfoByFlow(Flow flow) {
        ArrayList<ActionBaseInfo> actionBaseInfoList = new ArrayList<ActionBaseInfo>();
        List actionList = flow.getActions();
        if (actionList == null || actionList.isEmpty()) {
            return actionBaseInfoList;
        }
        for (Action action : actionList) {
            Var var;
            QFilter[] filters;
            if (action instanceof LLMAction) {
                LLMAction llmAction = (LLMAction)action;
                ActionBaseInfo actionBaseInfo = new ActionBaseInfo();
                actionBaseInfo.setActionId(action.getId());
                int promptType = llmAction.getPromptType();
                if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
                    DynamicObjectCollection outputs;
                    long promptId = llmAction.getLlmPromptId();
                    DynamicObject promptInfo = null;
                    try {
                        filters = new QFilter[]{new QFilter("id", "=", (Object)promptId)};
                        String selectProperties = "language_model, var_configs, out_var_configs, var_name, var_type, out_var_name, out_var_type";
                        promptInfo = BusinessDataServiceHelper.loadSingle((String)"gai_prompt", (String)selectProperties, (QFilter[])filters);
                    }
                    catch (Exception e) {
                        log.info("\u63d0\u793a\u8bcd\u4e0d\u5b58\u5728\uff0c promptId: {}", (Object)promptId);
                    }
                    if (Objects.isNull(promptInfo)) continue;
                    String serviceNumber = promptInfo.getString("language_model");
                    String serviceName = InitEventHandler.getServiceName(serviceNumber);
                    DynamicObjectCollection inputs = promptInfo.getDynamicObjectCollection("var_configs");
                    if (inputs != null) {
                        ArrayList<Var> inputVarList = new ArrayList<Var>(10);
                        for (Iterator input : inputs) {
                            var = new Var(input.getString("var_name"), input.getString("var_type"), "");
                            inputVarList.add(var);
                        }
                        actionBaseInfo.setInputVarList(inputVarList);
                    }
                    if ((outputs = promptInfo.getDynamicObjectCollection("out_var_configs")) != null) {
                        Iterator input;
                        ArrayList<Var> outputVarList = new ArrayList<Var>(10);
                        input = outputs.iterator();
                        while (input.hasNext()) {
                            DynamicObject output = (DynamicObject)input.next();
                            Var var2 = new Var(output.getString("out_var_name"), output.getString("out_var_type"), "");
                            outputVarList.add(var2);
                        }
                        actionBaseInfo.setOutputVarList(outputVarList);
                    }
                    actionBaseInfo.setLlmPromptLLM(serviceName);
                } else {
                    String serviceName = InitEventHandler.getServiceName(llmAction.getLlm());
                    actionBaseInfo.setLlmPromptLLM(serviceName);
                    PromptTemplateContent promptTemplateContent = llmAction.getPromptTemplateContent();
                    if (promptTemplateContent != null) {
                        actionBaseInfo.setInputVarList(promptTemplateContent.getInputVarList());
                        actionBaseInfo.setOutputVarList(promptTemplateContent.getOutputVarList());
                    }
                }
                actionBaseInfoList.add(actionBaseInfo);
                continue;
            }
            if (action instanceof RepoReplyAction) {
                ActionBaseInfo actionBaseInfo = InitEventHandler.setRepoReplyConfigLLM((RepoReplyAction)action);
                actionBaseInfoList.add(actionBaseInfo);
                continue;
            }
            if (action instanceof RepoAction) {
                String repoType;
                RepoAction repoAction = (RepoAction)action;
                ArrayList<String> repoNameList = new ArrayList<String>();
                switch (repoType = repoAction.getRepoType()) {
                    case "select": {
                        DynamicObject[] repoInfoArr;
                        List repoIdList = repoAction.getRepoList();
                        if (!CollectionUtils.isNotEmpty((Collection)repoIdList) || (repoInfoArr = BusinessDataServiceHelper.load((String)"gai_repo_info", (String)"name", (QFilter[])(filters = new QFilter[]{new QFilter("id", "in", (Object)repoIdList)}))) == null || repoInfoArr.length == 0) break;
                        repoNameList.addAll(Arrays.stream(repoInfoArr).map(repoInfo -> repoInfo.get("name").toString()).collect(Collectors.toList()));
                        break;
                    }
                    case "structure": {
                        DynamicObject structureRepoDO;
                        Long structureRepoId = repoAction.getStructureId();
                        if (structureRepoId == null || (structureRepoDO = BusinessDataServiceHelper.loadSingle((Object)structureRepoId, (String)"gai_repo_schema", (String)"repo_name")) == null) break;
                        String structureRepoName = structureRepoDO.getString("repo_name");
                        repoNameList.add(structureRepoName);
                        break;
                    }
                    case "dynamic": {
                        if (repoAction.getRepoMapper() == null) break;
                        repoNameList.add("\u5df2\u914d\u7f6e\u52a8\u6001\u6570\u636e\u5e93(\u6587\u6863)");
                        break;
                    }
                    case "meta": {
                        List metaRepoIdList = repoAction.getMetaIdList();
                        if (!CollectionUtils.isNotEmpty((Collection)metaRepoIdList)) break;
                        repoNameList.addAll(metaRepoIdList);
                        break;
                    }
                    case "universal": {
                        QFilter[] filters2;
                        DynamicObject[] repoInfoArr;
                        List universalRepoIdStrList = repoAction.getUniversalIdList();
                        List universalRepoIdList = universalRepoIdStrList.stream().map(Long::valueOf).collect(Collectors.toList());
                        if (!CollectionUtils.isNotEmpty(universalRepoIdList) || (repoInfoArr = BusinessDataServiceHelper.load((String)"aikm_knl_manager", (String)"name", (QFilter[])(filters2 = new QFilter[]{new QFilter("id", "in", universalRepoIdList)}))) == null || repoInfoArr.length == 0) break;
                        repoNameList.addAll(Arrays.stream(repoInfoArr).map(repoInfo -> repoInfo.get("name").toString()).collect(Collectors.toList()));
                        break;
                    }
                    case "dynamic_universal": {
                        if (repoAction.getUniversalRepoMapper() == null) break;
                        repoNameList.add("\u5df2\u914d\u7f6e\u52a8\u6001\u6570\u636e\u5e93(\u901a\u7528)");
                        break;
                    }
                }
                ActionBaseInfo actionBaseInfo = new ActionBaseInfo();
                actionBaseInfo.setActionId(action.getId());
                actionBaseInfo.setRepoName(repoNameList);
                actionBaseInfo.setInputVarList(repoAction.getVarList());
                actionBaseInfo.setOutputVarList(repoAction.getOutputVarList());
                actionBaseInfoList.add(actionBaseInfo);
                continue;
            }
            if (action instanceof JavaPluginAction) {
                DynamicObjectCollection outputs;
                String selectProperties = "input, input_name, input_type, input_desc, isinput, input_value, output, output_name, output_type, output_desc";
                JavaPluginAction javaPluginAction = (JavaPluginAction)action;
                long actionId = javaPluginAction.getActionId();
                QFilter[] filters3 = new QFilter[]{new QFilter("id", "=", (Object)actionId)};
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ENTITY_OPERATION, (String)selectProperties, (QFilter[])filters3);
                if (obj == null) continue;
                ActionBaseInfo actionBaseInfo = new ActionBaseInfo();
                DynamicObjectCollection inputs = obj.getDynamicObjectCollection(KEY_ENTRYENTITY_INPUT);
                if (inputs != null) {
                    ArrayList<Var> inputVarList = new ArrayList<Var>(10);
                    for (DynamicObject input : inputs) {
                        Var var3 = new Var(input.getString(KEY_INPUT_NAME), input.getString(KEY_INPUT_TYPE), input.getString(KEY_INPUT_DESC), input.getBoolean(KEY_IS_INPUT), input.getString(KEY_INPUT_VALUE));
                        inputVarList.add(var3);
                    }
                    actionBaseInfo.setInputVarList(inputVarList);
                }
                if ((outputs = obj.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTPUT)) != null) {
                    ArrayList<Var> outputVarList = new ArrayList<Var>(10);
                    for (DynamicObject output : outputs) {
                        var = new Var(output.getString(KEY_OUTPUT_NAME), output.getString(KEY_OUTPUT_TYPE), output.getString(KEY_OUTPUT_DESC));
                        outputVarList.add(var);
                    }
                    actionBaseInfo.setOutputVarList(outputVarList);
                }
                actionBaseInfo.setActionId(action.getId());
                actionBaseInfoList.add(actionBaseInfo);
                continue;
            }
            if (action instanceof AskUserAction) {
                AskUserAction askUserAction = (AskUserAction)action;
                ActionBaseInfo actionBaseInfo = new ActionBaseInfo();
                actionBaseInfo.setOutputVarList(askUserAction.getOutputVarList());
                actionBaseInfo.setActionId(action.getId());
                actionBaseInfoList.add(actionBaseInfo);
                continue;
            }
            if (!(action instanceof ToolAction)) continue;
            ToolAction toolAction = (ToolAction)action;
            ActionBaseInfo actionBaseInfo = new ActionBaseInfo();
            String iconPath = InitEventHandler.buildIconUrl(InitEventHandler.getToolIconPathById(toolAction.getToolId()));
            actionBaseInfo.setIconPath(iconPath);
            actionBaseInfo.setActionId(toolAction.getId());
            actionBaseInfoList.add(actionBaseInfo);
        }
        return actionBaseInfoList;
    }

    private static String buildIconUrl(String iconPath) {
        if (StringUtils.isNotEmpty((CharSequence)iconPath) && iconPath.startsWith("/kingdee")) {
            String host = RequestContext.get().getClientFullContextPath();
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            return host + iconPath;
        }
        return iconPath;
    }

    private static String getToolIconPathById(Long toolId) {
        if (toolId == null || toolId == 0L) {
            return "";
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"gai_tool", (String)"picture", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)toolId)});
        return dynamicObject == null ? "" : dynamicObject.getString("picture");
    }

    private static String getServiceName(String serviceNumber) {
        String serviceName = "";
        List serviceList = AiccService.getLlmList();
        for (Map service : serviceList) {
            if (!service.get("number").equals(serviceNumber)) continue;
            serviceName = (String)service.get("name");
        }
        return serviceName;
    }

    private static ActionBaseInfo setRepoReplyConfigLLM(RepoReplyAction action) {
        RepoReplyConfig repoReplyConfig = action.getRepoReplyConfig();
        ActionBaseInfo actionBaseInfo = new ActionBaseInfo();
        if (repoReplyConfig != null) {
            actionBaseInfo.setActionId(action.getId());
            actionBaseInfo.setLlmPromptLLM(InitEventHandler.getServiceName(repoReplyConfig.getLlm()));
            actionBaseInfo.setInputVarList(action.getVarList());
            actionBaseInfo.setOutputVarList(action.getOutputVarList());
        }
        return actionBaseInfo;
    }

    private void sendProcessTemplateListAction() {
        DynamicObject[] templateDOArr = FlowTemplateFactory.getFlowTemplateList();
        if (templateDOArr == null || templateDOArr.length == 0) {
            log.info("No templates found.");
            return;
        }
        HashMap groupTemplateListMap = Maps.newHashMapWithExpectedSize((int)templateDOArr.length);
        for (DynamicObject templateDO : templateDOArr) {
            String groupKey = this.createGroupKey(templateDO);
            Map<String, Object> templateMap = this.createTemplateMap(templateDO);
            groupTemplateListMap.computeIfAbsent(groupKey, k -> Lists.newArrayList()).add(templateMap);
        }
        List groupTemplateMapList = groupTemplateListMap.entrySet().parallelStream().map(entry -> this.createGroupMap((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
        groupTemplateMapList.sort((map1, map2) -> {
            String groupName1 = (String)map1.get("groupName");
            String groupName2 = (String)map2.get("groupName");
            boolean isUncategorized1 = ResManager.loadKDString((String)"\u672a\u5206\u7c7b", (String)"InitEventHandler_0", (String)"ai-gai-plugin", (Object[])new Object[0]).equals(groupName1);
            boolean isUncategorized2 = ResManager.loadKDString((String)"\u672a\u5206\u7c7b", (String)"InitEventHandler_0", (String)"ai-gai-plugin", (Object[])new Object[0]).equals(groupName2);
            if (isUncategorized1 && !isUncategorized2) {
                return 1;
            }
            if (!isUncategorized1 && isUncategorized2) {
                return -1;
            }
            String timeStr1 = (String)map1.get("modifytime");
            String timeStr2 = (String)map2.get("modifytime");
            LocalDateTime time1 = this.parseTime(timeStr1);
            LocalDateTime time2 = this.parseTime(timeStr2);
            if (time1 == null && time2 == null) {
                return 0;
            }
            if (time1 == null) {
                return -1;
            }
            if (time2 == null) {
                return 1;
            }
            return time1.compareTo(time2);
        });
        CustomControlAction getFlowTemplateListAction = new CustomControlAction("getFlowTemplateList");
        getFlowTemplateListAction.setValue(JsonUtil.toJson(groupTemplateMapList));
        FlowEditingContext.get().getService(FlowActionService.class).sendAction(getFlowTemplateListAction);
    }

    private String createGroupKey(DynamicObject templateDO) {
        Object groupObj = templateDO.get("group");
        if (groupObj != null) {
            DynamicObject groupDO = (DynamicObject)groupObj;
            return groupDO.getPkValue() + "_" + groupDO.getString("name") + "_" + groupDO.getString("modifytime");
        }
        return "-999_" + ResManager.loadKDString((String)"\u672a\u5206\u7c7b", (String)"InitEventHandler_0", (String)"ai-gai-plugin", (Object[])new Object[0]) + "_9999-12-31";
    }

    private Map<String, Object> createTemplateMap(DynamicObject templateDO) {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        templateMap.put("id", String.valueOf(templateDO.getPkValue()));
        templateMap.put("number", templateDO.getString("number"));
        templateMap.put("name", templateDO.getString("name"));
        templateMap.put("desc", templateDO.getString("servicedesc"));
        templateMap.put("ispreset", templateDO.getBoolean("ispreset"));
        return templateMap;
    }

    private Map<String, Object> createGroupMap(String groupKey, List<Map<String, Object>> templateList) {
        HashMap<String, Object> groupMap = new HashMap<String, Object>();
        String[] parts = groupKey.split("_");
        groupMap.put("groupId", parts[0]);
        groupMap.put("groupName", parts[1]);
        groupMap.put("modifytime", parts[2]);
        groupMap.put("templateList", templateList);
        return groupMap;
    }

    private LocalDateTime parseTime(String timeStr) {
        if (timeStr == null || timeStr.trim().isEmpty()) {
            return null;
        }
        try {
            return LocalDateTime.parse(timeStr, FORMATTER1);
        }
        catch (DateTimeParseException e1) {
            try {
                ZonedDateTime zoned = ZonedDateTime.parse(timeStr, FORMATTER2);
                return zoned.toLocalDateTime();
            }
            catch (DateTimeParseException e2) {
                return null;
            }
        }
    }
}

