/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.event;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.ai.gai.core.engine.flow.ActionBaseInfo;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.SetVarMapper;
import kd.ai.gai.core.engine.flow.SetVariableAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.flow.template.FlowTemplate;
import kd.ai.gai.core.flow.template.FlowTemplateFactory;
import kd.ai.gai.core.util.RecommendNodeUtil;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.event.IEventHandler;
import kd.ai.gai.plugin.flow.event.InitEventHandler;
import kd.ai.gai.plugin.flow.listener.FlowOperationListenerManager;
import kd.ai.gai.plugin.flow.listener.FlowOperationManager;
import kd.ai.gai.plugin.flow.listener.IFlowTemplateListener;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ValidateService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class LoadFlowTemplateEventHandler
implements IEventHandler {
    @Override
    public void handleEvent(String eventArgs) {
        Flow eventFlow = (Flow)JsonUtil.fromJson((String)eventArgs, Flow.class);
        Long flowTemplateId = eventFlow.getId();
        Optional flowTemplateOptional = FlowTemplateFactory.getTemplateById((Long)flowTemplateId);
        if (!flowTemplateOptional.isPresent()) {
            FlowEditingContext.get().getService(ViewService.class).getDesignerView().showErrorNotification(String.format(ResManager.loadKDString((String)"[id=%s]\u7684\u4efb\u52a1\u6d41\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"LoadFlowTemplateEventHandler_0", (String)"ai-gai-plugin", (Object[])new Object[0]), flowTemplateId));
            return;
        }
        FlowTemplate flowTemplate = (FlowTemplate)flowTemplateOptional.get();
        this.addTemplateParamToFlow(eventFlow);
        this.addFlowTemplateToFlow(flowTemplate);
        FlowEditingContext.get().getService(ValidateService.class).sendNodeValidateInfos();
    }

    public void addFlowTemplateToFlow(FlowTemplate flowTemplate) {
        Flow flowNew = FlowEditingContext.get().getService(ModelService.class).getFlow();
        Flow flowTemp = flowTemplate.getFlow();
        RecommendNodeUtil.removeRecommendNode((Flow)flowTemp);
        this.updateTemplateNodeId(flowTemp, flowNew);
        String validateContent = flowTemplate.getValidateContent();
        ArrayList<NodeValidateInfo> flowTemplateValidateInfos = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)validateContent) && StringUtils.isNotBlank((CharSequence)validateContent)) {
            flowTemplateValidateInfos = JSON.parseArray((String)validateContent, NodeValidateInfo.class);
        }
        flowNew.getActions().addAll(flowTemp.getActions());
        flowNew.getTransfers().addAll(flowTemp.getTransfers());
        flowNew.setMaxNodeId(flowTemp.getMaxNodeId());
        Set<IFlowTemplateListener> flowTemplateListeners = FlowOperationListenerManager.getFlowOperationListener(IFlowTemplateListener.class);
        FlowOperationManager flowOperationManager = new FlowOperationManager(flowTemp, FlowEditingContext.get());
        flowTemplateListeners.forEach(listener -> listener.beforeApplyTemplate(flowOperationManager, flowTemplate));
        List validateContents = flowTemplate.getValidateContents();
        if (CollectionUtils.isNotEmpty((Collection)validateContents)) {
            for (Map validateContentMap : validateContents) {
                NodeValidateInfo nodeValidateInfo = new NodeValidateInfo();
                nodeValidateInfo.setNodeId(Integer.parseInt((String)validateContentMap.get("nodeId")));
                nodeValidateInfo.setStatus((String)validateContentMap.get("status"));
                nodeValidateInfo.setValidMessage((String)validateContentMap.get("validMessage"));
                flowTemplateValidateInfos.add(nodeValidateInfo);
            }
        }
        this.updateTemplateValidateInfoNodeId(flowTemp, flowTemplateValidateInfos, flowNew);
        FlowEditingContext.get().getService(ModelService.class).updateFlow(flowNew);
        this.sendLoadTemplateAction(flowTemp);
    }

    public int getNewNodeId(int oldNodeId, int curMaxNodeId) {
        if (oldNodeId == 0 || oldNodeId == 1) {
            return oldNodeId;
        }
        return oldNodeId + curMaxNodeId;
    }

    private void sendLoadTemplateAction(Flow flowTemp) {
        CustomControlAction loadFlowTemplateAction = new CustomControlAction("loadFlowTemplate");
        loadFlowTemplateAction.setValue(JsonUtil.toJson((Object)flowTemp));
        List<ActionBaseInfo> actionBaseInfoList = InitEventHandler.getActionBaseInfoByFlow(flowTemp);
        loadFlowTemplateAction.setActionBaseInfos(actionBaseInfoList);
        FlowEditingContext.get().getService(FlowActionService.class).sendAction(loadFlowTemplateAction);
    }

    private void updateTemplateValidateInfoNodeId(Flow flowTemplate, List<NodeValidateInfo> flowTemplateValidateInfos, Flow flowCurrent) {
        int curMaxNodeId = flowCurrent.getMaxNodeId();
        flowTemplateValidateInfos.forEach(nodeValidateInfo -> FlowEditingContext.get().getService(ModelService.class).getValidateInfoManager().addNodeValidateInfo((NodeValidateInfo)nodeValidateInfo));
    }

    private void updateTemplateNodeId(Flow flowTemplate, Flow flowCurrent) {
        int curMaxNodeId = flowCurrent.getMaxNodeId();
        int curStartNodeId = flowCurrent.getStart().getId();
        int curEndNodeId = flowCurrent.getEnd().getId();
        int oldStartNodeId = flowTemplate.getStart().getId();
        int oldEndNodeId = flowTemplate.getEnd().getId();
        flowTemplate.getStart().setId(curStartNodeId);
        flowTemplate.getEnd().setId(curEndNodeId);
        boolean bNoNeedLinkStartAndEnd = !flowCurrent.getActions().isEmpty();
        List transfers = flowTemplate.getTransfers();
        ListIterator transferListIterator = transfers.listIterator();
        while (transferListIterator.hasNext()) {
            Transfer transfer = (Transfer)transferListIterator.next();
            if (bNoNeedLinkStartAndEnd && transfer.getFromNodeId() == oldStartNodeId) {
                flowTemplate.findNodeById(transfer.getToNodeId()).removeInTransfer(transfer);
                transferListIterator.remove();
                continue;
            }
            if (bNoNeedLinkStartAndEnd && transfer.getToNodeId() == oldEndNodeId) {
                flowTemplate.findNodeById(transfer.getFromNodeId()).removeOutTransfer(transfer);
                transferListIterator.remove();
                continue;
            }
            transfer.setId(transfer.getId() + curMaxNodeId);
            int toNodeId = transfer.getToNodeId();
            if (toNodeId == oldEndNodeId) {
                transfer.setToNodeId(curEndNodeId);
            } else {
                transfer.setToNodeId(toNodeId + curMaxNodeId);
            }
            int fromNodeId = transfer.getFromNodeId();
            if (fromNodeId == oldStartNodeId) {
                transfer.setFromNodeId(curStartNodeId);
            } else {
                transfer.setFromNodeId(fromNodeId + curMaxNodeId);
            }
            if (transfer.getCondition() == null || transfer.getCondition().getConditionRows() == null || transfer.getCondition().getConditionRows().isEmpty()) continue;
            List conditionRows = transfer.getCondition().getConditionRows();
            conditionRows.forEach(row -> {
                if (row.getLeftParamPath().getNodeIdAtInt() == oldStartNodeId) {
                    row.getLeftParamPath().setNodeId(String.valueOf(curStartNodeId));
                } else {
                    row.getLeftParamPath().setNodeId(String.valueOf(row.getLeftParamPath().getNodeIdAtInt() + curMaxNodeId));
                }
                if (row.getRightParamPath() != null) {
                    if (row.getRightParamPath().getNodeIdAtInt() == oldStartNodeId) {
                        row.getRightParamPath().setNodeId(String.valueOf(curStartNodeId));
                    } else {
                        row.getRightParamPath().setNodeId(String.valueOf(row.getRightParamPath().getNodeIdAtInt() + curMaxNodeId));
                    }
                }
            });
            conditionRows.forEach(row -> {
                if (row.getLeftParamPath().getNodeIdAtInt() == oldStartNodeId) {
                    row.setLeftNodeId(curStartNodeId);
                } else {
                    row.setLeftNodeId(row.getLeftParamPath().getNodeIdAtInt() + curMaxNodeId);
                }
                if (row.getRightParamPath() == null || row.getRightParamPath().getNodeIdAtInt() == oldStartNodeId) {
                    row.setRightNodeId(curStartNodeId);
                } else {
                    row.setRightNodeId(row.getRightParamPath().getNodeIdAtInt() + curMaxNodeId);
                }
            });
        }
        List actions = flowTemplate.getActions();
        actions.forEach(action -> {
            int blockNodeId;
            action.setId(this.getNewNodeId(action.getId(), curMaxNodeId));
            if (ParamMode.VARIABLE.name().equals(flowTemplate.getParamMode())) {
                action.getParams().values().forEach(paramDefinitionMap -> paramDefinitionMap.values().forEach(paramDefinition -> {
                    NodeParamPath nodeParamPath = paramDefinition.getReferencePath();
                    if (nodeParamPath != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)nodeParamPath.getNodeId())) {
                        nodeParamPath.setNodeId(String.valueOf(this.getNewNodeId(nodeParamPath.getNodeIdAtInt(), curMaxNodeId)));
                    }
                }));
                if (action instanceof SetVariableAction) {
                    List setParamMap = ((SetVariableAction)action).getSetParamMap();
                    for (SetVarMapper setVarMapper : setParamMap) {
                        NodeParamPath outParamPath;
                        NodeParamPath inParamPath = setVarMapper.getInParamPath();
                        if (inParamPath != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inParamPath.getNodeId())) {
                            inParamPath.setNodeId(String.valueOf(this.getNewNodeId(inParamPath.getNodeIdAtInt(), curMaxNodeId)));
                        }
                        if ((outParamPath = setVarMapper.getOutParamPath()) == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)outParamPath.getNodeId())) continue;
                        outParamPath.setNodeId(String.valueOf(this.getNewNodeId(outParamPath.getNodeIdAtInt(), curMaxNodeId)));
                    }
                }
            }
            if ((blockNodeId = action.getBlockNodeId()) != -1) {
                action.setBlockNodeId(this.getNewNodeId(action.getBlockNodeId(), curMaxNodeId));
            }
            if (action instanceof LoopAction) {
                LoopAction loopAction = (LoopAction)action;
                List outParamMap = loopAction.getOutParamMap();
                Optional.ofNullable(loopAction.getOutParamMap()).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).forEach(mapper -> mapper.setOutNodeId(this.getNewNodeId(mapper.getOutNodeId(), curMaxNodeId)));
                Optional.ofNullable(loopAction.getLoopParamMap()).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).forEach(mapper -> mapper.setOutNodeId(this.getNewNodeId(mapper.getOutNodeId(), curMaxNodeId)));
            }
            if (action instanceof SetVariableAction) {
                SetVariableAction setVariableAction = (SetVariableAction)action;
                Optional.ofNullable(setVariableAction.getSetParamMap()).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).forEach(mapper -> {
                    mapper.setInNodeId(this.getNewNodeId(mapper.getInNodeId(), curMaxNodeId));
                    mapper.setOutNodeId(this.getNewNodeId(mapper.getOutNodeId(), curMaxNodeId));
                });
            }
            if (action instanceof ParallelAction) {
                ParallelAction parallelAction = (ParallelAction)action;
                Optional.ofNullable(parallelAction.getOutParamMap()).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).forEach(mapper -> mapper.setOutNodeId(this.getNewNodeId(mapper.getOutNodeId(), curMaxNodeId)));
            }
            if (action instanceof LLMAction) {
                VarMapper repoMapper;
                LLMAction llmAction = (LLMAction)action;
                VarMapper userInputMapper = llmAction.getUserInputMapper();
                if (userInputMapper != null) {
                    userInputMapper.setOutNodeId(this.getNewNodeId(userInputMapper.getOutNodeId(), curMaxNodeId));
                }
                if ((repoMapper = llmAction.getRepoMapper()) != null) {
                    repoMapper.setOutNodeId(this.getNewNodeId(repoMapper.getOutNodeId(), curMaxNodeId));
                }
            }
            List transferInList = action.getTransferInList();
            transferInList.replaceAll(n -> n + curMaxNodeId);
            action.setTransferInList(transferInList);
            List transferOutList = action.getTransferOutList();
            transferOutList.replaceAll(n -> n + curMaxNodeId);
            action.setTransferOutList(transferOutList);
            List inParams = action.getInParamMap();
            if (inParams != null) {
                inParams.forEach(varMapper -> varMapper.setOutNodeId(this.getNewNodeId(varMapper.getOutNodeId(), curMaxNodeId)));
            }
        });
        flowTemplate.setMaxNodeId(flowTemplate.getMaxNodeId() + curMaxNodeId);
    }

    private void addTemplateParamToFlow(Flow eventFlow) {
        Start eventStart = eventFlow.getStart();
        End eventEnd = eventFlow.getEnd();
        Flow flowNew = FlowEditingContext.get().getService(ModelService.class).getFlow();
        Start newStart = flowNew.getStart();
        if (eventStart != null && !eventStart.getInputParams().isEmpty()) {
            eventStart.addSystemParamDefinition();
            List additionalParams = eventStart.getParamByGroup(eventStart.getInputParamGroup());
            Map newStartParamMap = newStart.getParams().getOrDefault(newStart.getInputParamGroup(), new HashMap(additionalParams.size()));
            for (ParamDefinition additionalParam : additionalParams) {
                String paramName = additionalParam.getName();
                if (newStartParamMap.containsKey(paramName)) continue;
                newStartParamMap.put(paramName, additionalParam);
            }
            flowNew.getStart().setParams(newStart.getInputParamGroup(), newStartParamMap.values());
        }
        End newEnd = flowNew.getEnd();
        int maxNodeId = flowNew.getMaxNodeId();
        if (eventEnd != null && !eventEnd.getOutputParams().isEmpty()) {
            List additionalParams = eventEnd.getOutputParams();
            Map newEndParamMap = newEnd.getParams().getOrDefault(newEnd.getOutputParamGroup(), new HashMap(additionalParams.size()));
            for (ParamDefinition additionalParam : additionalParams) {
                String paramName = additionalParam.getName();
                if (newEndParamMap.containsKey(paramName)) continue;
                NodeParamPath referencePath = additionalParam.getReferencePath();
                if (referencePath != null && StringUtils.isNotBlank((CharSequence)referencePath.getNodeId())) {
                    referencePath.setNodeId(String.valueOf(this.getNewNodeId(referencePath.getNodeIdAtInt(), maxNodeId)));
                }
                newEndParamMap.put(paramName, additionalParam);
            }
            flowNew.getEnd().setParams(newEnd.getOutputParamGroup(), newEndParamMap.values());
        }
        FlowEditingContext.get().getService(ModelService.class).updateFlow(flowNew);
    }
}

