/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Position;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.event.IEventHandler;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ViewService;

public class NewNodeEventHandler
implements IEventHandler {
    @Override
    public void handleEvent(String eventArgs) {
        JSONObject jsonNodesData = JSON.parseObject((String)eventArgs);
        ProcessNodeType processNodeType = ProcessNodeType.valueOf((int)jsonNodesData.getInteger("type"));
        if (processNodeType == ProcessNodeType.Start || processNodeType == ProcessNodeType.End) {
            return;
        }
        if (processNodeType == ProcessNodeType.Condition) {
            JSONArray jsonTransfers = jsonNodesData.getJSONArray("transfers");
            List<Transfer> newTransfers = this.buildTransfersList(jsonTransfers);
            FlowEditingContext.get().getService(ModelService.class).newTransfers(newTransfers);
        } else {
            JSONArray jsonNodes = jsonNodesData.getJSONArray("nodes");
            ArrayList<Node> newNodes = new ArrayList<Node>(jsonNodes.size());
            for (int i = 0; i < jsonNodes.size(); ++i) {
                JSONObject jsonNode = jsonNodes.getJSONObject(i);
                Node node = new Node();
                node.setId(jsonNode.getInteger("id").intValue());
                node.setName(jsonNode.getString("name"));
                node.setType(jsonNode.getString("type"));
                if (jsonNode.getInteger("blockNodeId") != null) {
                    node.setBlockNodeId(jsonNode.getInteger("blockNodeId").intValue());
                }
                Position position = new Position();
                position.setX(jsonNode.getJSONObject("position").getDouble("x").doubleValue());
                position.setY(jsonNode.getJSONObject("position").getDouble("y").doubleValue());
                node.setPostion(position);
                List transeferInlistIds = jsonNode.getJSONArray("transferInList").toJavaList(Integer.class);
                node.setTransferInList(transeferInlistIds);
                List transeferOutlistIds = jsonNode.getJSONArray("transferOutList").toJavaList(Integer.class);
                node.setTransferOutList(transeferOutlistIds);
                newNodes.add(node);
            }
            FlowEditingContext.get().getService(ModelService.class).newNodes(newNodes);
            JSONArray jsonTransfers = jsonNodesData.getJSONArray("transfers");
            if (jsonTransfers != null && !jsonTransfers.isEmpty()) {
                List<Transfer> newTransfers = this.buildTransfersList(jsonTransfers);
                FlowEditingContext.get().getService(ModelService.class).newTransfers(newTransfers);
            }
        }
        FlowEditingContext.get().getService(ViewService.class).setCurrentEditNode(jsonNodesData.getInteger("id"), jsonNodesData.getInteger("type"), true);
    }

    private List<Transfer> buildTransfersList(JSONArray jsonTransfers) {
        ArrayList<Transfer> newTransfers = new ArrayList<Transfer>(jsonTransfers.size());
        for (int i = 0; i < jsonTransfers.size(); ++i) {
            JSONObject jsonTransfer = jsonTransfers.getJSONObject(i);
            Transfer transfer = new Transfer();
            transfer.setId(jsonTransfer.getInteger("id").intValue());
            transfer.setFromNodeId(jsonTransfer.getInteger("fromNodeId").intValue());
            transfer.setToNodeId(jsonTransfer.getInteger("toNodeId").intValue());
            newTransfers.add(transfer);
        }
        return newTransfers;
    }
}

