/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.event;

import java.util.List;
import java.util.ListIterator;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.event.IEventHandler;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ValidateService;

public class SaveFlowEventHandler
implements IEventHandler {
    @Override
    public void handleEvent(String eventArgs) {
        FlowEditingContext context = FlowEditingContext.get();
        if (!context.getService(ValidateService.class).validateFlowSaveFrontErrors(eventArgs)) {
            return;
        }
        Flow flowToSave = (Flow)JsonUtil.fromJson((String)eventArgs, Flow.class);
        this.setFinalFlowToSave(context, flowToSave);
        context.getService(ModelService.class).save();
    }

    public void setFinalFlowToSave(FlowEditingContext context, Flow flowToSave) {
        ModelService modelService = context.getService(ModelService.class);
        Flow flow = modelService.getFlow();
        flowToSave.setParamMode(flow.getParamMode());
        this.updateNodeInfo((Node)flow.getStart(), (Node)flowToSave.getStart());
        this.updateNodeInfo((Node)flow.getEnd(), (Node)flowToSave.getEnd());
        List actions = flow.getActions();
        for (Object action : actions) {
            if (flowToSave.isExistsNode(action.getId())) {
                this.updateNodeInfo((Node)action, flowToSave.findNodeById(action.getId()));
                continue;
            }
            modelService.getDeleteDataManager().addNode((Node)action);
        }
        List transfers = flow.getTransfers();
        for (Transfer transfer : transfers) {
            if (!flowToSave.isExistsTransfer(transfer.getId())) continue;
            this.updateTransferInfo(transfer, flowToSave.findTransferById(transfer.getId()));
        }
        flowToSave.setId(flow.getId());
        flowToSave.setMaxNodeId(flow.getMaxNodeId());
        flowToSave.setStart(flow.getStart());
        flowToSave.setEnd(flow.getEnd());
        List saveActions = flowToSave.getActions();
        ListIterator<Action> actionIterator = saveActions.listIterator();
        while (actionIterator.hasNext()) {
            Action action = (Action)actionIterator.next();
            if (!flow.isExistsNode(action.getId())) continue;
            actionIterator.set(flow.findActionById(action.getId()));
        }
        List saveTransfers = flowToSave.getTransfers();
        ListIterator<Transfer> transferIterator = saveTransfers.listIterator();
        while (transferIterator.hasNext()) {
            Transfer transfer = (Transfer)transferIterator.next();
            if (!flow.isExistsTransfer(transfer.getId())) continue;
            transferIterator.set(flow.findTransferById(transfer.getId()));
        }
        modelService.updateFlow(flowToSave);
    }

    private void updateNodeInfo(Node targetNode, Node sourceNode) {
        if (targetNode.getId() != sourceNode.getId()) {
            return;
        }
        targetNode.setName(sourceNode.getName());
        targetNode.setType(sourceNode.getType());
        targetNode.setTransferInList(sourceNode.getTransferInList());
        targetNode.setTransferOutList(sourceNode.getTransferOutList());
        targetNode.setPostion(sourceNode.getPostion());
        targetNode.setHeight(sourceNode.getHeight());
        targetNode.setWidth(sourceNode.getWidth());
    }

    private void updateTransferInfo(Transfer targetTransfer, Transfer sourceTransfer) {
        if (targetTransfer.getId() != sourceTransfer.getId()) {
            return;
        }
        targetTransfer.setFromNodeId(sourceTransfer.getFromNodeId());
        targetTransfer.setToNodeId(sourceTransfer.getToNodeId());
    }
}

