/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.plugin.flow.listener.IFlowOperationListener;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

public class FlowOperationListenerManager {
    private static final Log logger = LogFactory.getLog(FlowOperationListenerManager.class);
    private static final Set<IFlowOperationListener> flowListeners = new HashSet<IFlowOperationListener>();
    private static final Map<Class<? extends IFlowOperationListener>, Set<? extends IFlowOperationListener>> mapListenerCache = new HashMap<Class<? extends IFlowOperationListener>, Set<? extends IFlowOperationListener>>();

    private static void dynamicRegisterListeners() {
        logger.debug("\u52a0\u8f7dFlowOperationListener--\u5f00\u59cb\uff1a" + System.currentTimeMillis());
        Reflections reflections = new Reflections("kd.ai.gai.plugin.flow.listener.impl", new Scanner[]{new SubTypesScanner()});
        Set flowListenerSet = reflections.getSubTypesOf(IFlowOperationListener.class);
        flowListenerSet.forEach(listenerClass -> {
            if (!listenerClass.isInterface()) {
                flowListeners.add((IFlowOperationListener)TypesContainer.getOrRegisterSingletonInstance((String)listenerClass.getName()));
            }
        });
        logger.debug("\u52a0\u8f7dFlowOperationListener--\u7ed3\u675f\uff1a" + System.currentTimeMillis());
    }

    public static <T extends IFlowOperationListener> Set<T> getFlowOperationListener(Class<T> listenerType) {
        if (mapListenerCache.isEmpty() || ((Set)mapListenerCache.getOrDefault(listenerType, new HashSet())).isEmpty()) {
            FlowOperationListenerManager.dynamicRegisterListeners();
        }
        if (mapListenerCache.containsKey(listenerType)) {
            return mapListenerCache.get(listenerType);
        }
        Set listenerSet = flowListeners.stream().filter(listenerType::isInstance).map(listenerType::cast).collect(Collectors.toSet());
        mapListenerCache.put(listenerType, listenerSet);
        return listenerSet;
    }

    static {
        FlowOperationListenerManager.dynamicRegisterListeners();
    }
}

