/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;

public class FlowOperationManager {
    private Flow flow;
    private DynamicObject process;
    private FlowEditingContext context;
    private Map<ProcessNodeType, List<? extends Action>> mapNodeActions;

    public FlowOperationManager(Flow flow, FlowEditingContext context) {
        this.flow = flow;
        this.context = context;
        this.initNodeActionMap();
    }

    public FlowOperationManager(DynamicObject process, Flow flow, OperateOption operateOption) {
        this.process = process;
        this.flow = flow;
        this.initNodeActionMap();
    }

    private void initNodeActionMap() {
        this.mapNodeActions = new HashMap<ProcessNodeType, List<? extends Action>>();
        if (this.flow != null) {
            ProcessNodeType[] processNodeTypes;
            List actionList = this.flow.getActions();
            for (ProcessNodeType nodeType : processNodeTypes = ProcessNodeType.values()) {
                List nodeTypeActions = actionList.stream().filter(action -> nodeType == action.getNodeType()).collect(Collectors.toList());
                this.mapNodeActions.put(nodeType, nodeTypeActions);
            }
        }
    }

    public <T extends Action> List<T> getNodeActions(ProcessNodeType nodeType) {
        if (!this.mapNodeActions.containsKey(nodeType)) {
            return new ArrayList();
        }
        return this.mapNodeActions.get(nodeType);
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public DynamicObject getProcess() {
        return this.process;
    }

    public void setProcess(DynamicObject process) {
        this.process = process;
    }

    public FlowEditingContext getContext() {
        return this.context;
    }

    public void setContext(FlowEditingContext context) {
        this.context = context;
    }
}

