/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.listener.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.flow.template.FlowTemplate;
import kd.ai.gai.core.util.OperationResultUtil;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.listener.FlowOperationManager;
import kd.ai.gai.plugin.flow.listener.IFlowSaveListener;
import kd.ai.gai.plugin.flow.listener.IFlowTemplateListener;
import kd.ai.gai.plugin.flow.model.DeleteDataManager;
import kd.ai.gai.plugin.flow.model.NodeDataManager;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ListenerImpl4CusOption
implements IFlowTemplateListener,
IFlowSaveListener {
    private static final String GAI_OPERATION = "gai_operation";
    private static final String PRAMSNAME_CUSTOM_OPERTION_LIST_TODELETE = "CustomOperationListToDelete";
    private static final String PRAMSNAME_CUSTOM_OPERTION_DATA_TOSAVE = "CustomOperationDataToSave";

    @Override
    public void beforeApplyTemplate(FlowOperationManager flowOperationManager, FlowTemplate flowTemplate) {
        List<JavaPluginAction> javaPluginActionList = flowOperationManager.getNodeActions(ProcessNodeType.CusOption);
        ArrayList validateContentMapList = Lists.newArrayListWithExpectedSize((int)javaPluginActionList.size());
        javaPluginActionList.forEach(pluginAction -> {
            if (pluginAction.getActionId() <= 0L || StringUtils.isNotEmpty((CharSequence)pluginAction.getServiceName())) {
                return;
            }
            long actionId = pluginAction.getActionId();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)GAI_OPERATION);
            DynamicObject operationDO = null;
            try {
                operationDO = BusinessDataServiceHelper.loadSingle((Object)actionId, (DynamicObjectType)dt);
            }
            catch (Exception e) {
                return;
            }
            if (operationDO != null) {
                CloneUtils cloneUtils = new CloneUtils(false, true);
                DynamicObject dObjNewOperation = (DynamicObject)cloneUtils.clone((IDataEntityBase)operationDO);
                dObjNewOperation.set("createtime", null);
                dObjNewOperation.set("modifytime", null);
                dObjNewOperation.set("creator", (Object)RequestContext.get().getCurrUserId());
                dObjNewOperation.set("modifier", (Object)RequestContext.get().getCurrUserId());
                pluginAction.setActionId(0L);
                NodeConfigData nodeConfigData = new NodeConfigData();
                nodeConfigData.setNodeId(pluginAction.getId());
                nodeConfigData.setDataByDynamicObject(dObjNewOperation);
                FlowEditingContext.get().getService(ModelService.class).getNodeDataManager().add(nodeConfigData);
                String validMessage = this.valid(operationDO);
                if (StringUtils.isNotBlank((CharSequence)validMessage)) {
                    HashMap validateContentMap = Maps.newHashMapWithExpectedSize((int)3);
                    validateContentMap.put("nodeId", String.valueOf(pluginAction.getId()));
                    validateContentMap.put("validMessage", validMessage);
                    validateContentMap.put("status", "error");
                    validateContentMapList.add(validateContentMap);
                }
            }
        });
        List validateContents = flowTemplate.getValidateContents();
        if (validateContents == null) {
            flowTemplate.setValidateContents((List)validateContentMapList);
        } else {
            validateContents.addAll(validateContentMapList);
        }
    }

    public String valid(DynamicObject operationDO) {
        Object app = operationDO.get("app");
        if (app == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"GaiProcessOperationSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        String className = operationDO.getString("servicename");
        if (StringUtils.isBlank((CharSequence)className)) {
            return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u64cd\u4f5c\u7c7b\u540d\u3002", (String)"GaiProcessOperationSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        String action = operationDO.getString("action");
        if (StringUtils.isBlank((CharSequence)action)) {
            return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u64cd\u4f5c\u540d\u79f0\u3002", (String)"GaiProcessOperationSetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection inputs = operationDO.getDynamicObjectCollection("input");
        if (inputs != null) {
            int i = 1;
            for (DynamicObject show : inputs) {
                boolean showInputs = show.getBoolean("isinput");
                String inputType = show.getString("input_type");
                String inputValue = show.getString("input_value");
                if (StringUtils.isBlank((CharSequence)inputType)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u7c7b\u578b\u201d", (String)"GaiProcessMessageSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (showInputs && StringUtils.isBlank((CharSequence)inputValue)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u624b\u5de5\u7ef4\u62a4\u5185\u5bb9\u201d", (String)"GaiProcessMessageSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        return "";
    }

    @Override
    public void beforeFlowSave(FlowOperationManager flowOperationManager, OperateOption saveOption) {
        List<Long> toDeleteCustomOperationIDs = this.getToDeleteCustomOperationIDs(flowOperationManager);
        saveOption.setVariableValue(PRAMSNAME_CUSTOM_OPERTION_LIST_TODELETE, JSON.toJSONString(toDeleteCustomOperationIDs));
        NodeDataManager nodeDataManager = flowOperationManager.getContext().getService(ModelService.class).getNodeDataManager();
        List<JavaPluginAction> javaPluginActions = flowOperationManager.getNodeActions(ProcessNodeType.CusOption);
        HashMap mapToSaveCusOperationData = new HashMap(javaPluginActions.size());
        javaPluginActions.forEach(action -> {
            NodeConfigData nodeConfigData = nodeDataManager.get(action.getId());
            if (nodeConfigData == null || StringUtils.isEmpty((CharSequence)nodeConfigData.getData())) {
                return;
            }
            mapToSaveCusOperationData.put(String.valueOf(action.getId()), nodeConfigData.getData());
        });
        saveOption.setVariableValue(PRAMSNAME_CUSTOM_OPERTION_DATA_TOSAVE, JSON.toJSONString(mapToSaveCusOperationData));
    }

    private List<Long> getToDeleteCustomOperationIDs(FlowOperationManager flowOperationManager) {
        DeleteDataManager deleteDataManager = flowOperationManager.getContext().getService(ModelService.class).getDeleteDataManager();
        List<Node> cusOptionNodeList = deleteDataManager.getNodes(ProcessNodeType.CusOption);
        ArrayList<Long> toDeleteCustomOperationPkIds = new ArrayList<Long>(cusOptionNodeList.size());
        for (Node node : cusOptionNodeList) {
            long actionId = ((JavaPluginAction)node).getActionId();
            if (actionId <= 0L) continue;
            toDeleteCustomOperationPkIds.add(actionId);
        }
        return toDeleteCustomOperationPkIds;
    }

    @Override
    public void beginFlowSaveTransaction(FlowOperationManager flowOperationManager, OperateOption saveOption) {
        Flow flow = flowOperationManager.getFlow();
        List listToDeleteCustomOperationPkIds = new ArrayList(10);
        String sToDelete = saveOption.getVariableValue(PRAMSNAME_CUSTOM_OPERTION_LIST_TODELETE);
        if (StringUtils.isNotEmpty((CharSequence)sToDelete)) {
            listToDeleteCustomOperationPkIds = JSON.parseArray((String)sToDelete).toJavaList(Long.class);
        }
        if (!listToDeleteCustomOperationPkIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)GAI_OPERATION), (Object[])listToDeleteCustomOperationPkIds.toArray());
        }
        Map mapToSaveCusOperationData = new HashMap();
        String sToSave = saveOption.getVariableValue(PRAMSNAME_CUSTOM_OPERTION_DATA_TOSAVE);
        if (StringUtils.isNotEmpty((CharSequence)sToSave)) {
            mapToSaveCusOperationData = (Map)JSON.parseObject((String)sToSave, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        }
        for (Map.Entry entry : mapToSaveCusOperationData.entrySet()) {
            int nodeId = Integer.parseInt((String)entry.getKey());
            if (!flow.isExistsNode(nodeId)) continue;
            DynamicObject dObjCusOperation = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)entry.getValue()));
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)GAI_OPERATION, (DynamicObject[])new DynamicObject[]{dObjCusOperation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(OperationResultUtil.getOperationResultMessage((OperationResult)result));
            }
            JavaPluginAction pluginAction = (JavaPluginAction)flow.findActionById(nodeId);
            pluginAction.setActionId(Long.parseLong(result.getSuccessPkIds().get(0).toString()));
        }
    }
}

