/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.listener.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.flow.template.FlowTemplate;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.listener.FlowOperationManager;
import kd.ai.gai.plugin.flow.listener.IFlowTemplateListener;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public class ListenerImpl4Prompt
implements IFlowTemplateListener {
    @Override
    public void beforeApplyTemplate(FlowOperationManager flowOperationManager, FlowTemplate flowTemplate) {
        List<LLMAction> llmActions = flowOperationManager.getNodeActions(ProcessNodeType.Llm);
        ArrayList validateContentMapList = Lists.newArrayListWithExpectedSize((int)llmActions.size());
        llmActions.forEach(llmAction -> {
            String llmServiceNumber = llmAction.getLlm();
            llmAction.setLlm(GaiFieldTypeInitUtils.getDefaultLLMService((String)llmServiceNumber));
            String validMessage = "";
            if (StringUtils.isNotBlank((CharSequence)validMessage)) {
                HashMap validateContentMap = Maps.newHashMapWithExpectedSize((int)3);
                validateContentMap.put("nodeId", String.valueOf(llmAction.getId()));
                validateContentMap.put("validMessage", validMessage);
                validateContentMap.put("status", "error");
                validateContentMapList.add(validateContentMap);
            }
        });
        List validateContents = flowTemplate.getValidateContents();
        if (validateContents == null) {
            flowTemplate.setValidateContents((List)validateContentMapList);
        } else {
            validateContents.addAll(validateContentMapList);
        }
    }

    public String valid(LLMAction llmAction) {
        int promptType = llmAction.getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            long llmPromptId = llmAction.getLlmPromptId();
            if (llmPromptId == 0L) {
                return ResManager.loadKDString((String)"\u63d0\u793a\u8bcd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
            VarMapper userInputMapper = llmAction.getUserInputMapper();
            if (userInputMapper == null) {
                return ResManager.loadKDString((String)"\u7528\u6237\u8f93\u5165\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
        } else {
            String llm = llmAction.getLlm();
            if (StringUtils.isEmpty((CharSequence)llm)) {
                return ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
        }
        return null;
    }
}

