/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.instance.Instance;

public class DeleteDataManager {
    private static final String CACHEKEY_DELETE_NODE_MAP = "delete-node-map";
    private static final String CACHEKEY_DELETE_TRANSFER_MAP = "delete-transfer-map";
    private static final String JSONKEY_NODE_ID = "nodeId";
    private static final String JSONKEY_NODE_CLASSNAME = "nodeClassName";
    private static final String JSONKEY_NODE_VALUE = "value";
    private Map<Integer, Node> mapDeleteNode;
    private IPageCache pageCache;

    public DeleteDataManager(IPageCache pageCache) {
        this.pageCache = pageCache;
        this.mapDeleteNode = new HashMap<Integer, Node>(1);
        this.init();
    }

    private void init() {
        String sdeleteNodeMapCache = this.pageCache.get(CACHEKEY_DELETE_NODE_MAP);
        if (StringUtils.isNotEmpty((CharSequence)sdeleteNodeMapCache)) {
            JSONArray jsonArrayDeleteNodes = JSON.parseArray((String)sdeleteNodeMapCache);
            for (int i = 0; i < jsonArrayDeleteNodes.size(); ++i) {
                JSONObject jsonObject = jsonArrayDeleteNodes.getJSONObject(i);
                String sClassName = jsonObject.getString(JSONKEY_NODE_CLASSNAME);
                String sValue = jsonObject.getString(JSONKEY_NODE_VALUE);
                int nodeId = jsonObject.getInteger(JSONKEY_NODE_ID);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(sClassName);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(String.format("%s: %s not find.", Instance.getAppName(), sClassName), ex);
                }
                Object node = JSON.parseObject((String)sValue, clazz);
                this.mapDeleteNode.put(nodeId, (Node)node);
            }
        }
    }

    public void addNode(Node node) {
        if (node == null) {
            return;
        }
        this.mapDeleteNode.put(node.getId(), node);
        this.save();
    }

    public void addNodes(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            if (node == null) {
                return;
            }
            this.mapDeleteNode.put(node.getId(), node);
        }
        this.save();
    }

    public List<Node> getNodes(ProcessNodeType processNodeType) {
        ArrayList<Node> nodeList = new ArrayList<Node>(this.mapDeleteNode.size());
        for (Map.Entry<Integer, Node> entry : this.mapDeleteNode.entrySet()) {
            Node node = entry.getValue();
            if (node.getNodeType() != processNodeType) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    public void clear() {
        this.mapDeleteNode.clear();
        this.save();
    }

    public Node getNode(int nodeId) {
        return this.mapDeleteNode.get(nodeId);
    }

    private void save() {
        JSONArray jsonNodeArray = new JSONArray();
        for (Map.Entry<Integer, Node> entry : this.mapDeleteNode.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(JSONKEY_NODE_ID, (Object)entry.getKey());
            jsonObject.put(JSONKEY_NODE_CLASSNAME, (Object)entry.getValue().getClass().getName());
            jsonObject.put(JSONKEY_NODE_VALUE, (Object)JSON.toJSONString((Object)entry.getValue()));
            jsonNodeArray.add((Object)jsonObject);
        }
        this.pageCache.put(CACHEKEY_DELETE_NODE_MAP, jsonNodeArray.toJSONString());
    }
}

