/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.model;

import kd.ai.gai.core.engine.flow.Node;
import kd.bos.dataentity.resource.ResManager;

public class RefrenceParam {
    public static final String SEPERATOR = "#";
    public static final String NAME_SEPERATOR = ".";
    private int nodeId;
    private String nodeName;
    private String paramName;
    private String paramType;
    private String paramValue;
    private String paramDisplayName;
    private String paramImageKey;

    public RefrenceParam(int nodeId, String nodeName, String paramName) {
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.paramName = paramName;
        this.paramValue = RefrenceParam.getParamValue(nodeId, paramName);
        this.paramDisplayName = RefrenceParam.getParamDisplayName(nodeName, paramName);
    }

    public static RefrenceParam create(Node node, String paramName) {
        RefrenceParam param = new RefrenceParam(node.getId(), node.getName(), paramName);
        switch (paramName) {
            case "system.chat_sessionid": {
                param.setParamDisplayName(RefrenceParam.getSystemChatsessionDesc());
                break;
            }
            case "system.chat_history": {
                param.setParamDisplayName(RefrenceParam.getSystemChathistoryDesc());
                break;
            }
            case "system.user_input": {
                param.setParamDisplayName(RefrenceParam.getSystemUserinputDesc());
                break;
            }
            case "system.chat_environment": {
                param.setParamDisplayName(RefrenceParam.getSystemEnvironmentDesc());
            }
        }
        return param;
    }

    public static RefrenceParam create(Node node, String paramName, String paramImageKey) {
        RefrenceParam refrenceParam = RefrenceParam.create(node, paramName);
        refrenceParam.paramImageKey = paramImageKey;
        return refrenceParam;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getParamType() {
        return this.paramType;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public String getParamDisplayName() {
        return this.paramDisplayName;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public void setParamDisplayName(String paramDisplayName) {
        this.paramDisplayName = paramDisplayName;
    }

    public String getParamImageKey() {
        return this.paramImageKey;
    }

    public static String getParamValue(int nodeId, String paramName) {
        return String.format("%s%s%s", nodeId, SEPERATOR, paramName);
    }

    public static String getParamValue(String nodeId, String paramName) {
        return String.format("%s%s%s", nodeId, SEPERATOR, paramName);
    }

    public static String getParamDisplayName(String nodeName, String paramName) {
        return String.format("%s%s%s", nodeName, NAME_SEPERATOR, paramName);
    }

    public static String getSystemUserinputDesc() {
        return ResManager.loadKDString((String)"\u7528\u6237\u8f93\u5165", (String)"AbstractGaiProcessSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
    }

    public static String getSystemChathistoryDesc() {
        return ResManager.loadKDString((String)"\u7528\u6237\u5bf9\u8bdd\u5386\u53f2", (String)"AbstractGaiProcessSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
    }

    public static String getSystemChatsessionDesc() {
        return ResManager.loadKDString((String)"\u4f1a\u8bddID", (String)"AbstractGaiProcessSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
    }

    public static String getSystemEnvironmentDesc() {
        return ResManager.loadKDString((String)"\u4f7f\u7528\u73af\u5883", (String)"AbstractGaiProcessSetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
    }
}

