/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.domain.dto.ProcessNode;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.BatchAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractBatchNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.AskUserNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.CodeNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.CusOptionNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.LLMNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.LoopNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.MessageNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.ParallelNodeReference;
import kd.ai.gai.plugin.flow.refrence.RepoNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.RepoReplyNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.SetVariableNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.StartNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.ToolNodeReference;
import kd.ai.gai.plugin.flow.refrence.TransferRefrence;
import kd.ai.gai.plugin.flow.refrence.VisionNodeRefrence;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;

public class RefrenceParamManager {
    private static final Map<ProcessNodeType, String> nodeRefrenceMap = new EnumMap<ProcessNodeType, String>(ProcessNodeType.class);
    private ModelService modelService;

    public RefrenceParamManager(ModelService modelService) {
        this.modelService = modelService;
    }

    public static RefrenceDataConfig getFullRefrenceConfig(int nodeId) {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setNodeId(nodeId);
        config.setIncludeSelfNode(true);
        config.setNeedBlockInnerNode(true);
        config.setAddChatHistory(true);
        return config;
    }

    public List<RefrenceParam> getFullCanRefrenceParamList(int nodeId) {
        return this.getCanRefrenceParamList(nodeId, RefrenceParamManager.getFullRefrenceConfig(nodeId));
    }

    public List<RefrenceParam> getCanRefrenceParamList(int nodeId, RefrenceDataConfig config) {
        int blockNodeId;
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>(10);
        Flow flow = this.modelService.getFlow();
        if (config == null) {
            config = new RefrenceDataConfig();
            config.setNodeId(nodeId);
        }
        config.setNodeId(nodeId);
        ArrayList<ProcessNode> upNodesList = new ArrayList<ProcessNode>(8);
        if (flow.isExistsTransfer(nodeId)) {
            Transfer transfer = flow.findTransferById(nodeId);
            nodeId = transfer.getFromNodeId();
            blockNodeId = flow.getBlockNodeIdByActionId(nodeId);
            config.setBlockNodeId(blockNodeId);
            upNodesList.addAll(flow.allUpProcessNodes(nodeId, true));
        } else {
            Action action = flow.findActionById(nodeId);
            blockNodeId = action.getBlockNodeId();
            config.setBlockNodeId(blockNodeId);
            if (config.isIncludeSelfNode()) {
                upNodesList.add(ProcessNode.parse((Node)action));
            }
            if (config.isNeedBlockInnerNode() && (action.isLoopBlockNode() || action.isParallelBlockNode())) {
                List processNodes = flow.allBlockInnerProcessNodes(action.getId());
                Collections.reverse(processNodes);
                upNodesList.addAll(processNodes);
            }
            if (!config.isOnlyNeedBlockInnerNode()) {
                upNodesList.addAll(flow.allUpProcessNodes(nodeId, false));
            }
        }
        if (blockNodeId != -1) {
            upNodesList.addAll(flow.allUpProcessNodes(blockNodeId, true));
        }
        for (ProcessNode processNode : upNodesList) {
            Set<Integer> onlyNodeIdList;
            Node node = flow.findNodeById(processNode.getNodeId());
            List<ProcessNodeType> onlyNodeType = config.getOnlyNodeTypeList();
            if (onlyNodeType != null && !onlyNodeType.isEmpty() && !onlyNodeType.contains(node.getNodeType()) || (onlyNodeIdList = config.getOnlyNodeIdList()) != null && !onlyNodeIdList.contains(processNode.getNodeId())) continue;
            AbstractNodeRefrence abstractNodeRefrence = RefrenceParamManager.getNodeRefrenceInstance(node);
            abstractNodeRefrence.setModelService(this.modelService);
            abstractNodeRefrence.setNode(node);
            List<RefrenceParam> nodeRefrenceParam = abstractNodeRefrence.getOutRefrenceParams(config);
            List<String> onlyParamType = config.getOnlyParamTypeList();
            if (onlyParamType != null && !onlyParamType.isEmpty()) {
                nodeRefrenceParam.removeIf(param -> !onlyParamType.contains(param.getParamType()));
            }
            refrenceParamList.addAll(nodeRefrenceParam);
        }
        return refrenceParamList;
    }

    private NodeValidateInfo validateOneNodeRefrenceParam(Node node) {
        AbstractNodeRefrence abstractNodeRefrence = RefrenceParamManager.getNodeRefrenceInstance(node);
        abstractNodeRefrence.setModelService(this.modelService);
        abstractNodeRefrence.setNode(node);
        String sValidateMessage = abstractNodeRefrence.validateInRefrenceParams();
        return this.createNodeValidateInfo(node.getId(), sValidateMessage);
    }

    private NodeValidateInfo createNodeValidateInfo(int nodeId, String sValidMessage) {
        if (!StringUtils.isEmpty((CharSequence)sValidMessage)) {
            NodeValidateInfo nodeValidateInfo = new NodeValidateInfo();
            nodeValidateInfo.setNodeId(nodeId);
            nodeValidateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            nodeValidateInfo.setValidMessage(sValidMessage);
            return nodeValidateInfo;
        }
        NodeValidateInfo nodeValidateInfo = new NodeValidateInfo();
        nodeValidateInfo.setNodeId(nodeId);
        nodeValidateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        nodeValidateInfo.setValidMessage("");
        return nodeValidateInfo;
    }

    public List<NodeValidateInfo> validateOneNodeRefrenceParam(int nodeId) {
        Flow flow = this.modelService.getFlow();
        if (!flow.isExistsNode(nodeId)) {
            return Collections.emptyList();
        }
        Node node = flow.findNodeById(nodeId);
        ArrayList<NodeValidateInfo> validateInfoList = new ArrayList<NodeValidateInfo>(1);
        NodeValidateInfo nodeValidateInfo = this.validateOneNodeRefrenceParam(node);
        validateInfoList.add(nodeValidateInfo);
        List outTransferIdList = node.getTransferOutList();
        if (outTransferIdList != null && !outTransferIdList.isEmpty()) {
            for (Integer transferId : outTransferIdList) {
                if (!flow.isExistsTransfer(transferId.intValue())) continue;
                Transfer transfer = flow.findTransferById(transferId.intValue());
                NodeValidateInfo transferValidateInfo = this.validateTransferRefrenceParam(transfer);
                validateInfoList.add(transferValidateInfo);
            }
        }
        if (node.isLoopBlockNode() || node.isParallelBlockNode()) {
            List innerNodes = flow.allBlockInnerProcessNodes(node.getId());
            innerNodes.forEach(innerNode -> validateInfoList.addAll(this.validateOneNodeRefrenceParam(innerNode.getNodeId())));
        }
        return validateInfoList;
    }

    public List<NodeValidateInfo> validateNodesRefrenceParam(int parentNodeId) {
        Flow flow = this.modelService.getFlow();
        if (!flow.isExistsNode(parentNodeId)) {
            return Collections.emptyList();
        }
        Node parentNode = flow.findNodeById(parentNodeId);
        List childNodes = flow.getAllChildNodes(parentNodeId);
        childNodes.add(0, parentNode);
        return this.validateSpecifyNodesRefrenceParam(childNodes);
    }

    public List<NodeValidateInfo> validateSpecifyNodesRefrenceParam(List<Node> nodes) {
        ArrayList<NodeValidateInfo> validateInfoList = new ArrayList<NodeValidateInfo>(nodes.size());
        for (Node node : nodes) {
            List<NodeValidateInfo> list = this.validateOneNodeRefrenceParam(node.getId());
            validateInfoList.addAll(list);
        }
        return validateInfoList;
    }

    public NodeValidateInfo validateTransferRefrenceParam(Transfer transfer) {
        TransferRefrence transferRefrence = new TransferRefrence();
        transferRefrence.setModelService(this.modelService);
        transferRefrence.setTransfer(transfer);
        String sValidateMessage = transferRefrence.validateInRefrenceParams();
        return this.createNodeValidateInfo(transfer.getId(), sValidateMessage);
    }

    private static AbstractNodeRefrence getNodeRefrenceInstance(Node node) {
        ProcessNodeType nodeType = node.getNodeType();
        String className = nodeRefrenceMap.get(nodeType);
        if (className != null) {
            return (AbstractNodeRefrence)TypesContainer.createInstance((String)className);
        }
        if (node instanceof BatchAction) {
            return new AbstractBatchNodeRefrence();
        }
        return new AbstractNodeRefrence();
    }

    public List<RefrenceParam> getRefrenceParamList(Action action, RefrenceDataConfig config) {
        AbstractNodeRefrence abstractNodeRefrence = RefrenceParamManager.getNodeRefrenceInstance((Node)action);
        abstractNodeRefrence.setModelService(this.modelService);
        abstractNodeRefrence.setNode((Node)action);
        return abstractNodeRefrence.getOutRefrenceParams(config);
    }

    static {
        nodeRefrenceMap.put(ProcessNodeType.Start, StartNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Llm, LLMNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.CusOption, CusOptionNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Message, MessageNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.PresetOption, CusOptionNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.AskUser, AskUserNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Repo, RepoNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.RepoReply, RepoReplyNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Loop, LoopNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.SetVariable, SetVariableNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Code, CodeNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Parallel, ParallelNodeReference.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Tool, ToolNodeReference.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Vision, VisionNodeRefrence.class.getName());
    }
}

