/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.BatchAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import org.apache.commons.lang3.StringUtils;

public class AbstractBatchNodeRefrence
extends AbstractNodeRefrence {
    @Override
    public List<RefrenceParam> getOutParamsNew(RefrenceDataConfig config) {
        Node node = this.getNode();
        if (!(node instanceof BatchAction)) {
            return Collections.emptyList();
        }
        BatchAction batchAction = (BatchAction)node;
        if (batchAction.isEnableBatch() && config.getNodeId() != batchAction.getId()) {
            return this.getBatchOutParams(batchAction, config);
        }
        if (batchAction.isEnableBatch() && config.getNodeId() == batchAction.getId()) {
            return this.getBatchInnerParams(batchAction, config);
        }
        return super.getOutParamsNew(config);
    }

    protected List<RefrenceParam> getBatchInnerParams(BatchAction batchAction, RefrenceDataConfig config) {
        List innerParams = batchAction.getParamByGroup("BATCH_INNER_GROUP");
        ArrayList<RefrenceParam> referenceParams = new ArrayList<RefrenceParam>(innerParams.size());
        for (ParamDefinition paramDef : innerParams) {
            if (paramDef == null || !StringUtils.isNotEmpty((CharSequence)paramDef.getName())) continue;
            RefrenceParam referenceParam = this.createReferenceParam(paramDef);
            referenceParams.add(referenceParam);
        }
        return referenceParams;
    }

    protected List<RefrenceParam> getBatchOutParams(BatchAction batchAction, RefrenceDataConfig config) {
        List outputParams = batchAction.getBatchOutputParams();
        if (outputParams == null) {
            return Collections.emptyList();
        }
        ArrayList<RefrenceParam> referenceParams = new ArrayList<RefrenceParam>(outputParams.size());
        for (ParamDefinition outputParam : outputParams) {
            if (outputParam == null || !StringUtils.isNotEmpty((CharSequence)outputParam.getName())) continue;
            RefrenceParam referenceParam = this.createReferenceParam(outputParam);
            referenceParams.add(referenceParam);
        }
        return referenceParams;
    }

    @Override
    protected String getParamValidateMsgNewUniversal(Action action) {
        String msg = super.getParamValidateMsgNewUniversal(action);
        String batchInputMsg = "";
        if (!(action instanceof ParallelAction)) {
            batchInputMsg = this.validateGroupParamDefinitions(action, "BATCH_INPUT_GROUP", "\u6279\u5904\u8f93\u5165");
        }
        return msg + batchInputMsg;
    }
}

