/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.flow.node.DesignNode;
import kd.ai.gai.core.flow.param.define.ArrayParamDefinition;
import kd.ai.gai.core.flow.param.define.NodeParamPath;
import kd.ai.gai.core.flow.param.define.ObjectParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.flow.config.helper.FlowConfigEntityHelper;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.model.RefrenceParamManager;
import kd.ai.gai.plugin.flow.refrence.INodeRefrence;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateResult;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateStatus;
import kd.ai.gai.plugin.flow.services.ModelService;
import org.apache.commons.lang3.StringUtils;

public class AbstractNodeRefrence
implements INodeRefrence {
    private ModelService modelService;
    private Node node;
    private List<String> canRefParamValueList;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    protected ModelService getModelService() {
        return this.modelService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    protected List<String> getFullCanRefrenceParamValueList() {
        if (this.canRefParamValueList != null) {
            return this.canRefParamValueList;
        }
        List<RefrenceParam> canRefrenceParamList = this.getModelService().getRefrenceParamManager().getFullCanRefrenceParamList(this.node.getId());
        this.canRefParamValueList = new ArrayList<String>(canRefrenceParamList.size());
        for (RefrenceParam param : canRefrenceParamList) {
            this.canRefParamValueList.add(param.getParamValue());
        }
        return this.canRefParamValueList;
    }

    @Override
    public List<RefrenceParam> getOutRefrenceParams(RefrenceDataConfig config) {
        List<ParamDefinition> editingParamList = config.getEditingParamList();
        if (config.getNodeId() == this.getNode().getId() && editingParamList != null) {
            ArrayList<RefrenceParam> referenceParams = new ArrayList<RefrenceParam>(editingParamList.size());
            for (ParamDefinition editingParam : editingParamList) {
                if (editingParam == null || !StringUtils.isNotEmpty((CharSequence)editingParam.getName())) continue;
                RefrenceParam referenceParam = this.createReferenceParam(editingParam);
                referenceParams.add(referenceParam);
            }
            return referenceParams;
        }
        boolean enablePropertyParamMode = FlowConfigEntityHelper.isPropertyParamMode();
        return enablePropertyParamMode ? this.getOutParamsOld(config) : this.getOutParamsNew(config);
    }

    public List<RefrenceParam> getOutParamsNew(RefrenceDataConfig config) {
        if (this.node == null || !(this.node instanceof DesignNode)) {
            return Collections.emptyList();
        }
        DesignNode designNode = (DesignNode)this.node;
        List outputParams = designNode.getOutputParams();
        if (outputParams == null) {
            return Collections.emptyList();
        }
        ArrayList<RefrenceParam> referenceParams = new ArrayList<RefrenceParam>(outputParams.size());
        for (ParamDefinition outputParam : outputParams) {
            if (outputParam == null || !StringUtils.isNotEmpty((CharSequence)outputParam.getName())) continue;
            RefrenceParam referenceParam = this.createReferenceParam(outputParam);
            referenceParams.add(referenceParam);
        }
        return referenceParams;
    }

    public List<RefrenceParam> getOutParamsOld(RefrenceDataConfig config) {
        return Collections.emptyList();
    }

    protected RefrenceParam createReferenceParam(ParamDefinition paramDefinition) {
        RefrenceParam refParam = paramDefinition instanceof ArrayParamDefinition || paramDefinition instanceof ObjectParamDefinition ? RefrenceParam.create(this.node, paramDefinition.getName(), "/icons/pc/other/xcjly_zk_16_16.png") : RefrenceParam.create(this.node, paramDefinition.getName(), "/icons/pc/state/not_passing_13_13.png");
        if (paramDefinition instanceof ArrayParamDefinition) {
            refParam.setParamType(GaiFieldTypeInitUtils.buildDisplayedArrayType((ParamType)((ArrayParamDefinition)paramDefinition).getItemDefinition().getType()));
        } else {
            refParam.setParamType(paramDefinition.getType().getDesc());
        }
        return refParam;
    }

    @Override
    public String validateInRefrenceParams() {
        boolean enablePropertyParamMode = FlowConfigEntityHelper.isPropertyParamMode();
        if (this.node instanceof Action) {
            Action action = (Action)this.node;
            return enablePropertyParamMode ? this.getParamValidateMsgOldUniversal(action) : this.getParamValidateMsgNewUniversal(action);
        }
        return "";
    }

    protected String getParamValidateMsgOldUniversal(Action action) {
        List varMapperList = action.getInParamMap();
        if (varMapperList == null || varMapperList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < varMapperList.size(); ++i) {
            VarMapper varMapper = (VarMapper)varMapperList.get(i);
            int nodeId = varMapper.getOutNodeId();
            String paramName = varMapper.getOutVarName();
            this.appendValidateMsg("", nodeId, paramName, sb, i);
        }
        return sb.toString();
    }

    protected String getParamValidateMsgNewUniversal(Action action) {
        String inValidateMsg = this.validateGroupParamDefinitions(action, action.getInputParamGroup(), "\u8f93\u5165");
        String outValidateMsg = this.validateGroupParamDefinitions(action, action.getOutputParamGroup(), "\u8f93\u51fa");
        return inValidateMsg + outValidateMsg;
    }

    protected String validateGroupParamDefinitions(Action action, String paramGroup, String displayGroupName) {
        List params = action.getParamByGroup(paramGroup);
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            ParamDefinition paramDefinition = (ParamDefinition)params.get(i);
            if (!paramDefinition.isReference()) continue;
            NodeParamPath referencePath = paramDefinition.getReferencePath();
            int nodeId = Integer.parseInt(referencePath.getNodeId());
            String paramName = referencePath.getOutputParamName();
            this.appendValidateMsg(displayGroupName, nodeId, paramName, sb, i);
        }
        return sb.toString();
    }

    protected void appendValidateMsg(String displayGroupName, int nodeId, String paramName, StringBuilder sb, int i) {
        String paramValue;
        RefrenceParamValidateResult result = this.validateRefrenceParam(nodeId, paramName);
        String paramDisplayName = paramValue = RefrenceParam.getParamValue(nodeId, paramName);
        if (result.getStatus() != RefrenceParamValidateStatus.NODE_NOTEXISTS) {
            paramValue = result.getRefrenceParam().getParamValue();
            paramDisplayName = result.getRefrenceParam().getParamDisplayName();
        }
        switch (result.getStatus()) {
            case NODE_NOTEXISTS: {
                sb.append(String.format("%s \u7b2c%s\u884c\u7684\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", displayGroupName, i + 1, paramValue));
                sb.append("\n");
                break;
            }
            case PARAM_NOTEXISTS: {
                sb.append(String.format("%s \u7b2c%s\u884c\u7684\u6765\u6e90(%s)\u4e0d\u5b58\u5728\u3002", displayGroupName, i + 1, paramDisplayName));
                sb.append("\n");
                break;
            }
            case NODE_NOTPARENT: {
                sb.append(String.format("%s \u7b2c%s\u884c\u7684\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u7236\u8282\u70b9\u3002", displayGroupName, i + 1, paramDisplayName));
                sb.append("\n");
            }
        }
    }

    protected RefrenceParamValidateResult validateRefrenceParam(int refrenceNodeId, String paramName) {
        RefrenceParamValidateResult result = new RefrenceParamValidateResult();
        Node refrenceNode = null;
        Flow flow = this.modelService.getFlow();
        boolean bNodeDelete = false;
        if (flow.isExistsNode(refrenceNodeId)) {
            refrenceNode = flow.findNodeById(refrenceNodeId);
            RefrenceParam param = RefrenceParam.create(refrenceNode, paramName);
            result.setRefrenceParam(param);
            result.setRefrenceNode(refrenceNode);
        } else {
            bNodeDelete = true;
        }
        if (bNodeDelete) {
            result.setStatus(RefrenceParamValidateStatus.NODE_NOTEXISTS);
        } else {
            List<String> canRefrenceParamsValue = this.getFullCanRefrenceParamValueList();
            if (canRefrenceParamsValue.contains(result.getRefrenceParam().getParamValue())) {
                result.setStatus(RefrenceParamValidateStatus.PASS);
            } else if (!this.isExistsRefParam(result.getRefrenceNode(), result.getRefrenceParam().getParamName())) {
                result.setStatus(RefrenceParamValidateStatus.PARAM_NOTEXISTS);
            } else {
                result.setStatus(RefrenceParamValidateStatus.NODE_NOTPARENT);
            }
        }
        return result;
    }

    private boolean isExistsRefParam(Node node, String paramName) {
        List<RefrenceParam> refrenceParams = this.getModelService().getRefrenceParamManager().getRefrenceParamList((Action)node, RefrenceParamManager.getFullRefrenceConfig(node.getId()));
        for (RefrenceParam refParam : refrenceParams) {
            if (!refParam.getParamName().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    private boolean isChildOfParent(Node parentNode) {
        Flow flow = this.modelService.getFlow();
        List childNodes = flow.getAllChildNodes(parentNode.getId());
        for (Node childNode : childNodes) {
            if (childNode.getId() != this.node.getId()) continue;
            return true;
        }
        return false;
    }

    protected static List<RefrenceParam> varTransferToParam(Node node, List<Var> varList) {
        return varList == null ? Collections.emptyList() : varList.stream().filter(Objects::nonNull).filter(var -> StringUtils.isNotEmpty((CharSequence)var.getName())).map(var -> RefrenceParam.create(node, var.getName())).collect(Collectors.toList());
    }
}

