/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.plugin.flow.config.helper.FlowConfigEntityHelper;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateResult;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class LLMNodeRefrence
extends AbstractNodeRefrence {
    private static final String ENTITY_GAI_PROMPT = "gai_prompt";
    private static final String KEY_ENTRY_ENTITY_OUT_VAR_CONFIG = "out_var_configs";

    @Override
    public List<RefrenceParam> getOutParamsOld(RefrenceDataConfig config) {
        List<RefrenceParam> refrenceParamList;
        Node node = this.getNode();
        LLMAction llmAction = (LLMAction)node;
        int promptType = llmAction.getPromptType();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            DynamicObjectCollection outVarConfig;
            long actionId = ((LLMAction)node).getLlmPromptId();
            if (actionId <= 0L) {
                return Collections.emptyList();
            }
            DynamicObject serviceInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)actionId, (String)ENTITY_GAI_PROMPT);
            DynamicObjectCollection dynamicObjectCollection = outVarConfig = serviceInfo == null ? null : serviceInfo.getDynamicObjectCollection(KEY_ENTRY_ENTITY_OUT_VAR_CONFIG);
            if (outVarConfig == null) {
                return Collections.emptyList();
            }
            refrenceParamList = new ArrayList<RefrenceParam>(outVarConfig.size());
            for (DynamicObject var : outVarConfig) {
                String name = var.getString("out_var");
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                refrenceParamList.add(RefrenceParam.create(node, name));
            }
        } else {
            List outputVarList = llmAction.getPromptTemplateContent().getOutputVarList();
            refrenceParamList = LLMNodeRefrence.varTransferToParam(node, outputVarList);
        }
        return refrenceParamList;
    }

    @Override
    public String validateInRefrenceParams() {
        LLMAction action = (LLMAction)this.getNode();
        boolean enablePropertyParamMode = FlowConfigEntityHelper.isPropertyParamMode();
        return enablePropertyParamMode ? this.getParamValidateMsgOld(action) : this.getParamValidateMsgNew(action);
    }

    public String getParamValidateMsgOld(LLMAction llmAction) {
        VarMapper varMapper = llmAction.getUserInputMapper();
        VarMapper varRepoMapper = llmAction.getRepoMapper();
        List varMapperList = llmAction.getInParamMap();
        int promptType = llmAction.getPromptType();
        StringBuilder sb = new StringBuilder();
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            String sRefrenceDisplayName;
            String sRefrenceValue;
            RefrenceParamValidateResult result;
            if (varMapper != null) {
                result = this.validateRefrenceParam(varMapper.getOutNodeId(), varMapper.getOutVarName());
                sRefrenceDisplayName = sRefrenceValue = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                if (result.getStatus() != RefrenceParamValidateStatus.NODE_NOTEXISTS) {
                    sRefrenceValue = result.getRefrenceParam().getParamValue();
                    sRefrenceDisplayName = result.getRefrenceParam().getParamDisplayName();
                }
                switch (result.getStatus()) {
                    case NODE_NOTEXISTS: {
                        sb.append(String.format("\u7528\u6237\u8f93\u5165\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", sRefrenceValue));
                        sb.append("\n");
                        break;
                    }
                    case PARAM_NOTEXISTS: {
                        sb.append(String.format("\u7528\u6237\u8f93\u5165\u6765\u6e90(%s)\u4e0d\u5b58\u5728\u3002", sRefrenceDisplayName));
                        sb.append("\n");
                        break;
                    }
                    case NODE_NOTPARENT: {
                        sb.append(String.format("\u7528\u6237\u8f93\u5165\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u7236\u8282\u70b9\u3002", sRefrenceDisplayName));
                        sb.append("\n");
                    }
                }
            }
            if (varRepoMapper != null) {
                result = this.validateRefrenceParam(varRepoMapper.getOutNodeId(), varRepoMapper.getOutVarName());
                sRefrenceDisplayName = sRefrenceValue = RefrenceParam.getParamValue(varRepoMapper.getOutNodeId(), varRepoMapper.getOutVarName());
                if (result.getStatus() != RefrenceParamValidateStatus.NODE_NOTEXISTS) {
                    sRefrenceValue = result.getRefrenceParam().getParamValue();
                    sRefrenceDisplayName = result.getRefrenceParam().getParamDisplayName();
                }
                switch (result.getStatus()) {
                    case NODE_NOTEXISTS: {
                        sb.append(String.format("\u52a8\u6001\u77e5\u8bc6\u5e93(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", sRefrenceValue));
                        sb.append("\n");
                        break;
                    }
                    case PARAM_NOTEXISTS: {
                        sb.append(String.format("\u52a8\u6001\u77e5\u8bc6\u5e93(%s)\u4e0d\u5b58\u5728\u3002", sRefrenceDisplayName));
                        sb.append("\n");
                        break;
                    }
                    case NODE_NOTPARENT: {
                        sb.append(String.format("\u52a8\u6001\u77e5\u8bc6\u5e93(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u7236\u8282\u70b9\u3002", sRefrenceDisplayName));
                        sb.append("\n");
                    }
                }
            }
        } else {
            for (int i = 0; i < varMapperList.size(); ++i) {
                VarMapper varMapperItem = (VarMapper)varMapperList.get(i);
                int nodeId = varMapperItem.getOutNodeId();
                String paramName = varMapperItem.getOutVarName();
                this.appendValidateMsg("\u8f93\u5165", nodeId, paramName, sb, i);
            }
        }
        return sb.toString();
    }

    public String getParamValidateMsgNew(LLMAction llmAction) {
        return this.getParamValidateMsgNewUniversal((Action)llmAction);
    }
}

