/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.plugin.flow.config.helper.FlowConfigEntityHelper;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import kd.bos.dataentity.utils.StringUtils;

public class LoopNodeRefrence
extends AbstractNodeRefrence {
    @Override
    public List<RefrenceParam> getOutRefrenceParams(RefrenceDataConfig config) {
        boolean enablePropertyParamMode = FlowConfigEntityHelper.isPropertyParamMode();
        return enablePropertyParamMode ? this.getOutParamsOld(config) : this.getOutParamsNew(config);
    }

    @Override
    public List<RefrenceParam> getOutParamsOld(RefrenceDataConfig config) {
        Node node = this.getNode();
        LoopAction action = (LoopAction)node;
        if (config.getBlockNodeId() == -1 || config.getBlockNodeId() != node.getId()) {
            List varList = action.getOutputVars();
            return LoopNodeRefrence.varTransferToParam(node, varList);
        }
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>();
        List varList = action.getVarList();
        if (varList != null && !config.isOnlyNeedBlockNodeVar()) {
            for (Var var : varList) {
                String name = var.getName();
                if ("Array<Object>".equals(var.getType())) {
                    refrenceParamList.add(RefrenceParam.create(node, name + ".businessId"));
                    refrenceParamList.add(RefrenceParam.create(node, name + ".chunk"));
                    refrenceParamList.add(RefrenceParam.create(node, name + ".chunkId"));
                    refrenceParamList.add(RefrenceParam.create(node, name + ".repoId"));
                    refrenceParamList.add(RefrenceParam.create(node, name + ".title"));
                    refrenceParamList.add(RefrenceParam.create(node, name + ".url"));
                    refrenceParamList.add(RefrenceParam.create(node, name + ".{{index}}"));
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                refrenceParamList.add(RefrenceParam.create(node, name + ".{{item}}"));
                refrenceParamList.add(RefrenceParam.create(node, name + ".{{index}}"));
            }
        }
        List loopVarList = action.getLoopVarList();
        refrenceParamList.addAll(LoopNodeRefrence.varTransferToParam(node, loopVarList));
        return refrenceParamList;
    }

    @Override
    public List<RefrenceParam> getOutParamsNew(RefrenceDataConfig config) {
        Node node = this.getNode();
        if ((config.getBlockNodeId() == -1 || config.getBlockNodeId() != node.getId()) && node.getId() != config.getNodeId()) {
            return super.getOutParamsNew(config);
        }
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>();
        if (node instanceof Action) {
            List loopInputParamDefinitions = ((Action)node).getParamByGroup("LOOP_VAR_GROUP");
            if (loopInputParamDefinitions != null) {
                for (ParamDefinition loopInputParamDef : loopInputParamDefinitions) {
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)loopInputParamDef.getName())) continue;
                    refrenceParamList.add(this.createReferenceParam(loopInputParamDef));
                }
            }
            if (config.isOnlyNeedBlockNodeVar()) {
                return refrenceParamList;
            }
            List loopInnerParamDefinitions = ((Action)node).getParamByGroup("LOOP_ARR_INNER_GROUP");
            if (loopInnerParamDefinitions != null) {
                for (ParamDefinition loopInnerParamDef : loopInnerParamDefinitions) {
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)loopInnerParamDef.getName())) continue;
                    refrenceParamList.add(this.createReferenceParam(loopInnerParamDef));
                }
            }
        }
        return refrenceParamList;
    }

    @Override
    protected String getParamValidateMsgNewUniversal(Action action) {
        String arrMsg = this.validateGroupParamDefinitions(action, "LOOP_ARR_GROUP", "\u5faa\u73af\u6570\u7ec4");
        String varMsg = this.validateGroupParamDefinitions(action, "LOOP_VAR_GROUP", "\u5faa\u73af\u53d8\u91cf");
        String outMsg = this.validateGroupParamDefinitions(action, action.getOutputParamGroup(), "\u8f93\u51fa");
        return arrMsg + varMsg + outMsg;
    }
}

