/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.services;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Set;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.util.RecommendNodeUtil;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.NodePropertyDesigner;
import kd.ai.gai.plugin.flow.listener.FlowOperationListenerManager;
import kd.ai.gai.plugin.flow.listener.FlowOperationManager;
import kd.ai.gai.plugin.flow.listener.IFlowSaveListener;
import kd.ai.gai.plugin.flow.model.CurrentNodeInfo;
import kd.ai.gai.plugin.flow.model.DeleteDataManager;
import kd.ai.gai.plugin.flow.model.NodeDataManager;
import kd.ai.gai.plugin.flow.model.RefrenceParamManager;
import kd.ai.gai.plugin.flow.model.ValidateInfoManager;
import kd.ai.gai.plugin.flow.services.AbstractService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ModelService
extends AbstractService {
    private static final String FORMID_PROCESS = "gai_process";
    private static final String KEY_PROCESS_FLOWSTR = "flow";
    private IDataModel processModel;
    private Flow flow;
    private IPageCache cache;
    private NodeDataManager nodeDataManager;
    private RefrenceParamManager refrenceParamManager;
    private ValidateInfoManager validateInfoManager;
    private DeleteDataManager deleteDataManager;

    public IDataModel getProcessModel() {
        return this.processModel;
    }

    public Flow getFlow() {
        String sFlow = this.getProcessModel().getValue(KEY_PROCESS_FLOWSTR).toString();
        if (StringUtils.isNotEmpty((CharSequence)sFlow)) {
            Flow flowWithRecommend = JsonUtil.fromBase64String((String)sFlow);
            RecommendNodeUtil.removeRecommendNode((Flow)flowWithRecommend);
            this.flow = flowWithRecommend;
            Object number = this.processModel.getValue("number");
            if (number != null) {
                this.flow.setNumber(number.toString());
            }
        }
        return this.flow;
    }

    public NodeDataManager getNodeDataManager() {
        return this.nodeDataManager;
    }

    public RefrenceParamManager getRefrenceParamManager() {
        return this.refrenceParamManager;
    }

    public ValidateInfoManager getValidateInfoManager() {
        return this.validateInfoManager;
    }

    public DeleteDataManager getDeleteDataManager() {
        return this.deleteDataManager;
    }

    public ModelService(IFormView processView) {
        this.cache = processView.getPageCache();
        this.processModel = processView.getModel();
        this.nodeDataManager = new NodeDataManager(this.cache, this.processModel);
        this.refrenceParamManager = new RefrenceParamManager(this);
        this.validateInfoManager = new ValidateInfoManager(this.cache);
        this.deleteDataManager = new DeleteDataManager(this.cache);
    }

    public IPageCache getCache() {
        return this.cache;
    }

    public void setCurrentNodeInfo(CurrentNodeInfo currentNodeInfo) {
        this.getCache().put("CurrentNodeInfo", JSON.toJSONString((Object)currentNodeInfo));
    }

    public CurrentNodeInfo getCurrentNodeInfo() {
        String jsonCurrentNodeInfo = this.getCache().get("CurrentNodeInfo");
        if (StringUtils.isEmpty((CharSequence)jsonCurrentNodeInfo)) {
            return null;
        }
        return (CurrentNodeInfo)JsonUtil.fromJson((String)jsonCurrentNodeInfo, CurrentNodeInfo.class);
    }

    public void saveCurrentNodeData(boolean bRemoveCurrentNode) {
        IFormView designerView = this.getFlowEditingContext().getService(ViewService.class).getDesignerView();
        IFormView nodeConfigView = this.getFlowEditingContext().getService(ViewService.class).getNodePropertyView();
        if (nodeConfigView != null && nodeConfigView.getModel().isDataLoaded()) {
            NodePropertyDesigner nodePropertyDesigner = new NodePropertyDesigner(nodeConfigView);
            nodePropertyDesigner.saveNodeData();
            designerView.sendFormAction(nodeConfigView);
        }
        if (bRemoveCurrentNode) {
            this.getCache().remove("CurrentNodeInfo");
        }
    }

    public void updateFlow(Flow flow) {
        String flowStr = JsonUtil.toBase64String((Flow)flow);
        this.getProcessModel().setValue(KEY_PROCESS_FLOWSTR, (Object)flowStr);
    }

    public void newTransfers(List<Transfer> newTransfers) {
        Flow newFlow = this.getFlow();
        newFlow.appendNewTransfersInFlowDesignMode(newTransfers);
        if (!newTransfers.isEmpty()) {
            this.updateFlow(newFlow);
        }
    }

    public void newNodes(List<Node> newNodes) {
        Flow newFlow = this.getFlow();
        newFlow.appendNewNodesInFlowDesignMode(newNodes);
        if (!newNodes.isEmpty()) {
            this.updateFlow(newFlow);
        }
    }

    public void deleteNodes(List<Integer> nodeIdList, boolean bIsTransfer) {
        Flow flowNew = this.getFlow();
        if (bIsTransfer) {
            flowNew.deleteTransfersInFlowDesignMode(nodeIdList);
        } else {
            flowNew.deleteNodesInFlowDesignMode(nodeIdList);
        }
        this.updateFlow(flowNew);
        this.getValidateInfoManager().remove(nodeIdList);
    }

    public void save() {
        DynamicObject process = this.getProcessModel().getDataEntity(true);
        OperateOption option = OperateOption.create();
        option.setVariableValue("flowdesignersave", Boolean.TRUE.toString());
        Flow flowSave = this.getFlow();
        FlowOperationManager flowOperationManager = new FlowOperationManager(process, flowSave, option);
        flowOperationManager.setContext(FlowEditingContext.get());
        Set<IFlowSaveListener> listeners = FlowOperationListenerManager.getFlowOperationListener(IFlowSaveListener.class);
        listeners.forEach(listener -> listener.beforeFlowSave(flowOperationManager, option));
        OperationResult result = SaveServiceHelper.saveOperate((String)"save", (String)FORMID_PROCESS, (DynamicObject[])new DynamicObject[]{process}, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder sbMessage = new StringBuilder();
            sbMessage.append(result.getMessage());
            List infoList = result.getAllErrorOrValidateInfo();
            if (infoList != null) {
                for (IOperateInfo operateInfo : infoList) {
                    sbMessage.append(operateInfo.getMessage());
                }
            }
            this.getFlowEditingContext().getService(ViewService.class).getDesignerView().showErrorNotification(sbMessage.toString());
            return;
        }
        List pkIds = result.getSuccessPkIds();
        if (pkIds != null && !pkIds.isEmpty()) {
            this.getNodeDataManager().clear();
            this.getValidateInfoManager().clear();
            this.getDeleteDataManager().clear();
            this.getProcessModel().setDataChanged(false);
            this.getFlowEditingContext().getService(ViewService.class).getDesignerView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GaiProcessPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
    }
}

