/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.plugin.AbstractGaiAssistantPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class H5AssistantChatPlugin
extends AbstractGaiAssistantPlugin {
    private static final Log log = LogFactory.getLog(H5AssistantChatPlugin.class);
    private static final String AI_H5_LOGIN_URL = "h5loginurl";
    private static final String ERROR_MSG_DESCRIPTION_1 = "\u8be5\u52a9\u624b\u4fe1\u606f\u4e0d\u5b58\u5728\u3002";
    private static final String AI_GAI_PLUGIN = "ai-gai-plugin";
    private static final String GAI_GPT_ASSISTANT_CONFIG = "gai_gpt_assistant_config";
    private static final String H5_ASSISTANT_CHAT_PLUGIN_1 = "H5AssistantChatPlugin_1";
    private static final String ERROR_MSG_DESCRIPTION_2 = "\u52a9\u624b\u672a\u542f\u7528\u3002";
    private static final String H5_ASSISTANT_CHAT_PLUGIN_2 = "H5AssistantChatPlugin_2";
    private static final String ERROR_MSG_DESCRIPTION_3 = "\u52a9\u624b\u672a\u53d1\u5e03\u81f3H5\u3002";
    private static final String H5_ASSISTANT_CHAT_PLUGIN_3 = "H5AssistantChatPlugin_3";
    private static final String ERROR_MSG_DESCRIPTION_0 = "\u52a9\u624b\u4fe1\u606f\u6709\u8bef\u3002";
    private static final String H5_ASSISTANT_CHAT_PLUGIN_0 = "H5AssistantChatPlugin_0";
    private static final String IS_DS = "isDs";
    private static final String CHECKED = "checked";
    private CustomControl customcontrol;

    public void initialize() {
        this.customcontrol = (CustomControl)this.getControl("gpt_gai");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String chatType = (String)formShowParameter.getCustomParam("chatType");
        boolean isDs = "ds".equals(chatType);
        this.putCache(IS_DS, String.valueOf(isDs));
    }

    @Override
    public void beforeBindData(EventObject e) {
        long currUserId = RequestContext.get().getCurrUserId();
        if (currUserId < 1L) {
            this.doLogin();
            return;
        }
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        formShowParameter.setCustomParam("slideEnv", (Object)"H5");
        Long assId = this.getAssistantId(formShowParameter);
        if (assId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)ERROR_MSG_DESCRIPTION_0, (String)H5_ASSISTANT_CHAT_PLUGIN_0, (String)AI_GAI_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean checked = this.checkAssistant(assId);
        this.putCache(CHECKED, String.valueOf(checked));
        if (checked) {
            this.assistantInit(formView, assId);
        }
    }

    private boolean checkAssistant(Long assId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)assId, (String)GAI_GPT_ASSISTANT_CONFIG);
        if (dynamicObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)ERROR_MSG_DESCRIPTION_1, (String)H5_ASSISTANT_CHAT_PLUGIN_1, (String)AI_GAI_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (!dynamicObject.getBoolean("enable")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)ERROR_MSG_DESCRIPTION_2, (String)H5_ASSISTANT_CHAT_PLUGIN_2, (String)AI_GAI_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (!"C".equals(dynamicObject.getString("type"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)ERROR_MSG_DESCRIPTION_3, (String)H5_ASSISTANT_CHAT_PLUGIN_3, (String)AI_GAI_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        if (!this.getBooleanCache(CHECKED)) {
            return;
        }
        String eventName = e.getEventName();
        JSONObject requestData = JSON.parseObject((String)e.getEventArgs());
        String chatSessionId = requestData.getString("id");
        Context context = null;
        Map resultMap = new HashMap();
        if ("getSkillList".equals(eventName)) {
            context = FlowCacheData.getContext((String)chatSessionId);
            if (context == null) {
                GaiUtils.newContextInSlide((IFormView)this.getView(), null, (long)this.getAssistantId(this.getView().getFormShowParameter()));
                context = FlowCacheData.getContext((String)chatSessionId);
            }
            List<Skill> processDataList = context.getSkillList();
            log.info("processDataIDList: {}", (Object)processDataList.stream().map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet()).toString());
            processDataList = H5AssistantChatPlugin.getSkillListByCheckLic(context, processDataList);
            resultMap = ResultVoHelper.buildProcessList(processDataList);
            this.customcontrol.setData(resultMap);
            return;
        }
        if ("doLogin".equals(eventName)) {
            this.doLogin();
            return;
        }
        super.customEvent(e);
    }

    private void doLogin() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>(8);
        mpURL.put("url", this.createLoginUrl());
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    private void assistantInit(IFormView formView, Long assId) {
        RootPageIdContext rootPageIdContext = GaiUtils.newContextInSlide((IFormView)formView, null, (long)assId);
        Map crossPageData = rootPageIdContext.getData();
        GaiInitConfig gaiInitConfig = GaiUtils.getInitGaiConfig((Map)crossPageData, (IFormView)formView, (String)rootPageIdContext.getChatSessionId(), (long)assId);
        if (gaiInitConfig.getChatUser() != null) {
            formView.getPageCache().put("control_visible_status", String.valueOf(gaiInitConfig.getSwitchSide()));
            this.cacheAssistantInfo(gaiInitConfig);
        }
        if (this.customcontrol != null) {
            if (this.getBooleanCache(IS_DS)) {
                gaiInitConfig.setDs(true);
            }
            Map data = ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig);
            this.customcontrol.setData((Object)data);
        }
    }

    private String createLoginUrl() {
        String domain = this.getDomainUrl();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : customParams.entrySet()) {
            if ("userId".equalsIgnoreCase((String)entry.getKey()) && "guest".equalsIgnoreCase(entry.getValue() + "")) continue;
            builder.append("&").append((String)entry.getKey()).append("=").append(entry.getValue());
        }
        String redirectUrl = domain + "ai/h5/chat.do" + "?" + builder;
        String encode = null;
        try {
            encode = URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String url = this.getLoginUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            return this.getDomainUrl() + "login.html?redirect=" + encode;
        }
        return url + encode;
    }

    private String getLoginUrl() {
        Map objectMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("3ACHGCGWU9MJ", Long.valueOf(OrgUnitServiceHelper.getRootOrgId())));
        if (!objectMap.isEmpty()) {
            return (String)objectMap.get(AI_H5_LOGIN_URL);
        }
        return null;
    }

    private String getDomainUrl() {
        String domain = UrlService.getDomainContextUrl();
        if (domain.endsWith("/")) {
            return domain;
        }
        return domain + "/";
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private void putCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private boolean getBooleanCache(String key) {
        return Boolean.parseBoolean(this.getCache(key));
    }
}

