/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.impexp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.bos.dataentity.entity.LocaleString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StructRepoDataExportUtil {
    public static void exportFields(File file, List<StructRepoField> repoFieldList) {
        if (file == null) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            HashMap mapFieldNames = new HashMap();
            repoFieldList.forEach(field -> mapFieldNames.put(field.getFieldName() + "_tag", new LocaleString(field.getName())));
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
            Sheet sheet = wb.getSheet("sheet1");
            Row headerRow = sheet.getRow(2);
            int maxColIndex = headerRow.getLastCellNum();
            Stack<Integer> deleteColIndex = new Stack<Integer>();
            for (int i = 0; i < maxColIndex; ++i) {
                String headerFiledName = headerRow.getCell(i).getStringCellValue();
                if (!headerFiledName.startsWith("datafield") || mapFieldNames.containsKey(headerFiledName)) continue;
                deleteColIndex.push(i);
            }
            int newMaxColIndex = maxColIndex - deleteColIndex.size();
            int maxRow = sheet.getLastRowNum();
            while (!deleteColIndex.isEmpty()) {
                Row row;
                short curRowMaxCol;
                int col = (Integer)deleteColIndex.pop();
                for (int i = 2; i <= maxRow && col < (curRowMaxCol = (row = sheet.getRow(i)).getLastCellNum()); ++i) {
                    row.removeCell(row.getCell(col));
                    row.shiftCellsLeft(col + 1, (int)curRowMaxCol, 1);
                }
            }
            HashMap<String, Integer> mapFieldColIndex = new HashMap<String, Integer>();
            int iFirstDataFieldColIndex = -1;
            for (int i = 0; i < newMaxColIndex; ++i) {
                String headerFiledName = headerRow.getCell(i).getStringCellValue();
                if (!headerFiledName.startsWith("datafield")) continue;
                if (iFirstDataFieldColIndex < 0) {
                    iFirstDataFieldColIndex = i;
                }
                mapFieldColIndex.put(headerFiledName, i);
            }
            int insertCols = repoFieldList.size();
            for (int i = 2; i <= maxRow; ++i) {
                Row row = sheet.getRow(i);
                short curRowMaxCol = row.getLastCellNum();
                row.shiftCellsRight(iFirstDataFieldColIndex, (int)curRowMaxCol, insertCols);
                for (int j = 0; j < insertCols; ++j) {
                    int oldIndex = (Integer)mapFieldColIndex.get(repoFieldList.get(j).getFieldName() + "_tag");
                    int newIndex = iFirstDataFieldColIndex + j;
                    Cell oldCell = row.getCell(oldIndex + insertCols);
                    Cell newCell = row.createCell(newIndex, oldCell.getCellType());
                    newCell.setCellValue(oldCell.getStringCellValue());
                    newCell.setCellStyle(oldCell.getCellStyle());
                    row.removeCell(oldCell);
                }
            }
            FileOutputStream out = new FileOutputStream(file);
            wb.write((OutputStream)out);
            wb.close();
            out.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

