/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.impexp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class StructRepoDataImportPlugin
extends BatchImportPlugin
implements IImportPlugin {
    private static final Log log = LogFactory.getLog(StructRepoDataImportPlugin.class);
    private Map<String, Object> importParams;
    private StructRepo structRepo;
    private DynamicObject createOrg;
    private Map<String, List<StructRepoField>> mapStructRepoFields = new ConcurrentHashMap<String, List<StructRepoField>>();

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                String keyFields;
                IFormView formView = (IFormView)view.get(ctx);
                String formId = formView.getFormShowParameter().getFormId();
                if (formId.equals("bos_importing") || formId.equals("bos_importstart")) {
                    String createOrgId;
                    IFormView listView = formView.getView(formView.getFormShowParameter().getParentPageId());
                    Object repoId = listView.getFormShowParameter().getCustomParam("StructRepoID");
                    if (repoId != null) {
                        this.structRepo = GaiStructRepoHelper.queryStructRepo((long)Long.parseLong(repoId.toString()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(createOrgId = listView.getPageCache().get("createOrg")))) {
                        this.createOrg = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(createOrgId), (String)"bos_org", (String)String.format("%s,%s,%s", "id", "name", "number"));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(keyFields = ctx.getOption().getOrDefault("KeyFields", "").toString())) && !keyFields.contains("structrepo")) {
                    keyFields = keyFields + "structrepo,";
                    ctx.addOption("KeyFields", (Object)keyFields);
                }
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage());
            }
        }
        catch (NoSuchFieldException e) {
            log.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    private List<StructRepoField> getStructRepoFieldList(String repoNumber) {
        List repoFields = this.mapStructRepoFields.getOrDefault(repoNumber, null);
        if (repoFields == null) {
            StructRepo structRepo = GaiStructRepoHelper.queryStructRepoByRepoNumber((String)repoNumber);
            repoFields = structRepo.getFields();
            if (repoFields.isEmpty()) {
                repoFields = GaiStructRepoHelper.queryStructRepoFields((long)structRepo.getRepoId());
            }
            this.mapStructRepoFields.put(repoNumber, repoFields);
        }
        return repoFields;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        ListIterator<ImportBillData> listIterator = billdatas.listIterator();
        while (listIterator.hasNext()) {
            ImportBillData row = listIterator.next();
            if (!this.checkCommonFieldsValid(row, logger)) {
                listIterator.remove();
                continue;
            }
            if (!this.checkBussinessFieldsValid(row, logger)) {
                listIterator.remove();
                continue;
            }
            this.setCustomFieldsValue(row, logger);
        }
        super.beforeSave(billdatas, logger);
    }

    private void setCustomFieldsValue(ImportBillData row, ImportLogger logger) {
        JSONObject data = row.getData();
        JSONObject jsonStructRepo = data.getJSONObject("structrepo");
        String repoNumber = jsonStructRepo.getString("number");
        List<StructRepoField> structRepoFieldList = this.getStructRepoFieldList(repoNumber);
        structRepoFieldList.forEach(field -> {
            String fieldName = field.getFieldName();
            String fieldName_Tag = fieldName + "_tag";
            if (data.containsKey((Object)fieldName) && !data.containsKey((Object)fieldName_Tag)) {
                data.put(fieldName_Tag, (Object)data.getString(fieldName));
            }
            if (data.containsKey((Object)fieldName_Tag) && !data.containsKey((Object)fieldName)) {
                String fieldTagValue = data.getString(fieldName_Tag);
                String fieldValue = fieldTagValue.length() > 255 ? fieldTagValue.substring(0, 255) : fieldTagValue;
                data.put(fieldName, (Object)fieldValue);
            }
        });
    }

    private boolean checkBussinessFieldsValid(ImportBillData row, ImportLogger logger) {
        if (this.structRepo.getRepoType().equals(RepoConstant.RepoType.LEVEL.getType())) {
            return this.checkTreeDataFieldsValid(row, logger);
        }
        return this.checkTableDataFieldsValid(row, logger);
    }

    private boolean checkTableDataFieldsValid(ImportBillData row, ImportLogger logger) {
        JSONObject jsonStructRepo;
        String repoNumber;
        List<StructRepoField> structRepoFieldList;
        StructRepoField firstField;
        JSONObject data = row.getData();
        String name = data.getString((firstField = (structRepoFieldList = this.getStructRepoFieldList(repoNumber = (jsonStructRepo = data.getJSONObject("structrepo")).getString("number"))).get(0)).getFieldName() + "_tag");
        if (StringUtils.isEmpty((CharSequence)name)) {
            data.put("name", (Object)"\u77e5\u8bc6\u6570\u636e");
        } else {
            data.put("name", (Object)(name.length() > 50 ? name.substring(0, 50) : name));
        }
        return true;
    }

    private boolean checkTreeDataFieldsValid(ImportBillData row, ImportLogger logger) {
        JSONObject data = row.getData();
        JSONObject jsonStructRepo = data.getJSONObject("structrepo");
        int rowNum = data.getInteger("rowNum");
        String repoNumber = jsonStructRepo.getString("number");
        List<StructRepoField> structRepoFieldList = this.getStructRepoFieldList(repoNumber);
        StructRepoField firstField = structRepoFieldList.get(0);
        String name = data.getString(firstField.getFieldName() + "_tag");
        if (StringUtils.isEmpty((CharSequence)name)) {
            logger.log(Integer.valueOf(rowNum), String.format("\u7b2c\u4e00\u4e2a\u5b57\u6bb5\u3010%s\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", firstField.getName()));
            logger.fail();
            return false;
        }
        name = name.length() > 50 ? name.substring(0, 50) : name;
        data.put("name", (Object)name);
        return true;
    }

    private boolean checkCommonFieldsValid(ImportBillData row, ImportLogger logger) {
        JSONObject data = row.getData();
        int rowNum = data.getInteger("rowNum");
        JSONObject jsonStructRepo = data.getJSONObject("structrepo");
        if (row.getEntityMapping().getCols().getOrDefault("structrepo", null) == null || jsonStructRepo == null || StringUtils.isEmpty((CharSequence)jsonStructRepo.getString("number"))) {
            if (this.structRepo != null) {
                jsonStructRepo = new JSONObject();
                jsonStructRepo.put("number", (Object)this.structRepo.getNumber());
                data.put("structrepo", (Object)jsonStructRepo);
            } else {
                logger.log(Integer.valueOf(rowNum), "\u65e0\u6cd5\u4ece\u5217\u8868\u754c\u9762\u83b7\u53d6\u5230\u6240\u5c5e\u77e5\u8bc6\u5e93\u3002\u8bf7\u586b\u5199\u201c\u77e5\u8bc6\u5e93.\u7f16\u7801\u201d\u3002");
                logger.fail();
                return false;
            }
        }
        JSONObject jsonCreateOrg = data.getJSONObject("createorg");
        if (row.getEntityMapping().getCols().getOrDefault("createorg", null) == null || jsonCreateOrg == null || StringUtils.isEmpty((CharSequence)jsonCreateOrg.getString("number"))) {
            if (this.createOrg != null) {
                jsonCreateOrg = new JSONObject();
                jsonCreateOrg.put("id", this.createOrg.getPkValue());
                jsonCreateOrg.put("number", (Object)this.createOrg.getString("number"));
                data.put("createorg", (Object)jsonCreateOrg);
            } else {
                logger.log(Integer.valueOf(rowNum), "\u65e0\u6cd5\u4ece\u5217\u8868\u754c\u9762\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u3002\u8bf7\u586b\u5199\u201c\u521b\u5efa\u7ec4\u7ec7.\u7f16\u7801\u201d\u3002");
                logger.fail();
                return false;
            }
        }
        return true;
    }

    public List<String> getDefaultLockUIs() {
        List lockUIs = super.getDefaultLockUIs();
        lockUIs.add("flexpanelap10");
        return lockUIs;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List repoFieldList = GaiStructRepoHelper.queryStructRepoFields((long)this.structRepo.getRepoId());
        HashMap<String, LocaleString> mapFieldDisplayName = new HashMap<String, LocaleString>(repoFieldList.size());
        for (StructRepoField field : repoFieldList) {
            mapFieldDisplayName.put(field.getFieldName(), new LocaleString(field.getName()));
        }
        List defaultItems = super.getOverrideFieldsConfig();
        ListIterator listIterator = defaultItems.listIterator();
        while (listIterator.hasNext()) {
            ComboItem comboItem = (ComboItem)listIterator.next();
            String key = comboItem.getValue();
            if (key.equals("name")) {
                listIterator.remove();
            }
            if (key.startsWith("datafield") && !mapFieldDisplayName.containsKey(key)) {
                listIterator.remove();
            }
            if (!key.startsWith("datafield") || !mapFieldDisplayName.containsKey(key)) continue;
            comboItem.setCaption((LocaleString)mapFieldDisplayName.get(key));
        }
        return defaultItems;
    }

    public String getDefaultKeyFields() {
        return ",structrepo,";
    }

    public MainEntityType getExportMainEntityType(String billFormId, DynamicObject templateData) {
        this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)billFormId);
        try {
            MainEntityType exportEntityType = (MainEntityType)this.mainEntityType.clone();
            String extendData = this.importParams.get("ExtendData").toString();
            long structRepoId = JSON.parseObject((String)extendData).getLong("StructRepoID");
            List repoFieldList = GaiStructRepoHelper.queryStructRepoFields((long)structRepoId);
            HashMap mapFieldNames = new HashMap();
            repoFieldList.forEach(field -> {
                mapFieldNames.put(field.getFieldName(), new LocaleString(field.getName()));
                mapFieldNames.put(field.getFieldName() + "_tag", new LocaleString(field.getName() + "_\u8be6\u60c5"));
            });
            DataEntityPropertyCollection properties = exportEntityType.getProperties();
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                IDataEntityProperty prop = (IDataEntityProperty)iterator.next();
                if (!prop.getName().startsWith("datafield")) continue;
                if (!mapFieldNames.containsKey(prop.getName())) {
                    iterator.remove();
                    continue;
                }
                ((FieldProp)prop).setDisplayName((LocaleString)mapFieldNames.get(prop.getName()));
            }
            return exportEntityType;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return this.mainEntityType;
        }
    }

    public void init(Map<String, Object> importParams) {
        this.importParams = importParams;
    }
}

