/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.list;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.plugin.common.FormPulginUtil;
import kd.ai.gai.plugin.control.RadioButtonAp;
import kd.ai.gai.plugin.control.RadioButtonGroup;
import kd.ai.gai.plugin.list.CardListConfig;
import kd.ai.gai.plugin.list.ICardListListener;
import kd.ai.gai.plugin.list.RadioButtonFilterEvent;
import kd.bos.dataentity.TypesContainer;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ActiveViewEvent;
import kd.bos.form.control.events.ActiveViewListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.QueryExceedMaxCountEvent;
import kd.bos.list.events.QueryExceedMaxCountListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class GaiListPlugin
extends AbstractListPlugin
implements ActiveViewListener,
SearchEnterListener,
QueryExceedMaxCountListener,
PagerClickListener {
    private static final String CARD_MODE_QUICK_SEARCH_FILTER = "CardMode_QuickSearchFilter";
    private ICardListListener iCardListListener;
    private static final Log logger = LogFactory.getLog(GaiListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    private ICardListListener getCardListListener() {
        if (this.iCardListListener != null) {
            return this.iCardListListener;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof ICardListListener)) continue;
            this.iCardListListener = (ICardListListener)plugin;
            break;
        }
        return this.iCardListListener;
    }

    private ICardListListener getCardListListener(ListShowParameter listShowParameter) {
        List pluginList = listShowParameter.getFormConfig().getPlugins();
        for (Plugin plugin : pluginList) {
            try {
                Class<?> clazz = Class.forName(plugin.getClassName());
                if (!ICardListListener.class.isAssignableFrom(clazz)) continue;
                ICardListListener listener = (ICardListListener)TypesContainer.createInstance(clazz);
                return listener;
            }
            catch (ClassNotFoundException ex) {
                logger.error((Throwable)ex);
            }
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        CustomControl control = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("formId", formId);
        control.setData(data);
        if (!GaiFormIdEnum.GAI_ASS.getId().equals(formId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"statusfilter"});
        }
    }

    private CardListConfig getDefaultConfig() {
        CardListConfig cardListConfig = new CardListConfig();
        cardListConfig.setBarItems(new ArrayList<BarItemAp>());
        cardListConfig.setFilterRadioButtonGroup(new RadioButtonGroup());
        return cardListConfig;
    }

    private CardListConfig getCardListConfig() {
        String sConfig = this.getPageCache().get("CardListConfig");
        if (StringUtils.isNotEmpty((String)sConfig)) {
            return (CardListConfig)JSON.parseObject((String)sConfig, CardListConfig.class);
        }
        CardListConfig cardListConfig = this.getDefaultConfig();
        cardListConfig.setTitle(this.getView().getFormShowParameter().getFormConfig().getCaption());
        ICardListListener iCardListListener = this.getCardListListener();
        if (iCardListListener != null) {
            iCardListListener.onInitCardListConfig(cardListConfig);
        }
        this.setCardListConfig(cardListConfig);
        return cardListConfig;
    }

    private void setCardListConfig(CardListConfig config) {
        this.getPageCache().put("CardListConfig", JSON.toJSONString((Object)config));
    }

    private CardListConfig getCardListConfig(ListShowParameter listShowParameter) {
        CardListConfig cardListConfig = this.getDefaultConfig();
        cardListConfig.setTitle(listShowParameter.getFormConfig().getCaption());
        ICardListListener iCardListListener = this.getCardListListener(listShowParameter);
        if (iCardListListener != null) {
            iCardListListener.onInitCardListConfig(cardListConfig);
        }
        return cardListConfig;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList list = (BillList)this.getControl("billlistap");
        list.addActiveViewListener((ActiveViewListener)this);
        list.addQueryExceedMaxCountListener((QueryExceedMaxCountListener)this);
        list.addPagerClickListener((PagerClickListener)this);
        Search search = (Search)this.getView().getControl("card_searchap");
        search.addEnterListener((SearchEnterListener)this);
        CardListConfig config = this.getCardListConfig();
        ArrayList<String> filterBtnKeys = new ArrayList<String>(0);
        List<RadioButtonAp> radioButtonApList = config.getFilterRadioButtonGroup().getButtonApList();
        for (RadioButtonAp radioButtonAp : radioButtonApList) {
            filterBtnKeys.add(radioButtonAp.getKey());
        }
        this.addClickListeners(filterBtnKeys.toArray(new String[0]));
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        CardListConfig config = this.getCardListConfig((ListShowParameter)e.getSource());
        HashMap<String, String> mapTitle = new HashMap<String, String>();
        mapTitle.put("id", "card_lbl_title");
        mapTitle.put("caption", (String)config.getTitle());
        e.getItems().add(mapTitle);
        ToolbarAp toolbarAp = new ToolbarAp();
        toolbarAp.setId("mytoolbarap");
        toolbarAp.setKey("mytoolbarap");
        List<BarItemAp> barItemApList = config.getBarItems();
        for (BarItemAp barItemAp : barItemApList) {
            toolbarAp.getItems().add(barItemAp);
        }
        HashMap<String, String> mapToolBar = new HashMap<String, String>();
        mapToolBar.put("id", "card_toolbarap");
        mapToolBar.put("items", (String)toolbarAp.createControl().get("items"));
        e.getItems().add(mapToolBar);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setId("myflexpanelap");
        flexPanelAp.setKey("myflexpanelap");
        List<RadioButtonAp> radioButtonApList = config.getFilterRadioButtonGroup().getButtonApList();
        for (RadioButtonAp radioButtonAp : radioButtonApList) {
            flexPanelAp.getItems().add(radioButtonAp);
        }
        HashMap<String, String> mapfilterButton = new HashMap<String, String>();
        mapfilterButton.put("id", "card_filterbtn_container");
        mapfilterButton.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(mapfilterButton);
    }

    public void onGetControl(OnGetControlArgs e) {
        RadioButtonAp radioButtonAp;
        super.onGetControl(e);
        CardListConfig config = this.getCardListConfig();
        BarItemAp barItemAp = config.getBarItem(e.getKey());
        if (barItemAp != null) {
            Button button = new Button();
            button.setKey(barItemAp.getKey());
            button.setOperationKey(barItemAp.getOperationKey());
            button.addItemClickListener((ItemClickListener)this);
            button.setView(this.getView());
            e.setControl((Control)button);
        }
        if ((radioButtonAp = config.getRadioButton(e.getKey())) != null) {
            Button button = new Button();
            button.setKey(radioButtonAp.getKey());
            button.setOperationKey(radioButtonAp.getOperationKey());
            button.setView(this.getView());
            e.setControl((Control)button);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getCurrentListMode() == null) {
            BillList list = (BillList)this.getControl("billlistap");
            if (list.getDefaultView() != null && list.getDefaultView().equals("gridview")) {
                this.switchListMode(ListMode.List);
            } else {
                this.switchListMode(ListMode.Card);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        CardListConfig config = this.getCardListConfig();
        RadioButtonAp radioButtonAp = config.getRadioButton(key);
        if (radioButtonAp != null) {
            config.getFilterRadioButtonGroup().setCurrentCheckButtonKey(radioButtonAp.getKey());
            this.setCardListConfig(config);
            this.setCardFilter();
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
            config.getFilterRadioButtonGroup().updateControlMetadata(this.getView());
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        if (StringUtils.isNotEmpty((String)searchEnterEvent.getText())) {
            List searchFields = searchEnterEvent.getSearchFields();
            if (!searchFields.isEmpty()) {
                QFilter qFilter = null;
                for (Map searchField : searchFields) {
                    List value = (List)searchField.get("value");
                    List fieldName = (List)searchField.get("fieldName");
                    if (qFilter == null) {
                        qFilter = QFilter.ftlike((String[])value.toArray(new String[0]), (String[])fieldName.toArray(new String[0]));
                        continue;
                    }
                    qFilter.and(QFilter.ftlike((String[])value.toArray(new String[0]), (String[])fieldName.toArray(new String[0])));
                }
                if (qFilter != null) {
                    this.getPageCache().put(CARD_MODE_QUICK_SEARCH_FILTER, qFilter.toSerializedString());
                }
            }
        } else {
            this.getPageCache().remove(CARD_MODE_QUICK_SEARCH_FILTER);
        }
        this.setCardFilter();
        BillList list = (BillList)this.getControl("billlistap");
        list.refresh();
    }

    public void activeView(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.getView().equals("gridview")) {
            this.switchListMode(ListMode.List);
        } else {
            this.switchListMode(ListMode.Card);
        }
    }

    private ListMode getCurrentListMode() {
        String curListMode = this.getPageCache().get("ListMode");
        if (StringUtils.isNotEmpty((String)curListMode)) {
            return ListMode.valueOf(curListMode);
        }
        return null;
    }

    private void setCurrentListMode(ListMode listMode) {
        this.getPageCache().put("ListMode", listMode.name());
    }

    private void switchListMode(ListMode listMode) {
        ListMode curMode = this.getCurrentListMode();
        if (curMode != null && curMode == listMode) {
            return;
        }
        this.setCurrentListMode(listMode);
        switch (listMode) {
            case List: {
                ListView listView = (ListView)this.getView();
                String billFormId = listView.getBillFormId();
                if (GaiFormIdEnum.GAI_TOOL.getId().equalsIgnoreCase(billFormId)) {
                    ListShowParameter lsp = new ListShowParameter();
                    lsp.setBillFormId(billFormId);
                    lsp.setFormId("bos_templatetreelist");
                    lsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
                this.setListModePageInfo(curMode == null);
                this.setListModeStyle();
                break;
            }
            case Card: {
                this.setCardFilter();
                this.setCardModePageInfo(curMode == null);
                this.setCardModeStyle();
            }
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.refresh();
    }

    private void setCardModePageInfo(boolean bFirstLoad) {
        BillList list = (BillList)this.getControl("billlistap");
        int pageRow = 12;
        int pageIndex = 1;
        if (!bFirstLoad) {
            this.getPageCache().put("List-pageIndex", String.valueOf(list.getEntryState().getCurrentPageIndex()));
            this.getPageCache().put("List-pageRow", String.valueOf(list.getEntryState().getPageRows()));
            if (this.getPageCache().get("Card-pageIndex") != null) {
                pageIndex = Integer.parseInt(this.getPageCache().get("Card-pageIndex"));
                pageRow = Integer.parseInt(this.getPageCache().get("Card-pageRow"));
            }
        }
        list.getEntryState().setPageRows(pageRow);
        list.getEntryState().setCurrentPageIndex(Integer.valueOf(pageIndex));
    }

    private void setListModePageInfo(boolean bFirstLoad) {
        BillList list = (BillList)this.getControl("billlistap");
        int pageRow = 10;
        int pageIndex = 1;
        if (bFirstLoad) {
            pageRow = list.getEntryState().getPageRows();
        } else {
            this.getPageCache().put("Card-pageIndex", String.valueOf(list.getEntryState().getCurrentPageIndex()));
            this.getPageCache().put("Card-pageRow", String.valueOf(list.getEntryState().getPageRows()));
            if (this.getPageCache().get("List-pageIndex") != null) {
                pageIndex = Integer.parseInt(this.getPageCache().get("List-pageIndex"));
                pageRow = Integer.parseInt(this.getPageCache().get("List-pageRow"));
            }
        }
        list.getEntryState().setPageRows(pageRow);
        list.getEntryState().setCurrentPageIndex(Integer.valueOf(pageIndex));
    }

    private void setListModeStyle() {
        StringBuilder sbStyle = new StringBuilder();
        sbStyle.append("${ background-color: #E2E7EF; }");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_container_all", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${ display:none; }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_card_header", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${}");
        FormPulginUtil.setCustomStyle(this.getView(), "flexpanelap", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${}");
        FormPulginUtil.setCustomStyle(this.getView(), "billlistap", sbStyle.toString());
    }

    private void setCardModeStyle() {
        StringBuilder sbStyle = new StringBuilder();
        sbStyle.append("${ background-image: linear-gradient(180deg, var(--theme-color-level3) 0%, #FFFFFF 50%); }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_container_all", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${}");
        FormPulginUtil.setCustomStyle(this.getView(), "flex_card_header", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("${ display:none; }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "flexpanelap", sbStyle.toString());
        sbStyle.delete(0, sbStyle.length());
        sbStyle.append("$+div{ margin-top:-8px; margin-right:54px;}\n");
        sbStyle.append("$ { margin-left: 28px;\nmargin-right: 40px; }\n");
        sbStyle.append("$ div.x-Dtok1y>div { background-color: transparent!important; }\n");
        sbStyle.append("$ div.x-Dtok1y>div._17unDfqU { height: 100%; }\n");
        sbStyle.append("$ div.x-Dtok1y>div._17unDfqU>div { height: 100%; }\n");
        sbStyle.append("$ div#view-container {  height: 100%; }\n");
        sbStyle.append("$ div.x-Dtok1y>div.oCkmDxX5 > div:first-of-type { visibility: hidden; }\n");
        sbStyle.append("$ .x-Dtok1y:last-of-type { flex-direction: column-reverse; }\n");
        FormPulginUtil.setCustomStyle(this.getView(), "billlistap", sbStyle.toString());
    }

    public void queryExceedMaxCount(QueryExceedMaxCountEvent queryExceedMaxCountEvent) {
        this.setCardFilter();
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        this.setCardFilter();
    }

    private void setCardFilter() {
        if (this.getCurrentListMode() != ListMode.Card) {
            return;
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.getQueryFilterParameter().getQFilters().clear();
        String quickSearchFilterString = this.getPageCache().get(CARD_MODE_QUICK_SEARCH_FILTER);
        if (StringUtils.isNotEmpty((String)quickSearchFilterString)) {
            QFilter quickSearchFilter = QFilter.fromSerializedString((String)quickSearchFilterString);
            list.getQueryFilterParameter().getQFilters().add(quickSearchFilter);
        }
        list.getClientQueryFilterParameter().getQFilters().clear();
        CardListConfig config = this.getCardListConfig();
        RadioButtonFilterEvent radioButtonFilterEvent = new RadioButtonFilterEvent((Object)config.getRadioButton(config.getFilterRadioButtonGroup().getCurrentCheckButtonKey()));
        radioButtonFilterEvent.setFilters(new ArrayList<QFilter>());
        radioButtonFilterEvent.setCurrentCheckKey(config.getFilterRadioButtonGroup().getCurrentCheckButtonKey());
        this.getCardListListener().onRadioButtonCheckFilter(radioButtonFilterEvent);
        if (!radioButtonFilterEvent.getFilters().isEmpty()) {
            list.getClientQueryFilterParameter().getQFilters().addAll(radioButtonFilterEvent.getFilters());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("statusfilter".equals(name)) {
            BillList list = (BillList)this.getControl("billlistap");
            this.setCardFilter();
            list.refresh();
        }
    }

    private static enum ListMode {
        List,
        Card;

    }
}

