/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.nl2api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.ai.gai.core.api.mservice.MserviceResultHelper;
import kd.ai.gai.core.domain.mservice.GaiRepoCreateParams;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.repo.RepoServiceCallType;
import kd.ai.gai.core.helper.RagHelper;
import kd.ai.gai.core.nl2api.enumtype.DataSourceTypeEnum;
import kd.ai.gai.core.nl2api.enumtype.FieldTypeEnum;
import kd.ai.gai.core.nl2api.model.AttachmentFileInfo;
import kd.ai.gai.core.nl2api.model.AttachmentTempInfo;
import kd.ai.gai.core.nl2api.model.CustomizeChunk;
import kd.ai.gai.core.nl2api.model.DataSourceMetadata;
import kd.ai.gai.core.nl2api.model.EntityChunk;
import kd.ai.gai.core.nl2api.model.FieldChunk;
import kd.ai.gai.core.nl2api.model.FieldInfo;
import kd.ai.gai.core.nl2api.model.PartialEntityFields;
import kd.ai.gai.core.nl2api.model.PlainField;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.plugin.nl2api.BaseFormPlugin;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class BizobjCfgFormPlugin
extends BaseFormPlugin
implements TabSelectListener {
    public static final String KEY_TOOLBARAP = "toolbarap";
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String NUMBER = "number";
    public static final String KEY_NAME = "name";
    private static final String KEY_FLEX_PREVIEWBIZOBJDATA = "flexpreviewbizobjdata";
    private static final String KEY_FLEX_PREVIEW_BIZOBJ_EMPTY = "flexpreviewbizobjempty";
    private static final String KEY_BD_ENTITYNUMBER = "entitynumber";
    private static final String KEY_ENTITYDESC = "entitydesc";
    private static final String GAI_N2A_BIZOBJ_FIELD_SEL = "gai_n2a_bizobj_field_sel";
    private static final String GAI_N2A_BIZOBJ_CFG = "gai_n2a_bizobj_cfg";
    private static final String KEY_CODEEDITAP = "codeeditap";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanel";
    private static final String KEY_OP_SAVE_DS = "saveds";
    private static final String KEY_OP_SAVE = "save";
    private static final String KEY_OP_UPLOAD_REPO = "uploadrepo";
    private static final String KEY_OP_SELECT_FIELD = "selectfield";
    private static final String KEY_FLEX_EMPTY = "flexempty";
    private static final String KEY_FLEX_ENTITY_STRUCTURE = "flexentitystructure";
    private static final String KEY_FLEX_TREE = "flextree";
    private static final String KEY_FLEX_TREEEMPTY = "flextreeempty";
    private static final String CACHE_KEY_TEMP_NAME = "tempName";
    private static final String CACHE_KEY_IS_INIT = "isInit";
    private static final String KEY_FIELD_ENTRYENTITY = "fieldentryentity";
    private static final String KEY_TABAP_BIZOBJ = "tabapbizobj";
    private static final String KEY_TAB_FIELD = "tabpageapfield";
    private static final String KEY_TAB_BIZOBJ_PREVIEWDATA = "tabbizobjpreviewdata";
    private static final String KEY_TAB_CHUNK = "tabchunk";
    private static final String KEY_CODEEDITAP_CHUNK = "codeeditapchunk";
    private static final String KEY_TAB_FIELD_VALUE_CHUNK = "tabfieldvaluechunk";
    private static final String KEY_CODEEDITAP_FIELD_VALUE = "codeeditapfieldvalue";
    private static final String KEY_VALUE_FIELD_LIST = "valuefieldlist";
    private static final String KEY_BARITEM_SELECTFIELD = "baritemselectfield";
    private static final String KEY_CHECK_BOX_SPLIT = "checkboxsplit";
    private static final String KEY_FIELD_DESC = "fielddesc";
    private static final String KEY_REPO = "repo";
    private static final String KEY_REPO_NAME = "repoName";
    private static final String KEY_INDEX_METHOD = "index_method";
    private static final String KEY_CHUNK_LENGTHLIMIT = "chunk_lengthlimit";
    private static final String KEY_REPO_DESC = "repodesc";
    private static final String KEY_ENABLE_FIELD_DESC = "enablefielddesc";
    private static final String KEY_ENABLE_SPLIT_REPO = "enablesplitrepo";
    private static final String KEY_MAX_VALUE_COUNT = "maxvaluecount";

    @Override
    public void initialize() {
        super.initialize();
    }

    public List<PlainField> getSelectedPlainFieldList() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FIELD_ENTRYENTITY);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        ArrayList<PlainField> selectedPlainFieldList = new ArrayList<PlainField>();
        if (dataEntitys != null) {
            for (DynamicObject rowDo : dataEntitys) {
                String fieldKey = rowDo.getString("fieldid");
                String fieldId = rowDo.getString("fieldid");
                String fieldName = rowDo.getString("fieldname");
                String fieldType = rowDo.getString("fieldtype");
                String enumKv = rowDo.getString("enumkv");
                boolean enableValueRepo = rowDo.getBoolean("enablevaluerepo");
                String entityKey = rowDo.getString("entitykey");
                PlainField plainField = new PlainField();
                plainField.setFieldId(fieldId);
                plainField.setFieldKey(fieldKey);
                plainField.setFieldName(fieldName);
                plainField.setFieldType(fieldType);
                plainField.setEntityKey(entityKey);
                plainField.setEnableValueRepo(enableValueRepo);
                plainField.setEnumKv(StringUtils.isEmpty((CharSequence)enumKv) ? null : (StrUtils.isValidJson((String)enumKv) ? JSONObject.parseObject((String)enumKv) : null));
                selectedPlainFieldList.add(plainField);
            }
        }
        return selectedPlainFieldList;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
        Tab tab = (Tab)this.getControl(KEY_TABAP_BIZOBJ);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.updatePageValue(false);
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_BIZOBJ_PREVIEWDATA)) {
            this.getView().hideLoading();
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BARITEM_SELECTFIELD});
            this.previewData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_FIELD)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BARITEM_SELECTFIELD});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_CHUNK)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BARITEM_SELECTFIELD});
            this.previewChunk();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_FIELD_VALUE_CHUNK)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BARITEM_SELECTFIELD});
            List<PlainField> valueFieldList = this.getValueFieldList();
            ComboEdit selector = (ComboEdit)this.getControl(KEY_VALUE_FIELD_LIST);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(valueFieldList.size());
            for (PlainField plainField : valueFieldList) {
                ComboItem ci = new ComboItem();
                ci.setCaption(new LocaleString(plainField.getFieldName()));
                ci.setValue(plainField.getFieldId());
                items.add(ci);
            }
            selector.setComboItems(items);
            if (!items.isEmpty()) {
                String defaultValue = ((ComboItem)items.get(0)).getValue();
                this.getModel().setValue(KEY_VALUE_FIELD_LIST, (Object)defaultValue);
                this.previewFieldValueChunk(defaultValue);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createRepo(String repoName, List<AttachmentFileInfo> attachmentFileInfoList) {
        if (attachmentFileInfoList == null || attachmentFileInfoList.isEmpty()) return;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext rc = RequestContext.get();
            rc.setRequestId(requestId);
            GaiRepoCreateParams params = new GaiRepoCreateParams();
            params.setName(repoName);
            params.setUseOrg(rc.getOrgId());
            params.setType("qa");
            params.setChunkStrategy("customize");
            params.setDesc((String)this.getModel().getValue(KEY_REPO_DESC));
            params.setIndexMethod((String)this.getModel().getValue(KEY_INDEX_METHOD));
            ArrayList fileInfos = new ArrayList();
            attachmentFileInfoList.forEach(attachmentFileInfo -> {
                GaiRepoCreateParams.RepoFileParam fileInfo = new GaiRepoCreateParams.RepoFileParam();
                fileInfo.setFileName(attachmentFileInfo.getName());
                fileInfo.setFileSize(attachmentFileInfo.getSize());
                fileInfo.setFileType("text");
                fileInfo.setFilePath(attachmentFileInfo.getPath());
                fileInfos.add(fileInfo);
            });
            params.setFileInfos(fileInfos);
            RepoDataInfo repo = RagHelper.createRepo((RepoServiceCallType)RepoServiceCallType.MSERVICE, (GaiRepoCreateParams)params);
            this.log.info("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)repo));
            if (repo == null) return;
        }
        catch (Throwable e) {
            this.log.error("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u5f02\u5e38:" + e.getMessage(), e);
            throw new KDBizException("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)KEY_OP_SAVE)) {
            if (args.getOperationResult().isSuccess()) {
                args.getOperationResult().setShowMessage(false);
            }
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)KEY_OP_UPLOAD_REPO)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long pkValue = (Long)dataEntity.getPkValue();
            boolean enableSplitRepo = (Boolean)this.getModel().getValue(KEY_ENABLE_SPLIT_REPO);
            String repoName = this.assemblyRepoName();
            this.getCache().put(KEY_REPO_NAME, repoName);
            ArrayList<AttachmentFileInfo> attachmentFileInfoList = new ArrayList<AttachmentFileInfo>();
            AttachmentFileInfo fieldMetadataAttachmentFileInfo = this.uploadFieldMetadataRepoAttachment(pkValue, repoName);
            attachmentFileInfoList.add(fieldMetadataAttachmentFileInfo);
            List<PlainField> valueFieldList = this.getValueFieldList();
            if (valueFieldList != null && !valueFieldList.isEmpty()) {
                valueFieldList.forEach(plainField -> {
                    AttachmentFileInfo fieldValueAttachmentFileInfo = this.uploadFieldValueRepoAttachment(pkValue, repoName, (PlainField)plainField);
                    attachmentFileInfoList.add(fieldValueAttachmentFileInfo);
                });
            }
            if (enableSplitRepo) {
                attachmentFileInfoList.forEach(attachmentFileInfo -> {
                    String name = attachmentFileInfo.getName();
                    this.createRepo(name.substring(0, name.lastIndexOf(".")), Collections.singletonList(attachmentFileInfo));
                });
            } else {
                this.createRepo(repoName, attachmentFileInfoList);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_OP_SAVE_DS)) {
            this.saveDs(true);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)KEY_OP_SELECT_FIELD)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(GAI_N2A_BIZOBJ_FIELD_SEL);
            fsp.setCustomParam(ENTITY_NUMBER, (Object)this.getEntityNumber());
            fsp.setCustomParam("metadata_tag", this.getModel().getValue("metadata_tag"));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_OP_SELECT_FIELD));
            StyleCss css = new StyleCss();
            css.setWidth("70%");
            css.setHeight("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
            this.getView().hideLoading();
        }
    }

    private AttachmentFileInfo uploadFieldMetadataRepoAttachment(Long pkValue, String repoName) {
        AttachmentFileInfo attachmentFileInfo = null;
        List<Map<String, Object>> oldAttachmentList = BizobjCfgFormPlugin.getAttachmentList(pkValue);
        this.uploadFieldMetadataAttachment(repoName);
        this.saveDs(false);
        List<Map<String, Object>> newAttachmentList = BizobjCfgFormPlugin.getAttachmentList(pkValue);
        List<Map<String, Object>> currentUploadAttachmentList = newAttachmentList.subList(oldAttachmentList.size(), newAttachmentList.size());
        if (!currentUploadAttachmentList.isEmpty()) {
            Map<String, Object> attachmentMap = currentUploadAttachmentList.get(0);
            String url = (String)attachmentMap.get("url");
            String name = (String)attachmentMap.get(KEY_NAME);
            long size = (Long)attachmentMap.get("size");
            String type = (String)attachmentMap.get("type");
            attachmentFileInfo = new AttachmentFileInfo();
            attachmentFileInfo.setName(name);
            attachmentFileInfo.setSize(size);
            attachmentFileInfo.setUrl(url);
            attachmentFileInfo.setType(type);
        }
        return attachmentFileInfo;
    }

    private AttachmentFileInfo uploadFieldValueRepoAttachment(Long pkValue, String repoName, PlainField plainField) {
        AttachmentFileInfo attachmentFileInfo = null;
        List<Map<String, Object>> oldAttachmentList = BizobjCfgFormPlugin.getAttachmentList(pkValue);
        this.uploadFieldValueAttachment(repoName, plainField);
        this.saveDs(false);
        List<Map<String, Object>> newAttachmentList = BizobjCfgFormPlugin.getAttachmentList(pkValue);
        List<Map<String, Object>> currentUploadAttachmentList = newAttachmentList.subList(oldAttachmentList.size(), newAttachmentList.size());
        if (!currentUploadAttachmentList.isEmpty()) {
            Map<String, Object> attachmentMap = currentUploadAttachmentList.get(0);
            String url = (String)attachmentMap.get("url");
            String name = (String)attachmentMap.get(KEY_NAME);
            long size = (Long)attachmentMap.get("size");
            String type = (String)attachmentMap.get("type");
            attachmentFileInfo = new AttachmentFileInfo();
            attachmentFileInfo.setName(name);
            attachmentFileInfo.setSize(size);
            attachmentFileInfo.setUrl(url);
            attachmentFileInfo.setType(type);
        }
        return attachmentFileInfo;
    }

    private void saveDs(boolean showTips) {
        boolean flag = this.updatePageValue(false);
        if (flag) {
            return;
        }
        List<PlainField> allPlainFieldList = this.getSelectedPlainFieldList();
        if (kd.bos.util.CollectionUtils.isEmpty(allPlainFieldList)) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u201c\u5b57\u6bb5\u201d\u3002");
            return;
        }
        this.getView().invokeOperation(KEY_OP_SAVE);
        if (showTips) {
            this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
        }
    }

    private String assemblyRepoName() {
        OrmLocaleValue nameOlv = (OrmLocaleValue)this.getModel().getValue(KEY_NAME);
        String name = nameOlv.getLocaleValue();
        int count = ORM.create().count(((Object)((Object)this)).getClass() + "FIELD_VALUE_COUNT", GaiFormIdEnum.GAI_REPO_INFO.getId(), new QFilter(KEY_NAME, "like", (Object)(name + "%")).toArray());
        name = count > 0 ? String.format("%s_V%s", name, count + 1) : name;
        return name;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject dataJo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)KEY_OP_SELECT_FIELD) && returnData != null && (dataJo = BizobjCfgFormPlugin.parseObj(returnData)) != null) {
            String entityNumber = dataJo.getString(ENTITY_NUMBER);
            this.updateBizObjValue(entityNumber);
            String metadataTag = dataJo.getString("metadata_tag");
            this.getModel().setValue("metadata_tag", (Object)metadataTag);
            this.initEntityFieldData();
        }
    }

    public static JSONObject parseObj(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        if (obj instanceof String) {
            return JSONObject.parseObject((String)obj.toString());
        }
        return JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
    }

    private List<PlainField> getValueFieldList() {
        List<PlainField> selectedPlainFieldList = this.getSelectedPlainFieldList();
        return selectedPlainFieldList.stream().filter(PlainField::isEnableValueRepo).collect(Collectors.toList());
    }

    List<String> getFieldValueList(String fieldId) {
        String entityNumber = this.getEntityNumber();
        DataSet rows = this.getFieldValueDs(fieldId, entityNumber);
        ArrayList<String> valueList = new ArrayList<String>(10);
        if (!rows.isEmpty()) {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                Object value = ((Row)it.next()).get(fieldId);
                if (value == null) continue;
                valueList.add(value + "");
            }
        }
        return valueList;
    }

    private DataSet getFieldValueDs(String fieldId, String entityNumber) {
        DataSet rows = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "FIELD_VALUE_DOC"), (String)entityNumber, (String)fieldId, null, null, (int)((Integer)this.getModel().getValue(KEY_MAX_VALUE_COUNT)));
        return rows.distinct();
    }

    private void uploadFieldMetadataAttachment(String repoName) {
        ArrayList<AttachmentTempInfo> attachmentTempInfoList = new ArrayList<AttachmentTempInfo>();
        List<EntityChunk> entityChunkList = this.getEntityChunkList(true, false);
        StringBuilder contentSb = new StringBuilder();
        if (entityChunkList != null) {
            entityChunkList.forEach(entityChunk -> {
                String chunk = JSONObject.toJSONString((Object)entityChunk);
                CustomizeChunk customizeChunk = new CustomizeChunk(chunk, Long.valueOf(1L), entityChunk.getEntityName(), "http", "link");
                if (StringUtils.isEmpty((CharSequence)contentSb)) {
                    contentSb.append(JSONObject.toJSONString((Object)customizeChunk));
                } else {
                    contentSb.append("\n").append(JSONObject.toJSONString((Object)customizeChunk));
                }
            });
        }
        String fileName = String.format("%s.txt", repoName);
        InputStream in = IOUtils.toInputStream((CharSequence)contentSb, (Charset)Charset.forName("utf-8"));
        AttachmentTempInfo attachmentTempInfo = new AttachmentTempInfo();
        attachmentTempInfo.setFileName(fileName);
        attachmentTempInfo.setInputStream(in);
        attachmentTempInfoList.add(attachmentTempInfo);
        this.uploadToTempCache(attachmentTempInfoList);
    }

    private void uploadFieldValueAttachment(String repoName, PlainField plainField) {
        ArrayList<AttachmentTempInfo> attachmentTempInfoList = new ArrayList<AttachmentTempInfo>();
        List<String> valueList = this.getFieldValueList(plainField.getFieldId());
        if (valueList != null && !valueList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String value : valueList) {
                CustomizeChunk customizeChunk = new CustomizeChunk(value, Long.valueOf(1L), plainField.getFieldName(), "http", "link");
                if (StringUtils.isEmpty((CharSequence)sb)) {
                    sb.append(JSONObject.toJSONString((Object)customizeChunk));
                    continue;
                }
                sb.append("\n").append(JSONObject.toJSONString((Object)customizeChunk));
            }
            String[] nameSplit = repoName.split("_", 2);
            String fileName = String.format("%s.%s_%s.txt", nameSplit[0], plainField.getFieldName(), nameSplit[1]);
            InputStream in = IOUtils.toInputStream((CharSequence)sb, (Charset)Charset.forName("utf-8"));
            AttachmentTempInfo attachmentTempInfo = new AttachmentTempInfo();
            attachmentTempInfo.setFileName(fileName);
            attachmentTempInfo.setInputStream(in);
            attachmentTempInfoList.add(attachmentTempInfo);
        }
        this.uploadToTempCache(attachmentTempInfoList);
    }

    private Map<String, Object> uploadFiles(List<AttachmentTempInfo> attachmentTempInfoList) {
        String entityNum = this.getView().getFormShowParameter().getFormId();
        HashMap<String, Object> allAttaPanelFileMap = new HashMap<String, Object>();
        ArrayList fileList = new ArrayList();
        if (attachmentTempInfoList != null) {
            attachmentTempInfoList.forEach(attachmentTempInfo -> {
                InputStream inputStream = attachmentTempInfo.getInputStream();
                try {
                    Map<String, Object> attachInfoMap = this.uploadFileToCache(entityNum, inputStream, attachmentTempInfo.getFileName());
                    fileList.add(attachInfoMap);
                }
                finally {
                    GaiUtils.safeClose((InputStream)inputStream);
                }
            });
        }
        allAttaPanelFileMap.put(KEY_ATTACHMENTPANELAP, fileList);
        return allAttaPanelFileMap;
    }

    private void uploadToTempCache(List<AttachmentTempInfo> attachmentTempInfoList) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("TampAttCache" + this.getView().getPageId(), SerializationUtils.toJsonString(this.uploadFiles(attachmentTempInfoList)));
        this.getView().updateView(KEY_ATTACHMENTPANELAP);
        this.getView().updateView();
        this.getView().invokeOperation("refresh");
    }

    private Map<String, Object> uploadFileToCache(String entityNum, InputStream in, String fileName) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = null;
        int size = 0;
        HashMap<String, Object> attaMap = new HashMap<String, Object>();
        try {
            size = in.available();
            url = cache.saveAsUrl(fileName, in, 7200);
            String prefix = RequestContext.get().getClientFullContextPath();
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            url = prefix + url;
            this.log.info("\u6587\u4ef6 " + fileName + " \u5df2\u4e0a\u4f20\u81f3\u4e34\u65f6\u6587\u4ef6\u670d\u52a1\u5668, \u5176\u4e34\u65f6\u5b58\u50a8\u8def\u5f84: " + url);
            attaMap.put(KEY_NAME, fileName);
            attaMap.put("size", size);
            String fileType = "";
            String[] fileNames = fileName.trim().split("\\.");
            if (fileNames.length < 2) {
                this.log.error("\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5931\u8d25");
            } else {
                fileType = fileNames[fileNames.length - 1];
            }
            attaMap.put("type", fileType);
            attaMap.put("uid", "rc-upload-" + new Date().getTime() + "-" + RandomUtils.nextInt((int)0, (int)1000));
            attaMap.put("url", url);
            attaMap.put("status", "success");
            attaMap.put("entityNum", entityNum);
            attaMap.put("client", "web");
            long time = new Date().getTime();
            attaMap.put("createdate", time);
            attaMap.put("lastModified", time);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.log.error(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.error(e.getMessage());
        }
        return attaMap;
    }

    private void updateBizObjValue(String entityNumber) {
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter(NUMBER, "=", (Object)entityNumber).toArray());
            this.getModel().setValue(KEY_BD_ENTITYNUMBER, (Object)bosEntityobject);
            this.getView().updateView(KEY_BD_ENTITYNUMBER);
        }
    }

    private static Map<String, Object> getLastAttachmentInfoMap(long bizobjCfgPkId) {
        List<Map<String, Object>> list = BizobjCfgFormPlugin.getAttachmentList(bizobjCfgPkId);
        if (kd.bos.util.CollectionUtils.isNotEmpty(list)) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    private static List<Map<String, Object>> getAttachmentList(long bizobjCfgPkId) {
        List list = AttachmentServiceHelper.getAttachments((String)GAI_N2A_BIZOBJ_CFG, (Object)bizobjCfgPkId, (String)KEY_ATTACHMENTPANELAP);
        return CollectionUtils.isNotEmpty((Collection)list) ? list : new ArrayList(1);
    }

    private void previewData() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        String entityNumber = this.getEntityNumber();
        List<PlainField> allPlainFieldList = this.getPlainFieldListFromMetadata(entityNumber);
        if (kd.bos.util.CollectionUtils.isEmpty(allPlainFieldList)) {
            return;
        }
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        List fieldIdList = allPlainFieldList.stream().map(PlainField::getFieldId).distinct().collect(Collectors.toList());
        String selectFields = StringUtils.join(fieldIdList, (String)",");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityNumber, (String)selectFields, null, null, (int)100);
        JSONArray dataJa = new JSONArray();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        if (doc != null && doc.size() > 0) {
            for (DynamicObject dynamicObject : doc) {
                JSONObject rowJo = new JSONObject();
                for (int i = 0; i < allPlainFieldList.size(); ++i) {
                    PlainField plainField = allPlainFieldList.get(i);
                    String fieldId = plainField.getFieldId();
                    Object fieldValue = dynamicObject.get(fieldId);
                    if (fieldValue != null && (StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATE.getId()) || StringUtils.equalsIgnoreCase((CharSequence)plainField.getFieldType(), (CharSequence)FieldTypeEnum.DATETIME.getId()))) {
                        fieldValue = KDDateFormatUtils.getDateFormat().format(fieldValue);
                    }
                    String fieldValueStr = fieldValue != null ? fieldValue.toString() : "";
                    rowJo.put(fieldId, (Object)fieldValueStr);
                }
                dataJa.add((Object)rowJo);
            }
        }
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
        codeEdit.setText(!dataJa.isEmpty() ? JSONObject.toJSONString((Object)dataJa, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullListAsEmpty}) : "[]");
        this.getView().hideLoading();
    }

    private void previewChunk() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        boolean split = (Boolean)this.getModel().getValue(KEY_CHECK_BOX_SPLIT);
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP_CHUNK);
        List<EntityChunk> entityChunkList = this.getEntityChunkList(split, true);
        codeEdit.setText(entityChunkList != null && !entityChunkList.isEmpty() ? JSONObject.toJSONString(entityChunkList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat}) : "[]");
        this.getView().hideLoading();
    }

    private void previewFieldValueChunk(String fieldId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"Common_Loading", (String)"ai-ids-plugin", (Object[])new Object[0])));
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_PREVIEW_BIZOBJ_EMPTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_PREVIEWBIZOBJDATA});
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP_FIELD_VALUE);
        codeEdit.setText(JSONObject.toJSONString(this.getFieldValueList(fieldId), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat}));
        this.getView().hideLoading();
    }

    private List<EntityChunk> getEntityChunkList(boolean split, boolean countChunkLength) {
        List<EntityChunk> entityChunkList;
        String entityNumber = this.getEntityNumber();
        List<PlainField> allPlainFieldList = this.getPlainFieldListFromMetadata(entityNumber);
        if (kd.bos.util.CollectionUtils.isEmpty(allPlainFieldList)) {
            return null;
        }
        DynamicObject entityDo = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter(NUMBER, "=", (Object)entityNumber).toArray());
        EntityChunk entityChunk = new EntityChunk();
        entityChunk.setEntityDesc((String)this.getModel().getValue(KEY_ENTITYDESC));
        entityChunk.setEntityKey(entityNumber);
        OrmLocaleValue nameOlv = (OrmLocaleValue)entityDo.get(KEY_NAME);
        entityChunk.setEntityName(nameOlv.getLocaleValue());
        PartialEntityFields partialEntityFields = new PartialEntityFields();
        entityChunk.setPartialEntityFields(partialEntityFields);
        ArrayList<FieldChunk> fieldChunkList = new ArrayList<FieldChunk>(10);
        allPlainFieldList.forEach(plainField -> {
            FieldChunk fieldChunk = new FieldChunk();
            fieldChunk.setDesc(plainField.getFieldName());
            fieldChunk.setName(plainField.getFieldId());
            fieldChunk.setType(plainField.getFieldType());
            Map enumKv = plainField.getEnumKv();
            fieldChunk.setEnumKv(enumKv != null && !enumKv.isEmpty() ? enumKv : null);
            fieldChunkList.add(fieldChunk);
        });
        if (!split) {
            if (((Boolean)this.getModel().getValue(KEY_ENABLE_FIELD_DESC)).booleanValue()) {
                partialEntityFields.setDesc((String)this.getModel().getValue(KEY_FIELD_DESC));
            }
            partialEntityFields.setFields(fieldChunkList);
            entityChunk.setPartialEntityFields(partialEntityFields);
            entityChunkList = Collections.singletonList(entityChunk);
        } else {
            entityChunkList = this.createEntityChunks(entityChunk, fieldChunkList, partialEntityFields, countChunkLength);
        }
        return entityChunkList;
    }

    public List<EntityChunk> createEntityChunks(EntityChunk entityChunk, List<FieldChunk> fieldChunkList, PartialEntityFields partialEntityFields, boolean countChunkLength) {
        int templateLength = "{\"entityKey\":\"\",\"entityName\":\"\",\"entityDesc\":\"\",\"partialEntityFields\":{\"desc\":\"\",\"fields\":}}".length();
        int maxChunkLength = (Integer)this.getModel().getValue(KEY_CHUNK_LENGTHLIMIT);
        int remainingLength = maxChunkLength - templateLength - StringUtils.length((CharSequence)entityChunk.getEntityDesc()) - StringUtils.length((CharSequence)entityChunk.getEntityKey()) - StringUtils.length((CharSequence)entityChunk.getEntityName()) - StringUtils.length((CharSequence)entityChunk.getPartialEntityFields().getDesc());
        ArrayList<EntityChunk> entityChunkList = new ArrayList<EntityChunk>(10);
        int startIndex = 0;
        while (startIndex < fieldChunkList.size()) {
            ArrayList<FieldChunk> tempFieldChunkList = new ArrayList<FieldChunk>(10);
            int tempLength = 0;
            for (int i = startIndex; i < fieldChunkList.size(); ++i) {
                tempFieldChunkList.add(fieldChunkList.get(i));
                tempLength = JSONObject.toJSONString(tempFieldChunkList).length();
                String fieldNameJoined = tempFieldChunkList.stream().map(FieldChunk::getDesc).collect(Collectors.joining("\u3001"));
                String fieldsDesc = String.format("\u8be5\u8868\u5305\u542b%s\u7b49\u5b57\u6bb5\u4fe1\u606f\u3002", fieldNameJoined);
                int tempRemainingLength = remainingLength - fieldsDesc.length();
                if (tempLength > tempRemainingLength) {
                    tempFieldChunkList.remove(tempFieldChunkList.size() - 1);
                    break;
                }
                startIndex = i + 1;
            }
            partialEntityFields.setFields(tempFieldChunkList);
            String fieldNameJoined = tempFieldChunkList.stream().map(FieldChunk::getDesc).collect(Collectors.joining("\u3001"));
            if (((Boolean)this.getModel().getValue(KEY_ENABLE_FIELD_DESC)).booleanValue()) {
                partialEntityFields.setDesc(String.format("\u8be5\u8868\u5305\u542b%s\u7b49\u5b57\u6bb5\u4fe1\u606f\u3002", fieldNameJoined));
            }
            entityChunk.setPartialEntityFields(partialEntityFields);
            EntityChunk tempEntityChunk = (EntityChunk)JSONObject.parseObject((String)JSONObject.toJSONString((Object)entityChunk), EntityChunk.class);
            if (countChunkLength) {
                tempEntityChunk.setChunkLength(Integer.valueOf(JSONObject.toJSONString((Object)tempEntityChunk).length()));
            }
            entityChunkList.add(tempEntityChunk);
        }
        return entityChunkList;
    }

    private boolean updatePageValue(boolean isInit) {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u3002");
            return true;
        }
        List<PlainField> allPlainFieldList = this.getSelectedPlainFieldList();
        DataSourceMetadata model = new DataSourceMetadata();
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setEntityNumber(entityNumber);
        fieldInfo.setPlainFieldList(allPlainFieldList);
        fieldInfoList.add(fieldInfo);
        model.setFieldInfoList(fieldInfoList);
        String modelStr = JSONObject.toJSONString((Object)model);
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITYNUMBER);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(KEY_NAME);
        if (name == null || name.isEmpty() || StringUtils.isEmpty((CharSequence)name.getLocaleValue())) {
            LocaleString localeName = new LocaleString(String.format("%s_%s", entityNumberDo.getString(KEY_NAME), DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMddHHmmss")));
            this.getModel().setValue(KEY_NAME, (Object)localeName);
        }
        this.getModel().setValue("metadata", (Object)String.format("%s\u914d\u7f6e", DataSourceTypeEnum.BIZOBJ.getName()));
        this.getModel().setValue("metadata_tag", (Object)modelStr);
        this.initEntityFieldData();
        return false;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_BD_ENTITYNUMBER)) {
            CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
            codeEdit.setText("[]");
            CodeEdit codeEditChunk = (CodeEdit)this.getControl(KEY_CODEEDITAP_CHUNK);
            codeEditChunk.setText("[]");
            this.loadModelData();
            this.updatePageValue(false);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_CHECK_BOX_SPLIT)) {
            this.previewChunk();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_VALUE_FIELD_LIST)) {
            this.previewFieldValueChunk((String)changeData[0].getNewValue());
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue(KEY_NAME, null);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getCache().put(CACHE_KEY_IS_INIT, "true");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(KEY_NAME);
        String formTitle = StringUtils.isEmpty((CharSequence)name.getLocaleValue()) ? "\u4e1a\u52a1\u5bf9\u8c61\u77e5\u8bc6\u5e93" : String.format("\u4e1a\u52a1\u5bf9\u8c61\u77e5\u8bc6\u5e93 - %s", name.getLocaleValue());
        this.getView().setFormTitle(new LocaleString(formTitle));
        this.getCache().put(CACHE_KEY_TEMP_NAME, name.getLocaleValue());
        List indexMethodomboItem = GaiFieldTypeInitUtils.createEmbeddingComboItem();
        ComboEdit indexMethod = (ComboEdit)this.getView().getControl(KEY_INDEX_METHOD);
        indexMethod.setComboItems(indexMethodomboItem);
        this.loadModelData();
        this.getCache().remove(CACHE_KEY_IS_INIT);
    }

    private String getEntityNumber() {
        DynamicObject entityNumberDo = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITYNUMBER);
        String entityNumber = "";
        if (entityNumberDo != null) {
            entityNumber = entityNumberDo.getString(NUMBER);
        }
        return entityNumber;
    }

    private void loadModelData() {
        String entityNumber = this.getEntityNumber();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_EMPTY, KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_EMPTY, KEY_FLEX_TREEEMPTY});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
            this.initEntityFieldData();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_EMPTY, KEY_FLEX_TREEEMPTY});
        }
    }

    private List<PlainField> getPlainFieldListFromMetadata(String entityNumber) {
        List fieldInfoList;
        Optional<FieldInfo> first;
        List<Object> plainFieldList = new ArrayList<PlainField>();
        String modelStr = (String)this.getModel().getValue("metadata_tag");
        DataSourceMetadata model = null;
        if (StringUtils.isNotEmpty((CharSequence)modelStr) && (first = (fieldInfoList = (model = (DataSourceMetadata)JSONObject.parseObject((String)modelStr, DataSourceMetadata.class)).getFieldInfoList()).stream().filter(e -> e.getEntityNumber().equalsIgnoreCase(entityNumber)).findFirst()).isPresent()) {
            FieldInfo fieldInfo = first.get();
            plainFieldList = fieldInfo.getPlainFieldList();
        }
        return plainFieldList;
    }

    private void initEntityFieldData() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        List<PlainField> allPlainFieldList = this.getPlainFieldListFromMetadata(entityNumber);
        this.getModel().deleteEntryData(KEY_FIELD_ENTRYENTITY);
        int size = allPlainFieldList.size();
        if (size > 0) {
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow(KEY_FIELD_ENTRYENTITY, size);
            for (int i = 0; i < allPlainFieldList.size(); ++i) {
                PlainField plainField = allPlainFieldList.get(i);
                dataModel.setValue("fieldid", (Object)plainField.getFieldId(), i);
                dataModel.setValue("fieldname", (Object)plainField.getFieldName(), i);
                Map enumKv = plainField.getEnumKv();
                dataModel.setValue("enumkv", enumKv != null && !enumKv.isEmpty() ? JSONObject.toJSONString((Object)enumKv) : null, i);
                dataModel.setValue("fieldtype", (Object)plainField.getFieldType(), i);
                dataModel.setValue("fieldid", (Object)plainField.getFieldId(), i);
                dataModel.setValue("entitykey", (Object)plainField.getEntityKey(), i);
                dataModel.setValue("enablevaluerepo", (Object)plainField.isEnableValueRepo(), i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldid"});
            }
            String fieldDesc = (String)this.getModel().getValue(KEY_FIELD_DESC);
            if (StringUtils.isEmpty((CharSequence)fieldDesc)) {
                String fieldNameJoined = allPlainFieldList.stream().map(PlainField::getFieldName).collect(Collectors.joining("\u3001"));
                fieldNameJoined = fieldNameJoined.length() > 50 ? fieldNameJoined.substring(0, 50) + "..." : fieldNameJoined;
                fieldDesc = String.format("\u8be5\u8868\u5305\u542b%s\u7b49\u5b57\u6bb5\u4fe1\u606f\u3002", fieldNameJoined);
                this.getModel().setValue(KEY_FIELD_DESC, (Object)fieldDesc);
            }
        }
    }
}

