/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.nl2api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.nl2api.enumtype.DataSourceTypeEnum;
import kd.ai.gai.core.nl2api.enumtype.FieldTypeEnum;
import kd.ai.gai.core.nl2api.enumtype.UploadTypeEnum;
import kd.ai.gai.core.nl2api.enumtype.XtypeEnum;
import kd.ai.gai.core.nl2api.model.DataSourceMetadata;
import kd.ai.gai.core.nl2api.model.Entity;
import kd.ai.gai.core.nl2api.model.EntityCatalog;
import kd.ai.gai.core.nl2api.model.Field;
import kd.ai.gai.core.nl2api.model.FieldInfo;
import kd.ai.gai.core.nl2api.model.PlainField;
import kd.ai.gai.plugin.nl2api.BaseFormPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.F7SelectedListSortEvent;
import kd.bos.list.events.F7SelectedListSortListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import org.apache.commons.lang3.StringUtils;

public class BizobjFieldSelDlgFormPlugin
extends BaseFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
BeforeBindDataListener,
F7SelectedListRemoveListener,
F7SelectedListSortListener,
RowClickEventListener {
    public static final String SPLIT_STR_U0001 = "\\u0001";
    public static final String SPLIT_COMMA = ",";
    public static final String DLG_RESULT = "dlgResult";
    public static final String KEY_TOOLBARAP = "toolbarap";
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String NUMBER = "number";
    private static final String KEY_BD_ENTITYNUMBER = "entitynumber";
    private static final String KEY_FLEX_EMPTY = "flexempty";
    private static final String KEY_FLEX_ENTITY_STRUCTURE = "flexentitystructure";
    private static final String KEY_FLEX_TREE = "flextree";
    private static final String KEY_FLEX_TREEEMPTY = "flextreeempty";
    private static final String KEY_LABELAP_ENTITY_BASE_INFO = "labelapentitybaseinfo";
    private static final String KEY_LABELAP_TABLE_BASE_INFO = "labelaptablebaseinfo";
    private static final String KEY_LABELAP_FIELD_COUNT = "labelapfieldcount";
    private static final String KEY_TREEVIEWAP_MODEL = "treeviewapmodel";
    private static final String CACHE_KEY_CURR_ENTITY_KEY = "currEntityKey";
    private static final String CACHE_KEY_SELECTED_PLAINFIELD_LIST_PREFIX = "selectedFieldList_";
    private static final String CACHE_KEY_ALL_PLAINFIELD_LIST_PREFIX = "allFieldList_";
    private static final String CACHE_KEY_ALL_ENTITY_KEY_LIST = "allEntityKey";
    private static final String CACHE_KEY_IS_INIT = "isInit";
    private static final String CACHE_KEY_SELECTED_VALUE_TEXT_ITEM_LIST = "selectedValueTextItemList";
    private static final String KEY_FIELD_ENTRYENTITY = "fieldentryentity";
    private static final String KEY_SHOW_ENTITY_NUMBER = "showentitynumber";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CANCEL = "btncancel";
    public static final String KEY_F7_SELECTEDLISTAP = "f7selectedlistap";

    public boolean isInit() {
        String isInit = this.getCache().get(CACHE_KEY_IS_INIT);
        return Boolean.parseBoolean(isInit);
    }

    public String getCurrEntityKey() {
        return this.getCache().get(CACHE_KEY_CURR_ENTITY_KEY);
    }

    public List<PlainField> getSelectedPlainFieldList(String entityKey) {
        return this.getCache().getAsList(CACHE_KEY_SELECTED_PLAINFIELD_LIST_PREFIX + entityKey, PlainField.class);
    }

    public List<PlainField> getAllPlainFieldList(String entityKey) {
        return this.getCache().getAsList(CACHE_KEY_ALL_PLAINFIELD_LIST_PREFIX + entityKey, PlainField.class);
    }

    public List<String> getAllEntityKeyList() {
        return this.getCache().getAsList(CACHE_KEY_ALL_ENTITY_KEY_LIST, String.class);
    }

    public List<ValueTextItem> getSelectedValueTextItemList() {
        return this.getCache().getAsList(CACHE_KEY_SELECTED_VALUE_TEXT_ITEM_LIST, ValueTextItem.class);
    }

    private void putEntityToCache(Map<String, String> data, Entity entity) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)entity);
        o.remove((Object)"children");
        data.put("EntityCache_" + entity.getKey(), o.toJSONString());
    }

    private Entity getEntityFromCache(String entityKey) {
        String s = this.getCache().get("EntityCache_" + entityKey);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return (Entity)JSON.parseObject((String)s, Entity.class);
    }

    @Override
    public void initialize() {
        super.initialize();
        final EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FIELD_ENTRYENTITY);
        entryGrid.addSelectRowsListener(new SelectRowsEventListener(){

            public void selectRowsChange(SelectRowsEvent evt) {
                super.selectRowsChange(evt);
                String currEntityKey = BizobjFieldSelDlgFormPlugin.this.getCurrEntityKey();
                List<PlainField> allPlainFieldList = BizobjFieldSelDlgFormPlugin.this.getAllPlainFieldList(currEntityKey);
                Map fieldIdPlainFieldMap = allPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldId, Function.identity(), (key1, key2) -> key2));
                List newRows = evt.getNewRows();
                List oldRows = evt.getOldRows();
                List subtractRows = null;
                boolean isAddField = false;
                if (newRows.size() > oldRows.size()) {
                    subtractRows = (List)org.apache.commons.collections4.CollectionUtils.subtract((Iterable)newRows, (Iterable)oldRows);
                    isAddField = true;
                } else {
                    subtractRows = (List)org.apache.commons.collections4.CollectionUtils.subtract((Iterable)oldRows, (Iterable)newRows);
                }
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)subtractRows)) {
                    int row = (Integer)subtractRows.get(0);
                    List<Object> selectedPlainFieldList = new ArrayList();
                    if (subtractRows.size() == 1) {
                        EntryData entryData = entryGrid.getEntryData();
                        DynamicObject[] dataEntitys = entryData.getDataEntitys();
                        DynamicObject rowDo = dataEntitys[row];
                        String fieldId = rowDo.getString("fieldid");
                        selectedPlainFieldList = BizobjFieldSelDlgFormPlugin.this.getSelectedPlainFieldList(currEntityKey);
                        Optional<PlainField> first = selectedPlainFieldList.stream().filter(plainField -> fieldId.equals(plainField.getFieldId())).findFirst();
                        if (first.isPresent()) {
                            selectedPlainFieldList = selectedPlainFieldList.stream().filter(e -> !StringUtils.equalsIgnoreCase((CharSequence)e.getFieldId(), (CharSequence)fieldId)).collect(Collectors.toList());
                        } else {
                            String fieldKey = rowDo.getString("fieldkey");
                            String fieldName = rowDo.getString("fieldname");
                            String fieldType = rowDo.getString("fieldtype");
                            Map enumKv = ((PlainField)fieldIdPlainFieldMap.get(fieldId)).getEnumKv();
                            PlainField plainField2 = new PlainField();
                            plainField2.setFieldId(fieldId);
                            plainField2.setFieldKey(fieldKey);
                            plainField2.setFieldName(fieldName);
                            plainField2.setFieldType(fieldType);
                            plainField2.setEntityKey(currEntityKey);
                            plainField2.setEnumKv(enumKv);
                            selectedPlainFieldList.add(plainField2);
                        }
                    } else if (subtractRows.size() > 1) {
                        if (isAddField) {
                            if (newRows != null && newRows.size() == allPlainFieldList.size()) {
                                selectedPlainFieldList = allPlainFieldList;
                            } else {
                                for (int i = 0; i < newRows.size(); ++i) {
                                    selectedPlainFieldList.add(allPlainFieldList.get((Integer)newRows.get(i)));
                                }
                            }
                        } else if (subtractRows.size() == allPlainFieldList.size()) {
                            if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)newRows)) {
                                selectedPlainFieldList.clear();
                            } else {
                                selectedPlainFieldList = BizobjFieldSelDlgFormPlugin.this.getSelectedPlainFieldList(currEntityKey);
                            }
                        } else {
                            selectedPlainFieldList = BizobjFieldSelDlgFormPlugin.this.getSelectedPlainFieldList(currEntityKey);
                            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)newRows)) {
                                selectedPlainFieldList.clear();
                                for (int i = 0; i < newRows.size(); ++i) {
                                    selectedPlainFieldList.add(allPlainFieldList.get((Integer)newRows.get(i)));
                                }
                            }
                        }
                    }
                    BizobjFieldSelDlgFormPlugin.this.cacheSelectRowData(row, selectedPlainFieldList);
                }
            }
        });
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row >= 0) {
            // empty if block
        }
    }

    private void cacheSelectRowData(int focusRowIndex, List<PlainField> selectedPlainFieldList) {
        String currEntityKey = this.getCurrEntityKey();
        this.getCache().put(CACHE_KEY_SELECTED_PLAINFIELD_LIST_PREFIX + currEntityKey, selectedPlainFieldList);
        Entity entity = this.getEntityFromCache(currEntityKey);
        if (entity != null) {
            this.log.info("##### entity:{}", (Object)JSONObject.toJSONString((Object)entity));
            this.initEntityFieldData(entity, focusRowIndex);
        }
        this.showInF7SelectList();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
        this.addClickListeners(new String[]{KEY_BTN_CANCEL, KEY_BTN_OK});
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(KEY_F7_SELECTEDLISTAP);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListSortListener((F7SelectedListSortListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FIELD_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    private void showInF7SelectList() {
        List<ValueTextItem> valueTextItemList = this.getSelectedValueTextItemList();
        valueTextItemList.clear();
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(KEY_F7_SELECTEDLISTAP);
        List<String> allEntityKeyList = this.getAllEntityKeyList();
        for (String entityKey : allEntityKeyList) {
            List<PlainField> selectedPlainFieldList = this.getSelectedPlainFieldList(entityKey);
            if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(selectedPlainFieldList)) continue;
            for (PlainField plainField : selectedPlainFieldList) {
                ValueTextItem item = new ValueTextItem(plainField.getFieldId(), plainField.getFieldName());
                valueTextItemList.add(item);
            }
        }
        f7SelectedList.addItems(valueTextItemList);
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnok": {
                String entityNumber = this.getEntityNumber();
                List<String> allEntityKeyList = this.getAllEntityKeyList();
                ArrayList<PlainField> allPlainFieldList = new ArrayList<PlainField>();
                for (String entityKey : allEntityKeyList) {
                    List<PlainField> selectedPlainFieldList = this.getSelectedPlainFieldList(entityKey);
                    if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(selectedPlainFieldList)) continue;
                    allPlainFieldList.addAll(selectedPlainFieldList);
                }
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(allPlainFieldList)) {
                    this.getView().showTipNotification("\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002");
                    return;
                }
                DataSourceMetadata metadata = new DataSourceMetadata();
                ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
                FieldInfo fieldInfo = new FieldInfo();
                fieldInfo.setEntityNumber(entityNumber);
                fieldInfo.setPlainFieldList(allPlainFieldList);
                fieldInfoList.add(fieldInfo);
                metadata.setFieldInfoList(fieldInfoList);
                String metadataTag = JSONObject.toJSONString((Object)metadata);
                JSONObject dataJo = new JSONObject();
                dataJo.put(ENTITY_NUMBER, (Object)entityNumber);
                dataJo.put("metadata_tag", (Object)metadataTag);
                this.getCache().put(DLG_RESULT, dataJo.toJSONString());
                this.getView().close();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getCache().get(DLG_RESULT));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_BD_ENTITYNUMBER)) {
            DynamicObject newDo = (DynamicObject)changeData[0].getNewValue();
            String entityNumber = newDo != null ? newDo.getString(NUMBER) : "";
            this.getCache().removeWithKeyPrefix(CACHE_KEY_SELECTED_PLAINFIELD_LIST_PREFIX);
            this.loadModelData(entityNumber);
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_SHOW_ENTITY_NUMBER) && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"type")) {
            String type = (String)changeData[0].getNewValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.BIZOBJ.getId())) {
                this.getModel().setValue("splitchar", (Object)SPLIT_STR_U0001);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)DataSourceTypeEnum.CSV.getId())) {
                this.getModel().setValue("splitchar", (Object)SPLIT_COMMA);
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.log.info("");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getCache().put(CACHE_KEY_IS_INIT, "true");
        String entityNumber = this.getEntityNumber();
        this.loadModelData(entityNumber);
        String currEntityKey = this.getCurrEntityKey();
        List<PlainField> selectedPlainFieldList = this.getSelectedPlainFieldList(currEntityKey);
        this.cacheSelectRowData(0, selectedPlainFieldList);
        this.getCache().remove(CACHE_KEY_IS_INIT);
    }

    private String getEntityNumber() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(ENTITY_NUMBER);
        DynamicObject entityDo = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITYNUMBER);
        if (entityDo != null) {
            entityNumber = entityDo.getString(NUMBER);
        }
        return entityNumber;
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String entityKey = (String)treeNodeEvent.getNodeId();
        this.log.info("#####treeNodeClick entityKey : {}" + entityKey);
        Entity entity = this.getEntityFromCache(entityKey);
        if (entity != null) {
            this.log.info("##### entity:{}", (Object)JSONObject.toJSONString((Object)entity));
            this.initEntityFieldData(entity, 0);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
    }

    private EntityCatalog loadDatasourceModelData(String entityNumber) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityCatalog entityEntityCatalog = new EntityCatalog();
        entityEntityCatalog.setId(entityNumber);
        entityEntityCatalog.setText(mainEntityType.getName());
        entityEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
        entityEntityCatalog.setParentid(mainEntityType.getAppId());
        Entity entity = this.getEntityStructByMainEntityType(entityEntityCatalog, mainEntityType);
        String bizAppNumber = mainEntityType.getBizAppNumber();
        QFilter filter = new QFilter(NUMBER, "=", (Object)bizAppNumber);
        DynamicObject bizAppDo = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filter.toArray());
        String bizAppId = bizAppDo.getString("id");
        String bizCloudId = bizAppDo.getString("bizcloud");
        DynamicObject bizCloudDo = BizCloudServiceHelp.getBizCloudByID((String)bizCloudId);
        EntityCatalog allEntityCatalog = new EntityCatalog();
        allEntityCatalog.setId("0");
        allEntityCatalog.setParentid("0");
        allEntityCatalog.setText("\u5168\u90e8");
        allEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
        allEntityCatalog.setEntity(null);
        allEntityCatalog.setChildren(null);
        ArrayList<EntityCatalog> bizCloudEntityCatalogList = new ArrayList<EntityCatalog>();
        EntityCatalog bizCloudCatalog = new EntityCatalog();
        bizCloudCatalog.setXtype(XtypeEnum.CATALOG.getKey());
        bizCloudCatalog.setId(bizCloudDo.getString("id"));
        bizCloudCatalog.setParentid("0");
        bizCloudCatalog.setText(bizCloudDo.getString("name"));
        bizCloudCatalog.setEntity(null);
        ArrayList<EntityCatalog> bizAppEntityCatalogList = new ArrayList<EntityCatalog>();
        EntityCatalog bizAppEntityCatalog = new EntityCatalog();
        bizAppEntityCatalog.setId(bizAppId);
        bizAppEntityCatalog.setParentid(bizCloudId);
        bizAppEntityCatalog.setText(bizAppDo.getString("name"));
        bizAppEntityCatalog.setXtype(XtypeEnum.CATALOG.getKey());
        bizAppEntityCatalog.setEntity(null);
        ArrayList<EntityCatalog> bizObjectList = new ArrayList<EntityCatalog>();
        EntityCatalog bizObjectEntityCatalog = new EntityCatalog();
        bizObjectEntityCatalog.setId(entityNumber);
        bizObjectEntityCatalog.setParentid(bizAppId);
        bizObjectEntityCatalog.setText(mainEntityType.getDisplayName().getLocaleValue());
        bizObjectEntityCatalog.setXtype(XtypeEnum.ENTITY.getKey());
        bizObjectEntityCatalog.setEntity(entity);
        bizObjectEntityCatalog.setChildren(null);
        bizObjectList.add(bizObjectEntityCatalog);
        if (!org.apache.commons.collections4.CollectionUtils.isEmpty(bizObjectList)) {
            bizAppEntityCatalog.setChildren(bizObjectList);
            bizAppEntityCatalogList.add(bizAppEntityCatalog);
        }
        if (!org.apache.commons.collections4.CollectionUtils.isEmpty(bizAppEntityCatalogList)) {
            bizCloudCatalog.setChildren(bizAppEntityCatalogList);
        }
        if (!org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)bizCloudCatalog.getChildren())) {
            bizCloudEntityCatalogList.add(bizCloudCatalog);
        }
        allEntityCatalog.setChildren(bizCloudEntityCatalogList);
        return allEntityCatalog;
    }

    private void loadModelData(String entityNumber) {
        this.updateBizObjValue(entityNumber);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_EMPTY, KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
        if (!StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_EMPTY, KEY_FLEX_TREEEMPTY});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_EMPTY, KEY_FLEX_TREEEMPTY});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_ENTITY_STRUCTURE, KEY_FLEX_TREE});
        EntityCatalog entityCatalog = this.loadDatasourceModelData(entityNumber);
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEWAP_MODEL);
        tv.deleteAllNodes();
        String rootId = entityCatalog.getId();
        TreeNode rootNode = new TreeNode(null, rootId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApplicationConfigPlugin_11", (String)"ai-ids-plugin", (Object[])new Object[0]), (Object)Boolean.TRUE);
        rootNode.setIsOpened(true);
        Entity initEntity = null;
        TreeNode initTreeNode = null;
        List bizCloudList = entityCatalog.getChildren();
        HashMap<String, String> cache = new HashMap<String, String>();
        ArrayList<String> allEntityKeyList = new ArrayList<String>();
        for (EntityCatalog bizCloudEntityCatalog : bizCloudList) {
            TreeNode tn1 = new TreeNode(bizCloudEntityCatalog.getParentid(), bizCloudEntityCatalog.getKey(), bizCloudEntityCatalog.getText(), (Object)Boolean.TRUE);
            tn1.setIcon("kdfont kdfont-jiaoben_yewuyun");
            tn1.setIsOpened(true);
            List appList = bizCloudEntityCatalog.getChildren();
            for (EntityCatalog appEntityCatalog : appList) {
                TreeNode tn2 = new TreeNode(appEntityCatalog.getParentid(), appEntityCatalog.getKey(), appEntityCatalog.getText(), (Object)Boolean.TRUE);
                tn2.setIsOpened(true);
                tn2.setIcon("kdfont kdfont-yingyongguanli");
                List entityList = appEntityCatalog.getChildren();
                for (EntityCatalog entityEntityCatalog : entityList) {
                    Entity entity = entityEntityCatalog.getEntity();
                    if (entity == null) continue;
                    String entityKey = entity.getKey();
                    String entityId = entity.getId();
                    String entityName = entityEntityCatalog.getText();
                    entityName = String.format("%s(%s)", entityName, entityId);
                    allEntityKeyList.add(entityKey);
                    TreeNode tn3 = new TreeNode(entityEntityCatalog.getParentid(), entityKey, entityName, (Object)Boolean.TRUE);
                    tn2.addChild(tn3);
                    tn3.setIsOpened(true);
                    if (initEntity == null) {
                        initEntity = entity;
                        initTreeNode = tn3;
                        this.initPlainFieldCache();
                        this.initEntityFieldData(initEntity, 0);
                    }
                    entity.setEntityId(entity.getId());
                    this.putEntityToCache(cache, entity);
                    List entityChildrenList = entity.getChildren();
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)entityChildrenList)) continue;
                    for (Entity childrenEntity : entityChildrenList) {
                        allEntityKeyList.add(childrenEntity.getKey());
                        childrenEntity.setEntityId(entity.getId());
                        this.putEntityToCache(cache, childrenEntity);
                        List subEntityChildrenList = childrenEntity.getChildren();
                        boolean isParent = !org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)childrenEntity.getChildren());
                        String childrenEntityId = childrenEntity.getId();
                        String childrenEntityName = childrenEntity.getName();
                        childrenEntityName = String.format("%s(%s)", childrenEntityName, childrenEntityId);
                        TreeNode tn4 = new TreeNode(entity.getKey(), childrenEntity.getKey(), childrenEntityName, isParent);
                        tn3.addChild(tn4);
                        tn4.setIsOpened(true);
                        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)subEntityChildrenList)) continue;
                        for (Entity subChildrenEntity : subEntityChildrenList) {
                            allEntityKeyList.add(subChildrenEntity.getKey());
                            subChildrenEntity.setEntityId(entity.getId());
                            this.putEntityToCache(cache, subChildrenEntity);
                            List subSubEntityChildrenList = subChildrenEntity.getChildren();
                            boolean subEntityIsParent = !org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)subSubEntityChildrenList);
                            String subChildrenEntityId = subChildrenEntity.getId();
                            String subChildrenEntityName = subChildrenEntity.getName();
                            subChildrenEntityName = String.format("%s(%s)", subChildrenEntityName, subChildrenEntityId);
                            TreeNode tn5 = new TreeNode(entity.getKey(), subChildrenEntity.getKey(), subChildrenEntityName, subEntityIsParent);
                            tn4.addChild(tn5);
                            tn5.setIsOpened(true);
                        }
                    }
                }
                tn1.addChild(tn2);
            }
            rootNode.addChild(tn1);
        }
        this.getCache().put(CACHE_KEY_ALL_ENTITY_KEY_LIST, allEntityKeyList);
        tv.addNode(rootNode);
        tv.setRootVisible(false);
        if (initTreeNode != null) {
            tv.focusNode(initTreeNode);
        }
        this.getCache().put(cache);
    }

    private void updateBizObjValue(String entityNumber) {
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter(NUMBER, "=", (Object)entityNumber).toArray());
            this.getModel().setValue(KEY_BD_ENTITYNUMBER, (Object)bosEntityobject);
            this.getView().updateView(KEY_BD_ENTITYNUMBER);
        }
    }

    private void initPlainFieldCache() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String metadataStr = (String)fsp.getCustomParam("metadata_tag");
        if (StringUtils.isNotEmpty((CharSequence)metadataStr)) {
            DataSourceMetadata metadata = (DataSourceMetadata)JSONObject.parseObject((String)metadataStr, DataSourceMetadata.class);
            String entityNumber = this.getEntityNumber();
            List fieldInfoList = metadata.getFieldInfoList();
            Optional<FieldInfo> first = fieldInfoList.stream().filter(e -> e.getEntityNumber().equalsIgnoreCase(entityNumber)).findFirst();
            if (first.isPresent()) {
                FieldInfo fieldInfo = first.get();
                List plainFieldList = fieldInfo.getPlainFieldList();
                Map<String, List<PlainField>> map = plainFieldList.stream().collect(Collectors.groupingBy(PlainField::getEntityKey));
                Set<Map.Entry<String, List<PlainField>>> entries = map.entrySet();
                for (Map.Entry<String, List<PlainField>> entry : entries) {
                    String entityKey = entry.getKey();
                    this.getCache().put(CACHE_KEY_SELECTED_PLAINFIELD_LIST_PREFIX + entityKey, entry.getValue());
                }
            }
        }
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    private void initEntityFieldData(Entity entity, int focusRowIndex) {
        if (entity == null) {
            return;
        }
        Label entityBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_ENTITY_BASE_INFO);
        entityBaseInfoLabel.setText(String.format("%s\uff1a%s(%s)", ResManager.loadKDString((String)"\u5b9e\u4f53", (String)"ApplicationConfigPlugin_12", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getName(), entity.getId()));
        Label tableBaseInfoLabel = (Label)this.getView().getControl(KEY_LABELAP_TABLE_BASE_INFO);
        tableBaseInfoLabel.setText(String.format("%s\uff1a%s", ResManager.loadKDString((String)"\u8868\u540d", (String)"ApplicationConfigPlugin_13", (String)"ai-ids-plugin", (Object[])new Object[0]), entity.getTableName()));
        List fieldList = BizobjFieldSelDlgFormPlugin.emptyIfNull(entity.getFields());
        this.setLabelText(KEY_LABELAP_FIELD_COUNT, String.format("\u5b57\u6bb5\u6570\u91cf\uff1a%s", fieldList.size()));
        String currEntityKey = entity.getKey();
        this.getCache().put(CACHE_KEY_CURR_ENTITY_KEY, currEntityKey);
        this.getModel().deleteEntryData(KEY_FIELD_ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_FIELD_ENTRYENTITY);
        int size = fieldList.size();
        IDataModel dataModel = this.getModel();
        dataModel.batchCreateNewEntryRow(KEY_FIELD_ENTRYENTITY, size);
        List<PlainField> selectedPlainFieldList = this.getSelectedPlainFieldList(currEntityKey);
        List<Object> selectedFieldIdList = new ArrayList();
        Map<Object, Object> plainFieldMap = new HashMap();
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(selectedPlainFieldList)) {
            selectedFieldIdList = selectedPlainFieldList.stream().map(PlainField::getFieldId).collect(Collectors.toList());
            plainFieldMap = selectedPlainFieldList.stream().collect(Collectors.toMap(PlainField::getFieldId, a -> a, (k1, k2) -> k1));
        }
        int[] selectRows = new int[selectedFieldIdList.size()];
        int selectRowIndex = 0;
        ArrayList<PlainField> allPlainFieldList = new ArrayList<PlainField>(10);
        for (int i = 0; i < fieldList.size(); ++i) {
            Field field = (Field)fieldList.get(i);
            String fieldName = field.getName();
            String fieldId = field.getFieldName();
            String fieldKey = field.getKey();
            String fieldType = field.getFieldType();
            Map enumKv = field.getEnumKv();
            PlainField plainField = (PlainField)plainFieldMap.get(fieldId);
            if (plainField != null && StringUtils.isNotEmpty((CharSequence)plainField.getFieldType())) {
                fieldType = plainField.getFieldType();
            }
            if (plainField == null) {
                plainField = new PlainField();
            }
            plainField.setFieldId(fieldId);
            plainField.setFieldKey(fieldKey);
            plainField.setFieldName(fieldName);
            plainField.setFieldType(fieldType);
            plainField.setEntityKey(currEntityKey);
            plainField.setEnumKv(enumKv);
            allPlainFieldList.add(plainField);
            dataModel.setValue("fieldid", (Object)fieldId, i);
            dataModel.setValue("fieldkey", (Object)fieldKey, i);
            dataModel.setValue("fieldname", (Object)fieldName, i);
            dataModel.setValue("enumkv", enumKv != null && !enumKv.isEmpty() ? JSONObject.toJSONString((Object)enumKv) : null, i);
            dataModel.setValue("fieldtype", (Object)fieldType, i);
            if (selectedFieldIdList.contains(field.getFieldName())) {
                selectRows[selectRowIndex++] = i;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldid"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldname"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"fieldtype"});
        }
        this.getCache().put(CACHE_KEY_ALL_PLAINFIELD_LIST_PREFIX + currEntityKey, allPlainFieldList);
        this.getView().updateView(KEY_FIELD_ENTRYENTITY);
        entryGrid.selectRows(selectRows, focusRowIndex);
    }

    public Entity getEntityStructByMainEntityType(EntityCatalog entityCatalog, MainEntityType mainEntityType) {
        Entity entity = null;
        if (mainEntityType != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getAlias())) {
            entity = new Entity();
            Map allEntities = mainEntityType.getAllEntities();
            HashMap<String, EntityType> idBillEntityTypeMap = new HashMap<String, EntityType>();
            HashMap<String, List> idEntryTypeListMap = new HashMap<String, List>();
            HashMap<String, List> idSubEntityTypeListMap = new HashMap<String, List>();
            for (Map.Entry entry : allEntities.entrySet()) {
                List entityTypeList;
                String parentName;
                String key = (String)entry.getKey();
                EntityType entityType = (EntityType)entry.getValue();
                if (entityType instanceof SubEntryType) {
                    this.log.info("#####" + entityType.getName() + "\u662f\u5b50\u5355\u636e\u4f53");
                    parentName = entityType.getParent().getName();
                    entityTypeList = idSubEntityTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idSubEntityTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (entityType instanceof EntryType) {
                    this.log.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u4f53");
                    parentName = entityType.getParent().getName();
                    entityTypeList = idEntryTypeListMap.getOrDefault(parentName, new ArrayList());
                    entityTypeList.add(entityType);
                    idEntryTypeListMap.put(parentName, entityTypeList);
                    continue;
                }
                if (!(entityType instanceof BillEntityType)) continue;
                this.log.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u5934");
                idBillEntityTypeMap.put(key, entityType);
            }
            HashMap<String, List<Field>> entityFieldListMap = new HashMap<String, List<Field>>();
            String displayName = "";
            if (mainEntityType.getDisplayName() != null) {
                displayName = mainEntityType.getDisplayName().getLocaleValue();
            }
            this.getEntityFieldListMap(mainEntityType.getName(), displayName, mainEntityType.getProperties(), entityFieldListMap);
            String keyPrefixId = entityCatalog.getParentid();
            for (Map.Entry entry : idBillEntityTypeMap.entrySet()) {
                String billEntityTypeName = (String)entry.getKey();
                EntityType billEntity = (EntityType)entry.getValue();
                String billEntityKey = keyPrefixId + "_" + billEntityTypeName;
                Field billEntityPkField = this.fillEntity(entityCatalog.getParentid(), billEntityKey, entity, billEntity, entityFieldListMap, "");
                ArrayList<Entity> entryEntityList = new ArrayList<Entity>();
                List entryTypeList = (List)idEntryTypeListMap.get(billEntityTypeName);
                if (!CollectionUtils.isEmpty((Collection)entryTypeList)) {
                    for (EntityType entityType : entryTypeList) {
                        String entryName = entityType.getName();
                        Entity entryEntity = new Entity();
                        String entryEntityKey = keyPrefixId + "_" + billEntityTypeName + "_" + entityType.getName();
                        Field entryEntityPkField = this.fillEntity(entityType.getParent().getName(), entryEntityKey, entryEntity, entityType, entityFieldListMap, entryName);
                        String entityTypeName = entityType.getName();
                        List subEntityTypeList = (List)idSubEntityTypeListMap.get(entityTypeName);
                        ArrayList<Entity> subEntityList = new ArrayList<Entity>();
                        if (!CollectionUtils.isEmpty((Collection)subEntityTypeList)) {
                            for (EntityType subEntityType : subEntityTypeList) {
                                String subEntryName = subEntityType.getName();
                                Entity subEntity = new Entity();
                                String subEntityKey = keyPrefixId + "_" + billEntityTypeName + "_" + entityTypeName + "_" + subEntityType.getName();
                                this.fillEntity(subEntityType.getParent().getName(), subEntityKey, subEntity, subEntityType, entityFieldListMap, entryName + "." + subEntryName);
                                List subEntityFieldList = subEntity.getFields();
                                subEntity.setFields(subEntityFieldList);
                                subEntity.setChildren(new ArrayList());
                                if (!StringUtils.isNotEmpty((CharSequence)subEntity.getTableName())) continue;
                                subEntityList.add(subEntity);
                            }
                        }
                        List entryEntityFieldList = entryEntity.getFields();
                        entryEntity.setFields(entryEntityFieldList);
                        entryEntity.setChildren(subEntityList);
                        if (!StringUtils.isNotEmpty((CharSequence)entryEntity.getTableName())) continue;
                        entryEntityList.add(entryEntity);
                    }
                }
                entity.setChildren(entryEntityList);
            }
            entityCatalog.setEntity(entity);
        }
        return entity;
    }

    private String getParentEntityId(IDataEntityType dataEntityType) {
        String parentId = "";
        while (dataEntityType != null) {
            String pid = dataEntityType.getName();
            parentId = StringUtils.isEmpty((CharSequence)parentId) ? pid : String.format("%s.%s", pid, parentId);
            dataEntityType = dataEntityType.getParent();
        }
        parentId = !StringUtils.contains((CharSequence)parentId, (CharSequence)".") ? "" : parentId.substring(parentId.indexOf(46) + 1);
        return parentId;
    }

    public static String getFieldTypeNameByDp(IDataEntityProperty dp) {
        String typeName = FieldTypeEnum.STRING.getId();
        if (dp instanceof BigIntProp || dp instanceof LongProp) {
            typeName = FieldTypeEnum.LONG.getId();
        } else if (dp instanceof IntegerProp) {
            typeName = FieldTypeEnum.INT.getId();
        } else if (dp instanceof DecimalProp) {
            typeName = FieldTypeEnum.DECIMAL.getId();
        } else if (dp instanceof DateProp) {
            typeName = FieldTypeEnum.DATE.getId();
        } else if (dp instanceof DateTimeProp) {
            typeName = FieldTypeEnum.DATETIME.getId();
        } else if (dp instanceof BooleanProp) {
            typeName = FieldTypeEnum.BOOLEAN.getId();
        }
        return typeName;
    }

    public static String getFieldTypeNameByDbType(Integer dbType) {
        if (dbType == null) {
            return "STRING";
        }
        String typeName = "";
        switch (dbType) {
            case 4: {
                typeName = "INT";
                break;
            }
            case -5: {
                typeName = "LONG";
                break;
            }
            case 3: {
                typeName = "DECIMAL";
                break;
            }
            case 1: {
                typeName = "BOOLEAN";
                break;
            }
            case 91: {
                typeName = "DATE";
                break;
            }
            case 93: {
                typeName = "DATETIME";
                break;
            }
            case -9: 
            case 0: 
            case 12: {
                typeName = "STRING";
                break;
            }
            default: {
                typeName = "STRING";
            }
        }
        return typeName;
    }

    private void getEntityFieldListMap(String entityName, String entityDisplayName, DataEntityPropertyCollection properties, Map<String, List<Field>> entityFieldListMap) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (IDataEntityProperty dp : properties) {
            List comboItems;
            String mainName;
            String originKey;
            if (dp.getName().contains("f7")) {
                this.log.info("");
            }
            String parentEntityId = this.getParentEntityId(dp.getParent());
            if (dp instanceof EntryProp) {
                EntryProp entry = (EntryProp)dp;
                DynamicObjectType dot = entry.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dot.getProperties();
                String displayName = "";
                if (entry.getDisplayName() != null) {
                    displayName = entry.getDisplayName().getLocaleValue();
                }
                this.getEntityFieldListMap(entry.getName(), displayName, entryProperties, entityFieldListMap);
                continue;
            }
            if (!this.canShow(dp)) continue;
            String mainKey = originKey = dp.getName();
            String pkName = "";
            if (dp.getParent() != null && dp.getParent().getPrimaryKey() != null) {
                pkName = dp.getParent().getPrimaryKey().getName();
            }
            String mainDisplayName = this.getDisplayName(dp);
            if (StringUtils.equalsIgnoreCase((CharSequence)pkName, (CharSequence)mainKey) && StringUtils.isNotEmpty((CharSequence)entityDisplayName)) {
                mainDisplayName = String.format("%s%s", entityDisplayName, mainDisplayName);
            }
            if (StringUtils.isNotEmpty((CharSequence)parentEntityId)) {
                mainKey = String.format("%s.%s", parentEntityId, mainKey);
            }
            if (StringUtils.isEmpty((CharSequence)(mainName = dp.getAlias()))) {
                mainName = mainKey.replaceAll("\\.", "_");
            }
            if (originKey.equalsIgnoreCase("id") || originKey.equalsIgnoreCase("seq")) {
                if (StringUtils.isNotEmpty((CharSequence)parentEntityId)) {
                    mainName = String.format("f%s_%s", entityName, originKey);
                }
            } else {
                mainName = String.format("f%s", originKey);
            }
            mainName = mainName.toLowerCase();
            if (dp instanceof BasedataProp) {
                MainEntityType dataEntityType;
                String baseEntityName;
                if (dp.getName().contains("f7")) {
                    this.log.info("");
                }
                BasedataProp bd = (BasedataProp)dp;
                DynamicObjectType ref = bd.getDynamicComplexPropertyType();
                DataEntityPropertyCollection subPS = ref.getProperties();
                String baseEntityDisplayName = baseEntityName = bd.getBaseEntityId();
                if (StringUtils.isNotEmpty((CharSequence)baseEntityName) && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName)) != null && dataEntityType.getDisplayName() != null) {
                    baseEntityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                }
                for (IDataEntityProperty subDP : subPS) {
                    if (!this.canShow(subDP)) continue;
                    String fieldType = BizobjFieldSelDlgFormPlugin.getFieldTypeNameByDp(subDP);
                    String subKey = subDP.getName();
                    String subDisplayName = this.getDisplayName(subDP);
                    String subName = subDP.getAlias();
                    if (StringUtils.isEmpty((CharSequence)subName)) {
                        subName = subKey.replaceAll("\\.", "_");
                    }
                    Field field = new Field();
                    field.setEnumKv(null);
                    field.setName(String.format("%s.%s", mainDisplayName, subDisplayName));
                    if (StringUtils.equalsIgnoreCase((CharSequence)"id", (CharSequence)subKey)) {
                        field.setRefEntityId(baseEntityName);
                        field.setRefEntityName(baseEntityDisplayName);
                    }
                    field.setFieldName(String.format("%s.%s", mainKey, subKey));
                    String key = String.format("%s_%s", mainName, subName);
                    key = key.toLowerCase();
                    field.setKey(key);
                    field.setFieldType(fieldType);
                    field.setBaseFieldKey(null);
                    if (keyList.contains(field.getKey())) continue;
                    fieldList.add(field);
                    keyList.add(field.getKey());
                }
                continue;
            }
            if (dp.isDbIgnore()) continue;
            HashMap enumKv = new HashMap();
            if (dp instanceof ComboProp && (comboItems = ((ComboProp)dp).getComboItems()) != null && !comboItems.isEmpty()) {
                comboItems.forEach(comboItem -> enumKv.put(comboItem.getValue(), comboItem.getName() != null ? comboItem.getName().getLocaleValue() : ""));
            }
            String fieldType = BizobjFieldSelDlgFormPlugin.getFieldTypeNameByDp(dp);
            Field field = new Field();
            field.setEnumKv(enumKv);
            field.setName(mainDisplayName);
            field.setFieldName(mainKey);
            field.setKey(mainName);
            field.setFieldType(fieldType);
            field.setBaseFieldKey(null);
            if (keyList.contains(field.getKey())) continue;
            fieldList.add(field);
            keyList.add(field.getKey());
        }
        entityFieldListMap.put(entityName, fieldList);
    }

    private boolean canShow(IDataEntityProperty dp) {
        return !(dp instanceof DynamicLocaleProperty) && StringUtils.isNotEmpty((CharSequence)dp.getAlias());
    }

    private String getDisplayName(IDataEntityProperty dp) {
        LocaleString displayName = dp.getDisplayName();
        if (displayName != null) {
            return displayName.getLocaleValue();
        }
        return dp.getName();
    }

    private Field fillEntity(String parentId, String entityKey, Entity entity, EntityType entityType, Map<String, List<Field>> entityIdFieldListMap, String rootName) {
        String entityNumber = entityType.getName();
        List<Field> fieldList = entityIdFieldListMap.get(entityNumber);
        String entityName = entityType.getDisplayName().getLocaleValue();
        entity.setId(entityNumber);
        entity.setKey(entityKey);
        entity.setName(entityName);
        entity.setUploadType(Integer.valueOf(UploadTypeEnum.ALL.getKey()));
        entity.setIncrementField(null);
        entity.setParentId(parentId);
        Field pkField = this.getPkField(entityType, rootName);
        if (pkField != null) {
            entity.setPkFieldName(pkField.getFieldName());
            entity.setPkFieldType(pkField.getFieldType());
        }
        entity.setTableName(entityType.getAlias());
        entity.setIsFormGroup(Integer.valueOf(0));
        entity.setFields(fieldList);
        entity.setChildren(null);
        return pkField;
    }

    private Field getPkField(EntityType entityType, String rootName) {
        String primaryKey = entityType.getPrimaryKey().getAlias();
        String primaryFieldName = entityType.getPrimaryKey().getName();
        if (StringUtils.isNotEmpty((CharSequence)rootName)) {
            primaryFieldName = rootName + "." + primaryFieldName;
        }
        String pkFieldType = BizobjFieldSelDlgFormPlugin.getFieldTypeNameByDbType(entityType.getPrimaryKey().getDbType());
        Field pkField = new Field();
        pkField.setKey(primaryKey);
        pkField.setBaseFieldKey(null);
        pkField.setEnumKv(null);
        pkField.setFieldName(primaryFieldName);
        pkField.setName(entityType.getDisplayName().getLocaleValue());
        pkField.setFieldType(pkFieldType);
        return pkField;
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
    }

    public void sort(F7SelectedListSortEvent f7SelectedListSortEvent) {
    }
}

