/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.nl2api;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import org.apache.commons.lang3.StringUtils;

public class GaiPageCache {
    private final String pageId;
    private final String regionKey;
    private Map<String, String> cacheMap = new HashMap<String, String>(16);
    private final Set<String> changeSet = new HashSet<String>();
    private final Set<String> removedKeys = new HashSet<String>();
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("gai-form-cache");

    public GaiPageCache(String pageId) {
        this.pageId = pageId;
        this.regionKey = CacheKeyUtil.getAcctId() + ".gaiformcache." + this.pageId;
        this.restore();
    }

    public String getPageId() {
        return this.pageId;
    }

    public void put(String keyName, String value) {
        if (value == null) {
            this.remove(keyName);
        } else if (!value.equals(this.cacheMap.get(keyName))) {
            this.cacheMap.put(keyName, value);
            this.changeSet.add(keyName);
            this.removedKeys.remove(keyName);
        }
    }

    public void put(String keyName, List<?> value) {
        if (value == null) {
            this.remove(keyName);
        } else {
            String json = JSON.toJSONString(value);
            this.put(keyName, json);
        }
    }

    public void put(Map<String, String> values) {
        this.cacheMap.putAll(values);
        this.changeSet.addAll(values.keySet());
    }

    public String get(String keyName) {
        return this.cacheMap.get(keyName);
    }

    public void removeWithKeyPrefix(String keyPrefix) {
        ArrayList<String> keyList = new ArrayList<String>();
        for (Map.Entry<String, String> mapEntry : this.cacheMap.entrySet()) {
            String key = mapEntry.getKey();
            if (!StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)keyPrefix)) continue;
            keyList.add(key);
        }
        if (keyList != null && !keyList.isEmpty()) {
            for (String key : keyList) {
                this.remove(key);
            }
        }
    }

    public <T> List<T> getAsList(String keyName, Class<T> clazz) {
        String s = this.get(keyName);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)s, clazz);
    }

    public void remove(String keyName) {
        this.cacheMap.remove(keyName);
        this.changeSet.remove(keyName);
        this.removedKeys.add(keyName);
    }

    public void restore() {
        this.cacheMap = cache.getAll(this.regionKey);
    }

    public void saveChanges() {
        if (!this.changeSet.isEmpty()) {
            HashMap<String, String> changes = new HashMap<String, String>(16);
            for (String key : this.changeSet) {
                changes.put(key, this.cacheMap.get(key));
            }
            cache.put(this.regionKey, changes, CacheKeyUtil.getPageCacheKeyTimeout());
            this.changeSet.clear();
        }
        if (!this.removedKeys.isEmpty()) {
            String[] keys = this.removedKeys.toArray(new String[0]);
            cache.remove(this.regionKey, keys);
            this.removedKeys.clear();
        }
    }

    public void release() {
        cache.remove(this.regionKey);
        this.cacheMap = null;
    }
}

