/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.op;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.GaiHistoryInitConfig;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiUserFeedbackFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(GaiUserFeedbackFormPlugin.class);
    private static final String AI_GPT_HISTORY = "aigpthistory";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject feedbackDo = this.getModel().getDataEntity();
        String chatSessionId = feedbackDo.getString("chatsessionid");
        String chatTraceId = feedbackDo.getString("chattraceid");
        Message userMessage = MessageService.getAgentMessage((String)chatTraceId, (ChatMessageTypeEnum)ChatMessageTypeEnum.USER);
        GaiHistoryInitConfig gaiHistoryInitConfig = new GaiHistoryInitConfig(chatSessionId, chatTraceId, userMessage.getAssistantId().longValue(), userMessage.getUserId().longValue());
        Map resultMap = ResultVoHelper.buildInitial((GaiInitConfig)gaiHistoryInitConfig);
        CustomControl ctrl = (CustomControl)this.getControl(AI_GPT_HISTORY);
        ctrl.setData((Object)resultMap);
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        log.info("key:{} eventArgs:{} eventName:{}", new Object[]{key, eventArgs, eventName});
        if (key.equals(AI_GPT_HISTORY)) {
            CustomControl customControl = (CustomControl)this.getControl(AI_GPT_HISTORY);
            Map resultMap = new HashMap();
            RequestActionType requestActionType = RequestActionType.valueOf((String)eventName);
            JSONObject requestData = JSON.parseObject((String)eventArgs);
            String chatSessionId = requestData.getString("id");
            if (requestActionType == RequestActionType.getChatItemList) {
                PageQuery pageQuery = this.parsePageQuery(requestData);
                PageResult chatMessagePage = ChatService.getChatMessagePage((String)chatSessionId, (PageQuery)pageQuery);
                resultMap = ResultVoHelper.buildCustomCtrlResult((ResultActionType)ResultActionType.getChatItemList, (Object)chatMessagePage);
            }
            if (!resultMap.isEmpty()) {
                customControl.setData(resultMap);
            }
        }
    }

    private PageQuery parsePageQuery(JSONObject requestData) {
        PageQuery pageQuery = new PageQuery();
        long lastId = Long.parseLong(requestData.getOrDefault((Object)"lastId", (Object)"0") + "");
        int pageSize = (Integer)requestData.getOrDefault((Object)"pageSize", (Object)20);
        String searchKey = requestData.getString("searchKey");
        pageQuery.setPageSize(Integer.valueOf(pageSize));
        pageQuery.setSearchKey(searchKey);
        pageQuery.setLasId(lastId);
        return pageQuery;
    }
}

