/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.operation;

import java.util.Set;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.plugin.flow.listener.FlowOperationListenerManager;
import kd.ai.gai.plugin.flow.listener.FlowOperationManager;
import kd.ai.gai.plugin.flow.listener.IFlowSaveListener;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiProcessSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(GaiProcessSaveOpPlugin.class);
    private static final String KEY_PROCESS_FLOWSTR = "flow";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String SEPERATOR = "#";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_PROCESS_FLOWSTR);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperateOption operateOption = this.getOption();
        if (!operateOption.containsVariable("flowdesignersave")) {
            return;
        }
        DynamicObject dObjProcess = e.getDataEntities()[0];
        Flow flow = null;
        String flowStr = dObjProcess.get(KEY_PROCESS_FLOWSTR).toString();
        if (StringUtils.isNotBlank((CharSequence)flowStr)) {
            flow = JsonUtil.fromBase64String((String)flowStr);
        }
        if (flow == null) {
            return;
        }
        Object id = dObjProcess.getPkValue();
        if (id == null || (Long)id == 0L) {
            id = DB.genGlobalLongId();
            dObjProcess.set("id", id);
        }
        flow.setId(((Long)id).longValue());
        FlowOperationManager flowOperationManager = new FlowOperationManager(dObjProcess, flow, this.getOption());
        Set<IFlowSaveListener> listeners = FlowOperationListenerManager.getFlowOperationListener(IFlowSaveListener.class);
        listeners.forEach(listener -> listener.beginFlowSaveTransaction(flowOperationManager, this.getOption()));
        dObjProcess.set(KEY_PROCESS_FLOWSTR, (Object)JsonUtil.toBase64String((Flow)flow));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (e.getDataEntities().length == 0) {
            return;
        }
        DynamicObject dObjProcess = e.getDataEntities()[0];
        Flow flow = null;
        String flowStr = dObjProcess.get(KEY_PROCESS_FLOWSTR).toString();
        if (StringUtils.isNotBlank((CharSequence)flowStr)) {
            flow = JsonUtil.fromBase64String((String)flowStr);
        }
        if (flow == null) {
            return;
        }
        FlowOperationManager flowOperationManager = new FlowOperationManager(dObjProcess, flow, this.getOption());
        Set<IFlowSaveListener> listeners = FlowOperationListenerManager.getFlowOperationListener(IFlowSaveListener.class);
        listeners.forEach(listener -> listener.endFlowSaveTransaction(flowOperationManager, this.getOption()));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (e.getDataEntities().length == 0) {
            return;
        }
        DynamicObject dObjProcess = e.getDataEntities()[0];
        Flow flow = null;
        String flowStr = dObjProcess.get(KEY_PROCESS_FLOWSTR).toString();
        if (StringUtils.isNotBlank((CharSequence)flowStr)) {
            flow = JsonUtil.fromBase64String((String)flowStr);
        }
        if (flow == null) {
            return;
        }
        FlowOperationManager flowOperationManager = new FlowOperationManager(dObjProcess, flow, this.getOption());
        Set<IFlowSaveListener> listeners = FlowOperationListenerManager.getFlowOperationListener(IFlowSaveListener.class);
        listeners.forEach(listener -> listener.afterFlowSave(flowOperationManager, this.getOption()));
    }
}

