/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.operation;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.entity.StructRepo;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.param.knoData.SaveKnoDataParam;
import kd.ai.gai.core.trace.util.CommonUtil;
import kd.ai.gai.plugin.repo.StructRepoUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiStructRepoTableDataEmbedOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(GaiStructRepoTableDataEmbedOpPlugin.class);
    private static final String BATCH_OPERATION_ADD = "add";
    private static final String BATCH_OPERATION_MODIFY = "modify";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("structrepo_id");
        List<String> keys = StructRepoUtil.getDataFieldKeys();
        for (String key : keys) {
            e.getFieldKeys().add(key);
            e.getFieldKeys().add(key + "_tag");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        try {
            DynamicObject[] dataObjs = e.getDataEntities();
            if (dataObjs.length == 0) {
                return;
            }
            DynamicObject[] data = e.getDataEntities();
            DynamicObject item = data[0];
            Long repoId = item.getLong("structrepo_id");
            logger.info("\u5b8c\u6210\u6279\u91cf{}\u4fdd\u5b58\u8868\u683c\u77e5\u8bc6\u6570\u636e\uff0c\u5f00\u59cb\u81ea\u52a8\u5411\u91cf\u5316\u6570\u636e\u3002\u77e5\u8bc6\u5e93ID:{}", (Object)repoId);
            ArrayList<DynamicObject> batchModifyData = new ArrayList<DynamicObject>(0);
            batchModifyData.addAll(Arrays.asList(data));
            logger.info("\u5171\u6279\u91cf\u4fee\u6539\u6570\u636e{}\u6761", (Object)batchModifyData.size());
            this.batchHandlerData(repoId, batchModifyData.toArray(new DynamicObject[0]), BATCH_OPERATION_MODIFY);
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("\u6784\u5efa\u7d22\u5f15\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            String errMessage = ex.getMessage();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                errMessage = ex.toString();
            }
            throw new KDBizException(String.format("\u6784\u5efa\u7d22\u5f15\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u5f02\u5e38\u3002\u5f02\u5e38\u4fe1\u606f=%s", errMessage));
        }
    }

    private void batchHandlerData(Long repoId, DynamicObject[] batchData, String operation) {
        String tips = "";
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)BATCH_OPERATION_ADD)) {
            tips = "\u65b0\u589e";
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)BATCH_OPERATION_MODIFY)) {
            tips = "\u4fee\u6539";
        }
        logger.info("\u5f00\u59cb\u6279\u91cf{}\u8868\u683c\u77e5\u8bc6\u6570\u636e...", (Object)tips);
        StructRepo repo = GaiStructRepoHelper.queryStructRepo((long)repoId);
        SaveKnoDataParam param = new SaveKnoDataParam();
        String repoNumber = repo.getRepoNumber();
        String number = repo.getNumber();
        param.setSchemaNumber(repoNumber);
        List structRepoFields = repo.getFields();
        List dataFields = structRepoFields.stream().map(new Function<StructRepoField, String>(){

            @Override
            public String apply(StructRepoField structRepoField) {
                return structRepoField.getFieldName();
            }
        }).collect(Collectors.toList());
        ArrayList<String> originFields = new ArrayList<String>(dataFields.size());
        for (String field : dataFields) {
            originFields.add(field);
        }
        dataFields.add("id");
        param.setFieldKeys(dataFields);
        Collections.sort(dataFields);
        int dataCount = batchData.length;
        int dataFieldLength = dataFields.size();
        Object[][] repoData = new Object[dataCount][dataFieldLength];
        ArrayList<Long> dataIdList = new ArrayList<Long>(0);
        for (int i = 0; i < dataCount; ++i) {
            DynamicObject rowData = batchData[i];
            long dataId = rowData.getLong("id");
            dataIdList.add(dataId);
            Object[] datas = new Object[dataFieldLength];
            for (int k = 0; k < originFields.size(); ++k) {
                Object fieldValue;
                String fieldKey = (String)originFields.get(k);
                datas[k] = fieldValue = rowData.get(String.format("%s_tag", fieldKey));
            }
            datas[dataFieldLength - 1] = dataId;
            repoData[i] = datas;
        }
        param.setData(repoData);
        logger.info("\u6279\u91cf{}\u8868\u683c\u77e5\u8bc6\u6570\u636e\u524d\u6279\u91cf\u66f4\u65b0\u6570\u636eIDS:{},\u72b6\u6001\u4e3a\uff1a{}", new Object[]{tips, dataIdList, RepoConstant.RepoDataStatus.PROCESSING.getName()});
        GaiStructRepoHelper.batchUpdateTableDataStatusWithMessage(dataIdList, (String)RepoConstant.RepoDataStatus.PROCESSING.getStatus());
        logger.info("\u5b8c\u6210\u6279\u91cf{}\u8868\u683c\u77e5\u8bc6\u6570\u636e\u524d\u6279\u91cf\u66f4\u65b0\u6570\u636e\u72b6\u6001\u64cd\u4f5c", (Object)tips);
        logger.info("\u5f00\u59cb\u6279\u91cf{}\u8868\u683c\u77e5\u8bc6\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)tips, (Object)JSONObject.toJSONString((Object)param));
        try {
            logger.info(String.format("\u5f00\u59cb\u6279\u91cf%s\u8868\u683c\u77e5\u8bc6\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a%s", tips, JSONObject.toJSONString((Object)param)));
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)BATCH_OPERATION_ADD)) {
                KnowledgeRepoServiceHelper.getDataService().batchAddKnowledge(param);
            } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)BATCH_OPERATION_MODIFY)) {
                KnowledgeRepoServiceHelper.getDataService().batchModKnowledge(param);
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf{}\u8868\u683c\u77e5\u8bc6\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)tips, (Object)CommonUtil.getStackTrace((Exception)e));
            logger.info(String.format("\u6279\u91cf%s\u8868\u683c\u77e5\u8bc6\u6570\u636e\u5931\u8d25\uff0c\u66f4\u65b0\u72b6\u6001\u4e3a\uff1a%s", tips, RepoConstant.RepoDataStatus.FAILED.getStatus()));
            String errorMsg = String.format("\u6279\u91cf%s\u8868\u683c\u77e5\u8bc6\u6570\u636e\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a%s", tips, e.getMessage());
            GaiStructRepoHelper.batchUpdateTableDataStatus(dataIdList, (String)RepoConstant.RepoDataStatus.FAILED.getStatus(), (String)errorMsg);
            throw new KDBizException(errorMsg);
        }
        logger.info("\u5b8c\u6210\u6279\u91cf{}\u8868\u683c\u77e5\u8bc6\u6570\u636e...", (Object)tips);
    }
}

