/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.operation;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.core.search.impl.KnowledgeDataService;
import kd.ai.gai.core.search.param.knoData.SaveKnoDataParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiStructRepoTreeDataEmbedOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(GaiStructRepoTreeDataEmbedOpPlugin.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        try {
            DynamicObject[] dataObjs = e.getDataEntities();
            if (dataObjs.length == 0) {
                return;
            }
            SaveKnoDataParam param = new SaveKnoDataParam();
            DynamicObject dObjStructRepo = dataObjs[0].getDynamicObject("structrepo");
            param.setSchemaNumber(dObjStructRepo.getString("reponumber"));
            List fieldDefinitionList = GaiStructRepoHelper.queryStructRepoFields((long)dObjStructRepo.getLong("id"));
            ArrayList<String> fieldNameList = new ArrayList<String>(fieldDefinitionList.size());
            fieldNameList.add("id");
            fieldDefinitionList.forEach(field -> fieldNameList.add(field.getFieldName()));
            Object[][] allFieldDatas = new Object[dataObjs.length][fieldNameList.size()];
            for (int i = 0; i < dataObjs.length; ++i) {
                Object[] oneFieldDatas = new Object[fieldNameList.size()];
                oneFieldDatas[0] = dataObjs[i].getLong("id");
                for (int j = 1; j < fieldNameList.size(); ++j) {
                    oneFieldDatas[j] = dataObjs[i].getString((String)fieldNameList.get(j) + "_tag");
                }
                allFieldDatas[i] = oneFieldDatas;
            }
            param.setFieldKeys(fieldNameList);
            param.setData(allFieldDatas);
            KnowledgeDataService dataService = new KnowledgeDataService();
            if (dataObjs[0].getString("datastatus").equals(RepoConstant.RepoDataStatus.NONE.getStatus())) {
                dataService.batchAddKnowledge(param);
            } else {
                dataService.batchModKnowledge(param);
            }
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("\u5411\u91cf\u5316\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            String errMessage = ex.getMessage();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                errMessage = ex.toString();
            }
            throw new KDBizException(String.format("\u5411\u91cf\u5316\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u5f02\u5e38\u3002\u5f02\u5e38\u4fe1\u606f=%s", errMessage));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataObjs = e.getDataEntities();
        if (dataObjs.length == 0) {
            return;
        }
        for (DynamicObject data : dataObjs) {
            data.set("datastatus", (Object)RepoConstant.RepoDataStatus.PROCESSING.getStatus());
        }
        SaveServiceHelper.save((DynamicObject[])dataObjs);
    }
}

