/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;

public class GaiProcessImportPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener,
BeforeAttachmentUploadListener {
    private static final String btnok = "btnok";
    private static final String btncancel = "btncancel";
    private static final String file_upload = "file_upload";
    private static final int file_max_size = 0x3200000;
    private static final String KEY_IMPORT_TYPE = "importtype";
    private static final String KEY_FILES = "files";
    private static final String KEY_COVER = "cover";
    private static final String KEY_LABELAP = "labelap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btnok});
        this.addClickListeners(new String[]{btncancel});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(file_upload);
        attachmentPanel.addUploadListener((UploadListener)this);
        attachmentPanel.addBeforeUploadListener((BeforeAttachmentUploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_LABELAP});
    }

    public void beforeAttachmentUpload(BeforeAttachmentUploadEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(KEY_IMPORT_TYPE)) {
            ChangeData data = e.getChangeSet()[0];
            this.getView().setVisible(Boolean.valueOf(StringUtils.equalsIgnoreCase((CharSequence)KEY_COVER, (CharSequence)data.getNewValue().toString())), new String[]{KEY_LABELAP});
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (Objects.nonNull(urls) && urls.length > 0) {
            for (Object url : urls) {
                if (!(url instanceof LinkedHashMap)) continue;
                Map attUrl = (Map)url;
                boolean no_status = !this.checkFileSize(attUrl);
                evt.setCancel(no_status);
                evt.setCancelMsg("\u4e0a\u4f20\u7684\u9644\u4ef6\u6587\u4ef6\u5927\u4e8e50M,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
        }
    }

    private boolean checkFileSize(Map<String, Object> attUrl) {
        Integer size = (Integer)attUrl.get("size");
        return size <= 0x3200000;
    }

    public void click(EventObject evt) {
        AttachmentPanel panel = (AttachmentPanel)this.getControl(file_upload);
        List files = panel.getAttachmentData();
        Button button = (Button)evt.getSource();
        String buttonOp = button.getKey();
        if (btnok.equals(buttonOp)) {
            if (CollectionUtils.isEmpty((Collection)files)) {
                this.getView().showTipNotification("\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6");
                return;
            }
            for (Map file : files) {
                boolean no_status = !this.checkFileSize(file);
                if (!no_status) continue;
                this.getView().showTipNotification("\u4e0a\u4f20\u7684\u9644\u4ef6\u6587\u4ef6\u5927\u4e8e50M,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(KEY_FILES, files);
            map.put(KEY_IMPORT_TYPE, this.getModel().getValue(KEY_IMPORT_TYPE));
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else if (btncancel.equals(buttonOp)) {
            for (Map file : files) {
                String url = (String)file.get("url");
                CacheFactory.getCommonCacheFactory().getTempFileCache().remove(url);
            }
            this.getView().close();
        }
    }
}

