/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.cache.SessionCache;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.vo.DebugInfo;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.flow.flow.core.Flow;
import kd.ai.gai.plugin.nl2api.BaseFormPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaiProcessEngineToolPlugin
extends BaseFormPlugin
implements RowClickEventListener,
TabSelectListener,
TreeNodeClickListener {
    private static final Logger log = LoggerFactory.getLogger(GaiProcessEngineToolPlugin.class);
    private static final String KEY_ADVCONTOOLBARAP = "toolbarap";
    private static final String KEY_TBMAIN = "tbmain";
    private static final String KEY_CODEEDITAP = "codeeditap";
    private static final String KEY_PROCESS = "process";
    private static final String KEY_FLOW = "flow";
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_TABAP_METADATA = "tabapmetadata";
    private static final String KEY_TAB_METADATA = "tab_metadata";
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_SEND_MSG = "sendmsg";
    private static final String KEY_NEXT_BREAK_POINT = "nextbreakpoint";
    private static final String KEY_RESUME_EXEC = "resumeexec";
    private static final String KEY_REFRESH_VAR = "refreshvar";
    private static final String KEY_VECTOR_NEXT_BREAK_POINT = "vectornextbreakpoint";
    private static final String KEY_VECTOR_RESUME_EXEC = "vectorresumeexec";
    private static final String KEY_VECTOR_REFRESH_VAR = "vectorrefreshvar";
    private static final String KEY_VECTOR_REFRESH = "vectorrefresh";
    private static final String KEY_USER_INPUT = "userinput";
    private static final String KEY_LABEL_DEBUG_NODE = "labeldebugnode";
    private static final String KEY_LABEL_EXEC_NODE = "labelexecnode";
    private static final String KEY_VAR_ENTRYENTITY = "varentryentity";
    private static final String KEY_NODE_NAME = "nodename";
    private static final String KEY_VAR_NAME = "varname";
    private static final String KEY_VAR_VALUE = "varvalue";
    private static final String KEY_COLOR_GREEN = "#1ba854";
    private static final String KEY_TAB_MD = "tab_md_";
    private static final String OP_DUMP_DIAGRAM = "dumpdiagram";
    private static final String OP_DUMP_MICRO_PROGRAMS = "dumpmicroprograms";
    private static final String OP_DUMP_JSON = "dumpjson";
    private static final String OP_DUMP_FFLOW = "dumpfflow";
    private static final String OP_DUMP_FFLOW_BASE64 = "dumpfflowbase64";
    private static final String KEY_SAVEFFLOW = "savefflow";
    private static final String KEY_OPTYPE = "optype";
    private static final String OP_SELECT_PROCESS = "selectprocess";
    private static final String KEY_AUTO_REFRESH = "auto_refresh";
    private static final String KEY_ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_ADVCONTOOLBARAP, KEY_TBMAIN});
        this.addClickListeners(new String[]{OP_SELECT_PROCESS});
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        Tab tabMetadata = (Tab)this.getControl(KEY_TABAP_METADATA);
        tabMetadata.addTabSelectListener((TabSelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object id = fsp.getCustomParam("id");
        if (id != null) {
            this.showDebug(id);
            kd.ai.gai.core.engine.flow.Flow gaiFlow = this.getGaiFlow();
            if (gaiFlow != null) {
                int count;
                this.setLabelText(KEY_LABEL_DEBUG_NODE, gaiFlow.getName());
                Start start = gaiFlow.getStart();
                List inputVars = start.getInputVars();
                if (CollectionUtils.isNotEmpty((Collection)inputVars) && (count = (inputVars = inputVars.stream().filter(var -> !StringUtils.startsWithIgnoreCase((CharSequence)var.getName(), (CharSequence)"system.")).collect(Collectors.toList())).size()) > 0) {
                    this.getModel().batchCreateNewEntryRow(KEY_ENTRY_ENTITY, count);
                    for (int i = 0; i < count; ++i) {
                        Var var2 = (Var)inputVars.get(i);
                        this.getModel().setValue("paramname", (Object)var2.getName(), i);
                        this.getModel().setValue("paramdesc", (Object)var2.getDesc(), i);
                        this.getModel().setValue("paramvalue", (Object)(var2.isInput() ? var2.getValue() : null), i);
                    }
                }
            }
            this.setLabelText(KEY_LABEL_EXEC_NODE, " - ");
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_VECTOR_NEXT_BREAK_POINT, KEY_VECTOR_RESUME_EXEC, KEY_VECTOR_REFRESH_VAR, KEY_VECTOR_REFRESH});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVEFFLOW, KEY_OPTYPE});
    }

    private void showDebug(Object id) {
        this.getModel().setValue(KEY_PROCESS, id);
        String debugResultCacheKey = String.format("%s_%s_%s", "debugProcessResult", RequestContext.get().getCurrUserId(), id);
        SessionCache.get().remove(debugResultCacheKey);
        this.loadMetadata(OP_DUMP_DIAGRAM);
    }

    private kd.ai.gai.core.engine.flow.Flow getGaiFlow() {
        DynamicObject processDo = (DynamicObject)this.getModel().getValue(KEY_PROCESS);
        if (processDo == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u6d41");
            return null;
        }
        processDo = BusinessDataServiceHelper.loadSingle((Object)processDo.getPkValue(), (String)GaiFormIdEnum.GAI_PROCESS.getId());
        String fflow = processDo.getString(KEY_FLOW);
        kd.ai.gai.core.engine.flow.Flow gaiFlow = JsonUtil.fromBase64String((String)fflow);
        String processName = processDo.getString("name");
        gaiFlow.setName(processName);
        return gaiFlow;
    }

    private void loadMetadata(String itemKey) {
        kd.ai.gai.core.engine.flow.Flow gaiFlow = this.getGaiFlow();
        Flow flow = FlowUtils.buildFlow((Context)Context.create4API(), (kd.ai.gai.core.engine.flow.Flow)gaiFlow);
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SAVEFFLOW, KEY_OPTYPE});
        if (OP_DUMP_DIAGRAM.equals(itemKey)) {
            codeEdit.setText(flow.dumpDiagram());
            this.loadProcessNodesTree(gaiFlow);
        } else if (OP_DUMP_MICRO_PROGRAMS.equals(itemKey)) {
            codeEdit.setText(flow.dumpMicroPrograms());
        } else if (OP_DUMP_JSON.equals(itemKey)) {
            codeEdit.setText(JSONObject.toJSONString((Object)flow, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        } else if (OP_DUMP_FFLOW.equals(itemKey)) {
            codeEdit.setText(GaiProcessEngineToolPlugin.getPrettyJson(gaiFlow));
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SAVEFFLOW, KEY_OPTYPE});
        } else if (OP_DUMP_FFLOW_BASE64.equals(itemKey)) {
            DynamicObject processDo = (DynamicObject)this.getModel().getValue(KEY_PROCESS);
            processDo = BusinessDataServiceHelper.loadSingle((Object)processDo.getPkValue(), (String)GaiFormIdEnum.GAI_PROCESS.getId());
            String fflow = processDo.getString(KEY_FLOW);
            codeEdit.setText(fflow);
        }
    }

    private void loadProcessNodesTree(kd.ai.gai.core.engine.flow.Flow gaiFlow) {
        Map<String, Object> properties = this.getDebugProperties();
        DebugInfo debugInfo = (DebugInfo)JSONObject.parseObject((String)properties.getOrDefault(FlowUtils.getPropertyName((int)0, (String)"debug_info"), null), DebugInfo.class);
        int execNodeId = -1;
        if (debugInfo != null) {
            execNodeId = debugInfo.getExecNodeId();
        }
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.deleteAllNodes();
        String rootNodeId = "-1";
        TreeNode rootNode = new TreeNode(null, rootNodeId, gaiFlow.getName(), (Object)Boolean.TRUE);
        rootNode.setIsOpened(true);
        if (execNodeId == -1) {
            rootNode.setColor(KEY_COLOR_GREEN);
        }
        Start start = gaiFlow.getStart();
        TreeNode startNode = new TreeNode(rootNodeId, String.valueOf(start.getId()), start.getName(), false);
        startNode.setIcon("kdfont kdfont-paixuxiangxia");
        rootNode.addChild(startNode);
        if (execNodeId == start.getId()) {
            startNode.setColor(KEY_COLOR_GREEN);
        }
        List actionList = gaiFlow.getActions();
        List normalActionList = actionList.stream().filter(action -> !action.isBlockInnerNode()).collect(Collectors.toList());
        List blockInnerActionList = actionList.stream().filter(Node::isBlockInnerNode).collect(Collectors.toList());
        Map blockInnerNodeIdActionListMap = blockInnerActionList.stream().collect(Collectors.groupingBy(Node::getBlockNodeId, Collectors.mapping(Action2 -> Action2, Collectors.toList())));
        if (CollectionUtils.isNotEmpty(normalActionList)) {
            for (Action action2 : normalActionList) {
                String actionNodeId = String.valueOf(action2.getId());
                TreeNode actionNode = new TreeNode(rootNodeId, actionNodeId, action2.getName(), action2.isBlockInnerNode());
                actionNode.setIcon(this.getIconByType(action2.getType()));
                if (execNodeId == action2.getId()) {
                    actionNode.setColor(KEY_COLOR_GREEN);
                }
                actionNode.setIsOpened(true);
                rootNode.addChild(actionNode);
                if (!blockInnerNodeIdActionListMap.containsKey(action2.getId())) continue;
                List innerNodeActionList = blockInnerNodeIdActionListMap.get(action2.getId());
                for (Action innerNodeAction : innerNodeActionList) {
                    String innerNodeActionId = String.valueOf(innerNodeAction.getId());
                    TreeNode innnerNode = new TreeNode(actionNodeId, innerNodeActionId, innerNodeAction.getName(), false);
                    innnerNode.setIcon(this.getIconByType(innerNodeAction.getType()));
                    if (execNodeId == innerNodeAction.getId()) {
                        innnerNode.setColor(KEY_COLOR_GREEN);
                    }
                    innnerNode.setIsOpened(true);
                    actionNode.addChild(innnerNode);
                }
            }
        }
        End end = gaiFlow.getEnd();
        TreeNode endNode = new TreeNode(rootNodeId, String.valueOf(end.getId()), end.getName(), false);
        endNode.setIcon("kdfont kdfont-paixuxiangshang");
        rootNode.addChild(endNode);
        if (execNodeId == end.getId()) {
            endNode.setColor(KEY_COLOR_GREEN);
        } else {
            this.getView().addClientCallBack(KEY_AUTO_REFRESH, Integer.valueOf(1000));
        }
        tv.addNode(rootNode);
        this.showDebugProperties(null);
    }

    private String getIconByType(String type) {
        String icon;
        ProcessNodeType processNodeType = ProcessNodeType.valueOf((int)Integer.parseInt(type));
        switch (processNodeType) {
            case Llm: {
                icon = "kdfont kdfont-gptcaozuoxianxing";
                break;
            }
            case CusOption: {
                icon = "kdfont kdfont-zidingyicaozuoxianxing";
                break;
            }
            case Message: {
                icon = "kdfont kdfont-xiaoxixianxing";
                break;
            }
            case AskUser: {
                icon = "kdfont kdfont-tishixinxi";
                break;
            }
            case Repo: {
                icon = "kdfont kdfont-zhishikuxianxing";
                break;
            }
            case RepoReply: {
                icon = "kdfont kdfont-fenxianghuilai";
                break;
            }
            case Loop: {
                icon = "kdfont kdfont-congSVNgengxinyuanshuju";
                break;
            }
            case StartLoop: {
                icon = "kdfont kdfont-kaishizhihang";
                break;
            }
            case SetVariable: {
                icon = "kdfont kdfont-hetongbiangeng";
                break;
            }
            case BreakLoop: {
                icon = "kdfont kdfont-shenpizhongzhi";
                break;
            }
            case Code: {
                icon = "kdfont kdfont-daima";
                break;
            }
            default: {
                icon = "kdfont kdfont-ditiexianrenwujiedian";
            }
        }
        return icon;
    }

    private static String getPrettyJson(Object obj) {
        String jsonStr = JsonUtil.toJson((Object)obj);
        return JSONObject.toJSONString((Object)JSON.parse((String)jsonStr), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (OP_SELECT_PROCESS.equals(control.getKey())) {
            this.showProcessF7();
        }
    }

    private void resumeExec(String nextDebugNodeId) {
        String chatSessionId;
        kd.ai.gai.core.engine.flow.Flow gaiFlow;
        Map<String, Object> properties = this.getDebugProperties();
        DebugInfo debugInfo = (DebugInfo)JSONObject.parseObject((String)properties.getOrDefault(FlowUtils.getPropertyName((int)0, (String)"debug_info"), null), DebugInfo.class);
        if (debugInfo == null) {
            this.sendMsg(nextDebugNodeId);
        } else if (debugInfo.isSuspend() && (gaiFlow = FlowCacheData.getFlowById((String)(chatSessionId = (String)properties.get(FlowUtils.getPropertyName((int)0, (String)"system.chat_sessionid"))), (long)debugInfo.getFlowId())) != null) {
            debugInfo.setDebugNodeId(nextDebugNodeId);
            properties.put(FlowUtils.getPropertyName((int)0, (String)"debug_info"), JSONObject.toJSONString((Object)debugInfo));
            FlowUtils.resumeFromDebug((String)chatSessionId, (long)gaiFlow.getId(), properties);
        }
        this.getView().addClientCallBack(KEY_AUTO_REFRESH, Integer.valueOf(1000));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        TreeView treeView;
        String focusNodeId;
        if (KEY_AUTO_REFRESH.equals(e.getName()) && (focusNodeId = (treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW)).getTreeState().getFocusNodeId()) == null) {
            this.refreshExecStatus(focusNodeId);
        }
    }

    private void refreshExecStatus(String focusNodeId) {
        this.showDebugProperties(focusNodeId);
        kd.ai.gai.core.engine.flow.Flow gaiFlow = this.getGaiFlow();
        this.loadProcessNodesTree(gaiFlow);
    }

    private Map<String, Object> getDebugProperties() {
        JSONObject properties = new HashMap();
        this.getModel().deleteEntryData(KEY_VAR_ENTRYENTITY);
        DynamicObject processDo = (DynamicObject)this.getModel().getValue(KEY_PROCESS);
        String debugResultCacheKey = String.format("%s_%s_%s", "debugProcessResult", RequestContext.get().getCurrUserId(), processDo.getPkValue());
        String debugResult = SessionCache.get().get(debugResultCacheKey);
        if (StringUtils.isNotEmpty((CharSequence)debugResult)) {
            properties = JSONObject.parseObject((String)debugResult);
            DebugInfo debugInfo = (DebugInfo)JSONObject.parseObject((String)properties.getOrDefault(GaiProcessEngineToolPlugin.getDebugInfoPropertyName(), null), DebugInfo.class);
            kd.ai.gai.core.engine.flow.Flow gaiFlow = this.getGaiFlow();
            if (gaiFlow != null) {
                this.setLabelText(KEY_LABEL_EXEC_NODE, gaiFlow.findNodeById(debugInfo.getExecNodeId()).getName());
            }
        }
        return properties;
    }

    private static String getDebugInfoPropertyName() {
        return FlowUtils.getPropertyName((int)0, (String)"debug_info");
    }

    private void showDebugProperties(String nodeId) {
        Map<String, Object> properties;
        DynamicObject processDo = (DynamicObject)this.getModel().getValue(KEY_PROCESS);
        if (StringUtils.equalsIgnoreCase((CharSequence)nodeId, (CharSequence)"-1")) {
            nodeId = null;
        }
        processDo = BusinessDataServiceHelper.loadSingle((Object)processDo.getPkValue(), (String)GaiFormIdEnum.GAI_PROCESS.getId());
        String fflow = processDo.getString(KEY_FLOW);
        kd.ai.gai.core.engine.flow.Flow gaiFlow = JsonUtil.fromBase64String((String)fflow);
        if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
            this.setLabelText(KEY_LABEL_DEBUG_NODE, gaiFlow.findNodeById(Integer.parseInt(nodeId)).getName());
        }
        if ((properties = this.getDebugProperties()) != null && !properties.isEmpty()) {
            Set keySet = properties.keySet();
            keySet = keySet.stream().filter(s -> s.startsWith("VAR_VALUE_")).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
                String finalNodeId = nodeId;
                keySet = keySet.stream().filter(s -> s.startsWith(String.format("%s%s.", "VAR_VALUE_", finalNodeId))).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
                this.setLabelText(KEY_LABEL_DEBUG_NODE, gaiFlow.findNodeById(Integer.parseInt(nodeId)).getName());
            }
            if (keySet.isEmpty()) {
                this.getModel().deleteEntryData(KEY_VAR_ENTRYENTITY);
            } else {
                this.getModel().batchCreateNewEntryRow(KEY_VAR_ENTRYENTITY, keySet.size());
                int index = 0;
                for (String key : keySet) {
                    Object value = properties.get(key);
                    String nodeIdStr = key.split("\\.")[0].replace("VAR_VALUE_", "");
                    Node node = gaiFlow.findNodeById(Integer.parseInt(nodeIdStr));
                    this.getModel().setValue(KEY_NODE_NAME, (Object)node.getName(), index);
                    this.getModel().setValue(KEY_VAR_NAME, (Object)key.split("\\.", 2)[1], index);
                    this.getModel().setValue(KEY_VAR_VALUE, (Object)value.toString(), index);
                    ++index;
                }
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        DynamicObject processDo = (DynamicObject)this.getModel().getValue(KEY_PROCESS);
        if (nodeId.equalsIgnoreCase("-1")) {
            nodeId = null;
        }
        this.showDebugProperties(nodeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (KEY_SEND_MSG.equalsIgnoreCase(operateKey)) {
            this.sendMsg(focusNodeId);
            this.getView().addClientCallBack(KEY_AUTO_REFRESH, Integer.valueOf(1000));
        } else if (KEY_NEXT_BREAK_POINT.equalsIgnoreCase(operateKey)) {
            if (StringUtils.isEmpty((CharSequence)focusNodeId)) {
                this.getView().showTipNotification("\u8bf7\u5148\u9009\u4e2d\u8981\u8c03\u8bd5\u7684\u6d41\u7a0b\u8282\u70b9");
                return;
            }
            this.resumeExec(focusNodeId);
        } else if (KEY_RESUME_EXEC.equalsIgnoreCase(operateKey)) {
            this.resumeExec(null);
        } else if (KEY_REFRESH_VAR.equalsIgnoreCase(operateKey)) {
            this.refreshExecStatus(focusNodeId);
            this.getView().showSuccessNotification("\u6267\u884c\u72b6\u6001\u5df2\u66f4\u65b0");
        } else if (KEY_SAVEFFLOW.equals(operateKey)) {
            DynamicObject processDo = (DynamicObject)this.getModel().getValue(KEY_PROCESS);
            CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
            String text = codeEdit.getText();
            String opType = (String)this.getModel().getValue(KEY_OPTYPE);
            if (StringUtils.equalsIgnoreCase((CharSequence)opType, (CharSequence)"loop2parallel")) {
                text = text.replaceAll("LoopAction", "ParallelAction").replaceAll("\"type\":\"10\"", "\"type\":\"15\"").replaceAll("\"type\":\"13\"", "\"type\":\"16\"").replaceAll("\u5faa\u73af", "\u5e76\u884c");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)opType, (CharSequence)"parallel2loop")) {
                text = text.replaceAll("ParallelAction", "LoopAction").replaceAll("\"type\":\"15\"", "\"type\":\"10\"").replaceAll("\"type\":\"16\"", "\"type\":\"13\"").replaceAll("\u5e76\u884c", "\u5faa\u73af");
            }
            processDo = BusinessDataServiceHelper.loadSingle((Object)processDo.getPkValue(), (String)GaiFormIdEnum.GAI_PROCESS.getId());
            kd.ai.gai.core.engine.flow.Flow flow = (kd.ai.gai.core.engine.flow.Flow)JsonUtil.fromJson((String)text, kd.ai.gai.core.engine.flow.Flow.class);
            processDo.set(KEY_FLOW, (Object)JsonUtil.toBase64String((kd.ai.gai.core.engine.flow.Flow)flow));
            Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{processDo});
            if (saveObjs != null && saveObjs.length > 0) {
                this.getView().showSuccessNotification("\u66f4\u65b0\u6210\u529f");
            }
        }
    }

    private void sendMsg(String focusNodeId) {
        this.getModel().deleteEntryData(KEY_VAR_ENTRYENTITY);
        Object userInput = this.getModel().getValue(KEY_USER_INPUT);
        if (userInput == null || StringUtils.isEmpty((CharSequence)userInput.toString())) {
            this.getView().showTipNotification("\u7528\u6237\u8f93\u5165\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        DynamicObject processDo = (DynamicObject)this.getModel().getValue(KEY_PROCESS);
        if (processDo == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u4efb\u52a1\u6d41");
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{KEY_VECTOR_NEXT_BREAK_POINT, KEY_VECTOR_RESUME_EXEC, KEY_VECTOR_REFRESH_VAR, KEY_VECTOR_REFRESH});
        kd.ai.gai.core.engine.flow.Flow gaiFlow = this.getGaiFlow();
        if (gaiFlow != null) {
            this.setLabelText(KEY_LABEL_DEBUG_NODE, StringUtils.isEmpty((CharSequence)focusNodeId) || StringUtils.equalsIgnoreCase((CharSequence)focusNodeId, (CharSequence)String.valueOf(processDo.getPkValue())) ? gaiFlow.getName() : gaiFlow.findNodeById(Integer.parseInt(focusNodeId)).getName());
        }
        processDo = BusinessDataServiceHelper.loadSingle((Object)processDo.getPkValue(), (String)GaiFormIdEnum.GAI_PROCESS.getId());
        String processId = String.valueOf(processDo.getPkValue());
        IFormView iFormView = this.getView().getMainView();
        if (iFormView == null) {
            iFormView = this.getView().getParentView();
        }
        String rootPageId = iFormView.getPageId();
        GaiInitConfig gaiInitConfig = new GaiInitConfig();
        gaiInitConfig.setSwitchSide(Boolean.valueOf(true));
        gaiInitConfig.setLockSide(Boolean.valueOf(true));
        gaiInitConfig.setSelectedProcessId(processId);
        gaiInitConfig.setStartProcessId(processId);
        HashMap<String, String> inParams = new HashMap<String, String>();
        inParams.put("debug_is_debug", "true");
        inParams.put("debug_info", JSONObject.toJSONString((Object)new DebugInfo(focusNodeId)));
        DynamicObjectCollection inputParamDoc = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        if (inputParamDoc != null) {
            for (DynamicObject inputParamDo : inputParamDoc) {
                inParams.put(inputParamDo.getString("paramname"), inputParamDo.getString("paramvalue"));
            }
        }
        gaiInitConfig.setStartParams(inParams);
        gaiInitConfig.setUserInput(userInput.toString());
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, JSON.toJSONString((Object)gaiInitConfig)});
    }

    private void showProcessF7() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setShowApproved(false);
        lsp.setBillFormId(GaiFormIdEnum.GAI_PROCESS.getId());
        lsp.setFormId("bos_listf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700");
        inlineStyleCss.setWidth("1200");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        lsp.setLookUp(true);
        lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), GaiFormIdEnum.GAI_PROCESS.getId()));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection && !(listSelectedRowCollection = (ListSelectedRowCollection)returnData).isEmpty()) {
            Object id = listSelectedRowCollection.get(0).getPrimaryKeyValue();
            this.showDebug(id);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)KEY_TAB_METADATA)) {
            this.loadMetadata(OP_DUMP_DIAGRAM);
        } else {
            this.loadMetadata(tabKey.replace(KEY_TAB_MD, ""));
        }
    }
}

