/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.script.Script;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiProcessCodeEditFullScreenPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(GaiProcessCodeEditFullScreenPlugin.class);
    private static final String btnok = "btnok";
    private static final String btncancel = "btncancel";
    private static final String testcodebtn = "testcodebtn";
    private static final String CODEEDITAP = "codeeditap";
    private static final String CODEEDITAP_INPUT = "codeeditap_input";
    private static final String CODEEDITAP_OUTPUT = "codeeditap_output";
    private static final String KEY_ENABLE_PARSE_JSON = "enableparsejson";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btnok, btncancel, testcodebtn});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String code = (String)fsp.getCustomParam("code");
        Map inputMap = (Map)fsp.getCustomParam("codeInput");
        boolean enableParseJson = fsp.getCustomParam(KEY_ENABLE_PARSE_JSON) != null ? (Boolean)fsp.getCustomParam(KEY_ENABLE_PARSE_JSON) : false;
        CodeEdit codeEdit = (CodeEdit)this.getControl(CODEEDITAP);
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            codeEdit.setText(code);
        }
        CodeEdit codeEditInput = (CodeEdit)this.getControl(CODEEDITAP_INPUT);
        codeEditInput.setText(inputMap != null ? JSON.toJSONString((Object)inputMap, (boolean)true) : "{}");
        this.getModel().setValue(KEY_ENABLE_PARSE_JSON, (Object)enableParseJson);
        this.getView().updateView(CODEEDITAP);
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        String buttonOp = button.getKey();
        CodeEdit codeEdit = (CodeEdit)this.getControl(CODEEDITAP);
        CodeEdit codeEditInput = (CodeEdit)this.getControl(CODEEDITAP_INPUT);
        CodeEdit codeEditOutput = (CodeEdit)this.getControl(CODEEDITAP_OUTPUT);
        if (btnok.equals(buttonOp)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("code", codeEdit.getText());
            map.put("codeInput", codeEditInput.getText());
            map.put("enableParseJson", this.getModel().getValue(KEY_ENABLE_PARSE_JSON));
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else if (btncancel.equals(buttonOp)) {
            this.getView().close();
        } else if (testcodebtn.equals(buttonOp)) {
            String code = codeEdit.getText();
            String codeInput = codeEditInput.getText();
            HashMap<String, String> $input = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)codeInput)) {
                if (StrUtils.isValidJSONObject((String)codeInput)) {
                    JSONObject inputJo = JSONObject.parseObject((String)codeInput);
                    for (String name : inputJo.keySet()) {
                        String value = inputJo.getString(name);
                        $input.put(name, value);
                        code = FlowUtils.fillCode((String)code, (String)name, (String)value);
                    }
                } else {
                    this.getView().showErrorNotification(String.format("\u8f93\u5165\uff1a%s\u3002\u4e0d\u662f\u6709\u6548JSONObject\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u6d4b\u8bd5", codeInput));
                }
            }
            HashMap<String, HashMap<String, String>> scriptCtx = new HashMap<String, HashMap<String, String>>(10);
            scriptCtx.putAll(Constant.ENGINE.scriptCtx);
            scriptCtx.put("$input", $input);
            Script p = null;
            try {
                p = Script.compile((String)code, scriptCtx);
            }
            catch (Exception e) {
                log.error("\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:{}" + e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(String.format("\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:%s", e.getMessage()));
                return;
            }
            Object result = null;
            try {
                result = p.eval(scriptCtx);
                log.info("code eval result: {}", result);
            }
            catch (Exception e) {
                log.error("\u4ee3\u7801\u6267\u884c\u5f02\u5e38:{}" + e.getMessage(), (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            String resultStr = StrUtils.getEvalResult((Object)result);
            if (((Boolean)this.getModel().getValue(KEY_ENABLE_PARSE_JSON)).booleanValue()) {
                JSONObject resultJo;
                if (StringUtils.isEmpty((CharSequence)resultStr)) {
                    this.getView().showErrorNotification(String.format("\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u80fd\u89e3\u6790\u4e3a\u6709\u6548JSONObject\u3002", resultStr));
                    return;
                }
                try {
                    resultJo = JSONObject.parseObject((String)resultStr);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u7ed3\u679c\u8f6cJSON\u5f02\u5e38:{}" + e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(String.format("\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u80fd\u89e3\u6790\u4e3a\u6709\u6548JSONObject\u3002", resultStr));
                    return;
                }
                codeEditOutput.setText(JSON.toJSONString((Object)resultJo, (boolean)true));
            } else if (StringUtils.isNotEmpty((CharSequence)resultStr)) {
                codeEditOutput.setText(resultStr);
            }
        }
    }
}

