/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.flow.script.GaiScript;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.flow.script.Script;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiProcessCodeSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessCodeSetPlugin.class);
    private static final String KEY_ADV_INPUT = "inputadv";
    private static final String KEY_ADV_OUTPUT = "outputadv";
    private static final String KEY_ADV_BASE = "baseadv";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_INPUT_VALUE = "input_value";
    private static final String KEY_OUTPUT_VALUE = "output_value";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_SOURCEPARAM = "output_sourceparam";
    private static final String KEY_CODEEDIT_AP = "codeeditap";
    private static final String KEY_HELPER_DOC = "helperdoc";
    private static final String KEY_TEST_CODE = "testcode";
    private static final String KEY_FULL_SCREEN = "fullscreen";
    private static final String KEY_ENABLE_PARSE_JSON = "enableparsejson";
    private static final String KEY_OUTPUT_NEW_ENTRY = "outputnewentry";
    private static final String KERY_OUTPUT_DELETE_ENTRY = "outputdeleteentry";
    private static final String HELP_DOC_CLICK_COUNT = "helpDocClickCount";
    private static final String KEY_ISC_ONLINE_HELPER_VIEW = "isc_online_helper_view";

    @Override
    protected void setComboItem() {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserChatHistory(true);
        List<ComboItem> paramItems = this.getComboItem(config);
        ComboEdit inputSourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        inputSourceParam.setComboItems(paramItems);
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        List outputItemList = GaiFieldTypeInitUtils.createVarTypeComboItem((VarFieldType[])VarFieldType.COMMON_VAR_FIELD_TYPE);
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(outputItemList);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INPUT_MUSTINPUT, KEY_OUTPUT_SOURCEPARAM});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FULL_SCREEN});
        this.initCodeEdit();
    }

    private void initCodeEdit() {
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        CodeAction codeAction = (CodeAction)flow.findActionById(nodeId);
        NodeConfigData nodeConfigData = this.getNodePropertyDesigner().getNodeDataManager().get(this.getNodeId());
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        if (nodeConfigData == null) {
            codeEdit.setText(GaiProcessCodeSetPlugin.assemblyCodeText(codeAction.getCode()));
        } else {
            codeEdit.setText(GaiProcessCodeSetPlugin.assemblyCodeText(nodeConfigData.getData()));
        }
    }

    private static String assemblyCodeText(String code) {
        return StringUtils.isEmpty((CharSequence)code) ? ResManager.loadKDString((String)"//\u901a\u8fc7$input.\u8f93\u5165\u53d8\u91cf\u540d/$input['\u8f93\u5165\u53d8\u91cf\u540d']/{{\u8f93\u5165\u53d8\u91cf\u540d}}\u683c\u5f0f\u5f15\u7528\u8f93\u5165\u53c2\u6570\uff0c\u5982:$input.param/$input['param']/{{param}}", (String)"GaiProcessCodeSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"//\u901a\u8fc7return\u8bed\u6cd5\u8fd4\u56de\u5b57\u7b26\u4e32\u6216JSONObject\uff0c\u5982:return \"Hello World\" \u6216 return {\"output\":\"Hello World\"}", (String)"GaiProcessCodeSetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"return \"Hello World\";", (String)"GaiProcessCodeSetPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]) : StringUtils.stripToEmpty((String)code);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)KEY_HELPER_DOC)) {
            String countStr = this.getPageCache().get(HELP_DOC_CLICK_COUNT);
            if (StringUtils.isNotEmpty((CharSequence)countStr)) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(KEY_ISC_ONLINE_HELPER_VIEW);
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
                this.getPageCache().remove(HELP_DOC_CLICK_COUNT);
            } else {
                this.getPageCache().put(HELP_DOC_CLICK_COUNT, "1");
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)KEY_TEST_CODE)) {
            CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
            String code = codeEdit.getText();
            HashMap<String, String> $input = new HashMap<String, String>();
            DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
            if (inputDoc != null) {
                for (DynamicObject row : inputDoc) {
                    String name = row.getString(KEY_INPUT_NAME);
                    String value = row.getString(KEY_INPUT_VALUE);
                    $input.put(name, value);
                    code = FlowUtils.fillCode((String)code, (String)name, (String)value);
                }
            }
            HashMap<String, HashMap<String, String>> scriptCtx = new HashMap<String, HashMap<String, String>>(10);
            scriptCtx.putAll(Constant.ENGINE.scriptCtx);
            scriptCtx.put("$input", $input);
            Script p = null;
            try {
                p = GaiScript.compile((String)code, scriptCtx);
            }
            catch (Exception e) {
                log.error("\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:{}" + e.getMessage(), (Throwable)e);
                String message = ResManager.loadKDString((String)"\u4ee3\u7801\u7f16\u8bd1\u9519\u8bef:%s", (String)"GaiProcessCodeSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(message, e.getMessage()));
                return;
            }
            Object result = null;
            try {
                result = p.eval(scriptCtx);
                log.info("code eval result: {}", result);
            }
            catch (Exception e) {
                String msg = Util.formatException((Exception)e);
                log.error("\u4ee3\u7801\u6267\u884c\u5f02\u5e38:{}" + msg, (Throwable)e);
                this.getView().showErrorNotification(msg);
                return;
            }
            String resultStr = StrUtils.getEvalResult((Object)result);
            if (((Boolean)this.getModel().getValue(KEY_ENABLE_PARSE_JSON)).booleanValue()) {
                JSONObject resultJo;
                if (StringUtils.isEmpty((CharSequence)resultStr)) {
                    String message = ResManager.loadKDString((String)"\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u80fd\u89e3\u6790\u4e3a\u6709\u6548JSONObject\u3002", (String)"GaiProcessCodeSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(message, resultStr));
                    return;
                }
                try {
                    resultJo = JSONObject.parseObject((String)resultStr);
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u7ed3\u679c\u8f6cJSON\u5f02\u5e38:{}" + e.getMessage(), (Throwable)e);
                    String message = ResManager.loadKDString((String)"\u4ee3\u7801\u6267\u884c\u7ed3\u679c\uff1a%s\u3002\u4e0d\u80fd\u89e3\u6790\u4e3a\u6709\u6548JSONObject\u3002", (String)"GaiProcessCodeSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(message, resultStr));
                    return;
                }
                DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
                if (outputDoc != null && !outputDoc.isEmpty()) {
                    int index = 0;
                    for (DynamicObject row : outputDoc) {
                        String name = row.getString(KEY_OUTPUT_NAME);
                        this.getModel().setValue(KEY_OUTPUT_VALUE, (Object)StrUtils.getEvalResult((Object)resultJo.get((Object)name)), index++);
                    }
                }
            } else {
                this.getModel().setValue(KEY_OUTPUT_VALUE, (Object)resultStr, 0);
            }
        }
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        CodeAction codeAction = (CodeAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam("nodeId")).intValue());
        if (codeAction != null) {
            this.loadMessage(codeAction);
            this.loadRefrenceParams((Action)codeAction, KEY_ENTRYENTITY_INPUT, KEY_INPUT_NAME, KEY_INPUT_SOURCEPARAM);
            this.getView().updateView();
        }
    }

    private void loadMessage(CodeAction codeAction) {
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        codeEdit.setText(GaiProcessCodeSetPlugin.assemblyCodeText(codeAction.getCode()));
        this.getModel().setValue(KEY_ENABLE_PARSE_JSON, (Object)codeAction.isEnableParseJson());
        List varList = codeAction.getVarList();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        inputDoc.clear();
        if (varList != null && !varList.isEmpty()) {
            for (Var var : varList) {
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_INPUT_NAME, (Object)var.getName());
                row.set(KEY_INPUT_TYPE, (Object)var.getType());
                row.set(KEY_INPUT_DESC, (Object)var.getDesc());
                row.set(KEY_INPUT_VALUE, (Object)var.getValue());
                inputDoc.add((Object)row);
                this.getView().updateView(KEY_ENTRYENTITY_INPUT);
            }
        }
        List outputVars = codeAction.getOutputVarList();
        EntryType outputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        outputDoc.clear();
        if (outputVars == null || outputVars.isEmpty() || !codeAction.isEnableParseJson()) {
            this.initOutputEnttry(outputDoc);
        } else {
            for (Var var : outputVars) {
                DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
                row.set(KEY_OUTPUT_NAME, (Object)var.getName());
                row.set(KEY_OUTPUT_TYPE, (Object)var.getType());
                row.set("output_desc", (Object)var.getDesc());
                outputDoc.add((Object)row);
                this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
            }
        }
    }

    private void initOutputEnttry(DynamicObjectCollection outputDoc) {
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
        DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
        row.set(KEY_OUTPUT_NAME, (Object)KEY_ENTRYENTITY_OUTPUT);
        row.set(KEY_OUTPUT_TYPE, (Object)VarFieldType.STRING.getType());
        row.set("output_desc", (Object)ResManager.loadKDString((String)"\u4ee3\u7801\u8f93\u51fa\u7ed3\u679c", (String)"GaiProcessCodeSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        outputDoc.add((Object)row);
        this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{KEY_OUTPUT_NAME, KEY_OUTPUT_TYPE, "output_desc"});
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OUTPUT_NEW_ENTRY, KERY_OUTPUT_DELETE_ENTRY});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        if (propertyName.equals(KEY_INPUT_NAME)) {
            this.validateNodeVarName(KEY_INPUT_NAME, KEY_ENTRYENTITY_INPUT, data);
        } else if (propertyName.equals(KEY_OUTPUT_NAME)) {
            this.validateNodeVarName(KEY_OUTPUT_NAME, KEY_ENTRYENTITY_OUTPUT, data);
        } else if (propertyName.equals(KEY_ENABLE_PARSE_JSON)) {
            boolean enableParseJson = (Boolean)data.getNewValue();
            this.getView().setEnable(Boolean.valueOf(enableParseJson), 0, new String[]{KEY_OUTPUT_NAME, KEY_OUTPUT_TYPE, "output_desc"});
            if (enableParseJson) {
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_OUTPUT_NEW_ENTRY, KERY_OUTPUT_DELETE_ENTRY});
            } else {
                DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
                this.initOutputEnttry(outputDoc);
            }
        }
    }

    private String check() {
        DynamicObjectCollection outputs;
        String name;
        DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        if (shows != null) {
            int i = 1;
            for (DynamicObject show : shows) {
                String sourceParam = show.getString(KEY_INPUT_SOURCEPARAM);
                name = show.getString(KEY_INPUT_NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u540d\u201d", (String)"GaiProcessAskUserSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (StringUtils.isBlank((CharSequence)sourceParam)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessMessageSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        if ((outputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT)) != null) {
            int i = 1;
            for (DynamicObject output : outputs) {
                name = output.getString(KEY_OUTPUT_NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u540d\u201d", (String)"GaiProcessAskUserSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        return "";
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        CodeAction codeAction = (CodeAction)this.getFlow().findActionById(nodeId);
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        if (!codeEdit.getText().equals(codeAction.getCode())) {
            this.getModel().setDataChanged(true);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickCode(flow, this.getNodeId());
    }

    private void clickCode(Flow flow, int nodeId) {
        Var var;
        CodeAction codeAction = (CodeAction)flow.findActionById(nodeId);
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        codeAction.setCode(codeEdit.getText());
        codeAction.setEnableParseJson(((Boolean)this.getModel().getValue(KEY_ENABLE_PARSE_JSON)).booleanValue());
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (inputDoc != null) {
            ArrayList<Var> varList = new ArrayList<Var>();
            for (DynamicObject row : inputDoc) {
                String name = row.getString(KEY_INPUT_NAME);
                String type = row.getString(KEY_INPUT_TYPE);
                String desc = row.getString(KEY_INPUT_DESC);
                String value = row.getString(KEY_INPUT_VALUE);
                var = new Var(name, type, desc, false, value);
                varList.add(var);
                VarMapper varM = new VarMapper();
                String sourceParam = row.getString(KEY_INPUT_SOURCEPARAM);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split("#");
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
            codeAction.setVarList(varList);
        }
        codeAction.setInParamMap(varMapper);
        ArrayList<Var> outputVars = null;
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        if (outputDoc != null && outputDoc.size() > 0) {
            outputVars = new ArrayList<Var>();
            for (DynamicObject row : outputDoc) {
                String name = row.getString(KEY_OUTPUT_NAME);
                String type = row.getString(KEY_OUTPUT_TYPE);
                String desc = row.getString("output_desc");
                var = new Var(name, type, desc);
                outputVars.add(var);
            }
        }
        codeAction.setOutputVarList(outputVars);
    }

    @Override
    public void cacheData(NodeConfigData nodeData) {
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDIT_AP);
        nodeData.setData(codeEdit.getText());
    }
}

