/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public class GaiProcessLoopPlugin
extends AbstractGaiProcessSetPlugin {
    private static final String NODE_ID = "nodeId";
    private static final String KEY_ENTRY_LOOP = "loop";
    private static final String KEY_ENTRY_VAR = "var";
    private static final String KEY_ENTRY_OUTPUT = "output";
    private static final String KEY_LOOP_NAME = "loop_name";
    private static final String KEY_LOOP_TYPE = "loop_type";
    private static final String KEY_LOOP_ISINPUT = "loop_isinput";
    private static final String KEY_LOOP_INPUT = "loop_input";
    private static final String KEY_LOOP_SOURCE = "loop_source";
    private static final String KEY_VAR_NAME = "var_name";
    private static final String KEY_VAR_TYPE = "var_type";
    private static final String KEY_VAR_ISINPUT = "var_isinput";
    private static final String KEY_VAR_INPUT = "var_input";
    private static final String KEY_VAR_SOURCE = "var_source";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_OUTPUT_SOURCE = "output_source";

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int loopRow = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_LOOP);
        if (KEY_LOOP_ISINPUT.equals(propertyName)) {
            Boolean isInput = (Boolean)this.getModel().getValue(KEY_LOOP_ISINPUT, loopRow);
            if (isInput.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, loopRow, new String[]{KEY_LOOP_SOURCE});
                this.getView().setEnable(Boolean.TRUE, loopRow, new String[]{KEY_LOOP_INPUT});
                this.getModel().setValue(KEY_LOOP_SOURCE, (Object)"");
                this.setComboItemType(GaiProcessLoopPlugin.createLoopTypeComboItemWithIsInput(), KEY_LOOP_TYPE);
            } else {
                this.getView().setEnable(Boolean.TRUE, loopRow, new String[]{KEY_LOOP_SOURCE});
                this.getView().setEnable(Boolean.FALSE, loopRow, new String[]{KEY_LOOP_INPUT});
                this.getModel().setValue(KEY_LOOP_INPUT, (Object)"");
                this.setComboItemType(GaiProcessLoopPlugin.createLoopTypeComboItemWithIsNotInput(), KEY_LOOP_TYPE);
            }
        }
        int varRow = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_VAR);
        if (KEY_VAR_ISINPUT.equals(propertyName)) {
            Boolean isInput = (Boolean)this.getModel().getValue(KEY_VAR_ISINPUT, varRow);
            if (isInput.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, varRow, new String[]{KEY_VAR_SOURCE});
                this.getView().setEnable(Boolean.TRUE, varRow, new String[]{KEY_VAR_INPUT});
                this.getModel().setValue(KEY_VAR_SOURCE, (Object)"");
                this.setComboItemType(GaiProcessLoopPlugin.createVarTypeComboItemWithIsInput(), KEY_VAR_TYPE);
            } else {
                this.getView().setEnable(Boolean.TRUE, varRow, new String[]{KEY_VAR_SOURCE});
                this.getView().setEnable(Boolean.FALSE, varRow, new String[]{KEY_VAR_INPUT});
                this.getModel().setValue(KEY_VAR_INPUT, (Object)"");
            }
        }
        this.getModel().setDataChanged(true);
    }

    private void setComboItemType(List<ComboItem> LoopTypeComboItemWithIsInput, String keyLoopType) {
        ComboEdit showLoopTypeEdit = (ComboEdit)this.getControl(keyLoopType);
        showLoopTypeEdit.setComboItems(LoopTypeComboItemWithIsInput);
    }

    @Override
    protected void setComboItem() {
        List<ComboItem> paramItems = this.getComboItem();
        ComboEdit loopSourceParam = (ComboEdit)this.getControl(KEY_LOOP_SOURCE);
        loopSourceParam.setComboItems(paramItems);
        ComboEdit varSourceParam = (ComboEdit)this.getControl(KEY_VAR_SOURCE);
        varSourceParam.setComboItems(paramItems);
        ComboEdit outputSourceParam = (ComboEdit)this.getControl(KEY_OUTPUT_SOURCE);
        List<ComboItem> outputParamItems = this.getOutputComboItem();
        outputSourceParam.setComboItems(outputParamItems);
        ComboEdit varTypeCombo = (ComboEdit)this.getControl(KEY_VAR_TYPE);
        List varTypeItems = GaiFieldTypeInitUtils.createVarTypeComboItem();
        varTypeCombo.setComboItems(varTypeItems);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)entryName, (CharSequence)KEY_ENTRY_LOOP)) {
            this.setComboItemType(GaiProcessLoopPlugin.createLoopTypeComboItemWithIsNotInput(), KEY_LOOP_TYPE);
        }
        this.setSourceEnable();
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickMessage(flow, this.getNodeId());
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        LoopAction loopAction = (LoopAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam(NODE_ID)).intValue());
        if (loopAction != null) {
            this.loadLoopAction(loopAction);
            this.loadRefrenceParams((Action)loopAction, KEY_ENTRY_LOOP, KEY_LOOP_NAME, KEY_LOOP_SOURCE);
            this.getView().updateView();
        }
        this.setSourceEnable();
    }

    private void clickMessage(Flow flow, int nodeId) {
        DynamicObjectCollection output;
        DynamicObjectCollection vars;
        String[] arr;
        String sourceParam;
        VarMapper varM;
        Var var;
        ArrayList<Var> varList;
        DynamicObjectCollection loops = this.getModel().getEntryEntity(KEY_ENTRY_LOOP);
        LoopAction loopAction = (LoopAction)flow.findActionById(nodeId);
        if (loops != null) {
            ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
            varList = new ArrayList<Var>();
            for (Object row : loops) {
                String name = row.getString(KEY_LOOP_NAME);
                boolean isInput = row.getBoolean(KEY_LOOP_ISINPUT);
                String showType = row.getString(KEY_LOOP_TYPE);
                String value = row.getString(KEY_LOOP_INPUT);
                var = new Var(name, showType, "");
                var.setValue(value);
                var.setInput(isInput);
                varList.add(var);
                varM = new VarMapper();
                sourceParam = row.getString(KEY_LOOP_SOURCE);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                arr = sourceParam.split("#");
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
            loopAction.setVarList(varList);
            loopAction.setInParamMap(varMapper);
        }
        if ((vars = this.getModel().getEntryEntity(KEY_ENTRY_VAR)) != null) {
            varList = new ArrayList();
            ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
            for (DynamicObject row : vars) {
                String name = row.getString(KEY_VAR_NAME);
                boolean isInput = row.getBoolean(KEY_VAR_ISINPUT);
                String showType = row.getString(KEY_VAR_TYPE);
                String value = row.getString(KEY_VAR_INPUT);
                Var var2 = new Var(name, showType, "");
                var2.setValue(value);
                var2.setInput(isInput);
                varList.add(var2);
                VarMapper varM2 = new VarMapper();
                String sourceParam2 = row.getString(KEY_VAR_SOURCE);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam2)) continue;
                String[] arr2 = sourceParam2.split("#");
                int selNodeId = Integer.parseInt(arr2[0]);
                String param = arr2[1];
                varM2.setInVarName(name);
                varM2.setOutNodeId(selNodeId);
                varM2.setOutVarName(param);
                varMapper.add(varM2);
            }
            loopAction.setLoopVarList(varList);
            loopAction.setLoopParamMap(varMapper);
        }
        if ((output = this.getModel().getEntryEntity(KEY_ENTRY_OUTPUT)) != null) {
            ArrayList<Var> varList2 = new ArrayList<Var>();
            ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
            for (DynamicObject row : output) {
                String name = row.getString(KEY_OUTPUT_NAME);
                String desc = row.getString(KEY_OUTPUT_DESC);
                var = new Var();
                var.setName(name);
                var.setDesc(desc);
                varList2.add(var);
                varM = new VarMapper();
                sourceParam = row.getString(KEY_OUTPUT_SOURCE);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                arr = sourceParam.split("#");
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
            loopAction.setOutputVars(varList2);
            loopAction.setOutParamMap(varMapper);
        }
    }

    private String check() {
        DynamicObjectCollection outs;
        DynamicObjectCollection vars;
        String sourceParam;
        DynamicObjectCollection loops = this.getModel().getEntryEntity(KEY_ENTRY_LOOP);
        if (loops != null) {
            int i = 1;
            for (Object show : loops) {
                boolean showInputs = show.getBoolean(KEY_LOOP_ISINPUT);
                String type = show.getString(KEY_LOOP_TYPE);
                sourceParam = show.getString(KEY_LOOP_SOURCE);
                String input = show.getString(KEY_LOOP_INPUT);
                String name = show.getString(KEY_LOOP_NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u540d\u201d", (String)"GaiProcessLoopPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (StringUtils.isBlank((CharSequence)type)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u7c7b\u578b\u201d", (String)"GaiProcessLoopPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (showInputs) {
                    if (StringUtils.isBlank((CharSequence)input)) {
                        return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u624b\u5de5\u7ef4\u62a4\u5185\u5bb9\u201d", (String)"GaiProcessLoopPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                    }
                } else if (StringUtils.isBlank((CharSequence)sourceParam)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessLoopPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        if ((vars = this.getModel().getEntryEntity(KEY_ENTRY_VAR)) != null) {
            int i = 1;
            for (DynamicObject show : vars) {
                boolean showInputs = show.getBoolean(KEY_VAR_ISINPUT);
                String type = show.getString(KEY_VAR_TYPE);
                String sourceParam2 = show.getString(KEY_VAR_SOURCE);
                String input = show.getString(KEY_VAR_INPUT);
                String name = show.getString(KEY_VAR_NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u540d\u201d", (String)"GaiProcessLoopPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (StringUtils.isBlank((CharSequence)type)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u7c7b\u578b\u201d", (String)"GaiProcessLoopPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (showInputs) {
                    if (StringUtils.isBlank((CharSequence)input)) {
                        return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u624b\u5de5\u7ef4\u62a4\u5185\u5bb9\u201d", (String)"GaiProcessLoopPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                    }
                } else if (StringUtils.isBlank((CharSequence)sourceParam2)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessLoopPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        if ((outs = this.getModel().getEntryEntity(KEY_ENTRY_OUTPUT)) != null) {
            int i = 1;
            for (DynamicObject show : outs) {
                sourceParam = show.getString(KEY_OUTPUT_SOURCE);
                String name = show.getString(KEY_OUTPUT_NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u540d\u201d", (String)"GaiProcessLoopPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (StringUtils.isBlank((CharSequence)sourceParam)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessLoopPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        return "";
    }

    private static List<ComboItem> createLoopTypeComboItemWithIsInput() {
        VarFieldType[] types = new VarFieldType[]{VarFieldType.ARRAY_STRING, VarFieldType.ARRAY_INTEGER};
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(2);
        for (VarFieldType type : types) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(type.getName()));
            comboItem.setValue(type.getType());
            list.add(comboItem);
        }
        return list;
    }

    private static List<ComboItem> createLoopTypeComboItemWithIsNotInput() {
        VarFieldType[] types = new VarFieldType[]{VarFieldType.ARRAY_STRING, VarFieldType.ARRAY_INTEGER, VarFieldType.ARRAY_OBJECT};
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(3);
        for (VarFieldType type : types) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(type.getName()));
            comboItem.setValue(type.getType());
            list.add(comboItem);
        }
        return list;
    }

    private static List<ComboItem> createVarTypeComboItemWithIsInput() {
        VarFieldType[] types = new VarFieldType[]{VarFieldType.STRING, VarFieldType.INTEGER, VarFieldType.ARRAY_STRING, VarFieldType.ARRAY_INTEGER};
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(4);
        for (VarFieldType type : types) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(type.getName()));
            comboItem.setValue(type.getType());
            list.add(comboItem);
        }
        return list;
    }

    private void loadLoopAction(LoopAction loopAction) {
        List outputVarList;
        List loopVarList;
        List varList;
        List list = varList = loopAction == null ? null : loopAction.getVarList();
        if (varList != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_LOOP);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRY_LOOP);
            shows.clear();
            List varMap = loopAction.getInParamMap();
            for (Object var : varList) {
                String name = var.getName();
                String type = var.getType();
                VarMapper varMapper = this.getVarMapper(name, varMap);
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_LOOP_NAME, (Object)name);
                row.set(KEY_LOOP_TYPE, (Object)type);
                row.set(KEY_LOOP_INPUT, (Object)var.getValue());
                row.set(KEY_LOOP_ISINPUT, (Object)var.isInput());
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_LOOP_SOURCE, (Object)param);
                }
                shows.add((Object)row);
            }
            this.getView().updateView(KEY_ENTRY_LOOP);
        }
        List list2 = loopVarList = loopAction == null ? null : loopAction.getLoopVarList();
        if (loopVarList != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_VAR);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRY_VAR);
            shows.clear();
            List varMap = loopAction.getLoopParamMap();
            for (Var var : loopVarList) {
                String name = var.getName();
                String type = var.getType();
                VarMapper varMapper = this.getVarMapper(name, varMap);
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_VAR_NAME, (Object)name);
                row.set(KEY_VAR_TYPE, (Object)type);
                row.set(KEY_VAR_INPUT, (Object)var.getValue());
                row.set(KEY_VAR_ISINPUT, (Object)var.isInput());
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_VAR_SOURCE, (Object)param);
                }
                shows.add((Object)row);
            }
            this.getView().updateView(KEY_ENTRY_VAR);
        }
        List list3 = outputVarList = loopAction == null ? null : loopAction.getOutputVars();
        if (outputVarList != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_OUTPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRY_OUTPUT);
            shows.clear();
            List varMap = loopAction.getOutParamMap();
            for (Var var : outputVarList) {
                String name = var.getName();
                String desc = var.getDesc();
                VarMapper varMapper = this.getVarMapper(name, varMap);
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_OUTPUT_NAME, (Object)name);
                row.set(KEY_OUTPUT_DESC, (Object)desc);
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_OUTPUT_SOURCE, (Object)param);
                }
                shows.add((Object)row);
            }
            this.getView().updateView(KEY_ENTRY_OUTPUT);
        }
    }

    private void setSourceEnable() {
        DynamicObjectCollection vars;
        DynamicObjectCollection loops = this.getModel().getEntryEntity(KEY_ENTRY_LOOP);
        if (loops != null) {
            int i = 0;
            for (DynamicObject show : loops) {
                boolean isInput = show.getBoolean(KEY_LOOP_ISINPUT);
                if (isInput) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_LOOP_INPUT});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_LOOP_SOURCE});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_LOOP_INPUT});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_LOOP_SOURCE});
                }
                ++i;
            }
        }
        if ((vars = this.getModel().getEntryEntity(KEY_ENTRY_VAR)) != null) {
            int i = 0;
            for (DynamicObject show : vars) {
                boolean isInput = show.getBoolean(KEY_VAR_ISINPUT);
                if (isInput) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_VAR_INPUT});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_VAR_SOURCE});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_VAR_INPUT});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_VAR_SOURCE});
                }
                ++i;
            }
        }
    }

    private List<ComboItem> getOutputComboItem() {
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam(NODE_ID);
        List actionList = flow.getActions();
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>();
        for (Action action : actionList) {
            List loopVarList;
            if (action.getBlockNodeId() == nodeId) {
                refrenceParamList.addAll(this.getNodePropertyDesigner().getRefrenceParamManager().getRefrenceParamList(action, new RefrenceDataConfig()));
            }
            if (action.getId() != nodeId || (loopVarList = ((LoopAction)action).getLoopVarList()) == null) continue;
            for (Var var : loopVarList) {
                String name = var.getName();
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                refrenceParamList.add(RefrenceParam.create((Node)action, name));
            }
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(5);
        for (RefrenceParam refrenceParam : refrenceParamList) {
            comboItemList.add(new ComboItem(new LocaleString(refrenceParam.getParamDisplayName()), refrenceParam.getParamValue()));
        }
        return comboItemList;
    }
}

