/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiProcessParallelSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessParallelSetPlugin.class);
    private static final String KEY_INPUT_ISINPUT = "input_isinput";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_SOURCE = "input_source";
    private static final String KEY_INPUT_VALUE = "input_value";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_OUTPUT_SOURCE = "output_source";
    private static final String TABLE_INPUT = "input";
    private static final String TABLE_OUTPUT = "output";
    private static final String PARALLEL_LIMIT = "stepper_parallellimit";

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.checkNodeParams();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.saveParallelNode(flow, this.getNodeId());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_INPUT_ISINPUT.equals(propertyName)) {
            int inputRow = this.getModel().getEntryCurrentRowIndex(TABLE_INPUT);
            Boolean isInput = (Boolean)this.getModel().getValue(KEY_INPUT_ISINPUT, inputRow);
            if (isInput.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, inputRow, new String[]{KEY_INPUT_SOURCE});
                this.getView().setEnable(Boolean.TRUE, inputRow, new String[]{KEY_INPUT_VALUE});
                this.getModel().setValue(KEY_INPUT_SOURCE, (Object)"");
            } else {
                this.getView().setEnable(Boolean.TRUE, inputRow, new String[]{KEY_INPUT_SOURCE});
                this.getView().setEnable(Boolean.FALSE, inputRow, new String[]{KEY_INPUT_VALUE});
                this.getModel().setValue(KEY_INPUT_SOURCE, (Object)"");
            }
        }
        this.getModel().setDataChanged(true);
    }

    @Override
    protected void setComboItem() {
        List<ComboItem> inputComboItems = this.getComboItem();
        ComboEdit inputSource = (ComboEdit)this.getControl(KEY_INPUT_SOURCE);
        inputSource.setComboItems(inputComboItems);
        List<ComboItem> outputParamItems = this.getOutputComboItem();
        ComboEdit outputSource = (ComboEdit)this.getControl(KEY_OUTPUT_SOURCE);
        outputSource.setComboItems(outputParamItems);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.setSourceEnable();
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        ParallelAction parallelAction = (ParallelAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam("nodeId")).intValue());
        if (parallelAction != null) {
            this.loadParallelAction(parallelAction);
            this.loadRefrenceParams((Action)parallelAction, TABLE_INPUT, KEY_INPUT_NAME, KEY_INPUT_SOURCE);
            this.getView().updateView();
        }
        this.setSourceEnable();
    }

    private String checkNodeParams() {
        String message;
        DynamicObjectCollection outputs;
        StringBuilder stringBuilder = new StringBuilder();
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(TABLE_INPUT);
        if (inputs != null) {
            int inputRow = inputs.size();
            for (int i = 0; i < inputRow; ++i) {
                String msg;
                DynamicObject input = (DynamicObject)inputs.get(i);
                boolean isInput = input.getBoolean(KEY_INPUT_ISINPUT);
                String type = input.getString(KEY_INPUT_TYPE);
                String sourceParam = input.getString(KEY_INPUT_SOURCE);
                String value = input.getString(KEY_INPUT_VALUE);
                String name = input.getString(KEY_INPUT_NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    stringBuilder.append("\n");
                    msg = ResManager.loadKDString((String)"\u8f93\u5165\u8868\u7b2c%s\u884c\u201c\u53c2\u6570\u540d\u201d", (String)"GaiProcessParallelSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    stringBuilder.append(String.format(msg, i));
                }
                if (StringUtils.isBlank((CharSequence)type)) {
                    stringBuilder.append("\n");
                    msg = ResManager.loadKDString((String)"\u8f93\u5165\u8868\u7b2c%s\u884c\u201c\u53c2\u6570\u7c7b\u578b\u201d", (String)"GaiProcessParallelSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    stringBuilder.append(String.format(msg, i));
                }
                if (isInput) {
                    if (!StringUtils.isBlank((CharSequence)value)) continue;
                    stringBuilder.append("\n");
                    msg = ResManager.loadKDString((String)"\u8f93\u5165\u8868\u7b2c%s\u884c\u201c\u624b\u5de5\u7ef4\u62a4\u5185\u5bb9\u201d", (String)"GaiProcessParallelSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    stringBuilder.append(String.format(msg, i));
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)sourceParam)) continue;
                stringBuilder.append("\n");
                msg = ResManager.loadKDString((String)"\u8f93\u5165\u8868\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessParallelSetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
                stringBuilder.append(String.format(msg, i));
            }
        }
        if ((outputs = this.getModel().getEntryEntity(TABLE_OUTPUT)) != null) {
            int outputRow = outputs.size();
            for (int i = 0; i < outputRow; ++i) {
                String msg;
                DynamicObject output = (DynamicObject)outputs.get(i);
                String sourceParam = output.getString(KEY_OUTPUT_SOURCE);
                String name = output.getString(KEY_OUTPUT_NAME);
                if (StringUtils.isBlank((CharSequence)name)) {
                    stringBuilder.append("\n");
                    msg = ResManager.loadKDString((String)"\u8f93\u51fa\u8868\u7b2c%s\u884c\u201c\u53c2\u6570\u540d\u201d", (String)"GaiProcessParallelSetPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    stringBuilder.append(String.format(msg, i));
                }
                if (!StringUtils.isBlank((CharSequence)sourceParam)) continue;
                stringBuilder.append("\n");
                msg = ResManager.loadKDString((String)"\u8f93\u51fa\u8868\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessParallelSetPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]);
                stringBuilder.append(String.format(msg, i));
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(message = stringBuilder.toString()))) {
            message = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\uff1a", (String)"GaiProcessParallelSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), message);
        }
        return message;
    }

    private List<ComboItem> getOutputComboItem() {
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        List actionList = flow.getActions();
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>();
        for (Action action : actionList) {
            if (action.getBlockNodeId() != nodeId) continue;
            refrenceParamList.addAll(this.getNodePropertyDesigner().getRefrenceParamManager().getRefrenceParamList(action, new RefrenceDataConfig()));
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(refrenceParamList.size());
        for (RefrenceParam refrenceParam : refrenceParamList) {
            comboItemList.add(new ComboItem(new LocaleString(refrenceParam.getParamDisplayName()), refrenceParam.getParamValue()));
        }
        return comboItemList;
    }

    private void saveParallelNode(Flow flow, int nodeId) {
        DynamicObjectCollection outputs;
        String name;
        ParallelAction parallelAction = (ParallelAction)flow.findActionById(nodeId);
        BigDecimal parallelLimit_BD = (BigDecimal)this.getModel().getValue(PARALLEL_LIMIT);
        if (parallelLimit_BD != null) {
            int parallelLimit = parallelLimit_BD.intValue();
            if (parallelLimit > 10) {
                parallelLimit = 10;
            } else if (parallelLimit < 1) {
                parallelLimit = 1;
            }
            parallelAction.setParallelLimit(parallelLimit);
        } else {
            log.info("\u89e3\u6790\u201c\u6700\u5927\u5e76\u884c\u8fd0\u884c\u6570\u91cf\u201d\u4e3a\u7a7a\uff0c\u5f53\u524d\u503c\u4e0d\u53d8");
        }
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(TABLE_INPUT);
        if (inputs != null) {
            ArrayList<Var> inVarList = new ArrayList<Var>();
            ArrayList<VarMapper> varMappers = new ArrayList<VarMapper>(10);
            for (DynamicObject inputRow : inputs) {
                boolean isInput = inputRow.getBoolean(KEY_INPUT_ISINPUT);
                name = inputRow.getString(KEY_INPUT_NAME);
                String inputType = inputRow.getString(KEY_INPUT_TYPE);
                String value = inputRow.getString(KEY_INPUT_VALUE);
                Var var = new Var(name, inputType, "");
                var.setValue(value);
                var.setInput(isInput);
                inVarList.add(var);
                VarMapper varMapper = new VarMapper();
                String inputSource = inputRow.getString(KEY_INPUT_SOURCE);
                if (!kd.bos.util.StringUtils.isNotEmpty((String)inputSource)) continue;
                String[] arr = inputSource.split("#");
                int outNodeId = Integer.parseInt(arr[0]);
                String outVarName = arr[1];
                varMapper.setInVarName(name);
                varMapper.setOutNodeId(outNodeId);
                varMapper.setOutVarName(outVarName);
                varMappers.add(varMapper);
            }
            parallelAction.setVarList(inVarList);
            parallelAction.setInParamMap(varMappers);
        }
        if ((outputs = this.getModel().getEntryEntity(TABLE_OUTPUT)) != null) {
            ArrayList<Var> outVarList = new ArrayList<Var>();
            ArrayList<VarMapper> varMappers = new ArrayList<VarMapper>(10);
            for (DynamicObject outputRow : outputs) {
                name = outputRow.getString(KEY_OUTPUT_NAME);
                String desc = outputRow.getString(KEY_OUTPUT_DESC);
                Var var = new Var();
                var.setName(name);
                var.setDesc(desc);
                outVarList.add(var);
                VarMapper varMapper = new VarMapper();
                String outputSource = outputRow.getString(KEY_OUTPUT_SOURCE);
                if (!kd.bos.util.StringUtils.isNotEmpty((String)outputSource)) continue;
                String[] arr = outputSource.split("#");
                int outNodeId = Integer.parseInt(arr[0]);
                String outVarName = arr[1];
                varMapper.setInVarName(name);
                varMapper.setOutNodeId(outNodeId);
                varMapper.setOutVarName(outVarName);
                varMappers.add(varMapper);
            }
            parallelAction.setOutputVars(outVarList);
            parallelAction.setOutParamMap(varMappers);
        }
    }

    private void loadParallelAction(ParallelAction parallelAction) {
        List outVarList;
        if (parallelAction == null) {
            return;
        }
        List inVarList = parallelAction.getVarList();
        if (inVarList != null) {
            DynamicObjectCollection inputs = this.getModel().getEntryEntity(TABLE_INPUT);
            inputs.clear();
            EntryType inputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(TABLE_INPUT);
            List inVarMaps = parallelAction.getInParamMap();
            for (Var var : inVarList) {
                String name = var.getName();
                String type = var.getType();
                VarMapper varMapper = this.getVarMapper(name, inVarMaps);
                DynamicObject row = new DynamicObject((DynamicObjectType)inputEntryType);
                row.set(KEY_INPUT_NAME, (Object)name);
                row.set(KEY_INPUT_TYPE, (Object)type);
                row.set(KEY_INPUT_VALUE, (Object)var.getValue());
                row.set(KEY_INPUT_ISINPUT, (Object)var.isInput());
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_INPUT_SOURCE, (Object)param);
                }
                inputs.add((Object)row);
            }
            this.getView().updateView(TABLE_INPUT);
        }
        if ((outVarList = parallelAction.getOutputVars()) != null) {
            DynamicObjectCollection outputs = this.getModel().getEntryEntity(TABLE_OUTPUT);
            outputs.clear();
            EntryType outputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(TABLE_OUTPUT);
            List outVarMaps = parallelAction.getOutParamMap();
            for (Var var : outVarList) {
                String name = var.getName();
                String desc = var.getDesc();
                VarMapper varMapper = this.getVarMapper(name, outVarMaps);
                DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
                row.set(KEY_OUTPUT_NAME, (Object)name);
                row.set(KEY_OUTPUT_DESC, (Object)desc);
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_OUTPUT_SOURCE, (Object)param);
                }
                outputs.add((Object)row);
            }
            this.getView().updateView(TABLE_OUTPUT);
        }
        this.getModel().setValue(PARALLEL_LIMIT, (Object)BigDecimal.valueOf(parallelAction.getParallelLimit()));
        this.getView().updateView(PARALLEL_LIMIT);
    }

    private void setSourceEnable() {
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(TABLE_INPUT);
        if (inputs != null) {
            for (int i = 0; i < inputs.size(); ++i) {
                DynamicObject input = (DynamicObject)inputs.get(i);
                boolean isInput = input.getBoolean(KEY_INPUT_ISINPUT);
                if (isInput) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_INPUT_VALUE});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_SOURCE});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_VALUE});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_INPUT_SOURCE});
            }
        }
    }
}

