/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.RepoReplyConfig;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.LLMTaskType;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiProcessRepoReplySetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessRepoReplySetPlugin.class);
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_OUTPUT_SOURCEPARAM = "output_sourceparam";
    private static final String KEY_TAB_REPO = "tabrepo";
    private static final String KEY_TAB_PAGE_SELECT = "tabpageselect";
    private static final String KEY_TAB_PAGE_DYNAMIC = "tabpagedynamic";
    private static final String KEY_TOOL_BAR_SELECT_REPO = "advcontoolbarselectrepo";
    private static final String KEY_RADIOGROUP_REPO = "radiogrouprepo";
    private static final String LLM = "llm";
    private static final String USER_PROMPT = "user_prompt";
    private static final String SYS_PROMPT = "sys_prompt";
    private static final String REFERENCE = "reference";
    private static final String SHOW_MESSAGE = "showmessage";
    private static final String INPUTNEWENTRY = "inputnewentry";
    private static final String ENABLE_CHAT_MSG = "enable_chat_msg";
    private static final String REMEMBER_COUNT = "remember_count";

    @Override
    protected void setComboItem() {
        List<ComboItem> paramItems = this.getComboItem();
        ComboEdit inputSourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        inputSourceParam.setComboItems(paramItems);
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(itemList);
        String id = String.valueOf(this.getFlow().getId());
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem((String)LLMTaskType.PROCESS.getId(), (String)id);
        ComboEdit llmComboEdit = (ComboEdit)this.getView().getControl(LLM);
        llmComboEdit.setComboItems(comboItems);
    }

    @Override
    public void afterBindData(EventObject e) {
        Node parentNode;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INPUT_MUSTINPUT, KEY_OUTPUT_SOURCEPARAM});
        int nodeId = this.getNodeId();
        Flow flow = this.getFlow();
        Node node = flow.findNodeById(nodeId);
        int blockNodeId = node.getBlockNodeId();
        if (blockNodeId != -1 && (parentNode = flow.findNodeById(blockNodeId)) instanceof ParallelAction) {
            this.getModel().setValue(SHOW_MESSAGE, (Object)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_MESSAGE});
            this.getModel().setDataChanged(false);
            this.getModel().updateCache();
        }
        boolean enableChatMsg = (Boolean)this.getModel().getValue(ENABLE_CHAT_MSG);
        this.getView().setEnable(Boolean.valueOf(enableChatMsg), new String[]{REMEMBER_COUNT});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (operateKey.equals(INPUTNEWENTRY)) {
            DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
            int index = inputDoc.size() - 1;
            this.getModel().setValue(KEY_INPUT_NAME, (Object)String.format("%s_%s", "retrievalContent", index), index);
            this.getModel().setValue(KEY_INPUT_TYPE, (Object)VarFieldType.ARRAY_OBJECT.getType());
            this.getModel().setValue(KEY_INPUT_DESC, (Object)ResManager.loadKDString((String)"\u53ec\u56de\u5185\u5bb9", (String)"GaiProcessRepoReplySetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void initData() {
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        RepoReplyAction repoReplyAction = (RepoReplyAction)flow.findActionById(nodeId);
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        RepoReplyConfig repoReplyConfig = repoReplyAction.getRepoReplyConfig();
        if (repoReplyConfig != null) {
            this.getModel().setValue(LLM, (Object)repoReplyConfig.getLlm());
            this.getModel().setValue(sysTagFieldKey, (Object)repoReplyConfig.getSysPrompt());
            this.getModel().setValue(userTagFieldKey, (Object)repoReplyConfig.getUserPrompt());
            this.getModel().setValue(REFERENCE, (Object)repoReplyConfig.isReference());
            this.getModel().setValue(SHOW_MESSAGE, (Object)repoReplyConfig.isShowMessage());
            this.getModel().setValue(ENABLE_CHAT_MSG, (Object)repoReplyConfig.isEnableChatMsg());
            this.getModel().setValue(REMEMBER_COUNT, (Object)repoReplyConfig.getRememberCount());
        } else {
            String sysTagValue = ResManager.loadKDString((String)"#\u4f60\u662f\u4e00\u4e2a\u77e5\u8bc6\u95ee\u7b54\u52a9\u624b\uff0c\u8bf7\u4e25\u683c\u4f9d\u636e\u63d0\u4f9b\u7684\u77e5\u8bc6\uff0c\u51c6\u786e\u3001\u7b80\u6d01\u5730\u56de\u7b54\u7528\u6237\u95ee\u9898\uff0c\u8bf7\u4e0d\u8981\u7f16\u9020\u5e7b\u60f3\u3002\u5982\u679c\u4f60\u65e0\u6cd5\u4ece\u63d0\u4f9b\u7684\u77e5\u8bc6\u4e2d\u5f97\u51fa\u7b54\u6848\uff0c\u8bf7\u56de\u590d\u201c\u4e0d\u77e5\u9053\u201d\u3002", (String)"GaiProcessRepoReplySetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getModel().setValue(sysTagFieldKey, (Object)sysTagValue);
            String userTagValue = ResManager.loadKDString((String)"#\u8fd9\u662f\u7528\u6237\u7684\u63d0\u95ee: {{question}} #\u8fd9\u662f\u548c\u7528\u6237\u63d0\u95ee\u6700\u76f8\u5173\u7684\u7684\u77e5\u8bc6: {{retrievalContent}}", (String)"GaiProcessRepoReplySetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getModel().setValue(userTagFieldKey, (Object)userTagValue);
        }
        this.getView().setEnable((Boolean)this.getModel().getValue(ENABLE_CHAT_MSG), new String[]{REMEMBER_COUNT});
        this.loadMessage(repoReplyAction);
        this.loadRefrenceParams((Action)repoReplyAction, KEY_ENTRYENTITY_INPUT, KEY_INPUT_NAME, KEY_INPUT_SOURCEPARAM);
    }

    private void loadMessage(RepoReplyAction repoReplyAction) {
        List varList = repoReplyAction.getVarList();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        inputDoc.clear();
        if (varList == null || varList.isEmpty()) {
            DynamicObject questionRow = new DynamicObject((DynamicObjectType)entryType);
            questionRow.set(KEY_INPUT_NAME, (Object)"question");
            questionRow.set(KEY_INPUT_TYPE, (Object)VarFieldType.STRING.getType());
            questionRow.set(KEY_INPUT_DESC, (Object)ResManager.loadKDString((String)"\u7528\u6237\u7684\u63d0\u95ee", (String)"GaiProcessRepoReplySetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
            inputDoc.add((Object)questionRow);
            DynamicObject retrievalRow = new DynamicObject((DynamicObjectType)entryType);
            retrievalRow.set(KEY_INPUT_NAME, (Object)"retrievalContent");
            retrievalRow.set(KEY_INPUT_TYPE, (Object)VarFieldType.ARRAY_OBJECT.getType());
            retrievalRow.set(KEY_INPUT_DESC, (Object)ResManager.loadKDString((String)"\u53ec\u56de\u5185\u5bb9", (String)"GaiProcessRepoReplySetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
            inputDoc.add((Object)retrievalRow);
            this.getView().updateView(KEY_ENTRYENTITY_INPUT);
        } else {
            for (Var var : varList) {
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_INPUT_NAME, (Object)var.getName());
                row.set(KEY_INPUT_TYPE, (Object)var.getType());
                row.set(KEY_INPUT_DESC, (Object)var.getDesc());
                inputDoc.add((Object)row);
                this.getView().updateView(KEY_ENTRYENTITY_INPUT);
            }
        }
        List outputVars = repoReplyAction.getOutputVarList();
        EntryType outputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        outputDoc.clear();
        if (outputVars == null) {
            DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
            row.set(KEY_OUTPUT_NAME, (Object)"answer");
            row.set(KEY_OUTPUT_TYPE, (Object)VarFieldType.STRING.getType());
            outputDoc.add((Object)row);
            this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        } else {
            for (Var var : outputVars) {
                DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
                row.set(KEY_OUTPUT_NAME, (Object)var.getName());
                row.set(KEY_OUTPUT_TYPE, (Object)var.getType());
                outputDoc.add((Object)row);
                this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_RADIOGROUP_REPO.equals(propertyName)) {
            String repoType = (String)e.getChangeSet()[0].getNewValue();
            Tab tab = (Tab)this.getControl(KEY_TAB_REPO);
            if (StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
                tab.activeTab(KEY_TAB_PAGE_SELECT);
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TOOL_BAR_SELECT_REPO});
            } else if (StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
                tab.activeTab(KEY_TAB_PAGE_DYNAMIC);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TOOL_BAR_SELECT_REPO});
            }
        }
        if (propertyName.equals(KEY_INPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_INPUT_NAME, KEY_ENTRYENTITY_INPUT, data);
        }
        if (propertyName.equals(KEY_OUTPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_OUTPUT_NAME, KEY_ENTRYENTITY_OUTPUT, data);
        }
        if (propertyName.equals(ENABLE_CHAT_MSG)) {
            data = e.getChangeSet()[0];
            this.getView().setEnable((Boolean)data.getNewValue(), new String[]{REMEMBER_COUNT});
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        String validMessage = this.checkLlm();
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setValidMessage(validMessage);
        if (StringUtils.isNotBlank((CharSequence)validMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
        } else {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        }
        return validateInfo;
    }

    public String checkLlm() {
        String llm = (String)this.getModel().getValue(LLM);
        if (StringUtils.isBlank((CharSequence)llm)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bed\u8a00\u6a21\u578b\u3002", (String)"GaiProcessRepoReplySetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickRepoReply(flow, this.getNodeId());
    }

    private void clickRepoReply(Flow flow, int nodeId) {
        RepoReplyAction repoReplyAction = (RepoReplyAction)flow.findActionById(nodeId);
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        String llm = (String)this.getModel().getValue(LLM);
        String userPrompt = (String)this.getModel().getValue(userTagFieldKey);
        String sysPrompt = (String)this.getModel().getValue(sysTagFieldKey);
        boolean reference = (Boolean)this.getModel().getValue(REFERENCE);
        boolean showMessage = (Boolean)this.getModel().getValue(SHOW_MESSAGE);
        boolean enableChatMsg = (Boolean)this.getModel().getValue(ENABLE_CHAT_MSG);
        BigDecimal rememberCount = (BigDecimal)this.getModel().getValue(REMEMBER_COUNT);
        this.getView().setEnable(Boolean.valueOf(enableChatMsg), new String[]{REMEMBER_COUNT});
        if (StringUtils.isEmpty((CharSequence)userPrompt)) {
            userPrompt = (String)this.getModel().getValue(USER_PROMPT);
        }
        if (StringUtils.isEmpty((CharSequence)sysPrompt)) {
            sysPrompt = (String)this.getModel().getValue(SYS_PROMPT);
        }
        RepoReplyConfig repoReplyConfig = new RepoReplyConfig(llm, userPrompt, sysPrompt, showMessage, reference, enableChatMsg, rememberCount);
        repoReplyAction.setRepoReplyConfig(repoReplyConfig);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (inputDoc != null) {
            ArrayList<Var> varList = new ArrayList<Var>();
            for (DynamicObject row : inputDoc) {
                String name = row.getString(KEY_INPUT_NAME);
                String type = row.getString(KEY_INPUT_TYPE);
                String desc = row.getString(KEY_INPUT_DESC);
                Var var = new Var(name, type, desc);
                varList.add(var);
                VarMapper varM = new VarMapper();
                String sourceParam = row.getString(KEY_INPUT_SOURCEPARAM);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split("#");
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
            repoReplyAction.setVarList(varList);
        }
        repoReplyAction.setInParamMap(varMapper);
        ArrayList<Var> outputVars = null;
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        if (outputDoc != null && outputDoc.size() > 0) {
            outputVars = new ArrayList<Var>();
            for (DynamicObject row : outputDoc) {
                String name = row.getString(KEY_OUTPUT_NAME);
                String type = row.getString(KEY_OUTPUT_TYPE);
                String desc = row.getString(KEY_OUTPUT_DESC);
                Var var = new Var(name, type, desc);
                outputVars.add(var);
            }
        }
        repoReplyAction.setOutputVarList(outputVars);
    }
}

