/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RetrievalConfig;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.ParamConfigEnum;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.enuz.repo.SelectRepoTypeEnum;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class GaiProcessRepoSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessRepoSetPlugin.class);
    private static final String KEY_ENTRYENTITY_REPO = "repo";
    private static final String KEY_ENTRYENTITY_STRUCTURE = "structure";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_OUTPUT_SOURCEPARAM = "output_sourceparam";
    private static final String KEY_TAB_REPO = "tabrepo";
    private static final String KEY_TAB_PAGE_SELECT = "tabpageselect";
    private static final String KEY_TAB_PAGE_DYNAMIC = "tabpagedynamic";
    private static final String KEY_TAB_PAGE_STRUCTURE = "tabpagestructure";
    private static final String KEY_TAB_PAGE_META = "tabpagemeta";
    private static final String KEY_TAB_PAGE_UNIVERSAL = "tabpageuniversal";
    private static final String KEY_TAB_PAGE_DYNAMIC_UNIVERSAL = "tabpagedynamicuniversal";
    private static final String KEY_TOOL_BAR_SELECT_REPO = "advcontoolbarselectrepo";
    private static final String KEY_MODE = "mode";
    private static final String KEY_UNIVERSAL_MODE = "universalmode";
    private static final String KEY_SELECT_REPO_TYPE = "selectrepotype";
    private static final String KEY_DY_REPO = "dyrepo";
    private static final String KEY_META_REPO = "metarepo";
    private static final String KEY_UNIVERSAL_REPO = "universalrepo";
    private static final String KEY_DY_STRUCTURE = "structure";
    private static final String KEY_DY_UNIVERSAL_REPO = "dyuniversalrepo";
    private static final String SEPERATOR = "#";
    private static final String MODE = "mode";
    private static final String RE_RANK = "rerank";
    private static final String RE_RANK_MODEL_LIST = "rerankmodellist";
    private static final String TOPK = "topk";
    private static final String SIMILARITY = "similarity";
    private static final String REPOID = "repoid";

    @Override
    protected void setComboItem() {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserChatHistory(false);
        List<ComboItem> paramItems = this.getComboItem(config);
        ComboEdit inputSourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        inputSourceParam.setComboItems(paramItems);
        ArrayList<ProcessNodeType> nodeTypeList = new ArrayList<ProcessNodeType>(2);
        nodeTypeList.add(ProcessNodeType.CusOption);
        nodeTypeList.add(ProcessNodeType.PresetOption);
        ArrayList<String> paramTypeList = new ArrayList<String>(1);
        paramTypeList.add(VarFieldType.STRING.getType());
        config.setAddUserChatHistory(false);
        config.setAddUserInput(false);
        config.setOnlyNodeTypeList(nodeTypeList);
        config.setOnlyParamTypeList(paramTypeList);
        paramItems = this.getComboItem(config);
        ComboEdit dyRepo = (ComboEdit)this.getControl(KEY_DY_REPO);
        dyRepo.setComboItems(paramItems);
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(itemList);
        this.setDyUniversalComboItems();
    }

    public void setDyUniversalComboItems() {
        ArrayList<ProcessNodeType> nodeTypeList = new ArrayList<ProcessNodeType>(2);
        nodeTypeList.add(ProcessNodeType.CusOption);
        nodeTypeList.add(ProcessNodeType.PresetOption);
        nodeTypeList.add(ProcessNodeType.Start);
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserChatHistory(false);
        config.setAddUserInput(false);
        config.setOnlyNodeTypeList(nodeTypeList);
        List<ComboItem> paramItems = this.getComboItem(config);
        ComboEdit dyRepo = (ComboEdit)this.getControl(KEY_DY_UNIVERSAL_REPO);
        dyRepo.setComboItems(paramItems);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INPUT_MUSTINPUT, KEY_OUTPUT_SOURCEPARAM});
        this.knowledgeVersionSwitch();
        String repoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
        this.knowledgeTypeSwitch(repoType);
    }

    private void knowledgeTypeSwitch(String repoType) {
        Tab tab = (Tab)this.getControl(KEY_TAB_REPO);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SIMILARITY});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_TOOL_BAR_SELECT_REPO});
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
            tab.activeTab(KEY_TAB_PAGE_SELECT);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mode", KEY_TOOL_BAR_SELECT_REPO});
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"structure")) {
            tab.activeTab(KEY_TAB_PAGE_STRUCTURE);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            tab.activeTab(KEY_TAB_PAGE_DYNAMIC);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mode"});
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"meta")) {
            tab.activeTab(KEY_TAB_PAGE_META);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"universal")) {
            this.activeUniversalRepoTab(tab);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            this.activeDyUniversalRepoTab(tab);
        }
    }

    private void knowledgeVersionSwitch() {
        ComboEdit repoTypeComboEdit = (ComboEdit)this.getControl(KEY_SELECT_REPO_TYPE);
        List<ComboItem> comboItemList = this.getSelectRepoTypeComboItems();
        repoTypeComboEdit.setComboItems(comboItemList);
        if (CollectionUtils.isNotEmpty(comboItemList)) {
            String savedRepoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
            Set comboItemValueSet = comboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            if (savedRepoType == null || !comboItemValueSet.contains(savedRepoType)) {
                this.getModel().setValue(KEY_SELECT_REPO_TYPE, (Object)comboItemList.get(0).getValue());
                this.getView().updateView(KEY_SELECT_REPO_TYPE);
            }
        }
    }

    private List<ComboItem> getSelectRepoTypeComboItems() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        for (SelectRepoTypeEnum typeEnum : SelectRepoTypeEnum.values()) {
            boolean isOldKnowledge;
            ComboItem comboItem = new ComboItem(new LocaleString(typeEnum.getName()), typeEnum.getId());
            boolean bl = isOldKnowledge = typeEnum == SelectRepoTypeEnum.SELECT || typeEnum == SelectRepoTypeEnum.DYNAMIC;
            if (!RepoService.isUsingOldKnowledge() && isOldKnowledge) continue;
            comboItemList.add(comboItem);
        }
        if (this.structureRepoEnable()) {
            comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93", (String)"SelectRepoTypeEnum_2", (String)"ai-gai-core", (Object[])new Object[0])), "structure"));
        }
        return comboItemList;
    }

    private boolean structureRepoEnable() {
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter("name", "=", (Object)ParamConfigEnum.STRUCTURE_REPO_ENABLE.getId()).toArray());
        if (configs.length > 0) {
            String paramValue;
            String value = configs[0].getString("value");
            String valueTag = configs[0].getString("value_tag");
            String string = paramValue = StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
            if ("1".equalsIgnoreCase(paramValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void initData() {
        VarMapper repoMapper;
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        RepoAction repoAction = (RepoAction)flow.findActionById(nodeId);
        String repoType = repoAction.getRepoType();
        this.getModel().setValue(KEY_SELECT_REPO_TYPE, (Object)repoType);
        Tab tab = (Tab)this.getControl(KEY_TAB_REPO);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
            DynamicObject[] doArr;
            tab.activeTab(KEY_TAB_PAGE_SELECT);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mode"});
            List repoList = repoAction.getRepoList();
            if (CollectionUtils.isNotEmpty((Collection)repoList) && (doArr = BusinessDataServiceHelper.load((Object[])repoAction.getRepoList().toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_REPO_INFO.getId()).getDynamicObjectType())).length > 0) {
                this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY_REPO, doArr.length);
                for (int i = 0; i < doArr.length; ++i) {
                    this.getModel().setValue(REPOID, (Object)doArr[i], i);
                }
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"structure")) {
            tab.activeTab(KEY_TAB_PAGE_STRUCTURE);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
            Long structureId = repoAction.getStructureId();
            if (structureId != null) {
                this.getModel().setValue("structure", (Object)structureId);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            tab.activeTab(KEY_TAB_PAGE_DYNAMIC);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mode"});
            repoMapper = repoAction.getRepoMapper();
            if (repoMapper != null) {
                String dynamicRepoValue = RefrenceParam.getParamValue(repoMapper.getOutNodeId(), repoMapper.getOutVarName());
                this.getModel().setValue(KEY_DY_REPO, (Object)dynamicRepoValue);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"meta")) {
            tab.activeTab(KEY_TAB_PAGE_META);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
            List metaId = repoAction.getMetaIdList();
            if (metaId != null) {
                this.getModel().setValue(KEY_META_REPO, (Object)metaId.toArray());
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"universal")) {
            this.activeUniversalRepoTab(tab);
            List universalIdStrList = repoAction.getUniversalIdList();
            if (universalIdStrList != null) {
                List universalIdList = universalIdStrList.stream().map(Long::valueOf).collect(Collectors.toList());
                this.getModel().setValue(KEY_UNIVERSAL_REPO, (Object)universalIdList.toArray());
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            this.activeDyUniversalRepoTab(tab);
            repoMapper = repoAction.getUniversalRepoMapper();
            if (repoMapper != null) {
                String dynamicRepoValue = RefrenceParam.getParamValue(repoMapper.getOutNodeId(), repoMapper.getOutVarName());
                this.getModel().setValue(KEY_DY_UNIVERSAL_REPO, (Object)dynamicRepoValue);
            }
        }
        RetrievalConfig retrievalConfig = repoAction.getRetrievalConfig();
        if (retrievalConfig != null) {
            this.getModel().setValue("mode", (Object)retrievalConfig.getMode());
            this.getModel().setValue(KEY_UNIVERSAL_MODE, (Object)retrievalConfig.getMode());
            this.getModel().setValue(TOPK, (Object)retrievalConfig.getTopK());
            this.getModel().setValue(SIMILARITY, (Object)Float.valueOf(retrievalConfig.getSimilarity()));
            this.getModel().setValue(RE_RANK, (Object)retrievalConfig.isReRank());
            this.getModel().setValue(RE_RANK_MODEL_LIST, (Object)retrievalConfig.getRerankModelNumber());
        }
        this.loadMessage(repoAction);
        this.loadRefrenceParams((Action)repoAction, KEY_ENTRYENTITY_INPUT, KEY_INPUT_NAME, KEY_INPUT_SOURCEPARAM);
        this.initRerankList();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit repo = (BasedataEdit)this.getControl(KEY_META_REPO);
        repo.addBeforeF7SelectListener(evt -> {
            evt.getFormShowParameter().setCustomParam("modeltype", (Object)"KMModel");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("bizappid.number", "!=", (Object)"tpl"));
            evt.setCustomQFilters(qFilters);
        });
    }

    private void loadMessage(RepoAction repoAction) {
        List varList = repoAction.getVarList();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        inputDoc.clear();
        if (varList == null || varList.size() == 0) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(KEY_INPUT_NAME, (Object)"query");
            row.set(KEY_INPUT_TYPE, (Object)VarFieldType.STRING.getType());
            row.set(KEY_INPUT_DESC, (Object)ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u68c0\u7d22\u5165\u53c2", (String)"GaiProcessKnowledgeSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            inputDoc.add((Object)row);
            this.getView().updateView(KEY_ENTRYENTITY_INPUT);
        } else {
            for (Var var : varList) {
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_INPUT_NAME, (Object)var.getName());
                row.set(KEY_INPUT_TYPE, (Object)var.getType());
                row.set(KEY_INPUT_DESC, (Object)var.getDesc());
                inputDoc.add((Object)row);
                this.getView().updateView(KEY_ENTRYENTITY_INPUT);
            }
        }
        List outputVars = repoAction == null ? null : repoAction.getOutputVarList();
        EntryType outputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        outputDoc.clear();
        if (outputVars == null) {
            DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
            row.set(KEY_OUTPUT_NAME, (Object)"outputList");
            row.set(KEY_OUTPUT_TYPE, (Object)VarFieldType.ARRAY_OBJECT.getType());
            outputDoc.add((Object)row);
            this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        } else {
            for (Var var : outputVars) {
                DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
                row.set(KEY_OUTPUT_NAME, (Object)var.getName());
                row.set(KEY_OUTPUT_TYPE, (Object)var.getType());
                outputDoc.add((Object)row);
                this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_SELECT_REPO_TYPE.equals(propertyName)) {
            String repoType = (String)e.getChangeSet()[0].getNewValue();
            this.knowledgeTypeSwitch(repoType);
        }
        if (KEY_UNIVERSAL_MODE.equals(propertyName)) {
            String universalMode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)universalMode, (CharSequence)"TEXT_QA")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SIMILARITY});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SIMILARITY});
            }
        }
        if (propertyName.equals(KEY_INPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_INPUT_NAME, KEY_ENTRYENTITY_INPUT, data);
        }
        if (propertyName.equals(KEY_OUTPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_OUTPUT_NAME, KEY_ENTRYENTITY_OUTPUT, data);
        }
    }

    private void activeUniversalRepoTab(Tab tab) {
        tab.activeTab(KEY_TAB_PAGE_UNIVERSAL);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
        String universalMode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)universalMode, (CharSequence)"TEXT_QA")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SIMILARITY});
        }
        this.initRerankList();
    }

    private void activeDyUniversalRepoTab(Tab tab) {
        tab.activeTab(KEY_TAB_PAGE_DYNAMIC_UNIVERSAL);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mode"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_UNIVERSAL_MODE, RE_RANK_MODEL_LIST});
        String universalMode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)universalMode, (CharSequence)"TEXT_QA")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SIMILARITY});
        }
        this.initRerankList();
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        String validMessage = this.checkRepoConfig();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)validMessage)) {
            validMessage = this.checkRetrievalConfig();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)validMessage)) {
            validMessage = this.checkInputParam();
        }
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setValidMessage(validMessage);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)validMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
        } else {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        }
        return validateInfo;
    }

    private String checkRepoConfig() {
        String repoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)repoType)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u77e5\u8bc6\u5e93\u7c7b\u578b\u3002", (String)"GaiProcessRepoSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
            return this.checkDocRepo();
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"structure")) {
            return this.checkStructureRepo();
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            return this.checkDyDocRepo();
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"meta")) {
            return this.checkMetaRepo();
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"universal")) {
            return this.checkUniversalRepo();
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            return this.checkDyUniversalRepo();
        }
        return "";
    }

    private String checkDocRepo() {
        DynamicObjectCollection doColl = this.getModel().getEntryEntity(KEY_ENTRYENTITY_REPO);
        if (doColl == null || doColl.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6587\u6863\u77e5\u8bc6\u5e93\u3002", (String)"GaiProcessRepoSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkStructureRepo() {
        DynamicObject doColl = (DynamicObject)this.getModel().getValue("structure");
        if (doColl == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u6784\u5316\u77e5\u8bc6\u5e93\u3002", (String)"GaiProcessRepoSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkDyDocRepo() {
        String dyRepo = (String)this.getModel().getValue(KEY_DY_REPO);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dyRepo)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a8\u6001\u77e5\u8bc6\u5e93(\u6587\u6863)\u3002", (String)"GaiProcessRepoSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkMetaRepo() {
        MulBasedataDynamicObjectCollection baseDoColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_META_REPO);
        if (baseDoColl == null || baseDoColl.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5143\u6a21\u578b\u77e5\u8bc6\u5e93\u3002", (String)"GaiProcessRepoSetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkUniversalRepo() {
        MulBasedataDynamicObjectCollection universalColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_UNIVERSAL_REPO);
        if (universalColl == null || universalColl.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u901a\u7528\u77e5\u8bc6\u5e93\u3002", (String)"GaiProcessRepoSetPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkDyUniversalRepo() {
        String dyRepo = (String)this.getModel().getValue(KEY_DY_UNIVERSAL_REPO);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dyRepo)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528)\u3002", (String)"GaiProcessRepoSetPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkRetrievalConfig() {
        BigDecimal topK = (BigDecimal)this.getModel().getValue(TOPK);
        if (topK == null) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6700\u5927\u53ec\u56de\u6570\u91cf\u3002", (String)"GaiProcessRepoSetPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        BigDecimal similarity = (BigDecimal)this.getModel().getValue(SIMILARITY);
        if (similarity == null) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6700\u5c0f\u5339\u914d\u5ea6\u3002", (String)"GaiProcessRepoSetPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        String repoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
        String searchMode = null;
        if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)repoType, (CharSequence[])new CharSequence[]{"dynamic_universal", "universal"})) {
            searchMode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
            Boolean reRank = (Boolean)this.getModel().getValue(RE_RANK);
            String rerankModelNumber = (String)this.getModel().getValue(RE_RANK_MODEL_LIST);
            if (reRank.booleanValue() && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rerankModelNumber)) {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u91cd\u6392\u5e8f\u6a21\u578b\u3002", (String)"GaiProcessRepoSetPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
        } else {
            searchMode = (String)this.getModel().getValue("mode");
        }
        if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)repoType, (CharSequence[])new CharSequence[]{"meta", "structure"})) {
            return "";
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)searchMode)) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u68c0\u7d22\u6a21\u5f0f\u3002", (String)"GaiProcessRepoSetPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkInputParam() {
        DynamicObjectCollection inputDoColl = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        if (inputDoColl == null || inputDoColl.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u3002", (String)"GaiProcessRepoSetPlugin_11", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        for (DynamicObject row : inputDoColl) {
            String name = row.getString(KEY_INPUT_NAME);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name)) {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u540d\u3002", (String)"GaiProcessRepoSetPlugin_12", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
            String type = row.getString(KEY_INPUT_TYPE);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)type)) {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u7c7b\u578b\u3002", (String)"GaiProcessRepoSetPlugin_13", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
            String desc = row.getString(KEY_INPUT_DESC);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)desc)) {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u8bf4\u660e\u3002", (String)"GaiProcessRepoSetPlugin_14", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
            String sourceParam = row.getString(KEY_INPUT_SOURCEPARAM);
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sourceParam)) continue;
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u6765\u6e90\u3002", (String)"GaiProcessRepoSetPlugin_15", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickRepo(flow, this.getNodeId());
    }

    private void clickRepo(Flow flow, int nodeId) {
        VarMapper llmMapper;
        String dyRepo;
        RepoAction repoAction = (RepoAction)flow.findActionById(nodeId);
        String repoType = (String)this.getModel().getValue(KEY_SELECT_REPO_TYPE);
        repoAction.setRepoType(repoType);
        Boolean reRank = (Boolean)this.getModel().getValue(RE_RANK);
        repoAction.setReRank(reRank.booleanValue());
        String mode = (String)this.getModel().getValue("mode");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"select")) {
            DynamicObjectCollection repoDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_REPO);
            if (repoDoc != null) {
                ArrayList<Long> reopList = new ArrayList<Long>();
                for (DynamicObject row : repoDoc) {
                    if (null == row.getDynamicObject(2)) continue;
                    reopList.add((Long)row.getDynamicObject(2).getPkValue());
                }
                repoAction.setRepoList(reopList);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"structure")) {
            DynamicObject structure = (DynamicObject)this.getModel().getValue("structure");
            if (structure != null) {
                repoAction.setStructureId((Long)structure.get("id"));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic")) {
            dyRepo = (String)this.getModel().getValue(KEY_DY_REPO);
            llmMapper = this.buildVarMapper(dyRepo, "");
            repoAction.setRepoMapper(llmMapper);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"meta")) {
            MulBasedataDynamicObjectCollection metas = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_META_REPO);
            if (metas != null && !metas.isEmpty()) {
                ArrayList<String> metaIdList = new ArrayList<String>();
                for (DynamicObject dynamicObject : metas) {
                    metaIdList.add((String)dynamicObject.getDynamicObject("fbasedataid").getPkValue());
                }
                repoAction.setMetaIdList(metaIdList);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"universal")) {
            repoAction.setReRank(reRank.booleanValue());
            MulBasedataDynamicObjectCollection universalColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_UNIVERSAL_REPO);
            if (universalColl != null && !universalColl.isEmpty()) {
                ArrayList<String> universalIdList = new ArrayList<String>();
                for (DynamicObject dynamicObject : universalColl) {
                    universalIdList.add(String.valueOf(dynamicObject.getDynamicObject("fbasedataid").getPkValue()));
                }
                repoAction.setUniversalIdList(universalIdList);
            }
            mode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)repoType, (CharSequence)"dynamic_universal")) {
            dyRepo = (String)this.getModel().getValue(KEY_DY_UNIVERSAL_REPO);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dyRepo)) {
                llmMapper = this.buildVarMapper(dyRepo, "\u52a8\u6001\u77e5\u8bc6\u5e93(\u901a\u7528)\u53c2\u6570");
                repoAction.setUniversalRepoMapper(llmMapper);
            }
            mode = (String)this.getModel().getValue(KEY_UNIVERSAL_MODE);
        }
        BigDecimal topK = (BigDecimal)this.getModel().getValue(TOPK);
        BigDecimal similarity = (BigDecimal)this.getModel().getValue(SIMILARITY);
        reRank = (Boolean)this.getModel().getValue(RE_RANK);
        reRank = reRank != null && reRank != false;
        String rerankModelNumber = (String)this.getModel().getValue(RE_RANK_MODEL_LIST);
        RetrievalConfig retrievalConfig = new RetrievalConfig(mode, topK.intValue(), similarity.floatValue(), reRank.booleanValue(), rerankModelNumber);
        repoAction.setRetrievalConfig(retrievalConfig);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (inputDoc != null) {
            ArrayList<Var> varList = new ArrayList<Var>();
            for (DynamicObject row : inputDoc) {
                String name = row.getString(KEY_INPUT_NAME);
                String type = row.getString(KEY_INPUT_TYPE);
                String desc = row.getString(KEY_INPUT_DESC);
                Var var = new Var(name, type, desc);
                varList.add(var);
                VarMapper varM = new VarMapper();
                String sourceParam = row.getString(KEY_INPUT_SOURCEPARAM);
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split(SEPERATOR);
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
            repoAction.setVarList(varList);
        }
        repoAction.setInParamMap(varMapper);
        ArrayList<Var> outputVars = null;
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        if (outputDoc != null && outputDoc.size() > 0) {
            outputVars = new ArrayList<Var>();
            for (DynamicObject row : outputDoc) {
                String name = row.getString(KEY_OUTPUT_NAME);
                String type = row.getString(KEY_OUTPUT_TYPE);
                String desc = row.getString(KEY_OUTPUT_DESC);
                Var var = new Var(name, type, desc);
                outputVars.add(var);
            }
        }
        repoAction.setOutputVarList(outputVars);
    }

    private VarMapper buildVarMapper(String sourceParam, String name) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sourceParam)) {
            VarMapper varM = new VarMapper();
            String[] arr = sourceParam.split(SEPERATOR);
            int selNodeId = Integer.parseInt(arr[0]);
            String param = arr[1];
            varM.setInVarName(name);
            varM.setOutNodeId(selNodeId);
            varM.setOutVarName(param);
            return varM;
        }
        return null;
    }

    private void initRerankList() {
        ComboEdit rerankComboEdit = (ComboEdit)this.getView().getControl(RE_RANK_MODEL_LIST);
        List rerankComboItemList = GaiFieldTypeInitUtils.createRerankComboItem();
        if (!rerankComboItemList.isEmpty()) {
            rerankComboEdit.setComboItems(rerankComboItemList);
            String rerankModelNumber = (String)this.getModel().getValue(RE_RANK_MODEL_LIST);
            Set rerankNumberSet = rerankComboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rerankModelNumber) || !rerankNumberSet.contains(rerankModelNumber)) {
                this.getModel().setValue(RE_RANK_MODEL_LIST, (Object)((ComboItem)rerankComboItemList.get(0)).getValue());
            }
        } else {
            rerankComboEdit.setComboItems(null);
            this.getModel().setValue(RE_RANK_MODEL_LIST, null);
        }
    }
}

