/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.SetVarMapper;
import kd.ai.gai.core.engine.flow.SetVariableAction;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public class GaiProcessSetVariablePlugin
extends AbstractGaiProcessSetPlugin {
    private static final String NODE_ID = "nodeId";
    private static final String KEY_SET_VAR = "setvar";
    private static final String KEY_LOOP_VAR = "loop_var";
    private static final String KEY_VAR_SOURCE = "var_source";

    @Override
    protected void setComboItem() {
        ComboEdit loopVarParam = (ComboEdit)this.getControl(KEY_LOOP_VAR);
        List<ComboItem> paramItems = this.getLoopVarComboItem();
        loopVarParam.setComboItems(paramItems);
        ComboEdit varSourceParam = (ComboEdit)this.getControl(KEY_VAR_SOURCE);
        List<ComboItem> outputParamItems = this.getComboItem();
        varSourceParam.setComboItems(outputParamItems);
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickMessage(flow, this.getNodeId());
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        SetVariableAction setVariableAction = (SetVariableAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam(NODE_ID)).intValue());
        if (setVariableAction != null) {
            this.loadSetVariableAction(setVariableAction);
            this.getView().updateView();
        }
    }

    private String check() {
        DynamicObjectCollection vars = this.getModel().getEntryEntity(KEY_SET_VAR);
        if (vars != null) {
            int i = 1;
            for (DynamicObject var : vars) {
                String loopVar = var.getString(KEY_LOOP_VAR);
                String source = var.getString(KEY_VAR_SOURCE);
                if (StringUtils.isBlank((CharSequence)loopVar)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u5faa\u73af\u53d8\u91cf\u201d", (String)"GaiProcessSetVariablePlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (StringUtils.isBlank((CharSequence)source)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessSetVariablePlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        return "";
    }

    private List<ComboItem> getLoopVarComboItem() {
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam(NODE_ID);
        List actionList = flow.getActions();
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>(5);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(5);
        for (Action action : actionList) {
            if (action.getId() != nodeId) continue;
            int blockNodeId = action.getBlockNodeId();
            LoopAction loopAction = (LoopAction)flow.findActionById(blockNodeId);
            RefrenceDataConfig refrenceDataConfig = new RefrenceDataConfig();
            refrenceDataConfig.setOnlyNeedBlockNodeVar(true);
            refrenceDataConfig.setBlockNodeId(blockNodeId);
            refrenceParamList.addAll(this.getNodePropertyDesigner().getRefrenceParamManager().getRefrenceParamList((Action)loopAction, refrenceDataConfig));
        }
        for (RefrenceParam refrenceParam : refrenceParamList) {
            comboItemList.add(new ComboItem(new LocaleString(refrenceParam.getParamDisplayName()), refrenceParam.getParamValue()));
        }
        return comboItemList;
    }

    private void clickMessage(Flow flow, int nodeId) {
        DynamicObjectCollection vars = this.getModel().getEntryEntity(KEY_SET_VAR);
        SetVariableAction setVariableAction = (SetVariableAction)flow.findActionById(nodeId);
        if (setVariableAction != null) {
            ArrayList<SetVarMapper> setParamList = new ArrayList<SetVarMapper>();
            for (DynamicObject row : vars) {
                String loopVar = row.getString(KEY_LOOP_VAR);
                String varSource = row.getString(KEY_VAR_SOURCE);
                if (!StringUtils.isNotBlank((CharSequence)loopVar) || !StringUtils.isNotBlank((CharSequence)varSource)) continue;
                String[] loopVarArr = loopVar.split("#");
                String[] varSourceArr = varSource.split("#");
                SetVarMapper varMapper = new SetVarMapper();
                varMapper.setInNodeId(Integer.parseInt(loopVarArr[0]));
                varMapper.setInVarName(loopVarArr[1]);
                varMapper.setOutVarName(varSourceArr[1]);
                varMapper.setOutNodeId(Integer.parseInt(varSourceArr[0]));
                setParamList.add(varMapper);
            }
            setVariableAction.setSetParamMap(setParamList);
        }
    }

    private void loadSetVariableAction(SetVariableAction setVariableAction) {
        List varMapperList;
        List list = varMapperList = setVariableAction == null ? null : setVariableAction.getSetParamMap();
        if (varMapperList != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_SET_VAR);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_SET_VAR);
            shows.clear();
            for (SetVarMapper setVarMapper : varMapperList) {
                String loopVarParam = RefrenceParam.getParamValue(setVarMapper.getInNodeId(), setVarMapper.getInVarName());
                String varSourceParam = RefrenceParam.getParamValue(setVarMapper.getOutNodeId(), setVarMapper.getOutVarName());
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_LOOP_VAR, (Object)loopVarParam);
                row.set(KEY_VAR_SOURCE, (Object)varSourceParam);
                shows.add((Object)row);
            }
            this.getView().updateView(KEY_SET_VAR);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getModel().setDataChanged(true);
    }
}

