/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.process.node;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GaiProcessToolSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessToolSetPlugin.class);
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_SOURCE = "input_source";
    private static final String KEY_INPUT_ISINPUT = "input_isinput";
    private static final String KEY_INPUT_VALUE = "input_value";
    private static final String KEY_PARALLEL_NAME = "parallel_name";
    private static final String KEY_PARALLEL_TYPE = "parallel_type";
    private static final String KEY_PARALLEL_SOURCE = "parallel_source";
    private static final String KEY_PARALLEL_ISINPUT = "parallel_isinput";
    private static final String KEY_PARALLEL_VALUE = "parallel_value";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String TABLE_INPUT = "input";
    private static final String TABLE_OUTPUT = "output";
    private static final String TABLE_PARALLEL = "parallel";
    private static final String PARALLEL_LIMIT = "stepper_parallellimit";
    private static final String PROCESS_LIMIT = "stepper_processlimit";
    private static final String MODE_CHOOSE = "radiogroup_modechoose";
    private static final String SINGLE_CALL = "radio_singlecall";
    private static final String BATCH_CALL = "radio_batchcall";
    private static final String TOOL_INFO = "basedata_tool";
    private static final String TOOL_KEY_TYPE = "tool_type";
    private static final String TOOL_KEY_NAME = "name";
    private static final String TOOL_KEY_PICTURE = "picture";
    private static final String TOOL_FORM_ID = "gai_tool";
    private static final String TOOL_FIELD_ID = "id";
    private static final String TOOL_FIELD_CONFIG = "config_tag";

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    private String check() {
        DynamicObject toolInfo = (DynamicObject)this.getModel().getValue(TOOL_INFO);
        if (toolInfo == null) {
            return ResManager.loadKDString((String)"\u5de5\u5177\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessToolSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection vars = this.getModel().getEntryEntity(TABLE_INPUT);
        if (vars != null) {
            int i = 1;
            for (DynamicObject show : vars) {
                boolean showInputs = show.getBoolean(KEY_INPUT_ISINPUT);
                String sourceParam = show.getString(KEY_INPUT_SOURCE);
                if (!showInputs && StringUtils.isEmpty((CharSequence)sourceParam)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessToolSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        return "";
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        ToolAction toolAction = (ToolAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam("nodeId")).intValue());
        if (toolAction != null) {
            this.loadToolAction(toolAction);
        }
    }

    private void loadToolAction(ToolAction toolAction) {
        List outVarList;
        String type;
        String name;
        List inputVarList;
        if (toolAction == null) {
            return;
        }
        Long toolId = toolAction.getToolId();
        if (toolId != null) {
            this.getModel().setValue(TOOL_INFO, (Object)toolAction.getToolId());
            this.getView().updateView(TOOL_INFO);
        }
        if ((inputVarList = toolAction.getInputVarList()) != null) {
            DynamicObjectCollection inputs = this.getModel().getEntryEntity(TABLE_INPUT);
            inputs.clear();
            EntryType inputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(TABLE_INPUT);
            List inVarMaps = toolAction.getInParamMap();
            for (Var var : inputVarList) {
                name = var.getName();
                type = var.getType();
                VarMapper varMapper = this.getVarMapper(name, inVarMaps);
                DynamicObject row = new DynamicObject((DynamicObjectType)inputEntryType);
                row.set(KEY_INPUT_NAME, (Object)name);
                row.set(KEY_INPUT_TYPE, (Object)type);
                row.set(KEY_INPUT_VALUE, (Object)var.getValue());
                row.set(KEY_INPUT_ISINPUT, (Object)var.isInput());
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_INPUT_SOURCE, (Object)param);
                }
                inputs.add((Object)row);
            }
            this.getView().updateView(TABLE_INPUT);
        }
        if ((outVarList = toolAction.getOutputVarList()) != null) {
            DynamicObjectCollection outputs = this.getModel().getEntryEntity(TABLE_OUTPUT);
            outputs.clear();
            EntryType outputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(TABLE_OUTPUT);
            for (Var var : outVarList) {
                name = var.getName();
                type = var.getType();
                DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
                row.set(KEY_OUTPUT_NAME, (Object)name);
                row.set(KEY_OUTPUT_TYPE, (Object)type);
                outputs.add((Object)row);
            }
            this.getView().updateView(TABLE_OUTPUT);
        }
    }

    private void setSourceEnable(String entryentity, String isinputKey, String sourceKey, String valueKey, int index) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryentity);
        if (collection != null) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(index);
            boolean isInput = dynamicObject.getBoolean(isinputKey);
            if (isInput) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{valueKey});
                this.getView().setEnable(Boolean.FALSE, index, new String[]{sourceKey});
            } else {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{valueKey});
                this.getView().setEnable(Boolean.TRUE, index, new String[]{sourceKey});
            }
        }
    }

    private void setSourceEnable() {
        DynamicObjectCollection outputs;
        DynamicObjectCollection inputs;
        DynamicObjectCollection parallelVars = this.getModel().getEntryEntity(TABLE_PARALLEL);
        if (parallelVars != null) {
            int i = 0;
            for (Object show : parallelVars) {
                boolean isInput = show.getBoolean(KEY_PARALLEL_ISINPUT);
                if (isInput) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_PARALLEL_VALUE});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_PARALLEL_SOURCE});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_PARALLEL_VALUE});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_PARALLEL_SOURCE});
                }
                ++i;
            }
        }
        if ((inputs = this.getModel().getEntryEntity(TABLE_INPUT)) != null) {
            int i = 0;
            for (DynamicObject show : inputs) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_NAME, KEY_INPUT_TYPE});
                boolean isInput = show.getBoolean(KEY_INPUT_ISINPUT);
                if (isInput) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_INPUT_VALUE});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_SOURCE});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_VALUE});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_INPUT_SOURCE});
                }
                ++i;
            }
        }
        if ((outputs = this.getModel().getEntryEntity(TABLE_OUTPUT)) != null) {
            int i = 0;
            for (DynamicObject show : outputs) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_OUTPUT_NAME, KEY_OUTPUT_TYPE});
                ++i;
            }
        }
    }

    @Override
    protected void setComboItem() {
        List<ComboItem> inputComboItems = this.getComboItem();
        ComboEdit inputSource = (ComboEdit)this.getControl(KEY_INPUT_SOURCE);
        inputSource.setComboItems(inputComboItems);
    }

    @Override
    public void afterBindData(EventObject e) {
        this.setSourceEnable();
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.saveToolNode(flow, this.getNodeId());
    }

    private void saveToolNode(Flow flow, int nodeId) {
        DynamicObjectCollection outputs;
        DynamicObjectCollection inputs;
        ToolAction toolAction = (ToolAction)flow.findActionById(nodeId);
        DynamicObject toolInfo = (DynamicObject)this.getModel().getValue(TOOL_INFO);
        if (toolInfo != null) {
            toolAction.setToolId(Long.valueOf(toolInfo.getLong(TOOL_FIELD_ID)));
            toolAction.setToolType(toolInfo.getString(TOOL_KEY_TYPE));
        }
        if ((inputs = this.getModel().getEntryEntity(TABLE_INPUT)) != null) {
            ArrayList<Var> inputVarList = new ArrayList<Var>();
            ArrayList<VarMapper> varMappers = new ArrayList<VarMapper>(10);
            for (DynamicObject inputRow : inputs) {
                boolean isInput = inputRow.getBoolean(KEY_INPUT_ISINPUT);
                String name = inputRow.getString(KEY_INPUT_NAME);
                String inputType = inputRow.getString(KEY_INPUT_TYPE);
                String value = inputRow.getString(KEY_INPUT_VALUE);
                Var var = new Var(name, inputType, "");
                var.setValue(value);
                var.setInput(isInput);
                inputVarList.add(var);
                VarMapper varMapper = new VarMapper();
                String inputSource = inputRow.getString(KEY_INPUT_SOURCE);
                if (!StringUtils.isNotEmpty((CharSequence)inputSource)) continue;
                String[] arr = inputSource.split("#");
                int outNodeId = Integer.parseInt(arr[0]);
                String outVarName = arr[1];
                varMapper.setInVarName(name);
                varMapper.setOutNodeId(outNodeId);
                varMapper.setOutVarName(outVarName);
                varMappers.add(varMapper);
            }
            toolAction.setInputVarList(inputVarList);
            toolAction.setInParamMap(varMappers);
        }
        if ((outputs = this.getModel().getEntryEntity(TABLE_OUTPUT)) != null) {
            ArrayList<Var> outputVarList = new ArrayList<Var>();
            for (DynamicObject outputRow : outputs) {
                String name = outputRow.getString(KEY_OUTPUT_NAME);
                String type = outputRow.getString(KEY_OUTPUT_TYPE);
                Var var = new Var();
                var.setName(name);
                var.setType(type);
                outputVarList.add(var);
            }
            toolAction.setOutputVarList(outputVarList);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "basedata_tool": {
                DynamicObject toolInfo = (DynamicObject)this.getModel().getValue(TOOL_INFO);
                String toolName = toolInfo.getString(TOOL_KEY_NAME);
                String iconPath = toolInfo.getString(TOOL_KEY_PICTURE);
                this.getModel().setValue(TOOL_KEY_NAME, (Object)toolName);
                this.fillInputAndOutput();
                this.sendIconPathToCustomControl(iconPath);
                this.getModel().updateCache();
                this.getView().updateView();
                break;
            }
            case "input_isinput": {
                int inputRow = this.getModel().getEntryCurrentRowIndex(TABLE_INPUT);
                Boolean isInput = (Boolean)this.getModel().getValue(KEY_INPUT_ISINPUT, inputRow);
                this.getView().setEnable(Boolean.valueOf(isInput == false), inputRow, new String[]{KEY_INPUT_SOURCE});
                this.getView().setEnable(isInput, inputRow, new String[]{KEY_INPUT_VALUE});
                if (isInput.booleanValue()) {
                    this.getModel().setValue(KEY_INPUT_SOURCE, (Object)"");
                    break;
                }
                this.getModel().setValue(KEY_INPUT_VALUE, (Object)"");
                break;
            }
            case "parallel_isinput": {
                int parallelRow = this.getModel().getEntryCurrentRowIndex(TABLE_PARALLEL);
                Boolean isInput2 = (Boolean)this.getModel().getValue(KEY_PARALLEL_ISINPUT, parallelRow);
                this.getView().setEnable(Boolean.valueOf(isInput2 == false), parallelRow, new String[]{KEY_PARALLEL_SOURCE});
                this.getView().setEnable(isInput2, parallelRow, new String[]{KEY_PARALLEL_VALUE});
                if (isInput2.booleanValue()) {
                    this.getModel().setValue(KEY_PARALLEL_SOURCE, (Object)"");
                    break;
                }
                this.getModel().setValue(KEY_PARALLEL_VALUE, (Object)"");
            }
        }
        this.getModel().setDataChanged(true);
    }

    private void fillInputAndOutput() {
        DynamicObject toolInfo = (DynamicObject)this.getModel().getValue(TOOL_INFO);
        if (toolInfo != null) {
            JSONArray outputParams;
            String type;
            String name;
            int index;
            JSONArray inputParams;
            long toolId = toolInfo.getLong(TOOL_FIELD_ID);
            DynamicObject toolObj = QueryServiceHelper.queryOne((String)TOOL_FORM_ID, (String)"id,config_tag", (QFilter[])new QFilter[]{new QFilter(TOOL_FIELD_ID, "=", (Object)toolId)});
            String toolTagJson = toolObj.getString(TOOL_FIELD_CONFIG);
            if (StringUtils.isEmpty((CharSequence)toolTagJson)) {
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)toolTagJson);
            this.getModel().deleteEntryData(TABLE_INPUT);
            if (jsonObject.containsKey((Object)"inputParams") && (inputParams = jsonObject.getJSONArray("inputParams")) != null && !inputParams.isEmpty()) {
                for (index = 0; index < inputParams.size(); ++index) {
                    JSONObject inputVar = inputParams.getJSONObject(index);
                    name = inputVar.getString("paramName");
                    type = inputVar.getString("paramType");
                    this.getModel().createNewEntryRow(TABLE_INPUT);
                    this.getModel().setValue(KEY_INPUT_NAME, (Object)name, index);
                    this.getModel().setValue(KEY_INPUT_TYPE, (Object)type, index);
                }
            }
            this.getModel().deleteEntryData(TABLE_OUTPUT);
            if (jsonObject.containsKey((Object)"outputParams") && (outputParams = jsonObject.getJSONArray("outputParams")) != null && !outputParams.isEmpty()) {
                for (index = 0; index < outputParams.size(); ++index) {
                    JSONObject outputVar = outputParams.getJSONObject(index);
                    name = outputVar.getString("paramName");
                    type = outputVar.getString("paramType");
                    this.getModel().createNewEntryRow(TABLE_OUTPUT);
                    this.getModel().setValue(KEY_OUTPUT_NAME, (Object)name, index);
                    this.getModel().setValue(KEY_OUTPUT_TYPE, (Object)type, index);
                }
            }
        }
    }

    private void sendIconPathToCustomControl(String iconPath) {
        this.getNodePropertyDesigner().sendModifyIconAction(this.buildIconUrl(iconPath));
    }

    private String buildIconUrl(String iconPath) {
        if (StringUtils.isNotEmpty((CharSequence)iconPath) && iconPath.startsWith("/kingdee")) {
            String host = RequestContext.get().getClientFullContextPath();
            if (host.endsWith("/")) {
                host = host.substring(0, host.length() - 1);
            }
            return host + iconPath;
        }
        return iconPath;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (entryName.equals(TABLE_PARALLEL)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                this.setSourceEnable(TABLE_PARALLEL, KEY_PARALLEL_ISINPUT, KEY_PARALLEL_SOURCE, KEY_PARALLEL_VALUE, rowDataEntity.getRowIndex());
            }
        }
    }
}

