/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.prompt;

import java.util.EventObject;
import java.util.Map;
import kd.ai.gai.plugin.prompt.GaiPromptTemplateListPlugin;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.mvc.list.ListDataProvider;

public class GaiPromptListPlugin
extends GaiPromptTemplateListPlugin {
    private static Map<String, String> mapllmService = null;

    public void initialize() {
        super.initialize();
        if (mapllmService == null || mapllmService.size() == 0) {
            mapllmService = this.getLlmService();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        mapllmService.clear();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        BillListDataProvider billListDataProvider = new BillListDataProvider();
        args.setListDataProvider((IListDataProvider)billListDataProvider);
    }

    public static class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            rows.forEach(dynamicObject -> {
                String serviceId = dynamicObject.getString("language_model");
                if (mapllmService.containsKey(serviceId)) {
                    String serviceName = (String)mapllmService.get(serviceId);
                    dynamicObject.set("language_model", (Object)serviceName);
                } else {
                    dynamicObject.set("language_model", (Object)"");
                }
            });
            return rows;
        }
    }
}

