/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.prompt;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.domain.prompt.PromptOptimizeTemplate;
import kd.ai.gai.core.enuz.LLMTaskType;
import kd.ai.gai.core.enuz.agent.ParamConfigEnum;
import kd.ai.gai.core.service.config.GaiParamConfigService;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GaiPromptOptimizeCfgPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GaiPromptOptimizeCfgPlugin.class);
    private static final String KEY_SAVE = "save";
    private static final String KEY_RESET = "reset";
    private static final String KEY_LLM = "llm";
    private static final String KEY_CODEEDITAP = "codeeditap";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String templateValue = GaiParamConfigService.getConfigValue((String)ParamConfigEnum.PROMPT_OPTIMITIZE_TEMPLATE.getId());
        String prompt = Constant.GaiPrompt.TEMPLATE_DEFAULT_PROMPT;
        if (StringUtils.isNotEmpty((CharSequence)templateValue) && StrUtils.isValidJSONObject((String)templateValue)) {
            PromptOptimizeTemplate template = (PromptOptimizeTemplate)JSONObject.parseObject((String)templateValue, PromptOptimizeTemplate.class);
            String llm = template.getLlm();
            prompt = template.getPrompt();
            this.getModel().setValue(KEY_LLM, (Object)llm);
        }
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
        codeEdit.setText(prompt);
        this.getView().updateView(KEY_LLM);
        this.getView().updateView(KEY_CODEEDITAP);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem((String)LLMTaskType.PROMPT.getId(), null);
        ComboEdit languageModel = (ComboEdit)this.getView().getControl(KEY_LLM);
        languageModel.setComboItems(comboItems);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_SAVE)) {
            String llm = (String)this.getModel().getValue(KEY_LLM);
            CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
            String prompt = codeEdit.getText();
            PromptOptimizeTemplate template = new PromptOptimizeTemplate(llm, prompt);
            GaiParamConfigService.save((String)ParamConfigEnum.PROMPT_OPTIMITIZE_TEMPLATE.getId(), (String)JSONObject.toJSONString((Object)template), null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GaiPromptOptimizeCfgPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)KEY_RESET)) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(KEY_RESET, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u5417\uff1f", (String)"GaiPromptOptimizeCfgPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        int value;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_RESET, (CharSequence)callBackId) && (value = event.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.getModel().setValue(KEY_LLM, null);
            CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITAP);
            codeEdit.setText(Constant.GaiPrompt.TEMPLATE_DEFAULT_PROMPT);
            GaiParamConfigService.delete((String)ParamConfigEnum.PROMPT_OPTIMITIZE_TEMPLATE.getId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u3002", (String)"GaiPromptOptimizeCfgPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
    }
}

