/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.prompt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.ai.gai.core.domain.llm.ModelParamLang;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.LlmServiceFactory;
import kd.ai.gai.core.service.llm.LlmService;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.StepperProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.StepperEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.StepperField;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import org.apache.commons.lang3.StringUtils;

public class GaiPromptStylePlugin
extends AbstractFormPlugin {
    private static final String BUTTON_OK = "btnok";
    private static Map<String, Object> map = new HashMap<String, Object>(16);
    private static Map<String, String> mapMaxTokensKey = new HashMap<String, String>(16);
    private static boolean isUpdate = false;
    private static final Log logger = LogFactory.getLog(GaiPromptStylePlugin.class);
    private static volatile ModelParamLang mpl = null;
    private String systemType = "ai-gai-plugin";
    private String MAX_TOKENS_DESC = ResManager.loadKDString((String)"\u63a7\u5236\u6a21\u578b\u8f93\u51fa\u7684Tokens\u957f\u5ea6\u4e0a\u9650\u3002\u901a\u5e38 100 Tokens \u7ea6\u7b49\u4e8e 150 \u4e2a\u4e2d\u6587\u6c49\u5b57\uff0c\u53d6\u503c\u8303\u56f4\u4e3a", (String)"GaiPromptStylePlugin0", (String)this.systemType, (Object[])new Object[0]);
    private String MAX_TOKENS_NAME = ResManager.loadKDString((String)"\u6700\u5927\u56de\u590d\u957f\u5ea6", (String)"GaiPromptStylePlugin1", (String)this.systemType, (Object[])new Object[0]);
    private String MAX_TOKENS_TITLE = this.MAX_TOKENS_NAME + "max tokens";

    public void initialize() {
        super.initialize();
        isUpdate = false;
        map.clear();
        mapMaxTokensKey.clear();
        if (mpl == null) {
            mpl = new ModelParamLang();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        JSONObject defaultParam = this.getLLMParam();
        if (defaultParam != null) {
            defaultParam.entrySet().forEach(entry -> {
                String stepperfieldKey = "stepper_" + (String)entry.getKey();
                if (e.getKey().equals(stepperfieldKey)) {
                    StepperEdit stepperEdit = new StepperEdit();
                    stepperEdit.setKey(stepperfieldKey);
                    stepperEdit.setId(stepperfieldKey);
                    stepperEdit.setView(this.getView());
                    e.setControl((Control)stepperEdit);
                }
            });
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType mainEntityType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)mainEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        JSONObject defaultParam = this.getLLMParam();
        if (defaultParam != null) {
            MainEntityType finalNewMainType = newMainType;
            defaultParam.entrySet().forEach(entry -> {
                StepperProp prop = new StepperProp();
                String stepperfieldKey = "stepper_" + (String)entry.getKey();
                prop.setName(stepperfieldKey);
                prop.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u6b65\u8fdb\u5668", (String)"GaiPromptStylePlugin2", (String)this.systemType, (Object[])new Object[0]) + (String)entry.getKey()));
                prop.setDbIgnore(true);
                prop.setAlias("");
                finalNewMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
            });
            e.setNewEntityType(newMainType);
        }
    }

    private JSONObject getMaxTokensParam(JSONObject defaultParam) {
        if (defaultParam != null) {
            String maxTokensKey = mapMaxTokensKey.get("max_tokens");
            if (StringUtils.isNotEmpty((CharSequence)maxTokensKey)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(maxTokensKey, defaultParam.get((Object)maxTokensKey));
                defaultParam.remove((Object)maxTokensKey);
                return jsonObject;
            }
            return null;
        }
        return null;
    }

    private void setMaxTokensValue(JSONObject typeParam) {
        String maxTokensKey;
        AtomicReference maxTokensValue = new AtomicReference();
        typeParam.entrySet().forEach(entry -> {
            String maxTokensKey;
            if (((String)entry.getKey()).equals("max_tokens") && StringUtils.isNotEmpty((CharSequence)(maxTokensKey = typeParam.get((Object)"max_tokens").toString()))) {
                JSONObject jsonObjectValue = new JSONObject();
                jsonObjectValue.put("name", (Object)this.MAX_TOKENS_NAME);
                jsonObjectValue.put("min", (Object)"1024");
                jsonObjectValue.put("max", (Object)"1000000");
                jsonObjectValue.put("value", (Object)4096);
                jsonObjectValue.put("stepvalue", (Object)1024);
                jsonObjectValue.put("ranger", (Object)"3");
                jsonObjectValue.put("desc", (Object)this.MAX_TOKENS_DESC);
                jsonObjectValue.put("title", (Object)this.MAX_TOKENS_TITLE);
                maxTokensValue.set(jsonObjectValue);
                mapMaxTokensKey.put("max_tokens", maxTokensKey);
            }
        });
        if (maxTokensValue.get() != null && StringUtils.isNotEmpty((CharSequence)(maxTokensKey = mapMaxTokensKey.get("max_tokens")))) {
            if (!maxTokensKey.equals("max_tokens")) {
                typeParam.remove((Object)"max_tokens");
            }
            typeParam.put(maxTokensKey, maxTokensValue.get());
        }
    }

    private JSONObject getLLMParam() {
        if (this.getView().getFormShowParameter().getCustomParam("serviceNumber") != null) {
            String serviceNumber = this.getView().getFormShowParameter().getCustomParam("serviceNumber").toString();
            String strllmStyle = this.getView().getFormShowParameter().getCustomParam("llmStyle").toString();
            String customStyle = this.getView().getFormShowParameter().getCustomParam("customstyle").toString();
            String key = String.format("%s_%s", serviceNumber, strllmStyle = strllmStyle.toLowerCase());
            if (map.get(key) != null) {
                return (JSONObject)map.get(key);
            }
            Map service = AiccService.queryLlmAiccService((String)serviceNumber);
            if (service == null || service.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b\u5bf9\u5e94\u7684\u7b97\u6cd5\u670d\u52a1\u4e0d\u5b58\u5728\u3002", (String)"SimpleChatPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            String llmNumber = (String)service.get("llm");
            LLM llm = LLM.parse((String)llmNumber);
            if (llm != null) {
                LlmService helper = LlmServiceFactory.getExecutor((LLM)llm, (boolean)false);
                LlmStyle llmStyle = LlmStyle.parse((String)strllmStyle);
                JSONObject typeParam = null;
                if (llmStyle == LlmStyle.CUSTOM) {
                    llmStyle = LlmStyle.BALANCE;
                    typeParam = helper.getTypeParam(llmStyle);
                    this.setMaxTokensValue(typeParam);
                    if (StringUtils.isNotEmpty((CharSequence)customStyle)) {
                        JSONObject customJsonObject = JSON.parseObject((String)customStyle);
                        typeParam.entrySet().forEach(entry -> {
                            if (customJsonObject.containsKey(entry.getKey())) {
                                BigDecimal newValue = customJsonObject.getBigDecimal((String)entry.getKey());
                                JSONObject value = (JSONObject)entry.getValue();
                                value.put("value", (Object)newValue);
                            }
                        });
                    }
                } else {
                    typeParam = helper.getTypeParam(llmStyle);
                    this.setMaxTokensValue(typeParam);
                }
                map.put(key, typeParam);
                return typeParam;
            }
        }
        return null;
    }

    private void createDynamicControl(JSONObject defaultParam, Container flex_container) {
        FlexPanelAp containerAp = new FlexPanelAp();
        containerAp.setId(flex_container.getKey() + "ap");
        containerAp.setKey(flex_container.getKey() + "ap");
        containerAp.setShrink(0);
        containerAp.setGrow(1);
        containerAp.setDirection("column");
        containerAp.setWrap(true);
        containerAp.setAlignItems("flex-start");
        containerAp.setJustifyContent("flex-start");
        containerAp.setWidth(new LocaleString("100%"));
        if (defaultParam != null) {
            defaultParam.entrySet().forEach(entry -> {
                JSONObject jsonValue = (JSONObject)entry.getValue();
                String min = jsonValue.getString("min");
                String max = jsonValue.getString("max");
                String ranger = jsonValue.getString("ranger");
                String dataScopeFormat = "%s%s,%s%s";
                String dataScope = "";
                switch (ranger) {
                    case "0": {
                        dataScope = String.format(dataScopeFormat, Character.valueOf('('), min, max, Character.valueOf(')'));
                        break;
                    }
                    case "1": {
                        dataScope = String.format(dataScopeFormat, Character.valueOf('('), min, max, Character.valueOf(']'));
                        break;
                    }
                    case "2": {
                        dataScope = String.format(dataScopeFormat, Character.valueOf('['), min, max, Character.valueOf(')'));
                        break;
                    }
                    case "3": {
                        dataScope = String.format(dataScopeFormat, Character.valueOf('['), min, max, Character.valueOf(']'));
                    }
                }
                FlexPanelAp panelAp = new FlexPanelAp();
                panelAp.setId("panelap_" + (String)entry.getKey());
                panelAp.setKey("panelap_" + (String)entry.getKey());
                panelAp.setShrink(0);
                panelAp.setGrow(0);
                panelAp.setDirection("row");
                panelAp.setAlignItems("left");
                panelAp.setAlignContent("left");
                panelAp.setJustifyContent("left");
                panelAp.setWidth(new LocaleString("100%"));
                FlexPanelAp flexPanelAp = new FlexPanelAp();
                flexPanelAp.setId("flexPanelAp" + (String)entry.getKey());
                flexPanelAp.setKey("flexPanelAp" + (String)entry.getKey());
                flexPanelAp.setGrow(0);
                Style style = new Style();
                Padding padding = new Padding();
                padding.setTop("8px");
                style.setPadding(padding);
                flexPanelAp.setStyle(style);
                flexPanelAp.setWidth(new LocaleString("150px"));
                LabelAp labelAp = new LabelAp();
                labelAp.setId("labelap_" + (String)entry.getKey());
                labelAp.setKey("labelap_" + (String)entry.getKey());
                labelAp.setAutoTextWrap(true);
                labelAp.setName(new LocaleString(jsonValue.getString("name")));
                Tips tips = new Tips();
                tips.setTitle(new LocaleString(jsonValue.getString("title")));
                tips.setContent(new LocaleString(jsonValue.getString("desc") + dataScope));
                tips.setTriggerType("hover");
                tips.setType("text");
                labelAp.setCtlTips(tips);
                labelAp.setFontSize(12);
                labelAp.setWidth(new LocaleString("auto"));
                labelAp.setTextAlign("left");
                flexPanelAp.getItems().add(labelAp);
                panelAp.getItems().add(flexPanelAp);
                String stepKey = "stepper_" + (String)entry.getKey();
                StepperField stepperField = new StepperField();
                stepperField.setName(new LocaleString(stepKey));
                stepperField.setId(stepKey);
                stepperField.setKey(stepKey);
                stepperField.setScale(2);
                stepperField.setStepperStyle(2);
                stepperField.setDataScope(dataScope);
                if (jsonValue.getString("stepvalue") != null) {
                    stepperField.setStepValue(new BigDecimal(jsonValue.getString("stepvalue")));
                    stepperField.setStepperValueType(0);
                } else {
                    stepperField.setStepValue(BigDecimal.valueOf(0.01));
                    stepperField.setStepperValueType(1);
                }
                FieldAp fieldAp = new FieldAp();
                fieldAp.setField((Field)stepperField);
                String fieldapKey = "stepper_" + (String)entry.getKey();
                fieldAp.setId(fieldapKey);
                fieldAp.setKey(fieldapKey);
                fieldAp.setMask("#");
                fieldAp.setWidth(new LocaleString("150px"));
                fieldAp.setHeight(new LocaleString("30px"));
                panelAp.getItems().add(fieldAp);
                containerAp.getItems().add(panelAp);
            });
            ArrayList<Map> itemMaps = new ArrayList<Map>(8);
            flex_container.getItems().addAll(((Container)containerAp.buildRuntimeControl()).getItems());
            flex_container.setView(this.getView());
            itemMaps.add(containerAp.createControl());
            flex_container.insertControls(0, itemMaps);
            this.getView().createControlIndex(flex_container.getItems());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject defaultParam = this.getLLMParam();
        if (defaultParam != null) {
            JSONObject cloneParam = defaultParam.clone();
            JSONObject maxTokenParam = this.getMaxTokensParam(cloneParam);
            Container flexContainer2 = (Container)this.getControl("flex_container2");
            if (maxTokenParam != null) {
                this.createDynamicControl(maxTokenParam, flexContainer2);
                this.setControlDefaultValue(maxTokenParam);
            }
            Container flexContainer1 = (Container)this.getControl("flex_container1");
            this.createDynamicControl(cloneParam, flexContainer1);
            this.setControlDefaultValue(cloneParam);
        }
    }

    private void setControlDefaultValue(JSONObject jsonObject) {
        jsonObject.entrySet().forEach(entry -> {
            String key = "stepper_" + (String)entry.getKey();
            JSONObject jsonValue = (JSONObject)entry.getValue();
            int scale = 2;
            if (jsonValue.getString("stepvalue") != null) {
                scale = 0;
            }
            BigDecimal value = new BigDecimal(jsonValue.getString("value"));
            value = value.setScale(scale, RoundingMode.HALF_UP);
            this.getModel().setValue(key, (Object)value);
        });
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (source.getKey().equals(BUTTON_OK)) {
            HashMap map = new HashMap(16);
            JSONObject defaultParam = this.getLLMParam();
            if (defaultParam != null) {
                defaultParam.entrySet().forEach(entry -> {
                    String key = "stepper_" + (String)entry.getKey();
                    int scale = 2;
                    if (((JSONObject)entry.getValue()).getString("stepvalue") != null) {
                        scale = 0;
                    }
                    BigDecimal value = new BigDecimal(this.getModel().getValue(key).toString());
                    value = value.setScale(scale, RoundingMode.HALF_UP);
                    map.put(entry.getKey(), value);
                });
            }
            this.getView().returnDataToParent((Object)JSON.parseObject((String)SerializationUtils.toJsonString(map)));
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_OK});
    }
}

