/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.prompt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.domain.llm.ModelTagEnum;
import kd.ai.gai.core.domain.prompt.PromptOptimizeTemplate;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.PromptTestCallbackMessage;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.OutPreVar;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.CtrlStrategyEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.ParamConfigEnum;
import kd.ai.gai.core.enuz.field.type.OutFieldType;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.config.GaiParamConfigService;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.plugin.AbstractGaiAssistantPlugin;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiPromptTemplatePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(GaiPromptTemplatePlugin.class);
    private static final String TO_TEMPLATE = "totemplate";
    private static final String FROM_TEMPLATE = "fromtemplate";
    private static final String toolbar = "tbmain";
    private static final String bar_save = "bar_save";
    private static final String bar_run = "bar_run";
    private static final String getChatInfo = "getChatInfo";
    private static final String key_prompt_encrypted_context = "prompt_encrypted_context";
    private static final int entry_max_size = 5;
    private static final String regex = "^[a-zA-Z0-9_]+$";
    private static final String UPDATE_PROMPT_VALUE_2_EMPTY = "updatePromptValue2Empty";
    private String aiccService = "aicc_service";
    private String prompt_content_form = "gai_prompt_content";
    private String KEY_ADV_REPO_CONFIG = "adv_repo_config";
    private String KEY_PROMPT_REPO_CONFIG = "prompt_repo_config";
    private static final String AI_GENERATE = "aigenerate";
    private static final String FLEX_OPTIMIZE = "flexoptimize";
    private static final String VECTORAP_OPTIMIZE = "vectorapoptimize";
    private DynamicObject createOrg;
    private boolean isChanged = true;
    private static List<ComboItem> listTempServiceNumber = null;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        Toolbar tbmain = (Toolbar)this.getView().getControl(toolbar);
        tbmain.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{bar_run});
        Control flexOptimize = this.getControl(FLEX_OPTIMIZE);
        ((ISuportClick)flexOptimize).addClickListener((ClickListener)this);
        Control vectorapOptimize = this.getControl(VECTORAP_OPTIMIZE);
        ((ISuportClick)vectorapOptimize).addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control && (FLEX_OPTIMIZE.equals(controlKey = ((Control)source).getKey()) || VECTORAP_OPTIMIZE.equals(controlKey))) {
            this.optimizePrompt();
        }
    }

    private void optimizePrompt() {
        if (this.requiredValidate()) {
            OrmLocaleValue nameOlv = (OrmLocaleValue)this.getModel().getValue("name");
            String input = (String)this.getModel().getValue("prompt_tag");
            String serviceNumber = (String)this.getModel().getValue("language_model");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(GaiFormIdEnum.GAI_SIMPLE_CHAT.getId());
            fsp.setShowTitle(false);
            fsp.setShowClose(false);
            OpenStyle openStyle = fsp.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("80%");
            inlineStyleCss.setWidth("60%");
            openStyle.setInlineStyleCss(inlineStyleCss);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "simpleChatResult"));
            String userInput = Constant.GaiPrompt.TEMPLATE_DEFAULT_PROMPT;
            String templateValue = GaiParamConfigService.getConfigValue((String)ParamConfigEnum.PROMPT_OPTIMITIZE_TEMPLATE.getId());
            if (StringUtils.isNotEmpty((CharSequence)templateValue) && StrUtils.isValidJSONObject((String)templateValue)) {
                PromptOptimizeTemplate template = (PromptOptimizeTemplate)JSONObject.parseObject((String)templateValue, PromptOptimizeTemplate.class);
                userInput = StringUtils.isNotEmpty((CharSequence)template.getPrompt()) ? template.getPrompt() : Constant.GaiPrompt.TEMPLATE_DEFAULT_PROMPT;
                serviceNumber = StringUtils.isNotEmpty((CharSequence)template.getLlm()) ? template.getLlm() : serviceNumber;
            }
            userInput = StringUtils.replace((String)userInput, (String)"{{name}}", (String)nameOlv.getLocaleValue());
            userInput = StringUtils.replace((String)userInput, (String)"{{prompt}}", (String)input);
            fsp.setCustomParam("userInput", (Object)userInput);
            fsp.setCustomParam("serviceNumber", (Object)serviceNumber);
            this.getView().showForm(fsp);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)TO_TEMPLATE)) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(GaiFormIdEnum.GAI_PROMPT_TEMP_GROUP.getId());
            lsp.setFormId("bos_templatetreelistf7");
            lsp.setLookUp(true);
            lsp.setShowTitle(false);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setMultiSelect(false);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("700");
            inlineStyleCss.setWidth("1080");
            lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TO_TEMPLATE));
            this.getView().showForm((FormShowParameter)lsp);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)FROM_TEMPLATE)) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
            lsp.setFormId("bos_templatetreelistf7");
            lsp.setLookUp(true);
            lsp.setShowTitle(false);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setMultiSelect(false);
            lsp.setCustomParam("enable", (Object)EnableEnum.YES.getKeyStr());
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("700");
            inlineStyleCss.setWidth("1080");
            lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FROM_TEMPLATE));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void afterBindData(EventObject e) {
        List comboItems;
        String id = String.valueOf(this.getModel().getValue("id"));
        listTempServiceNumber = comboItems = GaiFieldTypeInitUtils.createLlmComboItem((String)"prompt", (String)id);
        ComboEdit languageModel = (ComboEdit)this.getView().getControl("language_model");
        languageModel.setComboItems(comboItems);
        List varTypeComboItem = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit varType = (ComboEdit)this.getView().getControl("var_type");
        varType.setComboItems(varTypeComboItem);
        ComboEdit outVarType = (ComboEdit)this.getView().getControl("out_var_type");
        outVarType.setComboItems(varTypeComboItem);
        DynamicObjectCollection outVars = this.getModel().getEntryEntity("out_var_configs");
        if (outVars == null || outVars.isEmpty()) {
            this.setOutPreVar();
        } else {
            for (int i = 0; i < outVars.size(); ++i) {
                ArrayList<String> list = new ArrayList<String>();
                String outVar = ((DynamicObject)outVars.get(i)).getString("out_var");
                if (OutPreVar.GPT_OUTPUT.getVar().equalsIgnoreCase(outVar)) {
                    list.add("out_var");
                    list.add("out_var_name");
                    list.add("out_var_type");
                } else if (OutPreVar.RESONING_OUTPUT.getVar().equalsIgnoreCase(outVar)) {
                    list.add("out_var");
                    list.add("out_var_name");
                    list.add("out_var_type");
                    list.add("out_json_analysis");
                } else {
                    list.add("out_json_analysis");
                }
                this.getView().setEnable(Boolean.FALSE, i, list.toArray(new String[0]));
            }
        }
        DynamicObjectCollection docs = this.getModel().getEntryEntity("prompt_repo_config");
        for (int i = 0; i < docs.size(); ++i) {
            DynamicObject ddoc = ((DynamicObject)docs.get(i)).getDynamicObject("repoid");
            Object repoId = ddoc.getPkValue();
            DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)"file_total", (QFilter[])new QFilter[]{new QFilter("id", "=", repoId)});
            this.getModel().setValue("doc_total", (Object)repo.getInt("file_total"), i);
        }
        this.injectInfo();
        this.setStatus();
        if (!this.promptRepoEnable()) {
            this.setRepoConfigAdvVisible();
        }
    }

    private void setRepoConfigAdvVisible() {
        DynamicObjectCollection repoConfigDoc = this.getModel().getEntryEntity(this.KEY_PROMPT_REPO_CONFIG);
        if (repoConfigDoc != null && !repoConfigDoc.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"tap_newrepo"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.KEY_ADV_REPO_CONFIG});
        }
    }

    private boolean promptRepoEnable() {
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter("name", "=", (Object)"prompt_repo_enable").toArray());
        if (configs.length > 0) {
            String paramValue;
            String value = configs[0].getString("value");
            String valueTag = configs[0].getString("value_tag");
            String string = paramValue = kd.bos.util.StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
            if ("1".equalsIgnoreCase(paramValue)) {
                return true;
            }
        }
        return false;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "var_configs": {
                this.injectInfo();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            this.getModel().setValue("isdraft", (Object)false);
        } else if (source instanceof NewEntry) {
            String entityId;
            switch (entityId = ((NewEntry)source).getEntityId()) {
                case "var_configs": {
                    int customSize;
                    DynamicObjectCollection customRows = this.getView().getModel().getEntryEntity("var_configs");
                    int totalSize = customSize = Objects.nonNull(customRows) ? customRows.size() : 0;
                    if (totalSize < 5) break;
                    String message = ResManager.loadKDString((String)"\u53d8\u91cf\u4e2a\u6570\u9650\u52365\u4e2a\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u6dfb\u52a0\u3002", (String)"GaiPromptPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    args.setCancel(true);
                }
            }
        } else if (source instanceof Donothing) {
            Donothing donothing = (Donothing)source;
            String operate = donothing.getOperateKey();
            if (operate.equals("expand")) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(this.prompt_content_form);
                OpenStyle openStyle = fsp.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                StyleCss inlineStyleCss = new StyleCss();
                inlineStyleCss.setWidth("1080");
                inlineStyleCss.setHeight("92%");
                openStyle.setInlineStyleCss(inlineStyleCss);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.prompt_content_form));
                String centent = (String)this.getModel().getValue("prompt_tag");
                fsp.setCustomParam("content", (Object)centent);
                this.getView().showForm(fsp);
            } else if (operate.equals("custom_newrepo")) {
                Object[] selectedIdArr = this.getSelectedIdArr();
                String billFormId = "gai_repo_info";
                ListShowParameter lsp = new ListShowParameter();
                lsp.setShowApproved(true);
                lsp.setSelectedRows(selectedIdArr);
                lsp.setBillFormId(billFormId);
                lsp.setFormId("bos_listf7");
                lsp.getOpenStyle().setShowType(ShowType.Modal);
                lsp.setShowTitle(false);
                StyleCss inlineStyleCss = new StyleCss();
                inlineStyleCss.setHeight("700");
                inlineStyleCss.setWidth("1200");
                lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
                lsp.setLookUp(true);
                lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), billFormId));
                this.getView().showForm((FormShowParameter)lsp);
            } else if (operate.equalsIgnoreCase(AI_GENERATE)) {
                this.optimizePrompt();
            } else if (operate.equals("advanced_style")) {
                this.showCustomStyle();
            }
        }
    }

    private void showCustomStyle() {
        if (this.requiredValidate()) {
            String strStyle = this.getModel().getValue("model_style").toString();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("gai_prompt_style");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            String serviceNumber = (String)this.getModel().getValue("language_model");
            String customStyle = (String)this.getModel().getValue("customstyle");
            formShowParameter.setCustomParam("serviceNumber", (Object)serviceNumber);
            formShowParameter.setCustomParam("llmStyle", (Object)strStyle);
            formShowParameter.setCustomParam("customstyle", (Object)customStyle);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gai_prompt_style_callback"));
            this.getView().showForm(formShowParameter);
        }
    }

    private boolean requiredValidate() {
        OrmLocaleValue nameOlv = (OrmLocaleValue)this.getModel().getValue("name");
        String serviceNumber = (String)this.getModel().getValue("language_model");
        if (StringUtils.isEmpty((CharSequence)nameOlv.getLocaleValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u540d\u79f0\u3002", (String)"GaiPromptPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)serviceNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8bed\u8a00\u6a21\u578b\u3002", (String)"GaiPromptPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return false;
        }
        if (listTempServiceNumber != null) {
            boolean isExists = false;
            for (ComboItem comboItem : listTempServiceNumber) {
                if (!comboItem.getValue().equals(serviceNumber)) continue;
                isExists = true;
                break;
            }
            if (!isExists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b\u5bf9\u5e94\u7684\u7b97\u6cd5\u670d\u52a1\u4e0d\u5b58\u5728\u3002", (String)"GaiPromptTemplatePlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private Object[] getSelectedIdArr() {
        Object[] pkArr = new Object[]{};
        DynamicObjectCollection selectedDoc = this.getModel().getDataEntity(true).getDynamicObjectCollection("prompt_repo_config");
        if (selectedDoc != null) {
            pkArr = new Object[selectedDoc.size()];
            for (int i = 0; i < selectedDoc.size(); ++i) {
                DynamicObject doc = (DynamicObject)selectedDoc.get(i);
                pkArr[i] = doc.getDynamicObject("repoid").getPkValue();
            }
        }
        return pkArr;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (changeData[0] != null) {
            Object newValue = changeData[0].getNewValue();
            switch (key) {
                case "var": 
                case "var_name": {
                    this.injectInfo();
                    break;
                }
                case "out_var": {
                    DynamicObjectCollection outEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("out_var_configs");
                    if (!Objects.nonNull(outEntrys)) break;
                    HashSet<String> outVarSet = new HashSet<String>(outEntrys.size());
                    Pattern pattern = Pattern.compile(regex);
                    for (DynamicObject out : outEntrys) {
                        String outVar = out.getString("out_var");
                        if (!this.checkVar(true, pattern, outVarSet, outVar)) continue;
                        outEntrys.remove((Object)out);
                        this.getView().updateView("out_var_configs");
                        return;
                    }
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("out_var_configs");
                    String currenOutVar = (String)this.getModel().getValue("out_var", rowIndex);
                    if (!OutPreVar.GPT_OUTPUT.getVar().equalsIgnoreCase(currenOutVar)) break;
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"out_json_analysis"});
                    break;
                }
                case "language_model": {
                    this.updateModel(newValue);
                    break;
                }
                case "model_style": {
                    if (newValue.toString().toLowerCase().equals(LlmStyle.CUSTOM.getValue()) && this.isChanged) {
                        this.showCustomStyle();
                        break;
                    }
                    this.getModel().setValue("customstyle", null);
                    this.isChanged = true;
                }
            }
        }
    }

    private void updateModel(Object newValue) {
        if (newValue != null) {
            JSONArray jsonArray;
            Object modelTags;
            Optional<Map> firstMap;
            List servicesCache = GaiFieldTypeInitUtils.getServicesCache();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            boolean hasResoningOutput = false;
            if (servicesCache != null && !servicesCache.isEmpty() && (firstMap = servicesCache.stream().filter(map -> map.get("number").equals(newValue)).findFirst()).isPresent() && (modelTags = firstMap.get().get("modelTags")) != null && (jsonArray = JSON.parseArray((String)modelTags.toString())) != null && !jsonArray.isEmpty()) {
                for (Object arr : jsonArray) {
                    String tagKey = ((JSONObject)arr).getString("tagKey");
                    if (!tagKey.contains(ModelTagEnum.REASONING_CONTENT.getTagKey())) continue;
                    hasResoningOutput = true;
                    DynamicObjectCollection coll = dataEntity.getDynamicObjectCollection("out_var_configs");
                    Optional<DynamicObject> first = coll.stream().filter(obj -> OutPreVar.RESONING_OUTPUT.getVar().equals(obj.getString("out_var"))).findFirst();
                    if (first.isPresent()) continue;
                    DynamicObject billObj = this.getModel().getDataEntity(true);
                    EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)"out_var_configs");
                    DynamicObjectCollection rows = (DynamicObjectCollection)entryProp.getValue((Object)billObj);
                    EntryType entryType = (EntryType)entryProp.getItemType();
                    DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                    row.set("out_var", (Object)OutPreVar.RESONING_OUTPUT.getVar());
                    row.set("out_var_name", (Object)ResManager.loadKDString((String)"\u63a8\u7406\u8fc7\u7a0b\u8f93\u51fa", (String)"OutPreVar_1", (String)"ai-gai-core", (Object[])new Object[0]));
                    row.set("out_var_type", (Object)OutPreVar.RESONING_OUTPUT.getType().getType());
                    row.set("out_json_analysis", (Object)0);
                    rows.add((Object)row);
                    entryProp.setValue((Object)billObj, (Object)rows);
                    this.getView().setEnable(Boolean.FALSE, rows.size() - 1, new String[]{"out_var", "out_var_name", "out_var_type", "out_json_analysis"});
                    this.getView().updateView("out_var_configs");
                    break;
                }
            }
            if (!hasResoningOutput) {
                this.removeOutPutParam(dataEntity);
            }
            this.getModel().setValue("model_style", (Object)LlmStyle.CREATIVITY);
        }
    }

    private void removeOutPutParam(DynamicObject dataEntity) {
        DynamicObjectCollection outputDoc = dataEntity.getDynamicObjectCollection("out_var_configs");
        int resoningIndex = -1;
        if (outputDoc != null && !outputDoc.isEmpty()) {
            for (int i = 0; i < outputDoc.size(); ++i) {
                DynamicObject outputDo = (DynamicObject)outputDoc.get(i);
                String varKey = outputDo.getString("out_var");
                if (!OutPreVar.RESONING_OUTPUT.getVar().equals(varKey)) continue;
                resoningIndex = i;
                break;
            }
            if (resoningIndex >= 0) {
                this.getModel().deleteEntryRow("out_var_configs", resoningIndex);
                this.getView().updateView("out_var_configs");
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String fieldName = e.getKey();
        if ("language_model".equals(fieldName)) {
            String language_model = (String)e.getValue();
            List instanceList = AiccService.getAiccInstanceList();
            if (!instanceList.contains(language_model)) {
                this.getView().updateView(fieldName);
                e.setCancel(true);
                String message = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u8bed\u8a00\u6a21\u578b\uff0c\u8bf7\u8fdb\u5165\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u5217\u8868\u4e2d\u914d\u7f6e\u6a21\u578bAPI\u53c2\u6570\u3002", (String)"GaiPromptTemplatePlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OK);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "out_var_configs": {
                RowDataEntity[] rows;
                for (RowDataEntity row : rows = e.getRowDataEntities()) {
                    int rowIndex = row.getRowIndex();
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"out_json_analysis"});
                }
                break;
            }
        }
    }

    private void injectInfo() {
        HashMap<String, String> varMap = new HashMap<String, String>(5);
        DynamicObjectCollection custVars = this.getModel().getEntryEntity("var_configs");
        if (Objects.nonNull(custVars)) {
            for (DynamicObject custVar : custVars) {
                String var = custVar.getString("var");
                String varName = custVar.getString("var_name");
                if (!StringUtils.isNotEmpty((CharSequence)var) || !StringUtils.isNotEmpty((CharSequence)varName)) continue;
                varMap.put(var, varName);
            }
        }
        Map sendVarMapData = ResultVoHelper.buildInjectInfo(varMap);
        this.sendCustom(sendVarMapData);
        GaiUtils.newContextInPrompt((IFormView)this.getView());
    }

    private void setOutPreVar() {
        this.getModel().batchCreateNewEntryRow("out_var_configs", 1);
        this.getModel().setValue("out_var", (Object)OutPreVar.GPT_OUTPUT.getVar(), 0);
        this.getModel().setValue("out_var_name", (Object)ResManager.loadKDString((String)"GPT\u63d0\u793a\u8f93\u51fa", (String)"OutPreVar_0", (String)"ai-gai-core", (Object[])new Object[0]), 0);
        this.getModel().setValue("out_var_type", (Object)OutPreVar.GPT_OUTPUT.getType().getType(), 0);
        this.getModel().setValue("out_json_analysis", (Object)0, 0);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"out_var", "out_var_name", "out_var_type"});
        this.getView().updateView("out_var_configs");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_save": {
                IBillModel billModel = (IBillModel)this.getModel();
                DynamicObject dynamicObject = billModel.getDataEntity();
                String serviceNumber = dynamicObject.getString("language_model");
                QFilter qFilter = new QFilter("number", "=", (Object)serviceNumber);
                DynamicObject serviceObject = BusinessDataServiceHelper.loadSingle((String)this.aiccService, (String)"number,name", (QFilter[])new QFilter[]{qFilter});
                if (serviceObject != null) {
                    String serviceName = serviceObject.getString("name");
                    dynamicObject.set("service_name", (Object)serviceName);
                }
                if (this.checkVarAll(true)) {
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection outEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("out_var_configs");
                if (Objects.nonNull(outEntrys) && outEntrys.size() == 0) {
                    String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53d8\u91cf\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u3002", (String)"GaiServiceInfoPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    evt.setCancel(true);
                    return;
                }
                if (this.checkRepo()) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    private boolean checkRepo() {
        DynamicObjectCollection repoEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("prompt_repo_config");
        if (repoEntrys != null && !repoEntrys.isEmpty()) {
            String firstRepoType = "";
            for (DynamicObject repo : repoEntrys) {
                String type = repo.getString("repotype");
                if (repo.getDynamicObject("repoid") == null || StringUtils.isEmpty((CharSequence)type)) continue;
                if (StringUtils.isBlank((CharSequence)firstRepoType)) {
                    firstRepoType = type;
                    continue;
                }
                if (firstRepoType.equals(type)) continue;
                String message = ResManager.loadKDString((String)"\u8bf7\u5173\u8054\u540c\u7c7b\u578b\u7684\u77e5\u8bc6\u5e93\u3002", (String)"GaiServiceInfoPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return false;
            }
        }
        return true;
    }

    private boolean checkVarAll(boolean showTop) {
        DynamicObjectCollection customRows = this.getModel().getEntryEntity("var_configs");
        int customSize = Objects.nonNull(customRows) ? customRows.size() : 0;
        HashSet<String> varSet = new HashSet<String>(customSize);
        Pattern pattern = Pattern.compile(regex);
        if (Objects.nonNull(customRows)) {
            for (DynamicObject row : customRows) {
                String varValue = row.getString("var");
                if (!this.checkVar(showTop, pattern, varSet, varValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkVar(boolean showTop, Pattern pattern, Set<String> varSet, String varValue) {
        boolean status;
        boolean bl = status = !pattern.matcher(varValue).find();
        if (status) {
            if (showTop) {
                String message = ResManager.loadKDString((String)"\u53d8\u91cf\u53ea\u80fd\u8f93\u5165\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"GaiServiceInfoPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
            }
            return true;
        }
        if (varSet.contains(varValue)) {
            if (showTop) {
                String message = ResManager.loadKDString((String)"\u53d8\u91cf\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"GaiServiceInfoPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
            }
            return true;
        }
        varSet.add(varValue);
        return false;
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        Map<String, Object> resp = this.invokeCustom(this.getView(), eventName, eventArgs);
        this.sendCustom(resp);
        switch (eventName) {
            case "getChatInfo": {
                DynamicObjectCollection outEntrys;
                String modelStyle;
                String languageModel;
                String name;
                StringBuilder msg = new StringBuilder();
                boolean configSus = true;
                DynamicObject prampt = this.getModel().getDataEntity(true);
                String number = prampt.getString("number");
                if (StringUtils.isEmpty((CharSequence)number)) {
                    if (StringUtils.isNotEmpty((CharSequence)msg)) {
                        msg.append("\u3001");
                    }
                    msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"GaiPromptTemplatePlugin_15173846", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    configSus = false;
                }
                if (StringUtils.isEmpty((CharSequence)(name = prampt.getString("name")))) {
                    if (StringUtils.isNotEmpty((CharSequence)msg)) {
                        msg.append("\u3001");
                    }
                    msg.append(ResManager.loadKDString((String)"\u540d\u79f0", (String)"GaiPromptTemplatePlugin_15173847", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    configSus = false;
                }
                if (StringUtils.isEmpty((CharSequence)(languageModel = prampt.getString("language_model")))) {
                    if (StringUtils.isNotEmpty((CharSequence)msg)) {
                        msg.append("\u3001");
                    }
                    msg.append(ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b", (String)"GaiPromptTemplatePlugin_15173848", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    configSus = false;
                }
                if (StringUtils.isEmpty((CharSequence)(modelStyle = prampt.getString("model_style")))) {
                    if (StringUtils.isNotEmpty((CharSequence)msg)) {
                        msg.append("\u3001");
                    }
                    msg.append(ResManager.loadKDString((String)"\u6a21\u578b\u98ce\u683c", (String)"GaiPromptTemplatePlugin_15173849", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    configSus = false;
                }
                String customStyle = prampt.getString("customstyle");
                String promptStr = prampt.getString("prompt_tag");
                if (StringUtils.isNotEmpty((CharSequence)msg.toString())) {
                    msg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"GaiPromptTemplatePlugin_15173850", (String)"ai-gai-plugin", (Object[])new Object[0]));
                    this.getView().showTipNotification(msg.toString());
                }
                if (this.checkVarAll(true)) {
                    configSus = false;
                }
                if (Objects.nonNull(outEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("out_var_configs")) && outEntrys.size() == 0) {
                    String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53d8\u91cf\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u3002", (String)"GaiServiceInfoPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    configSus = false;
                }
                Map resultMap = ResultVoHelper.buildGetChatInfo((String)languageModel, (String)modelStyle, (String)customStyle, (String)promptStr, (boolean)configSus);
                this.sendCustom(resultMap);
            }
        }
    }

    private void sendCustom(Map<String, Object> resp) {
        CustomControl ctrl = (CustomControl)this.getControl("gai_gpt_playground");
        if (ctrl != null) {
            ctrl.setData(resp);
        }
    }

    private Map<String, Object> invokeCustom(IFormView formView, String eventName, String eventArgs) {
        logger.info("customEventName:{} {}", (Object)eventName, (Object)System.currentTimeMillis());
        RequestActionType requestActionType = RequestActionType.valueOf((String)eventName);
        JSONObject requestData = JSONObject.parseObject((String)eventArgs);
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String chatSessionId = requestData.getString("id");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)chatSessionId) && !kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)requestActionType.name(), (CharSequence)RequestActionType.newChat.name())) {
            chatSessionId = this.getChatSessionId();
        }
        Context context = null;
        switch (requestActionType) {
            case initial: {
                GaiUtils.newContextInPrompt((IFormView)this.getView());
                chatSessionId = this.getChatSessionId();
                GaiInitConfig gaiInitConfig = new GaiInitConfig(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, SLIDEENV.PLAYGROUND, chatSessionId, null, null);
                GaiUtils.setUserAgree((GaiInitConfig)gaiInitConfig, (Long)RequestContext.get().getCurrUserId());
                resultMap = ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig);
                break;
            }
            case newChat: {
                GaiUtils.newContextInPrompt((IFormView)this.getView());
                chatSessionId = this.getChatSessionId();
                context = FlowCacheData.getContext((String)chatSessionId);
                JSONObject dataJo = new JSONObject();
                String timestamp = requestData.getString("timestamp");
                if (StringUtils.isNotEmpty((CharSequence)timestamp)) {
                    dataJo.put("timestamp", (Object)timestamp);
                }
                dataJo.put("id", (Object)chatSessionId);
                resultMap = ResultVoHelper.buildResult((String)ResultActionType.newChat.name(), (Object)dataJo, (Context)context);
                break;
            }
            case preview: {
                ContextData.Item item = (ContextData.Item)JSON.parseObject((String)String.valueOf(requestData), ContextData.Item.class);
                AbstractGaiAssistantPlugin.preview(this.getView(), item);
                break;
            }
            case playgroundChat: {
                FlowCacheData.clearCache((String)chatSessionId, (String)"flowCancelled");
                context = FlowCacheData.getContext((String)chatSessionId);
                boolean stream = requestData.getBoolean("stream");
                String promptTemplate = requestData.getString("promptTemplate");
                DynamicObject promptInfo = this.getModel().getDataEntity(true);
                boolean isEncrypted = (Boolean)this.getModel().getValue("isencrypted");
                if (isEncrypted) {
                    promptTemplate = this.getView().getPageCache().get(key_prompt_encrypted_context);
                }
                String input = requestData.getString("input");
                String serviceNumber = requestData.getString("llm");
                Map service = AiccService.queryLlmAiccService((String)serviceNumber);
                if (service == null || service.isEmpty()) {
                    String msg = ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b\u5bf9\u5e94\u7684\u7b97\u6cd5\u670d\u52a1\u4e0d\u5b58\u5728\u3002", (String)"GaiPromptTemplatePlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
                String llmNumber = (String)service.get("llm");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)llmNumber)) {
                    llmNumber = serviceNumber;
                }
                LLM llm = LLM.parse((String)llmNumber);
                LlmStyle llmStyle = LlmStyle.parse((String)requestData.getString("llmStyle"));
                String customStyle = "";
                if (llmStyle == LlmStyle.CUSTOM) {
                    customStyle = requestData.getString("llmCustomStyle");
                }
                Map variableMap = GaiUtils.toMap((JSONObject)requestData.getJSONObject("variableMap"));
                DynamicObjectCollection repos = promptInfo.getDynamicObjectCollection("prompt_repo_config");
                ArrayList<Long> repoIds = new ArrayList<Long>(repos.size());
                for (DynamicObject repoRow : repos) {
                    DynamicObject repo = repoRow.getDynamicObject("repoid");
                    repoIds.add((Long)repo.getPkValue());
                }
                BigDecimal count = promptInfo.getBigDecimal("remembercount");
                Prompt prompt = new Prompt();
                prompt.setId(((Long)this.getModel().getValue("id")).longValue());
                prompt.setLlm(llm);
                prompt.setServiceNumber(serviceNumber);
                prompt.setLlmStyle(llmStyle);
                prompt.setCustomStyle(customStyle);
                prompt.setPrompt(promptTemplate);
                prompt.setRemembercount(count.intValue());
                prompt.setRepoIds(repoIds);
                String outmessage = ResManager.loadKDString((String)"GPT\u63d0\u793a\u8f93\u51fa", (String)"GaiPromptTemplatePlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                prompt.setPromptOutVarList(Collections.singletonList(new PromptOutVar("prompt_output", outmessage, OutFieldType.STRING.getType(), false)));
                prompt.setCreateTime((Date)this.getModel().getValue("createtime"));
                try {
                    Result result = this.sendAsync(input, prompt, stream, variableMap);
                    if (!result.getErrorCode().equals((Object)Errors.FAKE_OK)) break;
                    resultMap = ResultVoHelper.buildFakeErrMsg((String)Errors.LLM_ERROR.getCode(), (String)result.getErrorCode().getMessage(), null);
                }
                catch (Exception e) {
                    logger.error("GaiPrompt\u9519\u8bef", (Throwable)e);
                    if (e instanceof KDBizException) {
                        IPageCache chatSessionInfo = this.getView().getPageCache();
                        chatSessionId = chatSessionInfo.get("chatSessionId");
                        String errorCode = ((KDBizException)((Object)e)).getErrorCode().getCode();
                        String message = ((KDBizException)((Object)e)).getErrorCode().getMessage();
                        resultMap = ResultVoHelper.buildErrMsg((String)errorCode, (String)message, (String)chatSessionId, (Context)context);
                        break;
                    }
                    resultMap = ResultVoHelper.buildErrMsg((String)Errors.LLM_ERROR.getCode(), (String)e.getMessage(), (String)chatSessionId, (Context)context);
                }
                break;
            }
            case stopStream: {
                String taskId = requestData.getString("taskId");
                context = FlowCacheData.getContext((String)chatSessionId);
                StopStreamMessage stopStreamMessage = new StopStreamMessage();
                stopStreamMessage.setTaskId(taskId);
                stopStreamMessage.setFlowId(0L);
                Result result = HandlerFactory.runHandler((Context)context, (Message)stopStreamMessage);
                String message = ResManager.loadKDString((String)"\u63d0\u793a\u8bcd\u6d4b\u8bd5\u5173\u95ed\u6d41\u4fe1\u606f\u8f93\u51fa:{}\u3002", (String)"GaiServiceInfoPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]);
                logger.info(message, (Object)JsonUtil.toJson((Object)result));
                break;
            }
            case showAgreement: {
                String pageId = this.getView().getPageCache().get("showAgreement");
                if (StringUtils.isNotEmpty((CharSequence)pageId)) break;
                this.getView().getPageCache().put("showAgreement", "true");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("gai_privacy_agreement");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "agreementClose"));
                fsp.setCustomParam("agreementType", (Object)"userAgreement");
                this.getView().showForm(fsp);
            }
            default: {
                resultMap = new HashMap();
            }
        }
        return resultMap;
    }

    private String getChatSessionId() {
        return this.getView().getPageCache().get("chatSessionId");
    }

    private Result sendAsync(String input, Prompt prompt, boolean stream, Map<String, String> varParams) {
        IPageCache chatSessionInfo = this.getView().getPageCache();
        String chatSessionId = chatSessionInfo.get("chatSessionId");
        PromptTestCallbackMessage callbackMessage = new PromptTestCallbackMessage("gai_gpt_playground");
        callbackMessage.setChatSessionId(chatSessionId);
        callbackMessage.setParseOutput(true);
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage((LLMParsedMessage)callbackMessage);
        llmMessage.setUserInput(input);
        llmMessage.setPrompt(prompt);
        llmMessage.setStream(stream);
        llmMessage.setParamMap(varParams);
        MessageService.insertMessage((String)chatSessionId, (String)input, (String)"", null, null, (ChatMessageTypeEnum)ChatMessageTypeEnum.USER, (EnableEnum)EnableEnum.NO);
        return HandlerFactory.runHandler((Context)FlowCacheData.getContext((String)chatSessionId), (Message)llmMessage);
    }

    private void setStatus() {
        boolean isView;
        boolean isEncrypted = (Boolean)this.getModel().getValue("isencrypted");
        boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        boolean bl = isView = this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW;
        if (isEncrypted) {
            String promptInfo = this.getModel().getDataEntity(true).getString("prompt_tag");
            this.getView().getPageCache().put(key_prompt_encrypted_context, promptInfo);
            this.getModel().setValue("prompt", (Object)ResManager.loadKDString((String)"\u8be5\u63d0\u793a\u8bcd\u5df2\u88ab\u52a0\u5bc6", (String)"GaiPromptTemplatePlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
            this.getModel().setValue("prompt_tag", (Object)ResManager.loadKDString((String)"\u8be5\u63d0\u793a\u8bcd\u5df2\u88ab\u52a0\u5bc6", (String)"GaiPromptTemplatePlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
            this.getView().updateView("prompt");
            this.getView().updateView("prompt_tag");
        }
        if (isEncrypted || isPreset || isView) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"newentry", "deleteentry", "moveentryup", "moveentrydown", "newentry_out", "deleteentry_out", "moveentryup_out", "moveentrydown_out", "advconbaritemap2", "tap_newrepo", "advconbaritemap3", "advconbaritemap4", "advconbaritemap5"});
            if (isView) {
                this.getView().setEnable(Boolean.FALSE, new String[]{FROM_TEMPLATE, "lab_advanced", "buttonap1", "labelap1", VECTORAP_OPTIMIZE, "baritemap1", "baritemap", bar_save, FLEX_OPTIMIZE, "vectorap"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            if (TO_TEMPLATE.equals(actionId)) {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
                if (!listSelectedRowCollection.isEmpty()) {
                    ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
                    long templateGroupId = (Long)listSelectedRow.getPrimaryKeyValue();
                    DynamicObject promptDo = this.getModel().getDataEntity(true);
                    this.copy2PromptOrTemplate(promptDo, GaiFormIdEnum.GAI_PROMPT_TEMPLATE, templateGroupId);
                }
            } else if (FROM_TEMPLATE.equals(actionId)) {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
                if (!listSelectedRowCollection.isEmpty()) {
                    this.getModel().deleteEntryData("var_configs");
                    this.getModel().deleteEntryData("out_var_configs");
                    this.getModel().deleteEntryData("prompt_repo_config");
                    ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
                    Object templatePk = listSelectedRow.getPrimaryKeyValue();
                    DynamicObject templateDo = BusinessDataServiceHelper.loadSingle((Object)templatePk, (String)GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
                    this.copy2PromptOrTemplate(templateDo, GaiFormIdEnum.GAI_PROMPT, 0L);
                }
            } else {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
                if (!listSelectedRowCollection.isEmpty()) {
                    String billFormId;
                    DynamicObject[] doArr;
                    Object[] idArr = new Object[listSelectedRowCollection.size()];
                    for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                        ListSelectedRow listSelectedRow = listSelectedRowCollection.get(i);
                        idArr[i] = listSelectedRow.getPrimaryKeyValue();
                    }
                    this.getModel().deleteEntryData("prompt_repo_config");
                    if (idArr != null && idArr.length > 0 && (doArr = BusinessDataServiceHelper.load((Object[])idArr, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)(billFormId = "gai_repo_info")).getDynamicObjectType())) != null && doArr.length > 0) {
                        int i;
                        DynamicObject[] arr = new DynamicObject[doArr.length];
                        for (i = 0; i < doArr.length; ++i) {
                            for (int j = 0; j < idArr.length; ++j) {
                                if (!doArr[i].getString("id").equals(idArr[j].toString())) continue;
                                arr[j] = doArr[i];
                            }
                        }
                        this.getModel().batchCreateNewEntryRow("prompt_repo_config", arr.length);
                        for (i = 0; i < arr.length; ++i) {
                            DynamicObject repoDObj = arr[i];
                            this.getModel().setValue("repoid", (Object)repoDObj, i);
                            this.getModel().setValue("doc_total", (Object)repoDObj.getInt("file_total"), i);
                            this.getModel().setValue("repotype", (Object)repoDObj.getString("type"), i);
                        }
                    }
                }
            }
            return;
        }
        this.getView().getPageCache().remove("showAgreement");
        if ("agreementClose".equals(actionId)) {
            CustomControl customControl = (CustomControl)this.getControl("gai_gpt_playground");
            returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            String chatSessionId = this.getView().getPageCache().get("chatSessionId");
            GaiInitConfig gaiInitConfig = new GaiInitConfig(chatSessionId);
            if ("userAgree".equals(returnData)) {
                gaiInitConfig.setUserAgree(true);
            } else if ("userDisagree".equals(returnData)) {
                gaiInitConfig.setUserAgree(false);
            }
            Map resultMap = ResultVoHelper.buildUserAgree((GaiInitConfig)gaiInitConfig);
            customControl.setData((Object)resultMap);
        } else if (this.prompt_content_form.equals(actionId)) {
            this.getModel().setValue("prompt_tag", evt.getReturnData());
            this.getView().addClientCallBack("prompt_tag");
            if (evt.getReturnData() == null || StringUtils.isEmpty((CharSequence)((String)evt.getReturnData()))) {
                this.getView().addClientCallBack(UPDATE_PROMPT_VALUE_2_EMPTY);
            }
        } else if ("simpleChatResult".equals(actionId)) {
            if (evt.getReturnData() != null) {
                JSONObject resultJo = (JSONObject)evt.getReturnData();
                String message = resultJo.getString("message");
                this.getModel().setValue("prompt_tag", (Object)message);
                this.getView().addClientCallBack("prompt_tag");
                if (StringUtils.isEmpty((CharSequence)message)) {
                    this.getView().addClientCallBack(UPDATE_PROMPT_VALUE_2_EMPTY);
                }
            }
        } else if ("gai_prompt_style_callback".equals(actionId) && evt.getReturnData() != null) {
            this.isChanged = false;
            JSONObject resultJo = (JSONObject)evt.getReturnData();
            this.getModel().setValue("model_style", (Object)LlmStyle.CUSTOM.getValue().toUpperCase());
            this.getModel().setValue("customstyle", (Object)SerializationUtils.toJsonString((Object)resultJo));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e.getName().equals(UPDATE_PROMPT_VALUE_2_EMPTY)) {
            this.getModel().setValue("prompt", null);
            this.getModel().setValue("prompt_tag", null);
            this.getView().updateView();
        } else if (e.getName().equals("prompt_tag")) {
            this.getView().updateView("prompt");
            this.getView().updateView("prompt_tag");
            this.getView().updateView("var_configs");
            this.getView().updateView("out_var_configs");
            this.getView().updateView("prompt_repo_config");
        }
    }

    private void copy2PromptOrTemplate(DynamicObject sourceDo, GaiFormIdEnum targetFormId, long templateGroupId) {
        boolean toPrompt = targetFormId == GaiFormIdEnum.GAI_PROMPT;
        DynamicObject targetDataEntity = this.getModel().getDataEntity(true);
        DynamicObject targetDo = toPrompt ? targetDataEntity : BusinessDataServiceHelper.newDynamicObject((String)targetFormId.getId());
        targetDo.set("name", (Object)targetDo.getLocaleString("name"));
        targetDo.set("desc", (Object)sourceDo.getString("desc"));
        if (templateGroupId != 0L) {
            targetDo.set("group", (Object)templateGroupId);
        } else {
            targetDo.set("group", null);
        }
        targetDo.set("language_model", (Object)sourceDo.getString("language_model"));
        targetDo.set("model_style", (Object)sourceDo.getString("model_style"));
        targetDo.set("prompt", (Object)sourceDo.getString("prompt"));
        targetDo.set("prompt_tag", (Object)sourceDo.getString("prompt_tag"));
        targetDo.set("remembercount", (Object)sourceDo.getBigDecimal("remembercount"));
        targetDo.set("isencrypted", sourceDo.get("isencrypted"));
        targetDo.set("blgids", sourceDo.get("blgids"));
        targetDo.set("service_name", sourceDo.get("service_name"));
        DynamicObjectCollection varConfigsDoc = sourceDo.getDynamicObjectCollection("var_configs");
        DynamicObjectCollection tplVarConfigsDoc = targetDo.getDynamicObjectCollection("var_configs");
        for (DynamicObject tempDo : varConfigsDoc) {
            DynamicObject newDo = tplVarConfigsDoc.addNew();
            newDo.set("var", tempDo.get("var"));
            newDo.set("var_name", tempDo.get("var_name"));
            newDo.set("var_type", tempDo.get("var_type"));
        }
        DynamicObjectCollection outVarConfigsDoc = sourceDo.getDynamicObjectCollection("out_var_configs");
        DynamicObjectCollection tplOutVarConfigsDoc = targetDo.getDynamicObjectCollection("out_var_configs");
        for (DynamicObject tempDo : outVarConfigsDoc) {
            DynamicObject newDo = tplOutVarConfigsDoc.addNew();
            newDo.set("out_var", tempDo.get("out_var"));
            newDo.set("out_var_name", tempDo.get("out_var_name"));
            newDo.set("out_var_type", tempDo.get("out_var_type"));
            newDo.set("out_json_analysis", tempDo.get("out_json_analysis"));
        }
        DynamicObjectCollection repoConfigDoc = sourceDo.getDynamicObjectCollection("prompt_repo_config");
        DynamicObjectCollection tplRepoConfigDoc = targetDo.getDynamicObjectCollection("prompt_repo_config");
        for (DynamicObject tempDo : repoConfigDoc) {
            DynamicObject newDo = tplRepoConfigDoc.addNew();
            newDo.set("repoid", tempDo.get("repoid"));
            newDo.set("repo_name", tempDo.get("repo_name"));
            newDo.set("repotype", tempDo.get("repotype"));
        }
        long targetPk = ID.genLongId();
        long targetMasterId = targetDo.getLong("masterid");
        targetDo.set("id", targetDo.getPkValue() != null && (Long)targetDo.getPkValue() > 0L ? targetDo.getPkValue() : Long.valueOf(targetPk));
        targetDo.set("masterid", (Object)(targetMasterId > 0L ? targetMasterId : targetPk));
        targetDo.set("status", sourceDo.get("status"));
        targetDo.set("enable", sourceDo.get("enable"));
        targetDo.set("ctrlstrategy", (Object)CtrlStrategyEnum.ALL.getId());
        this.resetCreateInfo(targetDo, true, true);
        if (toPrompt) {
            String oldChatSessionId = this.getChatSessionId();
            String oldControlstates = this.getView().getPageCache().get("controlstates");
            this.getView().updateView();
            this.getView().getPageCache().put("chatSessionId", oldChatSessionId);
            this.getView().getPageCache().put("controlstates", oldControlstates);
        } else {
            String number = targetDo.getString("number");
            if (StringUtils.isEmpty((CharSequence)number) || StringUtils.contains((CharSequence)number, (CharSequence)ResManager.loadKDString((String)"\u968f\u673a\u7801", (String)"GaiPromptTemplatePlugin_15173853", (String)"ai-gai-plugin", (Object[])new Object[0]))) {
                number = CodeRuleServiceHelper.getNumber((String)targetFormId.getId(), (DynamicObject)targetDo, (String)String.valueOf(RequestContext.get().getOrgId()));
            }
            targetDo.set("number", (Object)number);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetDo});
            Long useOrgId = ((DynamicObject)targetDo.get("useorg")).getLong("id");
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)targetDo, (Long)useOrgId);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(targetDo.getPkValue());
            billShowParameter.setFormId(targetFormId.getId());
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(targetFormId == GaiFormIdEnum.GAI_PROMPT_TEMPLATE ? ShowType.MainNewTabPage : ShowType.InCurrentForm);
            billShowParameter.setOpenStyle(openStyle);
            billShowParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void resetCreateInfo(DynamicObject updateDo, boolean resetUser, boolean resetOrg) {
        RequestContext rc = RequestContext.get();
        if (resetUser) {
            updateDo.set("creator", (Object)rc.getCurrUserId());
            updateDo.set("modifier", (Object)rc.getCurrUserId());
        }
        if (resetOrg) {
            updateDo.set("org", (Object)this.getCreateOrg());
            updateDo.set("createorg", (Object)this.getCreateOrg());
            updateDo.set("useorg", (Object)this.getCreateOrg());
        }
        updateDo.set("createtime", (Object)KDDateUtils.now());
        updateDo.set("modifytime", (Object)KDDateUtils.now());
    }

    private DynamicObject getCreateOrg() {
        if (this.createOrg == null) {
            this.createOrg = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getOrgId(), (String)"bos_org", (String)String.format("%s,%s,%s", "id", "name", "number"));
        }
        return this.createOrg;
    }
}

