/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.prompt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.PromptTestCallbackMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.field.type.OutFieldType;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.plugin.AbstractGaiAssistantPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SimpleChatPlugin
extends AbstractGaiAssistantPlugin {
    private static final Log log = LogFactory.getLog(SimpleChatPlugin.class);
    private static final String GAI_OPTIMIZATION_STREAM = "gai_optimization_stream";
    private static final String START_OPTIMIZE_PROMPT_CALL_BACK = "startOptimizePrompt";

    @Override
    public void beforeBindData(EventObject e) {
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        formShowParameter.setCustomParam("slideEnv", (Object)SLIDEENV.SIMPLE_CHAT);
        this.assistantInit(formView, 10000L);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().addClientCallBack(START_OPTIMIZE_PROMPT_CALL_BACK, Integer.valueOf(1000));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (e.getName().equals(START_OPTIMIZE_PROMPT_CALL_BACK)) {
            this.startOptimizePrompt();
        }
    }

    private void startOptimizePrompt() {
        String chatSessionId = this.getChatSessionId();
        FlowCacheData.clearCache((String)chatSessionId, (String)"flowCancelled");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String userInput = (String)fsp.getCustomParam("userInput");
        String serviceNumber = (String)fsp.getCustomParam("serviceNumber");
        Map service = AiccService.queryLlmAiccService((String)serviceNumber);
        if (service == null || service.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b\u5bf9\u5e94\u7684\u7b97\u6cd5\u670d\u52a1\u4e0d\u5b58\u5728\u3002", (String)"SimpleChatPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String llmNumber = (String)service.get("llm");
        if (StringUtils.isEmpty((CharSequence)llmNumber)) {
            llmNumber = serviceNumber;
        }
        LLM llm = LLM.parse((String)llmNumber);
        LlmStyle llmStyle = LlmStyle.parse((String)LlmStyle.PRECISION.getValue());
        HashMap<String, String> variableMap = new HashMap<String, String>(0);
        ArrayList repoIds = new ArrayList(0);
        Prompt prompt = new Prompt();
        prompt.setId(2002989110637102080L);
        prompt.setLlm(llm);
        prompt.setServiceNumber(serviceNumber);
        prompt.setLlmStyle(llmStyle);
        prompt.setRemembercount(0);
        prompt.setRepoIds(repoIds);
        String outmessage = ResManager.loadKDString((String)"GPT\u63d0\u793a\u8f93\u51fa", (String)"SimpleChatPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        prompt.setPromptOutVarList(Collections.singletonList(new PromptOutVar("prompt_output", outmessage, OutFieldType.STRING.getType(), false)));
        try {
            this.sendAsync(chatSessionId, userInput, prompt, true, variableMap);
        }
        catch (Exception ex) {
            log.error("GaiSimpleChat\u9519\u8bef", (Throwable)ex);
            if (ex instanceof KDBizException) {
                String message = ((KDBizException)((Object)ex)).getErrorCode().getMessage();
                this.getView().showErrorNotification(message);
            } else {
                this.getView().showErrorNotification(ex.getMessage());
            }
            this.waitDoneWithError(chatSessionId);
        }
    }

    private void sendAsync(String chatSessionId, String input, Prompt prompt, boolean stream, Map<String, String> varParams) {
        PromptTestCallbackMessage callbackMessage = new PromptTestCallbackMessage("gai_gpt_playground");
        callbackMessage.setChatSessionId(chatSessionId);
        callbackMessage.setParseOutput(true);
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage((LLMParsedMessage)callbackMessage);
        llmMessage.setUserInput(input);
        llmMessage.setPrompt(prompt);
        llmMessage.setStream(stream);
        llmMessage.setParamMap(varParams);
        HandlerFactory.runHandler((Context)FlowCacheData.getContext((String)chatSessionId), (Message)llmMessage);
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        RequestActionType requestActionType = RequestActionType.valueOf((String)eventName);
        JSONObject requestData = JSON.parseObject((String)eventArgs);
        if (requestActionType == RequestActionType.confirm) {
            this.getView().returnDataToParent((Object)requestData);
            this.getView().close();
            return;
        }
        if (requestActionType == RequestActionType.cancel) {
            this.getView().close();
            return;
        }
        if (requestActionType == RequestActionType.error) {
            this.getView().showErrorNotification(requestData.getString("desc"));
            return;
        }
        super.customEvent(e);
    }

    private void waitDoneWithError(String chatSessionId) {
        Context context = FlowCacheData.getContext((String)chatSessionId);
        Map data = ResultVoHelper.buildWaitingDone((String)chatSessionId, (Context)context);
        CustomControl customControl = (CustomControl)this.getControl(GAI_OPTIMIZATION_STREAM);
        customControl.setData((Object)data);
    }

    private void assistantInit(IFormView formView, Long assId) {
        RootPageIdContext rootPageIdContext = GaiUtils.newContextInSlideWithNoSkill((IFormView)formView, null, (long)assId);
        GaiInitConfig gaiInitConfig = new GaiInitConfig();
        gaiInitConfig.setChatSessionId(rootPageIdContext.getChatSessionId());
        CustomControl customControl = (CustomControl)this.getControl(GAI_OPTIMIZATION_STREAM);
        Map data = ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig);
        customControl.setData((Object)data);
    }
}

