/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.ai.gai.plugin.repo.StructRepoUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.util.StringUtils;

public abstract class AbstractStructRepoDataEditPlugin
extends AbstractBillPlugIn {
    protected static String CACHEKEY_STRUCT_REPO_FIELDS = "STRUCT_REPO_FIELDS";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object pkStructRepo = this.getStructRepoId();
        if (pkStructRepo != null) {
            this.getModel().setValue("structrepo", pkStructRepo);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object pkStructRepo = this.getStructRepoId();
        if (pkStructRepo == null) {
            return;
        }
        String cacheFields = this.getPageCache().get(CACHEKEY_STRUCT_REPO_FIELDS);
        if (StringUtils.isEmpty((String)cacheFields)) {
            return;
        }
        List fieldDefinitionList = GaiStructRepoHelper.queryStructRepoFields((long)((Long)pkStructRepo));
        this.getPageCache().put(CACHEKEY_STRUCT_REPO_FIELDS, SerializationUtils.serializeToBase64((Object)fieldDefinitionList));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initConrolForDataFields();
    }

    private Object getStructRepoId() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        return billShowParameter.getCustomParam("StructRepoID");
    }

    private List<StructRepoField> getStructRepoFields() {
        String cacheFields = this.getPageCache().get(CACHEKEY_STRUCT_REPO_FIELDS);
        if (StringUtils.isEmpty((String)cacheFields)) {
            return Collections.emptyList();
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)cacheFields);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("structrepo")) {
            this.initConrolForDataFields();
        }
    }

    private void initConrolForDataFields() {
        Object pkStructRepo = this.getModel().getValue("structrepo");
        if (pkStructRepo == null) {
            return;
        }
        List<StructRepoField> fieldDefinitionList = this.getStructRepoFields();
        List<String> hideFieldKeys = StructRepoUtil.getDataFieldKeys();
        fieldDefinitionList.forEach(fieldDefinition -> {
            LargeTextOtherEdit textEdit = (LargeTextOtherEdit)this.getControl(fieldDefinition.getFieldName());
            textEdit.setCaption(new LocaleString(fieldDefinition.getName()));
            hideFieldKeys.remove(fieldDefinition.getFieldName());
        });
        this.getView().setVisible(Boolean.FALSE, hideFieldKeys.toArray(new String[0]));
    }
}

