/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.repo.entity.StructRepoField;
import kd.ai.gai.core.repo.helper.GaiStructRepoHelper;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public abstract class AbstractStructRepoDataTreeListPlugin
extends StandardTreeListPlugin {
    protected static String CACHEKEY_STRUCT_REPO_FIELDS = "STRUCT_REPO_FIELDS";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String structRepoNumber = (String)e.getFormShowParameter().getCustomParam("StructRepoNumber");
        if (StringUtils.isNotEmpty((String)structRepoNumber)) {
            e.getFormShowParameter().setCaption(String.format("%s(%s)", e.getFormShowParameter().getCaption(), structRepoNumber));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object pkStructRepo = this.getStructRepoId();
        if (pkStructRepo == null) {
            return;
        }
        String cacheFields = this.getPageCache().get(CACHEKEY_STRUCT_REPO_FIELDS);
        if (StringUtils.isNotEmpty((String)cacheFields)) {
            return;
        }
        List fieldDefinitionList = GaiStructRepoHelper.queryStructRepoFields((long)((Long)pkStructRepo));
        this.getPageCache().put(CACHEKEY_STRUCT_REPO_FIELDS, SerializationUtils.serializeToBase64((Object)fieldDefinitionList));
    }

    protected Object getStructRepoId() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        return listShowParameter.getCustomParam("StructRepoID");
    }

    protected String getStructRepoNumber() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        return (String)listShowParameter.getCustomParam("StructRepoNumber");
    }

    protected List<StructRepoField> getStructRepoFields() {
        String cacheFields = this.getPageCache().get(CACHEKEY_STRUCT_REPO_FIELDS);
        if (StringUtils.isEmpty((String)cacheFields)) {
            return Collections.emptyList();
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)cacheFields);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object pkStructRepo = this.getStructRepoId();
        if (pkStructRepo != null) {
            e.addCustomQFilter(new QFilter("structrepo", "=", pkStructRepo));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Object pkStructRepo = this.getStructRepoId();
        if (pkStructRepo == null) {
            return;
        }
        List<StructRepoField> fieldDefinitionList = this.getStructRepoFields();
        List listColumns = args.getListColumns();
        for (int i = 0; i < fieldDefinitionList.size(); ++i) {
            StructRepoField fieldDefinition = fieldDefinitionList.get(i);
            ListColumn column = new ListColumn();
            column.setKey(fieldDefinition.getFieldName());
            column.setCaption(new LocaleString(fieldDefinition.getName()));
            column.setListFieldKey(fieldDefinition.getFieldName());
            column.setColumnFilter(true);
            column.setColumnOrder(true);
            column.setFixed(true);
            listColumns.add(i + 2, column);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Object pkStructRepo = this.getStructRepoId();
        e.getParameter().setCustomParam("StructRepoID", pkStructRepo);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        Object pkStructRepo = this.getStructRepoId();
        if (pkStructRepo != null) {
            this.getTreeModel().getTreeFilter().add(new QFilter("structrepo", "=", pkStructRepo));
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        Object pkStructRepo = this.getStructRepoId();
        if (pkStructRepo != null) {
            this.getTreeModel().getTreeFilter().add(new QFilter("structrepo", "=", pkStructRepo));
        }
    }
}

