/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.repo.exp.ExpStatusEnum;
import kd.ai.gai.core.repo.exp.GaiRepoExpUtils;
import kd.ai.gai.core.repo.exp.RepoExpCallbackListener;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiRepoExportFormPlugin
extends AbstractFormPlugin
implements RepoExpCallbackListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(GaiRepoExportFormPlugin.class);
    private static final String CONTROL_PROGRESSBARAP = "progressbarap";
    private static final String REPO_ZIP_FILE_PATH_CACHE = "REPO_ZIP_FILE_PATH_CACHE";
    private static final String CONTROL_LABEL_TIPS = "tipslabel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object repoPk = formShowParameter.getCustomParam("RepoId");
        final String repoNumber = (String)formShowParameter.getCustomParam("RepoNumber");
        this.getPageCache().put("cache_repo_pk", String.valueOf((Long)repoPk));
        this.getPageCache().put("cache_repo_number", repoNumber);
        ProgressBar bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
        bar.start();
        final GaiRepoExportFormPlugin listener = this;
        final Long repoId = (Long)repoPk;
        GaiRepoExpUtils.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String zipFilePath = GaiRepoExpUtils.writeRepoZipFile((Long)repoId, (String)repoNumber, (RepoExpCallbackListener)listener);
                    logger.info("\u3010\u77e5\u8bc6\u5e93\u5bfc\u51fa- \u751f\u6210\u7684zip\u6587\u4ef6\u5730\u5740:{}\u3011", (Object)zipFilePath);
                    GaiRepoExportFormPlugin.this.getPageCache().put(GaiRepoExportFormPlugin.REPO_ZIP_FILE_PATH_CACHE, zipFilePath);
                }
                catch (Exception e) {
                    HashMap<String, String> progress = new HashMap<String, String>();
                    progress.put("text", e.getMessage());
                    progress.put("percent", "-1");
                    GaiRepoExportFormPlugin.this.getPageCache().put("progress", JSONObject.toJSONString(progress));
                }
            }
        });
    }

    public void onProgress(ProgressEvent progressEvent) {
        Label label;
        ProgressBar bar;
        String progressJson = this.getPageCache().get("progress");
        Map map = (Map)JSONObject.parseObject((String)progressJson, Map.class);
        String text = (String)map.get("text");
        int percent = Integer.parseInt((String)map.get("percent"));
        if (percent == -1) {
            bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
            label = (Label)this.getControl(CONTROL_LABEL_TIPS);
            label.setText(text);
            progressEvent.setText(text);
            bar.stop();
            this.getView().showErrorNotification(text);
        }
        if (percent >= 100) {
            bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
            label = (Label)this.getControl(CONTROL_LABEL_TIPS);
            label.setText(text);
            progressEvent.setText(text);
            progressEvent.setProgress(100);
            this.getView().addClientCallBack("close_page", Integer.valueOf(2000));
            bar.stop();
        } else {
            progressEvent.setText(text);
            progressEvent.setProgress(percent);
            Label label2 = (Label)this.getControl(CONTROL_LABEL_TIPS);
            label2.setText(text);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e.getName().equalsIgnoreCase("close_page")) {
            String zipFilePath = this.getPageCache().get(REPO_ZIP_FILE_PATH_CACHE);
            String downloadUrl = RequestContext.get().getClientFullContextPath() + "/attachment/download.do?path=" + zipFilePath;
            this.getView().close();
            this.getView().openUrl(downloadUrl);
        }
    }

    public void updateStatus(ExpStatusEnum expStatusEnum, int percent) {
        String status = expStatusEnum.getStatus();
        String tips = expStatusEnum.getName();
        logger.info("\u66f4\u65b0\u5bfc\u51fa\u72b6\u6001\uff1a{}\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)status, (Object)tips);
        HashMap<String, String> progress = new HashMap<String, String>();
        progress.put("text", tips);
        progress.put("percent", String.valueOf(percent));
        this.getPageCache().put("progress", JSONObject.toJSONString(progress));
    }

    public void operationResult(boolean success, String message) {
        HashMap<String, String> progress = new HashMap<String, String>();
        progress.put("text", message);
        progress.put("percent", "-1");
        this.getPageCache().put("progress", JSONObject.toJSONString(progress));
    }
}

