/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.repo.exp.ExpStatusEnum;
import kd.ai.gai.core.repo.exp.GaiRepoImpUtils;
import kd.ai.gai.core.repo.exp.RepoExpCallbackListener;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GaiRepoImportFormPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener,
RepoExpCallbackListener {
    private static final Log logger = LogFactory.getLog(GaiRepoImportFormPlugin.class);
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanelap";
    private static final String CONTROL_PROGRESSBARAP = "progressbarap";
    private static final String CONTROL_LABEL_TIPS = "tipslabel";
    private static final String PROGRESS_AP = "flexpanelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel panel = (AttachmentPanel)this.getControl(KEY_ATTACHMENTPANEL);
        panel.addUploadListener((UploadListener)this);
        ProgressBar bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
        bar.start();
        this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESS_AP});
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>(0);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{PROGRESS_AP});
        final GaiRepoImportFormPlugin listener = this;
        for (final String fileUrl : fileUrls) {
            GaiRepoImpUtils.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    GaiRepoImpUtils utils = new GaiRepoImpUtils(listener);
                    utils.importRepoFile(fileUrl);
                }
            });
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ATTACHMENTPANEL});
    }

    public void onProgress(ProgressEvent progressEvent) {
        String progressJson = this.getPageCache().get("progress");
        if (!StringUtils.isEmpty((CharSequence)progressJson)) {
            Map map = (Map)JSONObject.parseObject((String)progressJson, Map.class);
            String text = (String)map.get("text");
            int percent = Integer.parseInt((String)map.get("percent"));
            if (percent == -1) {
                ProgressBar bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
                Label label = (Label)this.getControl(CONTROL_LABEL_TIPS);
                label.setText(text);
                progressEvent.setText(text);
                bar.stop();
            } else if (percent >= 100) {
                ProgressBar bar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
                Label label = (Label)this.getControl(CONTROL_LABEL_TIPS);
                label.setText(text);
                progressEvent.setText(text);
                progressEvent.setProgress(100);
                this.getView().addClientCallBack("close_page", Integer.valueOf(2000));
                bar.stop();
            } else {
                progressEvent.setText(text);
                progressEvent.setProgress(percent);
                Label label = (Label)this.getControl(CONTROL_LABEL_TIPS);
                label.setText(text);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e.getName().equalsIgnoreCase("close_page")) {
            this.getView().close();
        }
    }

    public void updateStatus(ExpStatusEnum impStatus, int percent) {
        String status = impStatus.getStatus();
        String tips = impStatus.getName();
        logger.info("\u66f4\u65b0\u72b6\u6001\uff1a{}\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)status, (Object)tips);
        HashMap<String, String> progress = new HashMap<String, String>();
        progress.put("text", tips);
        progress.put("percent", String.valueOf(percent));
        this.getPageCache().put("progress", JSONObject.toJSONString(progress));
    }

    public void operationResult(boolean success, String message) {
        HashMap<String, String> progress = new HashMap<String, String>();
        progress.put("text", message);
        progress.put("percent", "-1");
        this.getPageCache().put("progress", JSONObject.toJSONString(progress));
    }
}

