/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GaiRepoInfoListImpExpPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(GaiRepoInfoListImpExpPlugin.class);
    private static final String OP_IMPORTREPO = "importrepo";
    private static final String OP_EXPORTREPO = "exportrepo";
    private static final String EXPORT_FORM = "gai_repo_export_win";
    private static final String IMPORT_FORM = "gai_repo_import_win";
    private static final String CONTROL_BTN_EXPORT = "btnexport";
    private static final String CONTROL_BTN_IMPORT = "btnimport";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operateKey = evt.getOperationKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OP_EXPORTREPO)) {
            logger.info("\u5f00\u59cb\u5bfc\u51fa\u77e5\u8bc6\u5e93");
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            int count = selectedRows.size();
            if (count == 0) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u77e5\u8bc6\u5e93\u3002");
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (count > 1) {
                this.getView().showTipNotification("\u4e0d\u652f\u6301\u6279\u91cf\u5bfc\u51fa\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002");
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "importrepo": {
                if (!args.getOperationResult().isSuccess()) break;
                logger.info("\u5f00\u59cb\u5bfc\u5165\u77e5\u8bc6\u5e93");
                this.importRepo();
                break;
            }
            case "exportrepo": {
                if (!args.getOperationResult().isSuccess()) break;
                logger.info("\u5f00\u59cb\u5bfc\u51fa\u77e5\u8bc6\u5e93");
                this.exportRepo();
            }
        }
    }

    private void exportRepo() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        Object repoPk = row.getPrimaryKeyValue();
        String repoNumber = row.getNumber();
        this.showExpForm(repoPk, repoNumber);
    }

    private void showExpForm(Object repoPk, String repoNumber) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EXPORT_FORM);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("RepoId", repoPk);
        formShowParameter.setCustomParam("RepoNumber", (Object)repoNumber);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterRepoExpActionCallback"));
        this.getView().showForm(formShowParameter);
    }

    private void importRepo() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(IMPORT_FORM);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterRepoImpActionCallback"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("afterRepoImpActionCallback")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }
}

