/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.ArrayList;
import kd.ai.gai.core.rag.service.RepoDispatchService;
import kd.ai.gai.core.service.RepoService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiRepoInfoListPlugin
extends AbstractListPlugin
implements ItemClickListener {
    private static Log LOGGER = LogFactory.getLog(GaiRepoInfoListPlugin.class);
    private static final String form_entity = "gai_repo_info";
    private static final String BILL_LIST_BILLLISTAP = "billlistap";
    private static final String tbldel = "delete";
    private static final String batch_createrepo = "batch_createrepo";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Delete) {
            BillList list = (BillList)this.getView().getControl(BILL_LIST_BILLLISTAP);
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Object[] repoIds = selectedRows.getPrimaryKeyValues();
            RepoService.delRepoChunkAndVectorByIds((Object[])repoIds);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals(batch_createrepo)) {
            BillList list = (BillList)this.getView().getControl(BILL_LIST_BILLLISTAP);
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Object[] repoIds = selectedRows.getPrimaryKeyValues();
            ArrayList<DynamicObject> entitylist = new ArrayList<DynamicObject>();
            int successCount = 0;
            int failCount = 0;
            ArrayList<String> failList = new ArrayList<String>();
            for (Object repoId : repoIds) {
                DynamicObject dynamicObject;
                long id = (Long)repoId;
                boolean addStatus = RepoDispatchService.dispatchTask((long)id);
                if (addStatus) {
                    dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)form_entity);
                    dynamicObject.set("id", (Object)id);
                    dynamicObject.set("status", (Object)"B");
                    entitylist.add(dynamicObject);
                    ++successCount;
                    LOGGER.info("\u3010Agent \u5e73\u53f0-\u77e5\u8bc6\u5e93\u3011\u521b\u5efa\u5206\u5757\u4efb\u52a1\u6210\u529f");
                } else {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)form_entity);
                    failList.add(dynamicObject.getString("name"));
                    ++failCount;
                    LOGGER.info("\u3010Agent \u5e73\u53f0-\u77e5\u8bc6\u5e93\u3011\u521b\u5efa\u5206\u5757\u4efb\u52a1\u5931\u8d25");
                }
                DynamicObject[] DObjArray = entitylist.toArray(new DynamicObject[0]);
                SaveServiceHelper.update((DynamicObject[])DObjArray);
            }
            if (successCount > 0) {
                this.getView().showSuccessNotification(String.format("\u89e6\u53d1\u6279\u91cf\u77e5\u8bc6\u5e93\u6784\u5efa\u7ed3\u675f\uff0c\u6210\u529f%d\u4e2a", successCount));
            }
            if (failCount > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("\u89e6\u53d1\u6279\u91cf\u77e5\u8bc6\u5e93\u6784\u5efa\u7ed3\u675f\uff0c\u5931\u8d25%d\u4e2a\uff0c\u77e5\u8bc6\u5e93\uff1a", failCount));
                for (String str : failList) {
                    stringBuilder.append(str);
                    stringBuilder.append(", ");
                }
                stringBuilder.append("\u6784\u5efa\u5931\u8d25");
                this.getView().showErrorNotification(stringBuilder.toString());
            }
        }
    }
}

