/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import kd.ai.gai.core.repo.constant.RepoConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiStructRepoListPlugin
extends AbstractListPlugin {
    private static final String STRUCT_REPO_FORM_ID = "gai_struct_repo";
    private static final String CONTROL_REPO_TYPE = "repotype";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object pkId = linkClickEvent.getCurrentRow().getPrimaryKeyValue();
        String repoNUmber = linkClickEvent.getCurrentRow().getNumber();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)STRUCT_REPO_FORM_ID);
        String repoType = dynamicObject.getString(CONTROL_REPO_TYPE);
        String dataStatus = dynamicObject.getString("datastatus");
        if (!StringUtils.equalsIgnoreCase((CharSequence)dataStatus, (CharSequence)RepoConstant.RepoDataStatus.SUCCESS.getStatus())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            this.getView().showTipNotification("\u77e5\u8bc6\u5e93\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u7ef4\u62a4\u3002");
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.LEVEL.getType())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            ListShowParameter bsp = new ListShowParameter();
            bsp.setFormId("bos_templatetreelist");
            bsp.setCustomParam("StructRepoID", pkId);
            bsp.setCustomParam("StructRepoNumber", (Object)repoNUmber);
            bsp.setBillFormId("gai_repo_treedata");
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)repoType, (CharSequence)RepoConstant.RepoType.TABLE.getType())) {
            args.setCancel(Boolean.TRUE.booleanValue());
            ListShowParameter bsp = new ListShowParameter();
            bsp.setFormId("bos_list");
            bsp.setCustomParam("StructRepoID", pkId);
            bsp.setCustomParam("StructRepoNumber", (Object)repoNUmber);
            bsp.setBillFormId("gai_table_repo");
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        block5: {
            String operationKey;
            block4: {
                super.beforeItemClick(evt);
                operationKey = evt.getOperationKey();
                if (!StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"modify")) break block4;
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                int count = selectedRows.size();
                if (count == 0) {
                    this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", Integer.valueOf(3000));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                if (count > 1) {
                    this.getView().showTipNotification("\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", Integer.valueOf(3000));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                ListSelectedRow row = selectedRows.get(0);
                Object pk = row.getPrimaryKeyValue();
                DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)STRUCT_REPO_FORM_ID);
                String dataStatus = repo.getString("datastatus");
                if (!StringUtils.equalsIgnoreCase((CharSequence)dataStatus, (CharSequence)RepoConstant.RepoDataStatus.PROCESSING.getStatus())) break block5;
                this.getView().showTipNotification("\u5904\u7406\u4e2d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002");
                evt.setCancel(Boolean.TRUE.booleanValue());
                break block5;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"delete")) {
                ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
                for (int i = 0; i < collection.size(); ++i) {
                    String datastatus;
                    ListSelectedRow row = collection.get(i);
                    Object pk = row.getPrimaryKeyValue();
                    DynamicObject repo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)STRUCT_REPO_FORM_ID);
                    if (repo == null || !StringUtils.equalsIgnoreCase((CharSequence)(datastatus = repo.getString("datastatus")), (CharSequence)RepoConstant.RepoDataStatus.PROCESSING.getStatus())) continue;
                    this.getView().showTipNotification("\u5904\u7406\u4e2d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    break;
                }
            }
        }
    }
}

